/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 1.67 $ of : mfd-interface.m2c,v $ 
 *
 * $Id: ifXTable_interface.c 19579 2010-10-28 17:51:25Z nba $
 */
/*
 * *********************************************************************
 * *********************************************************************
 * *********************************************************************
 * ***                                                               ***
 * ***  NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE  ***
 * ***                                                               ***
 * ***                                                               ***
 * ***       THIS FILE DOES NOT CONTAIN ANY USER EDITABLE CODE.      ***
 * ***                                                               ***
 * ***                                                               ***
 * ***       THE GENERATED CODE IS INTERNAL IMPLEMENTATION, AND      ***
 * ***                                                               ***
 * ***                                                               ***
 * ***    IS SUBJECT TO CHANGE WITHOUT WARNING IN FUTURE RELEASES.   ***
 * ***                                                               ***
 * ***                                                               ***
 * *********************************************************************
 * *********************************************************************
 * *********************************************************************
 */

/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "ifXTable.h"


#include <net-snmp/agent/table_container.h>
#include <net-snmp/library/container.h>

#include "ifXTable_interface.h"
#include "if-mib/ifTable/ifTable_interface.h"
#include "if-mib/ifTable/ifTable_defs.h"

#include <ctype.h>

/**********************************************************************
 **********************************************************************
 ***
 *** Table ifXTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * IF-MIB::ifXTable is subid 1 of ifMIBObjects.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.31.1.1, length: 9
 */
typedef struct ifXTable_interface_ctx_s {

    netsnmp_container *container;
    netsnmp_cache  *cache;

    ifXTable_registration *user_ctx;

    netsnmp_table_registration_info tbl_info;

    netsnmp_baby_steps_access_methods access_multiplexer;

    u_int           table_dirty;

} ifXTable_interface_ctx;

static ifXTable_interface_ctx ifXTable_if_ctx;

static void     _ifXTable_container_init(ifXTable_interface_ctx * if_ctx);
static void     _ifXTable_container_shutdown(ifXTable_interface_ctx *
                                             if_ctx);


netsnmp_container *
ifXTable_container_get(void)
{
    return ifXTable_if_ctx.container;
}

ifXTable_registration *
ifXTable_registration_get(void)
{
    return ifXTable_if_ctx.user_ctx;
}

ifXTable_registration *
ifXTable_registration_set(ifXTable_registration * newreg)
{
    ifXTable_registration *old = ifXTable_if_ctx.user_ctx;
    ifXTable_if_ctx.user_ctx = newreg;
    return old;
}

int
ifXTable_container_size(void)
{
    return CONTAINER_SIZE(ifXTable_if_ctx.container);
}

u_int
ifXTable_dirty_get(void)
{
    return ifXTable_if_ctx.table_dirty;
}

void
ifXTable_dirty_set(u_int status)
{
    DEBUGMSGTL(("ifXTable:ifXTable_dirty_set",
                "called. was %d, now %d\n",
                ifXTable_if_ctx.table_dirty, status));
    ifXTable_if_ctx.table_dirty = status;
}

/*
 * mfd multiplexer modes
 */
static Netsnmp_Node_Handler _mfd_ifXTable_pre_request;
static Netsnmp_Node_Handler _mfd_ifXTable_post_request;
static Netsnmp_Node_Handler _mfd_ifXTable_object_lookup;
static Netsnmp_Node_Handler _mfd_ifXTable_get_values;
static Netsnmp_Node_Handler _mfd_ifXTable_check_objects;
static Netsnmp_Node_Handler _mfd_ifXTable_undo_setup;
static Netsnmp_Node_Handler _mfd_ifXTable_set_values;
static Netsnmp_Node_Handler _mfd_ifXTable_undo_cleanup;
static Netsnmp_Node_Handler _mfd_ifXTable_undo_values;
static Netsnmp_Node_Handler _mfd_ifXTable_commit;
static Netsnmp_Node_Handler _mfd_ifXTable_undo_commit;
static Netsnmp_Node_Handler _mfd_ifXTable_irreversible_commit;
static Netsnmp_Node_Handler _mfd_ifXTable_check_dependencies;

NETSNMP_STATIC_INLINE int _ifXTable_undo_column(ifXTable_rowreq_ctx *
                                                rowreq_ctx,
                                                netsnmp_variable_list *
                                                var, int column);

ifXTable_data  *ifXTable_allocate_data(void);

/**
 * @internal
 * Initialize the table ifXTable 
 *    (Define its contents and how it's structured)
 */
void
_ifXTable_initialize_interface(ifXTable_registration * reg_ptr,
                               u_long flags)
{
    netsnmp_baby_steps_access_methods *access_multiplexer =
        &ifXTable_if_ctx.access_multiplexer;
    netsnmp_table_registration_info *tbl_info = &ifXTable_if_ctx.tbl_info;
    netsnmp_handler_registration *reginfo;
    netsnmp_mib_handler *handler;
    int             mfd_modes = 0;

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_initialize_interface",
                "called\n"));

    /*
     * make sure the ifTable container has been initialized, since
     * we use its container, and we can't guarantee that it has
     * already been initialized.
     */
    (void) if_mib_container_init();

    /*************************************************
     *
     * save interface context for ifXTable
     */
    /*
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(tbl_info, ASN_INTEGER,
                                               /** index: ifIndex */
                                     0);

    /*
     * Define the minimum and maximum accessible columns.  This
     * optimizes retrieval. 
     */
    tbl_info->min_column = IFXTABLE_MIN_COL;
    tbl_info->max_column = IFXTABLE_MAX_COL;

    /*
     * save users context
     */
    ifXTable_if_ctx.user_ctx = reg_ptr;

    /*
     * call data access initialization code
     */
    ifXTable_init_data(reg_ptr);

    /*
     * set up the container
     */
    _ifXTable_container_init(&ifXTable_if_ctx);
    if (NULL == ifXTable_if_ctx.container)
        return;                 /* msg already logged */

    /*
     * access_multiplexer: REQUIRED wrapper for get request handling
     */
    access_multiplexer->object_lookup = _mfd_ifXTable_object_lookup;
    access_multiplexer->get_values = _mfd_ifXTable_get_values;

    /*
     * no wrappers yet
     */
    access_multiplexer->pre_request = _mfd_ifXTable_pre_request;
    access_multiplexer->post_request = _mfd_ifXTable_post_request;


    /*
     * REQUIRED wrappers for set request handling
     */
    access_multiplexer->object_syntax_checks = _mfd_ifXTable_check_objects;
    access_multiplexer->undo_setup = _mfd_ifXTable_undo_setup;
    access_multiplexer->undo_cleanup = _mfd_ifXTable_undo_cleanup;
    access_multiplexer->set_values = _mfd_ifXTable_set_values;
    access_multiplexer->undo_sets = _mfd_ifXTable_undo_values;

    /*
     * no wrappers yet
     */
    access_multiplexer->commit = _mfd_ifXTable_commit;
    access_multiplexer->undo_commit = _mfd_ifXTable_undo_commit;
    access_multiplexer->irreversible_commit =
        _mfd_ifXTable_irreversible_commit;

    /*
     * REQUIRED for tables with dependencies
     */
    access_multiplexer->consistency_checks =
        _mfd_ifXTable_check_dependencies;

    /*************************************************
     *
     * Create a registration, save our reg data, register table.
     */
    DEBUGMSGTL(("ifXTable:init_ifXTable",
                "Registering ifXTable as a mibs-for-dummies table.\n"));
    handler =
        netsnmp_baby_steps_access_multiplexer_get(access_multiplexer);
    reginfo =
        netsnmp_handler_registration_create("ifXTable", handler,
                                            ifXTable_oid,
                                            ifXTable_oid_size,
                                            HANDLER_CAN_BABY_STEP |
                                            HANDLER_CAN_RWRITE);
    if (NULL == reginfo) {
        snmp_log(LOG_ERR, "error registering table ifXTable\n");
        return;
    }
    reginfo->my_reg_void = &ifXTable_if_ctx;

    /*************************************************
     *
     * set up baby steps handler, create it and inject it
     */
    if (access_multiplexer->object_lookup)
        mfd_modes |= BABY_STEP_OBJECT_LOOKUP;
    if (access_multiplexer->set_values)
        mfd_modes |= BABY_STEP_SET_VALUES;
    if (access_multiplexer->irreversible_commit)
        mfd_modes |= BABY_STEP_IRREVERSIBLE_COMMIT;
    if (access_multiplexer->object_syntax_checks)
        mfd_modes |= BABY_STEP_CHECK_OBJECT;

    if (access_multiplexer->pre_request)
        mfd_modes |= BABY_STEP_PRE_REQUEST;
    if (access_multiplexer->post_request)
        mfd_modes |= BABY_STEP_POST_REQUEST;

    if (access_multiplexer->undo_setup)
        mfd_modes |= BABY_STEP_UNDO_SETUP;
    if (access_multiplexer->undo_cleanup)
        mfd_modes |= BABY_STEP_UNDO_CLEANUP;
    if (access_multiplexer->undo_sets)
        mfd_modes |= BABY_STEP_UNDO_SETS;

    if (access_multiplexer->row_creation)
        mfd_modes |= BABY_STEP_ROW_CREATE;
    if (access_multiplexer->consistency_checks)
        mfd_modes |= BABY_STEP_CHECK_CONSISTENCY;
    if (access_multiplexer->commit)
        mfd_modes |= BABY_STEP_COMMIT;
    if (access_multiplexer->undo_commit)
        mfd_modes |= BABY_STEP_UNDO_COMMIT;

    handler = netsnmp_baby_steps_handler_get(mfd_modes);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject row_merge helper with prefix rootoid_len + 2 (entry.col)
     */
    handler = netsnmp_get_row_merge_handler(reginfo->rootoid_len + 2);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject container_table helper
     */
    handler =
        netsnmp_container_table_handler_get(tbl_info,
                                            ifXTable_if_ctx.container,
                                            TABLE_CONTAINER_KEY_NETSNMP_INDEX);
    netsnmp_inject_handler(reginfo, handler);

    /*************************************************
     *
     * inject cache helper
     */
    if (NULL != ifXTable_if_ctx.cache) {
        handler = netsnmp_cache_handler_get(ifXTable_if_ctx.cache);
        netsnmp_inject_handler(reginfo, handler);
    }

    /*
     * register table
     */
    netsnmp_register_table(reginfo, tbl_info);

    /*
     * register config/persistence callbacks
     */
    ifXTable_container_init_persistence(ifXTable_if_ctx.container);

}                               /* _ifXTable_initialize_interface */

/**
 * @internal
 * Shutdown the table ifXTable
 */
void
_ifXTable_shutdown_interface(ifXTable_registration * reg_ptr)
{
    /*
     * shutdown the container
     */
    _ifXTable_container_shutdown(&ifXTable_if_ctx);
}

void
ifXTable_valid_columns_set(netsnmp_column_info *vc)
{
    ifXTable_if_ctx.tbl_info.valid_columns = vc;
}                               /* ifXTable_valid_columns_set */

/**
 * @internal
 * convert the index component stored in the context to an oid
 */
int
ifXTable_index_to_oid(netsnmp_index * oid_idx,
                      ifXTable_mib_index * mib_idx)
{
    int             err = SNMP_ERR_NOERROR;

    /*
     * temp storage for parsing indexes
     */
    /*
     * ifIndex(1)/InterfaceIndex/ASN_INTEGER/long(long)//l/A/w/e/R/d/H
     */
    netsnmp_variable_list var_ifIndex;

    /*
     * set up varbinds
     */
    memset(&var_ifIndex, 0x00, sizeof(var_ifIndex));
    var_ifIndex.type = ASN_INTEGER;

    /*
     * chain temp index varbinds together
     */
    var_ifIndex.next_variable = NULL;


    DEBUGMSGTL(("verbose:ifXTable:ifXTable_index_to_oid", "called\n"));

    /*
     * ifIndex(1)/InterfaceIndex/ASN_INTEGER/long(long)//l/A/w/e/R/d/H 
     */
    snmp_set_var_value(&var_ifIndex, (u_char *) & mib_idx->ifIndex,
                       sizeof(mib_idx->ifIndex));


    err = build_oid_noalloc(oid_idx->oids, oid_idx->len, &oid_idx->len,
                            NULL, 0, &var_ifIndex);
    if (err)
        snmp_log(LOG_ERR, "error %d converting index to oid\n", err);

    /*
     * parsing may have allocated memory. free it.
     */
    snmp_reset_var_buffers(&var_ifIndex);

    return err;
}                               /* ifXTable_index_to_oid */

/**
 * extract ifXTable indexes from a netsnmp_index
 *
 * @retval SNMP_ERR_NOERROR  : no error
 * @retval SNMP_ERR_GENERR   : error
 */
int
ifXTable_index_from_oid(netsnmp_index * oid_idx,
                        ifXTable_mib_index * mib_idx)
{
    int             err = SNMP_ERR_NOERROR;

    /*
     * temp storage for parsing indexes
     */
    /*
     * ifIndex(1)/InterfaceIndex/ASN_INTEGER/long(long)//l/A/w/e/R/d/H
     */
    netsnmp_variable_list var_ifIndex;

    /*
     * set up varbinds
     */
    memset(&var_ifIndex, 0x00, sizeof(var_ifIndex));
    var_ifIndex.type = ASN_INTEGER;

    /*
     * chain temp index varbinds together
     */
    var_ifIndex.next_variable = NULL;


    DEBUGMSGTL(("verbose:ifXTable:ifXTable_index_from_oid", "called\n"));

    /*
     * parse the oid into the individual index components
     */
    err = parse_oid_indexes(oid_idx->oids, oid_idx->len, &var_ifIndex);
    if (err == SNMP_ERR_NOERROR) {
        /*
         * copy out values
         */
        mib_idx->ifIndex = *((long *) var_ifIndex.val.string);


    }

    /*
     * parsing may have allocated memory. free it.
     */
    snmp_reset_var_buffers(&var_ifIndex);

    return err;
}                               /* ifXTable_index_from_oid */


/*
 * ifXTable_allocate_data
 *
 * Purpose: create new ifXTable_data.
 */
ifXTable_data  *
ifXTable_allocate_data(void)
{
    ifXTable_data  *rtn = SNMP_MALLOC_TYPEDEF(ifXTable_data);

    DEBUGMSGTL(("verbose:ifXTable:ifXTable_allocate_data", "called\n"));

    if (NULL == rtn) {
        snmp_log(LOG_ERR, "unable to malloc memory for new "
                 "ifXTable_data.\n");
    }

    return rtn;
}                               /* ifXTable_allocate_data */

/*
 * ifXTable_release_data
 *
 * Purpose: release ifXTable data.
 */
void
ifXTable_release_data(ifXTable_data * data)
{
    DEBUGMSGTL(("verbose:ifXTable:ifXTable_release_data", "called\n"));

    free(data);
}                               /* ifXTable_release_data */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ifXTable_pre_request(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info *agtreq_info,
                          netsnmp_request_info *requests)
{
    int             rc;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_pre_request",
                "called\n"));

    if (1 != netsnmp_row_merge_status_first(reginfo, agtreq_info)) {
        DEBUGMSGTL(("internal:ifXTable",
                    "skipping additional pre_request\n"));
        return SNMP_ERR_NOERROR;
    }

    rc = ifXTable_pre_request(ifXTable_if_ctx.user_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("ifXTable", "error %d from "
                    "ifXTable_pre_request\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_pre_request */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ifXTable_post_request(netsnmp_mib_handler *handler,
                           netsnmp_handler_registration *reginfo,
                           netsnmp_agent_request_info *agtreq_info,
                           netsnmp_request_info *requests)
{
    ifXTable_rowreq_ctx *rowreq_ctx = (ifXTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);
    int             rc, packet_rc;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_post_request",
                "called\n"));

    /*
     * release row context, if deleted
     */
    if (rowreq_ctx && (rowreq_ctx->rowreq_flags & MFD_ROW_DELETED))
        ifTable_release_rowreq_ctx(rowreq_ctx);

    /*
     * wait for last call before calling user
     */
    if (1 != netsnmp_row_merge_status_last(reginfo, agtreq_info)) {
        DEBUGMSGTL(("internal:ifXTable",
                    "waiting for last post_request\n"));
        return SNMP_ERR_NOERROR;
    }

    packet_rc = netsnmp_check_all_requests_error(agtreq_info->asp, 0);
    if ((MFD_SUCCESS != packet_rc) && ifXTable_dirty_get()) {
        /*
         * we shouldn't get here. the undo steps should also clear
         * the dirty flags.
         */
        snmp_log(LOG_WARNING, "ifXTable dirty flag set in post_request "
                 "but status != SUCCESS.\n");
    }

    rc = ifXTable_post_request(ifXTable_if_ctx.user_ctx, packet_rc);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("ifXTable", "error %d from "
                    "ifXTable_post_request\n", rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_post_request */

/**
 * @internal
 * wrapper
 */
static int
_mfd_ifXTable_object_lookup(netsnmp_mib_handler *handler,
                            netsnmp_handler_registration *reginfo,
                            netsnmp_agent_request_info *agtreq_info,
                            netsnmp_request_info *requests)
{
    int             rc = SNMP_ERR_NOERROR;
    ifXTable_rowreq_ctx *rowreq_ctx = (ifXTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_object_lookup",
                "called\n"));

    /*
     * get our context from mfd
     * ifXTable_interface_ctx *if_ctx =
     *             (ifXTable_interface_ctx *)reginfo->my_reg_void;
     */

    if (NULL == rowreq_ctx) {
        rc = SNMP_ERR_NOCREATION;
    }

    if (MFD_SUCCESS != rc)
        netsnmp_request_set_error_all(requests, rc);
    else
        ifXTable_row_prep(rowreq_ctx);

    return SNMP_VALIDATE_ERR(rc);
}                               /* _mfd_ifXTable_object_lookup */

/***********************************************************************
 *
 * GET processing
 *
 ***********************************************************************/
/*
 * @internal
 * Retrieve the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ifXTable_get_column(ifXTable_rowreq_ctx * rowreq_ctx,
                     netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_get_column",
                "called for %d\n", column));


    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ifName(1)/DisplayString/ASN_OCTET_STR/char(char)//L/A/w/e/R/d/H 
         */
    case COLUMN_IFNAME:
        var->type = ASN_OCTET_STR;
        rc = ifName_get(rowreq_ctx, (char **) &var->val.string,
                        &var->val_len);
        break;

        /*
         * ifInMulticastPkts(2)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFINMULTICASTPKTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ifInMulticastPkts_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ifInBroadcastPkts(3)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFINBROADCASTPKTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ifInBroadcastPkts_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ifOutMulticastPkts(4)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFOUTMULTICASTPKTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ifOutMulticastPkts_get(rowreq_ctx,
                                    (u_long *) var->val.string);
        break;

        /*
         * ifOutBroadcastPkts(5)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFOUTBROADCASTPKTS:
        var->val_len = sizeof(u_long);
        var->type = ASN_COUNTER;
        rc = ifOutBroadcastPkts_get(rowreq_ctx,
                                    (u_long *) var->val.string);
        break;

        /*
         * ifHCInOctets(6)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCINOCTETS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCInOctets_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCInUcastPkts(7)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCINUCASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCInUcastPkts_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCInMulticastPkts(8)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCINMULTICASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCInMulticastPkts_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCInBroadcastPkts(9)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCINBROADCASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCInBroadcastPkts_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCOutOctets(10)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCOUTOCTETS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCOutOctets_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCOutUcastPkts(11)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCOUTUCASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCOutUcastPkts_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCOutMulticastPkts(12)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCOUTMULTICASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCOutMulticastPkts_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifHCOutBroadcastPkts(13)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCOUTBROADCASTPKTS:
        var->val_len = sizeof(U64);
        var->type = ASN_COUNTER64;
        rc = ifHCOutBroadcastPkts_get(rowreq_ctx, (U64 *) var->val.string);
        break;

        /*
         * ifLinkUpDownTrapEnable(14)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFLINKUPDOWNTRAPENABLE:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = ifLinkUpDownTrapEnable_get(rowreq_ctx,
                                        (u_long *) var->val.string);
        break;

        /*
         * ifHighSpeed(15)/GAUGE/ASN_GAUGE/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHIGHSPEED:
        var->val_len = sizeof(u_long);
        var->type = ASN_GAUGE;
        rc = ifHighSpeed_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ifPromiscuousMode(16)/TruthValue/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFPROMISCUOUSMODE:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = ifPromiscuousMode_get(rowreq_ctx, (u_long *) var->val.string);
        break;

        /*
         * ifConnectorPresent(17)/TruthValue/ASN_INTEGER/long(u_long)//l/A/w/E/r/d/h 
         */
    case COLUMN_IFCONNECTORPRESENT:
        var->val_len = sizeof(u_long);
        var->type = ASN_INTEGER;
        rc = ifConnectorPresent_get(rowreq_ctx,
                                    (u_long *) var->val.string);
        break;

        /*
         * ifAlias(18)/DisplayString/ASN_OCTET_STR/char(char)//L/A/W/e/R/d/H 
         */
    case COLUMN_IFALIAS:
        var->type = ASN_OCTET_STR;
        rc = ifAlias_get(rowreq_ctx, (char **) &var->val.string,
                         &var->val_len);
        break;

        /*
         * ifCounterDiscontinuityTime(19)/TimeStamp/ASN_TIMETICKS/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFCOUNTERDISCONTINUITYTIME:
        var->val_len = sizeof(u_long);
        var->type = ASN_TIMETICKS;
        rc = ifCounterDiscontinuityTime_get(rowreq_ctx,
                                            (u_long *) var->val.string);
        break;

    default:
        snmp_log(LOG_ERR, "unknown column %d in _ifXTable_get_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _ifXTable_get_column */

int
_mfd_ifXTable_get_values(netsnmp_mib_handler *handler,
                         netsnmp_handler_registration *reginfo,
                         netsnmp_agent_request_info *agtreq_info,
                         netsnmp_request_info *requests)
{
    ifXTable_rowreq_ctx *rowreq_ctx = (ifXTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    u_char         *old_string;
    void            (*dataFreeHook) (void *);
    int             rc;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_get_values", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    for (; requests; requests = requests->next) {
        /*
         * save old pointer, so we can free it if replaced
         */
        old_string = requests->requestvb->val.string;
        dataFreeHook = requests->requestvb->dataFreeHook;
        if (NULL == requests->requestvb->val.string) {
            requests->requestvb->val.string = requests->requestvb->buf;
            requests->requestvb->val_len =
                sizeof(requests->requestvb->buf);
        } else if (requests->requestvb->buf ==
                   requests->requestvb->val.string) {
            if (requests->requestvb->val_len !=
                sizeof(requests->requestvb->buf))
                requests->requestvb->val_len =
                    sizeof(requests->requestvb->buf);
        }

        /*
         * get column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ifXTable_get_column(rowreq_ctx, requests->requestvb,
                                  tri->colnum);
        if (rc) {
            if (MFD_SKIP == rc) {
                requests->requestvb->type = SNMP_NOSUCHINSTANCE;
                rc = SNMP_ERR_NOERROR;
            }
        } else if (NULL == requests->requestvb->val.string) {
            snmp_log(LOG_ERR, "NULL varbind data pointer!\n");
            rc = SNMP_ERR_GENERR;
        }
        if (rc)
            netsnmp_request_set_error(requests, SNMP_VALIDATE_ERR(rc));

        /*
         * if the buffer wasn't used previously for the old data (i.e. it
         * was allcoated memory)  and the get routine replaced the pointer,
         * we need to free the previous pointer.
         */
        if (old_string && (old_string != requests->requestvb->buf) &&
            (requests->requestvb->val.string != old_string)) {
            if (dataFreeHook)
                (*dataFreeHook) (old_string);
            else
                free(old_string);
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_get_values */

/***********************************************************************
 *
 * SET processing
 *
 ***********************************************************************/

/*----------------------------------------------------------------------
 *
 * SET: Syntax checks
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Check the syntax for a particular column
 */
NETSNMP_STATIC_INLINE int
_ifXTable_check_column(ifXTable_rowreq_ctx * rowreq_ctx,
                       netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_check_column",
                "called for %d\n", column));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ifName(1)/DisplayString/ASN_OCTET_STR/char(char)//L/A/w/e/R/d/H 
         */
    case COLUMN_IFNAME:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifInMulticastPkts(2)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFINMULTICASTPKTS:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifInBroadcastPkts(3)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFINBROADCASTPKTS:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifOutMulticastPkts(4)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFOUTMULTICASTPKTS:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifOutBroadcastPkts(5)/COUNTER/ASN_COUNTER/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFOUTBROADCASTPKTS:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifHCInOctets(6)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCINOCTETS:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifHCInUcastPkts(7)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCINUCASTPKTS:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifHCInMulticastPkts(8)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCINMULTICASTPKTS:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifHCInBroadcastPkts(9)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCINBROADCASTPKTS:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifHCOutOctets(10)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCOUTOCTETS:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifHCOutUcastPkts(11)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCOUTUCASTPKTS:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifHCOutMulticastPkts(12)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCOUTMULTICASTPKTS:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifHCOutBroadcastPkts(13)/COUNTER64/ASN_COUNTER64/U64(U64)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHCOUTBROADCASTPKTS:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifLinkUpDownTrapEnable(14)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFLINKUPDOWNTRAPENABLE:
        rc = netsnmp_check_vb_type_and_size(var, ASN_INTEGER,
                                            sizeof(rowreq_ctx->data.
                                                   ifLinkUpDownTrapEnable));
        /*
         * check that the value is one of defined enums 
         */
        if ((SNMPERR_SUCCESS == rc)
            && (*var->val.integer != IFLINKUPDOWNTRAPENABLE_ENABLED)
            && (*var->val.integer != IFLINKUPDOWNTRAPENABLE_DISABLED)
            ) {
            rc = SNMP_ERR_WRONGVALUE;
        }
        if (SNMPERR_SUCCESS != rc) {
            DEBUGMSGTL(("ifXTable:_ifXTable_check_column:ifLinkUpDownTrapEnable", "varbind validation failed (eg bad type or size)\n"));
        } else {
            rc = ifLinkUpDownTrapEnable_check_value(rowreq_ctx,
                                                    *((u_long *) var->val.
                                                      string));
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR,
                         "bad rc %d from ifLinkUpDownTrapEnable_check_value\n",
                         rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

        /*
         * ifHighSpeed(15)/GAUGE/ASN_GAUGE/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFHIGHSPEED:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifPromiscuousMode(16)/TruthValue/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFPROMISCUOUSMODE:
        rc = netsnmp_check_vb_type_and_size(var, ASN_INTEGER,
                                            sizeof(rowreq_ctx->data.
                                                   ifPromiscuousMode));
        /*
         * check that the value is one of defined enums 
         */
        if ((SNMPERR_SUCCESS == rc)
            && (*var->val.integer != TRUTHVALUE_TRUE)
            && (*var->val.integer != TRUTHVALUE_FALSE)
            ) {
            rc = SNMP_ERR_WRONGVALUE;
        }
        if (SNMPERR_SUCCESS != rc) {
            DEBUGMSGTL(("ifXTable:_ifXTable_check_column:ifPromiscuousMode", "varbind validation failed (eg bad type or size)\n"));
        } else {
            rc = ifPromiscuousMode_check_value(rowreq_ctx,
                                               *((u_long *) var->val.
                                                 string));
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR,
                         "bad rc %d from ifPromiscuousMode_check_value\n",
                         rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

        /*
         * ifConnectorPresent(17)/TruthValue/ASN_INTEGER/long(u_long)//l/A/w/E/r/d/h 
         */
    case COLUMN_IFCONNECTORPRESENT:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

        /*
         * ifAlias(18)/DisplayString/ASN_OCTET_STR/char(char)//L/A/W/e/R/d/H 
         */
    case COLUMN_IFALIAS:
        rc = netsnmp_check_vb_type_and_max_size(var, ASN_OCTET_STR,
                                                sizeof(rowreq_ctx->data.
                                                       ifAlias));
        /*
         * check defined range(s). 
         */
        if ((SNMPERR_SUCCESS == rc)
            && ((var->val_len < 0) || (var->val_len > 64))
            ) {
            rc = SNMP_ERR_WRONGLENGTH;
        }
        if (SNMPERR_SUCCESS != rc) {
            DEBUGMSGTL(("ifXTable:_ifXTable_check_column:ifAlias",
                        "varbind validation failed (eg bad type or size)\n"));
        } else {
            rc = ifAlias_check_value(rowreq_ctx, (char *) var->val.string,
                                     var->val_len);
            if ((MFD_SUCCESS != rc) && (MFD_NOT_VALID_EVER != rc)
                && (MFD_NOT_VALID_NOW != rc)) {
                snmp_log(LOG_ERR, "bad rc %d from ifAlias_check_value\n",
                         rc);
                rc = SNMP_ERR_GENERR;
            }
        }
        break;

        /*
         * ifCounterDiscontinuityTime(19)/TimeStamp/ASN_TIMETICKS/u_long(u_long)//l/A/w/e/r/d/h 
         */
    case COLUMN_IFCOUNTERDISCONTINUITYTIME:
        rc = SNMP_ERR_NOTWRITABLE;
        break;

    default:   /** We shouldn't get here */
        rc = SNMP_ERR_GENERR;
        snmp_log(LOG_ERR, "unknown column %d in _ifXTable_check_column\n",
                 column);
    }

    return rc;
}                               /* _ifXTable_check_column */

int
_mfd_ifXTable_check_objects(netsnmp_mib_handler *handler,
                            netsnmp_handler_registration *reginfo,
                            netsnmp_agent_request_info *agtreq_info,
                            netsnmp_request_info *requests)
{
    ifXTable_rowreq_ctx *rowreq_ctx = (ifXTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    int             rc;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_check_objects",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    for (; requests; requests = requests->next) {

        /*
         * get column number from table request info, and check that column
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ifXTable_check_column(rowreq_ctx, requests->requestvb,
                                    tri->colnum);
        if (rc) {
            netsnmp_request_set_error(requests, SNMP_VALIDATE_ERR(rc));
            break;
        }

    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_check_objects */


/*----------------------------------------------------------------------
 *
 * SET: check dependencies
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Check dependencies wrapper
 */
static int
_mfd_ifXTable_check_dependencies(netsnmp_mib_handler *handler,
                                 netsnmp_handler_registration *reginfo,
                                 netsnmp_agent_request_info *agtreq_info,
                                 netsnmp_request_info *requests)
{
    int             rc;
    ifXTable_rowreq_ctx *rowreq_ctx = (ifXTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);
    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_check_dependencies",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = ifXTable_check_dependencies(rowreq_ctx);
    if (rc) {
        DEBUGMSGTL(("ifXTable:mfd", "error %d from "
                    "ifXTable_check_dependencies\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_check_dependencies */

/*----------------------------------------------------------------------
 *
 * SET: Undo setup
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Set the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ifXTable_undo_setup_column(ifXTable_rowreq_ctx * rowreq_ctx, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_undo_setup_column",
                "called for %d\n", column));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ifLinkUpDownTrapEnable(14)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFLINKUPDOWNTRAPENABLE:
        rowreq_ctx->column_set_flags |= COLUMN_IFLINKUPDOWNTRAPENABLE_FLAG;
        rc = ifLinkUpDownTrapEnable_undo_setup(rowreq_ctx);
        break;

        /*
         * ifPromiscuousMode(16)/TruthValue/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFPROMISCUOUSMODE:
        rowreq_ctx->column_set_flags |= COLUMN_IFPROMISCUOUSMODE_FLAG;
        rc = ifPromiscuousMode_undo_setup(rowreq_ctx);
        break;

        /*
         * ifAlias(18)/DisplayString/ASN_OCTET_STR/char(char)//L/A/W/e/R/d/H 
         */
    case COLUMN_IFALIAS:
        rowreq_ctx->column_set_flags |= COLUMN_IFALIAS_FLAG;
        rc = ifAlias_undo_setup(rowreq_ctx);
        break;

    default:
        snmp_log(LOG_ERR,
                 "unknown column %d in _ifXTable_undo_setup_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _ifXTable_undo_setup_column */


/**
 * @internal
 * undo setup
 */
int
_mfd_ifXTable_undo_setup(netsnmp_mib_handler *handler,
                         netsnmp_handler_registration *reginfo,
                         netsnmp_agent_request_info *agtreq_info,
                         netsnmp_request_info *requests)
{
    int             rc;
    ifXTable_rowreq_ctx *rowreq_ctx = (ifXTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_undo_setup", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * allocate undo context
     */
    rowreq_ctx->undo = ifXTable_allocate_data();
    if (NULL == rowreq_ctx->undo) {
        /** msg already logged */
        netsnmp_request_set_error_all(requests,
                                      SNMP_ERR_RESOURCEUNAVAILABLE);
        return SNMP_ERR_NOERROR;
    }

    /*
     * row undo setup
     */
    rowreq_ctx->column_set_flags = 0;
    rc = ifXTable_undo_setup(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        DEBUGMSGTL(("ifXTable:mfd", "error %d from "
                    "ifXTable_undo_setup\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    } else {
        /*
         * column undo setup
         */
        netsnmp_table_request_info *tri;
        for (; requests; requests = requests->next) {
            /*
             * set column data
             */
            tri = netsnmp_extract_table_info(requests);
            if (NULL == tri)
                continue;

            rc = _ifXTable_undo_setup_column(rowreq_ctx, tri->colnum);
            if (MFD_SUCCESS != rc) {
                DEBUGMSGTL(("ifXTable:mfd", "error %d from "
                            "ifXTable_undo_setup_column\n", rc));
                netsnmp_set_request_error(agtreq_info, requests,
                                          SNMP_VALIDATE_ERR(rc));
            }
        }                       /* for results */
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_undo_setup */

/**
 * @internal
 * undo setup
 */
int
_mfd_ifXTable_undo_cleanup(netsnmp_mib_handler *handler,
                           netsnmp_handler_registration *reginfo,
                           netsnmp_agent_request_info *agtreq_info,
                           netsnmp_request_info *requests)
{
    ifXTable_rowreq_ctx *rowreq_ctx = (ifXTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);
    int             rc;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_undo_cleanup",
                "called\n"));

    /*
     * failed row create in early stages has no rowreq_ctx
     */
    if (NULL == rowreq_ctx)
        return MFD_SUCCESS;

    /*
     * call user cleanup
     */
    rc = ifXTable_undo_cleanup(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("ifXTable:mfd", "error %d from "
                    "ifXTable_undo_cleanup\n", rc));
    }

    /*
     * release undo context, if needed
     */
    if (rowreq_ctx->undo) {
        ifXTable_release_data(rowreq_ctx->undo);
        rowreq_ctx->undo = NULL;
    }


    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_undo_cleanup */

/*----------------------------------------------------------------------
 *
 * SET: Set values
 *
 *---------------------------------------------------------------------*/
/*
 * @internal
 * Set the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ifXTable_set_column(ifXTable_rowreq_ctx * rowreq_ctx,
                     netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_set_column",
                "called for %d\n", column));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ifLinkUpDownTrapEnable(14)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFLINKUPDOWNTRAPENABLE:
        rowreq_ctx->column_set_flags |= COLUMN_IFLINKUPDOWNTRAPENABLE_FLAG;
        rc = ifLinkUpDownTrapEnable_set(rowreq_ctx,
                                        *((u_long *) var->val.string));
        break;

        /*
         * ifPromiscuousMode(16)/TruthValue/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFPROMISCUOUSMODE:
        rowreq_ctx->column_set_flags |= COLUMN_IFPROMISCUOUSMODE_FLAG;
        rc = ifPromiscuousMode_set(rowreq_ctx,
                                   *((u_long *) var->val.string));
        break;

        /*
         * ifAlias(18)/DisplayString/ASN_OCTET_STR/char(char)//L/A/W/e/R/d/H 
         */
    case COLUMN_IFALIAS:
        rowreq_ctx->column_set_flags |= COLUMN_IFALIAS_FLAG;
        rc = ifAlias_set(rowreq_ctx, (char *) var->val.string,
                         var->val_len);
        break;

    default:
        snmp_log(LOG_ERR, "unknown column %d in _ifXTable_set_column\n",
                 column);
        rc = SNMP_ERR_GENERR;
        break;
    }

    return rc;
}                               /* _ifXTable_set_column */

int
_mfd_ifXTable_set_values(netsnmp_mib_handler *handler,
                         netsnmp_handler_registration *reginfo,
                         netsnmp_agent_request_info *agtreq_info,
                         netsnmp_request_info *requests)
{
    ifXTable_rowreq_ctx *rowreq_ctx = (ifXTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;
    int             rc = SNMP_ERR_NOERROR;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_set_values", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rowreq_ctx->column_set_flags = 0;
    for (; requests; requests = requests->next) {
        /*
         * set column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ifXTable_set_column(rowreq_ctx,
                                  requests->requestvb, tri->colnum);
        if (MFD_SUCCESS != rc) {
            DEBUGMSGTL(("ifXTable:mfd", "error %d from "
                        "ifXTable_set_column\n", rc));
            netsnmp_set_request_error(agtreq_info, requests,
                                      SNMP_VALIDATE_ERR(rc));
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_set_values */

/*----------------------------------------------------------------------
 *
 * SET: commit
 *
 *---------------------------------------------------------------------*/
/**
 * @internal
 * commit the values
 */
int
_mfd_ifXTable_commit(netsnmp_mib_handler *handler,
                     netsnmp_handler_registration *reginfo,
                     netsnmp_agent_request_info *agtreq_info,
                     netsnmp_request_info *requests)
{
    int             rc;
    ifXTable_rowreq_ctx *rowreq_ctx = (ifXTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_commit", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = ifXTable_commit(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        DEBUGMSGTL(("ifXTable:mfd", "error %d from "
                    "ifXTable_commit\n", rc));
        netsnmp_request_set_error_all(requests, SNMP_VALIDATE_ERR(rc));
    }

    if (rowreq_ctx->rowreq_flags & MFD_ROW_DIRTY) {
        /*
         * if we successfully commited this row, set the dirty flag. Use the
         * current value + 1 (i.e. dirty = # rows changed).
         * this is checked in post_request...
         */
        ifXTable_dirty_set(ifXTable_dirty_get() + 1);   /* set table dirty flag */
    }

    return SNMP_ERR_NOERROR;
}

int
_mfd_ifXTable_undo_commit(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info *agtreq_info,
                          netsnmp_request_info *requests)
{
    int             rc;
    ifXTable_rowreq_ctx *rowreq_ctx = (ifXTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_undo_commit",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    if (rowreq_ctx->rowreq_flags & MFD_ROW_DIRTY) {
        u_int           d = ifXTable_dirty_get();

        netsnmp_assert(d != 0);
        if (d)
            ifXTable_dirty_set(d - 1);
    }

    rc = ifXTable_undo_commit(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("ifXTable:mfd", "error %d from "
                    "ifXTable_undo_commit\n", rc));
    }

    if (rowreq_ctx->rowreq_flags & MFD_ROW_DIRTY) {
        snmp_log(LOG_WARNING,
                 "ifXTable row dirty flag still set after undo_commit\n");
        rowreq_ctx->rowreq_flags &= ~MFD_ROW_DIRTY;
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_commit */

/*----------------------------------------------------------------------
 *
 * SET: Undo
 *
 *---------------------------------------------------------------------*/
/**
 * @internal
 * undo the value for a particular column
 */
NETSNMP_STATIC_INLINE int
_ifXTable_undo_column(ifXTable_rowreq_ctx * rowreq_ctx,
                      netsnmp_variable_list * var, int column)
{
    int             rc = SNMPERR_SUCCESS;

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_undo_column",
                "called for %d\n", column));

    netsnmp_assert(NULL != rowreq_ctx);

    switch (column) {

        /*
         * ifLinkUpDownTrapEnable(14)/INTEGER/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFLINKUPDOWNTRAPENABLE:
        rc = ifLinkUpDownTrapEnable_undo(rowreq_ctx);
        break;

        /*
         * ifPromiscuousMode(16)/TruthValue/ASN_INTEGER/long(u_long)//l/A/W/E/r/d/h 
         */
    case COLUMN_IFPROMISCUOUSMODE:
        rc = ifPromiscuousMode_undo(rowreq_ctx);
        break;

        /*
         * ifAlias(18)/DisplayString/ASN_OCTET_STR/char(char)//L/A/W/e/R/d/H 
         */
    case COLUMN_IFALIAS:
        rc = ifAlias_undo(rowreq_ctx);
        break;

    default:
        snmp_log(LOG_ERR, "unknown column %d in _ifXTable_undo_column\n",
                 column);
        break;
    }

    return rc;
}                               /* _ifXTable_undo_column */

int
_mfd_ifXTable_undo_values(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info *agtreq_info,
                          netsnmp_request_info *requests)
{
    int             rc;
    ifXTable_rowreq_ctx *rowreq_ctx = (ifXTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);
    netsnmp_table_request_info *tri;

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_undo_values",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    rc = ifXTable_undo(rowreq_ctx);
    if (MFD_SUCCESS != rc) {
        /*
         * nothing we can do about it but log it
         */
        DEBUGMSGTL(("ifXTable:mfd", "error %d from "
                    "ifXTable_undo\n", rc));
    }

    for (; requests; requests = requests->next) {
        /*
         * set column data
         */
        tri = netsnmp_extract_table_info(requests);
        if (NULL == tri)
            continue;

        rc = _ifXTable_undo_column(rowreq_ctx, requests->requestvb,
                                   tri->colnum);
        if (MFD_SUCCESS != rc) {
            /*
             * nothing we can do about it but log it
             */
            DEBUGMSGTL(("ifXTable:mfd", "error %d from "
                        "ifXTable_undo_column\n", rc));
        }
    }                           /* for results */

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_undo_values */

/*----------------------------------------------------------------------
 *
 * SET: irreversible commit
 *
 *---------------------------------------------------------------------*/
/**
 * @internal
 * commit irreversible actions
 */
int
_mfd_ifXTable_irreversible_commit(netsnmp_mib_handler *handler,
                                  netsnmp_handler_registration *reginfo,
                                  netsnmp_agent_request_info *agtreq_info,
                                  netsnmp_request_info *requests)
{
    ifXTable_rowreq_ctx *rowreq_ctx = (ifXTable_rowreq_ctx*)
        netsnmp_container_table_row_extract(requests);

    DEBUGMSGTL(("internal:ifXTable:_mfd_ifXTable_irreversible:commit",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * check for and handle row creation/deletion
     * and update column exist flags...
     */
    if (rowreq_ctx->rowreq_flags & MFD_ROW_DELETED) {
        CONTAINER_REMOVE(ifXTable_if_ctx.container, rowreq_ctx);
    } else {
        if (rowreq_ctx->column_set_flags) {
            rowreq_ctx->column_set_flags = 0;
        }
    }

    return SNMP_ERR_NOERROR;
}                               /* _mfd_ifXTable_irreversible_commit */

/***********************************************************************
 *
 * DATA ACCESS
 *
 ***********************************************************************/
/**
 * @internal
 * initialize the container with functions or wrappers
 */
void
_ifXTable_container_init(ifXTable_interface_ctx * if_ctx)
{
    DEBUGMSGTL(("internal:ifXTable:_ifXTable_container_init", "called\n"));

    /*
     * cache init
     *
     * special case: sharing a cache
     */
    if_ctx->cache =
        netsnmp_cache_find_by_oid(ifTable_oid, ifTable_oid_size);
    if (NULL != if_ctx->cache) {
        if_ctx->container = (netsnmp_container *) if_ctx->cache->magic;
        return;
    } else {
        snmp_log(LOG_ERR, "error finding ifTable cache\n");
    }
}

/*
 * allow direct access to container.
 */
netsnmp_container *
_ifXTable_container_get(void)
{
    return ifXTable_if_ctx.container;
}

/**
 * @internal
 * shutdown the container with functions or wrappers
 */
void
_ifXTable_container_shutdown(ifXTable_interface_ctx * if_ctx)
{
    DEBUGMSGTL(("internal:ifXTable:_ifXTable_container_shutdown",
                "called\n"));

    /*
     * ifTable does this for us
     */
}                               /* _ifXTable_container_shutdown */

/***********************************************************************
 *
 * PERSISTENCE
 *
 ***********************************************************************/

static int      _ifXTable_container_save_rows(int majorID, int minorID,
                                              void *serverarg,
                                              void *clientarg);
static void     _ifXTable_container_row_restore(const char *token,
                                                char *buf);
static int      _ifXTable_container_row_save(ifXTable_rowreq_ctx *
                                             rowreq_ctx, void *type);
static char    *_ifXTable_container_col_restore(ifXTable_rowreq_ctx *
                                                rowreq_ctx, u_int col,
                                                char *buf);
static char    *_ifXTable_container_col_save(ifXTable_rowreq_ctx *
                                             rowreq_ctx, u_int col,
                                             char *buf);

static const char row_token[] = "ifXTable";

/************************************************************
 * *_init_persistence should be called from the main table
 * init routine.
 *
 * If your table depends on rows in another table,
 * you should register your callback after the other table,
 * which should ensure the rows on which you depend are saved
 * (and re-created) before the dependent rows.
 */
void
ifXTable_container_init_persistence(netsnmp_container *container)
{
    int             rc;

    register_config_handler(NULL, row_token,
                            _ifXTable_container_row_restore, NULL, NULL);
    rc = snmp_register_callback(SNMP_CALLBACK_LIBRARY,
                                SNMP_CALLBACK_STORE_DATA,
                                _ifXTable_container_save_rows, container);

    if (rc != SNMP_ERR_NOERROR)
        snmp_log(LOG_ERR, "error registering for STORE_DATA callback "
                 "in _ifXTable_container_init_persistence\n");
}

static int
_ifXTable_container_save_rows(int majorID, int minorID, void *serverarg,
                              void *clientarg)
{
    char            sep[] =
        "##############################################################";
    char            buf[] = "#\n" "# ifXTable persistent data\n" "#";
    char           *type = netsnmp_ds_get_string(NETSNMP_DS_LIBRARY_ID,
                                                 NETSNMP_DS_LIB_APPTYPE);

    read_config_store((char *) type, sep);
    read_config_store((char *) type, buf);

    /*
     * save all rows
     */
    CONTAINER_FOR_EACH((netsnmp_container *) clientarg,
                       (netsnmp_container_obj_func *)
                       _ifXTable_container_row_save, type);

    read_config_store((char *) type, sep);
    read_config_store((char *) type, "\n");

    /*
     * never fails 
     */
    return SNMPERR_SUCCESS;
}



/************************************************************
 * _ifXTable_container_row_save
 */
static int
_ifXTable_container_row_save(ifXTable_rowreq_ctx * rowreq_ctx, void *type)
{
    /*
     * Allocate space for a line with all data for a row. An
     * attempt is made to come up with a default maximum size, but
     * there is no guarantee it will be enough. It probably will be,
     * unless you are dealing with large values or you have external
     * indexes.
     *
     * 1) allocate space for each column. Comment out columns you don't
     * intend to save. You may also need to add room for any non-
     * column data you want to store. Remeber, data will be stored in
     * ASCII form, so you need to allow for that. Here are some
     * general guidelines:
     *
     *   Object ID   :  12 * len [ASCII len of max int + 1 for .]
     *   Octet String: (2 * len) + 2 [2 ASCII chars per byte + "0x"]
     *   Integers    :  12 [ASCII len for smallest negative number]
     *
     * 2) You also need to allocate space for the row index. This will
     * be stored as an OID, which means that Octet Strings need to
     * be treated a little differently. Specifically, you will need
     * (4 * len) + 4 [3 ASCII chars per byte + 1 for ., + 4 for len].
     *
     * 3) Also, remember to add space for the identifier and separator
     * characters (for example, each column is prefixed by the
     * column number and a semicolon. To allow for the maximum
     * column values, 12 bytes [11 for oid + 1 for ':'] per
     * column are added).
     */
        /** xxx: add storage for external index(s)! */
#define MAX_ROW_SIZE (sizeof(row_token) + 1 +  \
        ( 12 ) + /* ASN_INTEGER ifLinkUpDownTrapEnable */ \
        ( 12 ) + /* ASN_INTEGER ifPromiscuousMode */ \
        ( ( 2 * sizeof(rowreq_ctx->data.ifAlias) ) + 3 ) + /* ASN_OCTET_STR */ \
        ( IFXTABLE_MAX_COL * 12 ) + /* column num prefix + : */ \
    2 /* LINE_TERM_CHAR + \n */ )

    char            buf[MAX_ROW_SIZE], *pos = buf, *max =
        &buf[MAX_ROW_SIZE - 1];
    char           *tmp;
    int             i;

    if (ifXTable_container_should_save(rowreq_ctx) == 0) {
        return SNMP_ERR_NOERROR;
    }

    /*
     * build the line
     */
    pos += sprintf(pos, "%s ", row_token);
    pos = read_config_save_objid(pos, rowreq_ctx->oid_idx.oids,
                                 rowreq_ctx->oid_idx.len);
    if (NULL == pos) {
        snmp_log(LOG_ERR, "error saving ifXTable row "
                 "to persistent file\n");
        return SNMP_ERR_GENERR;
    }
    *pos++ = ' ';
    if (pos > max) {
        snmp_log(LOG_ERR, "error saving ifXTable row "
                 "to persistent file (too long)\n");
        return SNMP_ERR_GENERR;
    }

    /*
     * add each column
     */
    for (i = IFXTABLE_MIN_COL; i <= IFXTABLE_MAX_COL; ++i) {

        if ((0x1 << (i - 1)) & ~IFXTABLE_SETTABLE_COLS)
            continue;

        tmp = pos;
        pos = _ifXTable_container_col_save(rowreq_ctx, i, pos);
        if (NULL == pos)
            pos = tmp;
        else
            *pos++ = ' ';
        if (pos > max) {
            snmp_log(LOG_ERR, "error saving ifXTable row "
                     "to persistent file (too long)\n");
            return SNMP_ERR_GENERR;
        }
    }

    /*
     * if you have non-column data, add it here
     */


    /*
     * store the line
     */
    pos += sprintf(pos, "%c", LINE_TERM_CHAR);
    if (pos > max) {
        snmp_log(LOG_ERR, "error saving ifXTable row "
                 "to persistent file (too long)\n");
        return SNMP_ERR_GENERR;
    }
    read_config_store((char *) type, buf);

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_container_row_save",
                "saving line '%s'\n", buf));

    return SNMP_ERR_NOERROR;
}

static void
_ifXTable_container_row_restore(const char *token, char *buf)
{
    ifXTable_rowreq_ctx *rowreq_ctx;
    netsnmp_container *container;
    netsnmp_index   index;
    oid             tmp_oid[MAX_ifTable_IDX_LEN];
    u_int           col = 0, found = 0;


    if (strncmp(token, row_token, sizeof(row_token)) != 0) {
        snmp_log(LOG_ERR,
                 "unknown token in _ifXTable_container_row_restore\n");
        return;
    }

    container = _ifXTable_container_get();
    if (NULL == container) {
        snmp_log(LOG_ERR, "null container in _ifXTable_restore\n");
        return;
    }

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_container_row_restore",
                "parsing line '%s'\n", buf));

    /*
     * pull out index and find row. (Since we populate the cache
     * during startup, all rows should exist.)
     */
    index.oids = tmp_oid;
    index.len = OID_LENGTH(tmp_oid);
    buf = read_config_read_objid(buf, &index.oids, &index.len);
    if (NULL == buf) {
        snmp_log(LOG_ERR, "error reading row index in "
                 "_ifXTable_container_row_restore\n");
        return;
    }
    rowreq_ctx = (ifXTable_rowreq_ctx*)CONTAINER_FIND(container, &index);
    if (NULL == rowreq_ctx) {
        snmp_log(LOG_ERR, "error finding row index in "
                 "_ifXTable_container_row_restore\n");
        return;
    }

    /*
     * loop through and get each column
     */
    buf = skip_white(buf);
    while ((NULL != buf) && isdigit(*buf & 0xFF)) {
        /*
         * extract column, skip ':'
         */
        col = (u_int) strtol(buf, &buf, 10);
        if (NULL == buf)
            break;
        if (*buf != ':') {
            buf = NULL;
            break;
        }
        ++buf;                  /* skip : */

        /*
         * parse value
         */
        DEBUGMSGTL(("_ifXTable_container_row_restore",
                    "parsing column %d\n", col));
        buf = _ifXTable_container_col_restore(rowreq_ctx, col, buf);
        ++found;
    }
    if (0 == found) {
        snmp_log(LOG_ERR, "error parsing ifXTable row; no columns found\n");
        ifTable_release_rowreq_ctx(rowreq_ctx);
        return;
    }

    /*
     * if you added any non-column data, this is where
     * you should handle it.
     */

    /*
     * if the pointer is NULL and we didn't reach the
     * end of the line, something went wrong. Log message,
     * and bail.
     */
    if ((buf == NULL) || (*buf != LINE_TERM_CHAR)) {
        snmp_log(LOG_ERR, "error parsing ifXTable row around column %d\n",
                 col);
        return;
    }

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_container_row_restore",
                "inserting row\n"));
}

/************************************************************
 * _ifXTable_container_col_save
 */
static char    *
_ifXTable_container_col_save(ifXTable_rowreq_ctx * rowreq_ctx,
                             u_int col, char *buf)
{
    if ((NULL == rowreq_ctx) || (NULL == buf)) {
        snmp_log(LOG_ERR, "bad parameter in "
                 "_ifXTable_container_col_save\n");
        return NULL;
    }

    DEBUGMSGTL(("internal:ifXTable:_ifXTable_container_col_save",
                "processing column %d\n", col));

    /*
     * prefix with column number, so we don't ever depend on
     * order saved.
     */
    buf += sprintf(buf, "%u:", col);

    /*
     * save data for the column
     */
    switch (col) {

    case COLUMN_IFLINKUPDOWNTRAPENABLE:   /** INTEGER = ASN_INTEGER */
        buf +=
            sprintf(buf, "%ld", rowreq_ctx->data.ifLinkUpDownTrapEnable);
        break;

    case COLUMN_IFALIAS:   /** DisplayString = ASN_OCTET_STR */
        buf = read_config_save_octet_string(buf,
                                            (u_char *) rowreq_ctx->data.ifAlias,
                                            rowreq_ctx->data.ifAlias_len);
        break;

    default:
            /** We shouldn't get here */
        snmp_log(LOG_ERR, "unknown column %d in "
                 "_ifXTable_container_col_save\n", col);
        return NULL;
    }

    return buf;
}

/************************************************************
 * _ifXTable_container_col_restore
 */
static char    *
_ifXTable_container_col_restore(ifXTable_rowreq_ctx * rowreq_ctx,
                                u_int col, char *buf)
{
    size_t          len;
    if ((NULL == rowreq_ctx) || (NULL == buf)) {
        snmp_log(LOG_ERR, "bad parameter in "
                 "_ifXTable_container_col_restore\n");
        return NULL;
    }

    DEBUGMSGTL(("verbose:ifXTable:_ifXTable_container_col_restore",
                "processing column %d\n", col));

    /*
     * restore data for the column
     */
    switch (col) {

    case COLUMN_IFLINKUPDOWNTRAPENABLE:   /** INTEGER = ASN_INTEGER */
        len = sizeof(rowreq_ctx->data.ifLinkUpDownTrapEnable);
        buf = read_config_read_memory(ASN_INTEGER, buf,
                                      (char *) &rowreq_ctx->data.
                                      ifLinkUpDownTrapEnable, &len);
        break;

    case COLUMN_IFALIAS:   /** DisplayString = ASN_OCTET_STR */
        rowreq_ctx->data.ifAlias_len = sizeof(rowreq_ctx->data.ifAlias);
        buf = read_config_read_memory(ASN_OCTET_STR, buf,
                                      (char *) &rowreq_ctx->data.ifAlias,
                                      (size_t *) & rowreq_ctx->data.
                                      ifAlias_len);
        break;

    default:
            /** We shouldn't get here */
        snmp_log(LOG_ERR, "unknown column %d in "
                 "_ifXTable_container_col_restore\n", col);
        return NULL;
    }

    return buf;
}


ifXTable_rowreq_ctx *
ifXTable_row_find_by_mib_index(ifXTable_mib_index * mib_idx)
{
    ifXTable_rowreq_ctx *rowreq_ctx;
    oid             oid_tmp[MAX_OID_LEN];
    netsnmp_index   oid_idx;
    int             rc;

    /*
     * set up storage for OID
     */
    oid_idx.oids = oid_tmp;
    oid_idx.len = sizeof(oid_tmp) / sizeof(oid);

    /*
     * convert
     */
    rc = ifXTable_index_to_oid(&oid_idx, mib_idx);
    if (MFD_SUCCESS != rc)
        return NULL;

    rowreq_ctx = (ifXTable_rowreq_ctx*)CONTAINER_FIND(ifXTable_if_ctx.container, &oid_idx);

    return rowreq_ctx;
}
