/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcBatchUpdateException;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcResultSet;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcOdbcStatement
extends JdbcOdbcObject
implements Statement {
    protected JdbcOdbc OdbcApi = null;
    protected long hDbc = 0L;
    protected long hStmt = 0L;
    protected SQLWarning lastWarning = null;
    protected Hashtable typeInfo;
    protected ResultSet myResultSet;
    protected JdbcOdbcConnectionInterface myConnection;
    protected int rsType;
    protected int rsConcurrency;
    protected int fetchDirection;
    protected int fetchSize;
    protected Vector batchSqlVec;
    protected boolean batchSupport;
    protected int batchRCFlag;
    protected String mySql;
    protected boolean batchOn;
    protected int rsBlockSize;
    protected int moreResults;
    protected boolean closeCalledFromFinalize;

    public JdbcOdbcStatement(JdbcOdbcConnectionInterface jdbcOdbcConnectionInterface) {
        this.myConnection = jdbcOdbcConnectionInterface;
        this.rsType = 1003;
        this.rsConcurrency = 1007;
        this.fetchDirection = 1000;
        this.fetchSize = 1;
        this.batchRCFlag = -1;
        this.batchSupport = false;
        this.moreResults = 1;
    }

    protected void finalize() {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("Statement.finalize " + this);
        }
        try {
            this.closeCalledFromFinalize = true;
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void initialize(JdbcOdbc jdbcOdbc, long l, long l2, Hashtable hashtable, int n, int n2) throws SQLException {
        block17: {
            block16: {
                this.OdbcApi = jdbcOdbc;
                this.hDbc = l;
                this.hStmt = l2;
                this.rsType = n;
                this.rsConcurrency = n2;
                this.typeInfo = hashtable;
                this.batchRCFlag = this.myConnection.getBatchRowCountFlag(1);
                this.batchSupport = this.batchRCFlag > 0 && this.batchRCFlag == 2;
                if (this.rsType == 1003 || this.rsType == 1004 || this.rsType == 1005) {
                    if (this.rsConcurrency != 1007 && this.rsConcurrency != 1008) {
                        this.close();
                        throw new SQLException("Invalid Concurrency Type.");
                    }
                } else {
                    this.close();
                    throw new SQLException("Invalid Cursor Type.");
                }
                int n3 = this.myConnection.getOdbcCursorType(this.rsType);
                if (n3 == -1) {
                    n3 = this.myConnection.getBestOdbcCursorType();
                    if (n3 == -1) {
                        throw new SQLException("The result set type is not supported.");
                    }
                    this.setWarning(new SQLWarning("The result set type has been downgraded and changed."));
                    switch (n3) {
                        case 0: {
                            this.rsType = 1003;
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.rsType = 1004;
                        }
                    }
                }
                if (this.rsConcurrency == 1008) {
                    n3 = 2;
                }
                try {
                    this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)6, n3);
                }
                catch (SQLWarning sQLWarning) {
                    this.setWarning(sQLWarning);
                }
                catch (SQLException sQLException) {
                    if (n3 == 0) break block16;
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            short s = this.myConnection.getOdbcConcurrency(this.rsConcurrency);
            try {
                this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)7, s);
            }
            catch (SQLWarning sQLWarning) {
                this.setWarning(sQLWarning);
            }
            catch (SQLException sQLException) {
                if (s == 1) break block17;
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.executeQuery (" + string + ")");
        }
        ResultSet resultSet = null;
        if (!this.execute(string)) {
            throw new SQLException("No ResultSet was produced");
        }
        resultSet = this.getResultSet(false);
        if (this.batchOn) {
            this.clearBatch();
        }
        return resultSet;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.executeUpdate (" + string + ")");
        }
        int n = -1;
        if (this.execute(string)) {
            throw new SQLException("No row count was produced");
        }
        n = this.getUpdateCount();
        if (this.batchOn) {
            this.clearBatch();
        }
        return n;
    }

    @Override
    public synchronized boolean execute(String string) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.execute (" + string + ")");
        }
        boolean bl = false;
        SQLWarning sQLWarning = null;
        this.setSql(string);
        this.reset();
        this.lockIfNecessary(string);
        try {
            this.OdbcApi.SQLExecDirect(this.hStmt, string);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        if (this.getColumnCount() > 0) {
            bl = true;
        }
        if (this.batchOn) {
            this.clearBatch();
        }
        return bl;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getResultSet");
        }
        if (this.myResultSet != null) {
            return this.myResultSet;
        }
        this.myResultSet = this.getResultSet(true);
        return this.myResultSet;
    }

    public synchronized ResultSet getResultSet(boolean bl) throws SQLException {
        if (this.myResultSet != null) {
            throw new SQLException("Invalid state for getResultSet");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        int n = 1;
        if (bl) {
            n = this.getColumnCount();
        }
        if (n > 0) {
            if (this.rsType != 1003) {
                this.checkCursorDowngrade();
            }
            jdbcOdbcResultSet = new JdbcOdbcResultSet();
            jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, this.hStmt, true, this);
            this.myResultSet = jdbcOdbcResultSet;
        } else {
            this.clearMyResultSet();
        }
        return jdbcOdbcResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getUpdateCount");
        }
        int n = -1;
        if (this.moreResults == 3) {
            return n;
        }
        if (this.getColumnCount() == 0) {
            n = this.getRowCount();
        }
        return n;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.close");
        }
        this.clearMyResultSet();
        try {
            this.clearWarnings();
            if (this.hStmt != 0L) {
                if (this.closeCalledFromFinalize) {
                    if (!this.myConnection.isFreeStmtsFromConnectionOnly()) {
                        this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                    }
                } else {
                    this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                }
                this.hStmt = 0L;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.myConnection.deregisterStatement(this);
    }

    protected void reset() throws SQLException {
        this.clearWarnings();
        this.clearMyResultSet();
        if (this.hStmt != 0L) {
            this.OdbcApi.SQLFreeStmt(this.hStmt, 0);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getMoreResults");
        }
        SQLWarning sQLWarning = null;
        boolean bl = false;
        if (this.moreResults == 1) {
            this.moreResults = 3;
        }
        this.clearWarnings();
        try {
            this.moreResults = this.OdbcApi.SQLMoreResults(this.hStmt) ? 2 : 3;
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        if (this.moreResults == 2 && this.getColumnCount() != 0) {
            bl = true;
        }
        this.setWarning(sQLWarning);
        return bl;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getMaxFieldSize");
        }
        return this.getStmtOption((short)3);
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.setMaxFieldSize (" + n + ")");
        }
        this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)3, n);
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getMaxRows");
        }
        return this.getStmtOption((short)1);
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.setMaxRows (" + n + ")");
        }
        if (n < 0) {
            throw new SQLException("Invalid new max row limit");
        }
        this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)1, n);
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.setEscapeProcessing (" + bl + ")");
        }
        int n = 0;
        if (!bl) {
            n = 1;
        }
        this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)2, n);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getQueryTimeout");
        }
        return this.getStmtOption((short)0);
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.setQueryTimeout (" + n + ")");
        }
        this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)0, n);
    }

    @Override
    public void cancel() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.cancel");
        }
        this.clearWarnings();
        try {
            this.OdbcApi.SQLCancel(this.hStmt);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getWarnings");
        }
        return this.lastWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public void setWarning(SQLWarning sQLWarning) {
        this.lastWarning = sQLWarning;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.setCursorName " + string + ")");
        }
        this.OdbcApi.SQLSetCursorName(this.hStmt, string);
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000 && n != 1001 && n != 1002) {
            throw new SQLException("Invalid fetch direction");
        }
        this.fetchDirection = n;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (0 > n || n > this.getMaxRows()) {
            throw new SQLException("Invalid Fetch Size");
        }
        this.fetchSize = n;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.rsType;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.addBatch (" + string + ")");
        }
        try {
            if (string != null) {
                this.batchSqlVec = this.myConnection.getBatchVector(this);
                if (this.batchSqlVec == null) {
                    this.batchSqlVec = new Vector(5, 10);
                }
                this.batchSqlVec.addElement(string);
                this.myConnection.setBatchVector(this.batchSqlVec, this);
                this.batchOn = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void clearBatch() {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.clearBatch");
        }
        try {
            if (this.batchSqlVec != null) {
                this.myConnection.removeBatchVector(this);
                this.batchSqlVec = null;
                this.batchOn = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public int[] executeBatch() throws BatchUpdateException {
        return this.executeBatchUpdate();
    }

    protected int[] executeBatchUpdate() throws BatchUpdateException {
        int[] nArray;
        block10: {
            nArray = new int[]{};
            int[] nArray2 = null;
            int n = 0;
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("*Statement.executeBatch");
            }
            if (!this.batchSupport) {
                return this.emulateBatchUpdate();
            }
            this.batchSqlVec = this.myConnection.getBatchVector(this);
            if (this.batchSqlVec != null) {
                int n2;
                Enumeration enumeration = this.batchSqlVec.elements();
                nArray = new int[this.batchSqlVec.size()];
                int n3 = nArray.length;
                StringBuffer stringBuffer = new StringBuffer();
                for (n2 = 0; n2 < n3; ++n2) {
                    if (!enumeration.hasMoreElements()) continue;
                    String string = (String)enumeration.nextElement();
                    stringBuffer.append(string + "\n");
                }
                try {
                    if (!this.execute(stringBuffer.toString())) {
                        while ((n2 = this.getUpdateCount()) != -1) {
                            nArray[n++] = n2;
                            this.getMoreResults();
                        }
                        if (n < n3) {
                            nArray2 = new int[n];
                            for (n2 = 0; n2 < n; ++n2) {
                                nArray2[n2] = nArray[n2];
                            }
                            this.clearBatch();
                            throw new JdbcOdbcBatchUpdateException("SQL Attempt to produce a ResultSet from executeBatch", nArray2);
                        }
                        break block10;
                    }
                    this.clearBatch();
                    throw new JdbcOdbcBatchUpdateException("SQL Attempt to produce a ResultSet from executeBatch", null);
                }
                catch (SQLException sQLException) {
                    this.clearBatch();
                    throw new JdbcOdbcBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), nArray2);
                }
            }
        }
        this.clearBatch();
        return nArray;
    }

    protected int[] emulateBatchUpdate() throws BatchUpdateException {
        int[] nArray = new int[]{};
        this.batchSqlVec = this.myConnection.getBatchVector(this);
        if (this.batchSqlVec != null) {
            int[] nArray2 = new int[]{};
            int n = 0;
            Enumeration enumeration = this.batchSqlVec.elements();
            nArray = new int[this.batchSqlVec.size()];
            for (int i = 0; i < nArray.length; ++i) {
                if (!enumeration.hasMoreElements()) continue;
                String string = (String)enumeration.nextElement();
                try {
                    if (!this.execute(string)) {
                        nArray[i] = this.getUpdateCount();
                        ++n;
                        continue;
                    }
                    nArray2 = new int[n];
                    for (int j = 0; j <= i - 1; ++j) {
                        nArray2[j] = nArray[j];
                    }
                    this.clearBatch();
                    throw new JdbcOdbcBatchUpdateException("No row count was produced from executeBatch", nArray2);
                }
                catch (SQLException sQLException) {
                    nArray2 = new int[n];
                    for (int j = 0; j <= i - 1; ++j) {
                        nArray2[j] = nArray[j];
                    }
                    this.clearBatch();
                    throw new JdbcOdbcBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), nArray2);
                }
            }
            this.clearBatch();
        }
        return nArray;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.myConnection;
    }

    public String getSql() {
        return this.mySql;
    }

    public void setSql(String string) {
        this.mySql = string.toUpperCase();
    }

    public Object[] getObjects() {
        Object[] objectArray = new Object[]{};
        return objectArray;
    }

    public int[] getObjectTypes() {
        int[] nArray = new int[]{};
        return nArray;
    }

    public int getParamCount() {
        return 0;
    }

    public int getBlockCursorSize() {
        return this.rsBlockSize;
    }

    public void setBlockCursorSize(int n) {
        this.rsBlockSize = n;
    }

    protected int getStmtOption(short s) throws SQLException {
        int n = 0;
        this.clearWarnings();
        try {
            n = (int)this.OdbcApi.SQLGetStmtOption(this.hStmt, s);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n;
    }

    protected int getColumnCount() throws SQLException {
        int n = 0;
        try {
            n = this.OdbcApi.SQLNumResultCols(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
        }
        return n;
    }

    protected int getRowCount() throws SQLException {
        int n = 0;
        try {
            n = this.OdbcApi.SQLRowCount(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
        }
        return n;
    }

    protected boolean lockIfNecessary(String string) throws SQLException {
        boolean bl = false;
        String string2 = string.toUpperCase();
        int n = string2.indexOf(" FOR UPDATE");
        if (n > 0) {
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("Setting concurrency for update");
            }
            try {
                this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)7, 2);
            }
            catch (SQLWarning sQLWarning) {
                this.setWarning(sQLWarning);
            }
            bl = true;
        }
        return bl;
    }

    protected int getPrecision(int n) {
        JdbcOdbcTypeInfo jdbcOdbcTypeInfo;
        int n2 = -1;
        if (this.typeInfo != null && (jdbcOdbcTypeInfo = (JdbcOdbcTypeInfo)this.typeInfo.get(new Integer(n))) != null) {
            n2 = jdbcOdbcTypeInfo.getPrec();
        }
        if (n == -2 && n2 == -1) {
            n2 = this.getPrecision(-3);
        }
        return n2;
    }

    protected synchronized void clearMyResultSet() throws SQLException {
        if (this.myResultSet != null) {
            if (this.hStmt != 0L) {
                this.myResultSet.close();
            }
            this.myResultSet = null;
        }
    }

    protected void checkCursorDowngrade() throws SQLException {
        int n = (int)this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)6);
        if (n != this.myConnection.getOdbcCursorType(this.rsType)) {
            this.rsType = n == 0 ? 1003 : 1004;
        }
        this.setWarning(new SQLWarning("Result set type has been changed."));
    }

    public static int getTypeFromObject(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            return 1;
        }
        if (object instanceof BigDecimal) {
            return 2;
        }
        if (object instanceof Boolean) {
            return -7;
        }
        if (object instanceof Byte) {
            return -6;
        }
        if (object instanceof Short) {
            return 5;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Long) {
            return -5;
        }
        if (object instanceof Float) {
            return 6;
        }
        if (object instanceof Double) {
            return 8;
        }
        if (object instanceof byte[]) {
            return -3;
        }
        if (object instanceof InputStream) {
            return -4;
        }
        if (object instanceof Reader) {
            return -1;
        }
        if (object instanceof Date) {
            return 91;
        }
        if (object instanceof Time) {
            return 92;
        }
        if (object instanceof Timestamp) {
            return 93;
        }
        return 1111;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
    }
}

