/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.soap;

import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.encoding.internal.InternalEncoder;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.internal.ws.encoding.soap.EncoderDecoder;
import com.sun.xml.internal.ws.encoding.soap.SerializationException;
import com.sun.xml.internal.ws.encoding.soap.internal.AttachmentBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.BodyBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.model.CheckedException;
import com.sun.xml.internal.ws.model.ExceptionType;
import com.sun.xml.internal.ws.model.JavaMethod;
import com.sun.xml.internal.ws.model.Parameter;
import com.sun.xml.internal.ws.model.ParameterBinding;
import com.sun.xml.internal.ws.model.RuntimeModel;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.model.soap.SOAPBinding;
import com.sun.xml.internal.ws.model.soap.SOAPRuntimeModel;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.ws.Holder;

public class ServerEncoderDecoder
extends EncoderDecoder
implements InternalEncoder {
    public void toMessageInfo(Object object, MessageInfo messageInfo) {
        InternalMessage internalMessage = (InternalMessage)object;
        RuntimeContext runtimeContext = (RuntimeContext)messageInfo.getMetaData("com.sun.xml.internal.ws.runtime.context");
        BodyBlock bodyBlock = internalMessage.getBody();
        JavaMethod javaMethod = runtimeContext.getModel().getJavaMethod(messageInfo.getMethod());
        messageInfo.setMEP(javaMethod.getMEP());
        List<HeaderBlock> list = internalMessage.getHeaders();
        Map<String, AttachmentBlock> map = internalMessage.getAttachments();
        Iterator<Parameter> iterator = javaMethod.getRequestParameters().iterator();
        Object object2 = bodyBlock == null ? null : bodyBlock.getValue();
        int n = javaMethod.getInputParametersCount();
        Object[] objectArray = new Object[n];
        SOAPBinding sOAPBinding = (SOAPBinding)javaMethod.getBinding();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            ParameterBinding object3 = parameter.getInBinding();
            Object object4 = null;
            if (object3.isBody()) {
                object4 = object2;
            } else if (list != null && object3.isHeader()) {
                HeaderBlock headerBlock = this.getHeaderBlock(parameter.getName(), list);
                object4 = headerBlock != null ? headerBlock.getValue() : null;
            } else if (object3.isAttachment()) {
                object4 = this.getAttachment(runtimeContext, map, parameter, object3);
            }
            this.fillData(runtimeContext, parameter, object4, objectArray, sOAPBinding, object3);
        }
        for (Parameter parameter : javaMethod.getResponseParameters()) {
            this.createOUTHolders(parameter, objectArray);
        }
        messageInfo.setData(objectArray);
    }

    public Object toInternalMessage(MessageInfo messageInfo) {
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        RuntimeModel runtimeModel = runtimeContext.getModel();
        JavaMethod javaMethod = runtimeModel.getJavaMethod(messageInfo.getMethod());
        Object[] objectArray = messageInfo.getData();
        Object object = messageInfo.getResponse();
        InternalMessage internalMessage = new InternalMessage();
        if (runtimeContext.getHandlerContext() != null) {
            this.copyAttachmentProperty(runtimeContext.getHandlerContext().getMessageContext(), internalMessage);
        }
        BindingImpl bindingImpl = (BindingImpl)runtimeContext.getRuntimeEndpointInfo().getBinding();
        String string = bindingImpl.getBindingId();
        switch (messageInfo.getResponseType()) {
            case 1: {
                if (!(object instanceof Exception)) {
                    throw new SerializationException("exception.incorrectType", object.getClass().toString());
                }
                CheckedException checkedException = javaMethod.getCheckedException(object.getClass());
                if (checkedException == null) {
                    throw new SerializationException("exception.notfound", object.getClass().toString());
                }
                Object object2 = this.getDetail(javaMethod.getCheckedException(object.getClass()), object);
                JAXBBridgeInfo jAXBBridgeInfo = new JAXBBridgeInfo(runtimeModel.getBridge(checkedException.getDetailType()), object2);
                if (string.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
                    SOAPRuntimeModel.createFaultInBody(object, null, jAXBBridgeInfo, internalMessage);
                } else if (string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                    SOAPRuntimeModel.createSOAP12FaultInBody(object, null, null, jAXBBridgeInfo, internalMessage);
                }
                return internalMessage;
            }
            case 2: {
                if (string.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
                    SOAPRuntimeModel.createFaultInBody(object, this.getActor(), null, internalMessage);
                } else if (string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                    SOAPRuntimeModel.createSOAP12FaultInBody(object, null, null, null, internalMessage);
                }
                return internalMessage;
            }
        }
        SOAPBinding sOAPBinding = (SOAPBinding)javaMethod.getBinding();
        for (Parameter parameter : javaMethod.getResponseParameters()) {
            ParameterBinding parameterBinding = parameter.getOutBinding();
            Object object3 = this.createPayload(runtimeContext, parameter, objectArray, object, sOAPBinding, parameterBinding);
            if (parameterBinding.isBody()) {
                internalMessage.setBody(new BodyBlock(object3));
                continue;
            }
            if (parameterBinding.isHeader()) {
                internalMessage.addHeader(new HeaderBlock((JAXBBridgeInfo)object3));
                continue;
            }
            if (!parameterBinding.isAttachment()) continue;
            this.addAttachmentPart(runtimeContext, internalMessage, object3, parameter);
        }
        return internalMessage;
    }

    private Object getDetail(CheckedException checkedException, Object object) {
        if (checkedException.getExceptionType().equals((Object)ExceptionType.UserDefined)) {
            return this.createDetailFromUserDefinedException(checkedException, object);
        }
        try {
            Method method = object.getClass().getMethod("getFaultInfo", new Class[0]);
            return method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new SerializationException(exception);
        }
    }

    private Object createDetailFromUserDefinedException(CheckedException checkedException, Object object) {
        Class clazz = checkedException.getDetailBean();
        Field[] fieldArray = clazz.getDeclaredFields();
        try {
            Object t = clazz.newInstance();
            for (Field field : fieldArray) {
                Method method = object.getClass().getMethod(this.getReadMethod(field), new Class[0]);
                Method method2 = clazz.getMethod(this.getWriteMethod(field), method.getReturnType());
                method2.invoke(t, method.invoke(object, new Object[0]));
            }
            return t;
        }
        catch (Exception exception) {
            throw new SerializationException(exception);
        }
    }

    private String getReadMethod(Field field) {
        if (field.getType().isAssignableFrom(Boolean.TYPE)) {
            return "is" + StringUtils.capitalize(field.getName());
        }
        return "get" + StringUtils.capitalize(field.getName());
    }

    private String getWriteMethod(Field field) {
        return "set" + StringUtils.capitalize(field.getName());
    }

    public String getActor() {
        return null;
    }

    private void createOUTHolders(Parameter parameter, Object[] objectArray) {
        if (parameter.isWrapperStyle()) {
            for (Parameter parameter2 : ((WrapperParameter)parameter).getWrapperChildren()) {
                if (parameter2.isResponse() || !parameter2.isOUT()) continue;
                objectArray[parameter2.getIndex()] = new Holder();
            }
            return;
        }
        if (!parameter.isResponse() && parameter.isOUT()) {
            objectArray[parameter.getIndex()] = new Holder();
        }
    }
}

