/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.NIOServerSocket;
import gnu.java.nio.NIOSocket;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

public final class ServerSocketChannelImpl
extends ServerSocketChannel {
    private NIOServerSocket serverSocket = new NIOServerSocket(this);
    private boolean connected;

    protected ServerSocketChannelImpl(SelectorProvider provider) throws IOException {
        super(provider);
        this.configureBlocking(true);
    }

    public int getNativeFD() {
        return this.serverSocket.getPlainSocketImpl().getNativeFD();
    }

    public void finalizer() {
        if (this.connected) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void implCloseSelectableChannel() throws IOException {
        this.connected = false;
        this.serverSocket.close();
    }

    protected void implConfigureBlocking(boolean blocking) throws IOException {
        this.serverSocket.setSoTimeout(blocking ? 0 : 50);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SocketChannel accept() throws IOException {
        SocketChannel socketChannel;
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.serverSocket.isBound()) {
            throw new NotYetBoundException();
        }
        boolean completed = false;
        try {
            try {
                this.begin();
                this.serverSocket.getPlainSocketImpl().setInChannelOperation(true);
                NIOSocket socket = (NIOSocket)this.serverSocket.accept();
                completed = true;
                socketChannel = socket.getChannel();
                Object var5_5 = null;
                this.serverSocket.getPlainSocketImpl().setInChannelOperation(false);
            }
            catch (SocketTimeoutException e) {
                SocketChannel socketChannel2 = null;
                Object var5_6 = null;
                this.serverSocket.getPlainSocketImpl().setInChannelOperation(false);
                this.end(completed);
                return socketChannel2;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.serverSocket.getPlainSocketImpl().setInChannelOperation(false);
            this.end(completed);
            throw throwable;
        }
        this.end(completed);
        return socketChannel;
    }

    public ServerSocket socket() {
        return this.serverSocket;
    }
}

