// sizePreview.cpp
//
// Part of KVIEWSHELL - A framework for multipage text/gfx viewers
//
// (C) 2002 Stefan Kebekus
// Distributed under the GPL

// Add header files alphabetically

#include <kdebug.h> 
#include <krandomsequence.h>
#include <qevent.h>
#include <qpainter.h>

#include "sizePreview.h"

sizePreview::sizePreview( QWidget *parent, const char *name, WFlags f )
    : QWidget( parent, name, f  )
{
  // Set a sane default
  _width = _height = 50.0;
  orientation = 0; // Portrait
}

void sizePreview::setSize(float width, float height)
{
  _width = width;
  _height = height;

  if (_width < 50.0)
    _width = 50.0;
  if (_width > 1200.0)
    _width = 1200.0;

  if (_height < 50.0)
    _height = 50.0;
  if (_height > 1200.0)
    _height = 1200.0;
  
  update();
}

void sizePreview::paintEvent( QPaintEvent * )
{
  int displayedWidth, displayedHeight;

  // Figure the width and height of the displayed page. Tricky.
  if (orientation == 0) {
    displayedWidth  = (int)(height() * (_width/_height) + 0.5);
    displayedHeight = (int)(width() * (_height/_width) + 0.5);
  } else {
    displayedHeight  = (int)(height() * (_width/_height) + 0.5);
    displayedWidth = (int)(width() * (_height/_width) + 0.5);
  }
  if (displayedWidth <= width()) 
    displayedHeight = height();
  else
    displayedWidth = width();

  int hOffset = (width()-displayedWidth)/2;
  int vOffset = (height()-displayedHeight)/2;


  // Now draw the graphics
  erase();
  QPainter p(this);
  p.setPen(Qt::black);
  p.setBrush(Qt::white);
  p.drawRect(hOffset, vOffset, displayedWidth, displayedHeight);

  // mark the textbox; we assume 25mm margin
  int margin = (int)(25.0*displayedWidth/_width + 0.5);
  QRect textBox(hOffset+margin, vOffset+margin, displayedWidth-2*margin, displayedHeight-2*margin);
  p.setPen(Qt::lightGray);
  p.drawRect(textBox);

  // Draw some dummy "text", represented by black lines
  int lineSpacing    = (int)(7.0*displayedWidth/_width + 0.5); // equiv. 7 mm
  if (lineSpacing <= 0)
    lineSpacing = 3;
  int interWordSpace = (int)(4.0*displayedWidth/_width + 0.5); // equiv. 4 mm
  if (interWordSpace <= 1)
    interWordSpace = 2;

  KRandomSequence rnd(0); // to generate word widths

  p.setClipRect(textBox);
  p.setPen(Qt::black);
  int count = 1; // Counts lines
  for (int y = vOffset+margin+lineSpacing; y <= vOffset+displayedHeight-margin; y += lineSpacing) {
    // Every 10th line the end of a paragraph
    int endParagraph;
    if (count++ % 10 == 0)
      endParagraph = (int)(50.0*displayedWidth/_width + 0.5);
    else
      endParagraph = 0;
    for(int x = hOffset+margin; x <= hOffset+displayedWidth-margin-endParagraph; ) {
      double wordWidthMM = rnd.getDouble()*30.0+10.0;
      int wordWidth = (int)(wordWidthMM*displayedWidth/_width + 0.5); 
      p.drawLine(x, y, x+wordWidth, y);
      x += wordWidth+interWordSpace+1;
    }
  }

  p.end();
  return;
}

void sizePreview::setOrientation(int ori)
{
  orientation = ori;
  update();
}

#include "sizePreview.moc"
