/*
    Copyright (C) 2001-2003 KSVG Team
    This file is part of the KDE project

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "SVGAnimatedInteger.h"
#include "SVGAnimatedIntegerImpl.h"

using namespace KSVG;

SVGAnimatedInteger::SVGAnimatedInteger()
{
	impl = new SVGAnimatedIntegerImpl();
	impl->ref();
}

SVGAnimatedInteger::SVGAnimatedInteger(const SVGAnimatedInteger &other) : impl(0)
{
	(*this) = other;
}

SVGAnimatedInteger &SVGAnimatedInteger::operator=(const SVGAnimatedInteger &other)
{
	if(impl == other.impl)
		return *this;

	if(impl)
		impl->deref();

	impl = other.impl;

	if(impl)
		impl->ref();

	return *this;
}

SVGAnimatedInteger::SVGAnimatedInteger(SVGAnimatedIntegerImpl *other)
{
	impl = other;
	if(impl)
		impl->ref();
}

SVGAnimatedInteger::~SVGAnimatedInteger()
{
	if(impl)
		impl->deref();
}

void SVGAnimatedInteger::setBaseVal(long baseVal)
{
	if(impl)
		impl->setBaseVal(baseVal);
}

long SVGAnimatedInteger::baseVal() const
{
	if(!impl) return -1;
	return impl->baseVal();
}

long SVGAnimatedInteger::animVal() const
{
	if(!impl) return -1;
	return impl->animVal();
}

// vim:ts=4:noet
