#include "globals.h"

#include <xine.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <glib.h>

#include "skin.h"
#include "utils.h"
#include "widget_video.h"
#include "gtkvideo.h"

#ifdef EXP_STUFF

struct video_s {

  skin_widget_t  widget;

  char          *on_video_start;
  char          *on_video_end;

  gboolean       have_video;
};

static gint on_video_cb (gpointer data) {

  video_t *video = data;

  if (video->have_video != xine_get_stream_info (stream, XINE_STREAM_INFO_HAS_VIDEO)) {
    if (xine_get_stream_info (stream, XINE_STREAM_INFO_HAS_VIDEO)) {
      if (video->on_video_start) {
	printf ("executing onVideoStart script '%s' ...\n", video->on_video_start);
	se_eval (gse, video->on_video_start, video->widget.se_obj, NULL, NULL);
      }
    } else if (video->on_video_end) {
      printf ("executing onVideoEnd script '%s' ...\n", video->on_video_end);
      se_eval (gse, video->on_video_end, video->widget.se_obj, NULL, NULL);
    }
    video->have_video = xine_get_stream_info (stream, XINE_STREAM_INFO_HAS_VIDEO);
  }

  return TRUE;
}

static void video_layout (skin_widget_t *w) {
#if 0 /* FIXME */ 
  video_t *video = (video_t *) w;
  if (bg->pix) {
    bg->widget.x  = se_eval_int (bg->widget.xscript, w->se_obj);
    bg->widget.y  = se_eval_int (bg->widget.yscript, w->se_obj);
  }
#endif
}

static void video_paint (skin_widget_t *w, int xo, int yo) {

  

}

video_t *widget_video_create (xml_node_t *xvideo, skin_widget_t *parent) {

  video_t *video;

  video = (video_t *) malloc (sizeof (video_t));

  video->widget.parent  = parent;
  video->widget.view    = parent->view;
  video->widget.id      = xml_parser_get_property     (xvideo, "id");
  video->widget.zIndex  = xml_parser_get_property_int (xvideo, "zIndex", 0);

  video->have_video     = FALSE;
  video->on_video_start = xml_parser_get_property     (xvideo, "onVideoStart");
  video->on_video_end   = xml_parser_get_property     (xvideo, "onVideoEnd");

  video->widget.xscript = xml_parser_get_property     (xvideo, "left");
  video->widget.yscript = xml_parser_get_property     (xvideo, "top");
  video->widget.wscript = xml_parser_get_property     (xvideo, "width");
  video->widget.hscript = xml_parser_get_property     (xvideo, "height");

  video->widget.layout                = video_layout;
  video->widget.paint                 = video_paint;
  video->widget.handle_motion         = NULL;
  video->widget.handle_button_press   = NULL;
  video->widget.handle_button_release = NULL;

  if (!video->widget.id)
    video->widget.id = unique_name ("video");

  video->widget.se_obj = se_create_object (gse, parent->se_obj,
					   video->widget.id,
					   video);

  if (video->on_video_start || video->on_video_end) 
    gtk_timeout_add (1000, on_video_cb, video);

  if (video->widget.wscript && (gtv==NULL) ) {
    printf ("creating gtk_video widget\n");
    gtv = gtk_video_new (xine, stream, xine_get_video_source (stream), 
  	                 video_driver_id, 480, 300);
    gtk_fixed_put (GTK_FIXED (parent->view->fixed), gtv, 10, 10);
    printf ("creating gtk_video widget %p\n", gtv);
    gtk_widget_realize (gtv);
  }
  return video;
}

#endif /* EXP_STUFF */
