/* 
 * Copyright (C) 2003-2004 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: play_item.h,v 1.6 2004/11/26 23:09:52 dsalt Exp $
 *
 * playlist item / media mark:
 * an mrl + options (e.g. volume, start time, brightness/contrast ...)
 */

#ifndef HAVE_PLAY_ITEM_H
#define HAVE_PLAY_ITEM_H

#include <glib.h>
#include <stdio.h>
#include "xmlparser.h"

typedef struct play_item_s play_item_t;

struct play_item_s {

  char   *title;
  char   *mrl;

  int     start_time;

  GList  *options; /* options are simply script engine command strings */

  int     played; /* bool indicating this has been played in playlist */
};

play_item_t *play_item_new (const char *title, const char *mrl, int start_time);
void play_item_dispose (play_item_t *play_item) ;

void play_item_add_option (play_item_t *item, const char *option);

void play_item_save (play_item_t *item, FILE *fh, int depth) ;
play_item_t *play_item_load (xml_node_t *xplay_item);

play_item_t *play_item_copy (play_item_t *item);

void play_item_play (play_item_t *play_item) ;

/* gui part */

void play_item_init (void);

/* return value: 0=> cancel selected, 1=> ok selected */
typedef enum {
  PLAY_ITEM_LIST,
  PLAY_ITEM_MEDIAMARK,
  PLAY_ITEM_MEDIAMARK_NEW,
} play_item_type_t;  
int  play_item_edit (play_item_t *item, play_item_type_t type,
		     const char *title);

#endif
