/*
    This file is part of KAddressBook.
    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

#include <qcheckbox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qtooltip.h>
#include <qcombobox.h>

#include <kconfig.h>
#include <kdebug.h>
#include <kdialog.h>
#include <klistview.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <ktrader.h>

#include "addresseewidget.h"
#include "kabprefs.h"

#include "kabconfigwidget.h"

KABConfigWidget::KABConfigWidget( QWidget *parent, const char *name )
  : QWidget( parent, name )
{
  QVBoxLayout *topLayout = new QVBoxLayout( this, 0,
                                            KDialog::spacingHint() );

  QTabWidget *tabWidget = new QTabWidget( this );
  topLayout->addWidget( tabWidget );

  // General page
  QWidget *generalPage = new QWidget( this );
  QVBoxLayout *layout = new QVBoxLayout( generalPage, KDialog::marginHint(),
                                            KDialog::spacingHint() );

  QGroupBox *groupBox = new QGroupBox( 0, Qt::Vertical, i18n( "General" ), generalPage );
  QBoxLayout *boxLayout = new QVBoxLayout( groupBox->layout() );
  boxLayout->setAlignment( Qt::AlignTop );

  mViewsSingleClickBox = new QCheckBox( i18n( "Honor KDE single click" ), groupBox, "msingle" );
  boxLayout->addWidget( mViewsSingleClickBox );

  mNameParsing = new QCheckBox( i18n( "Automatic name parsing for new addressees" ), groupBox, "mparse" );
  boxLayout->addWidget( mNameParsing );

  mTradeAsFamilyName = new QCheckBox( i18n( "Trade single name component as family name" ), groupBox, "mtrade" );
  boxLayout->addWidget( mTradeAsFamilyName );
/**
  TODO: show the checkbox when we can compile agains kdelibs from HEAD, atm it
        doesn't work and would just confuse the users ;)
*/
  mTradeAsFamilyName->hide();

  mLimitContactDisplay = new QCheckBox( i18n( "Limit unfiltered display to 100 contacts" ), groupBox, "mlimit" );
  boxLayout->addWidget( mLimitContactDisplay );

  QBoxLayout *editorLayout = new QHBoxLayout( boxLayout, KDialog::spacingHint() );

  QLabel *label = new QLabel( i18n( "Addressee editor type:" ), groupBox );
  editorLayout->addWidget( label );

  mEditorCombo = new QComboBox( groupBox );
  mEditorCombo->insertItem( i18n( "Full Editor" ) );
  mEditorCombo->insertItem( i18n( "Simple Editor" ) );
  label->setBuddy( mEditorCombo );
  editorLayout->addWidget( mEditorCombo );

  editorLayout->addStretch( 1 );


  layout->addWidget( groupBox );

  groupBox = new QGroupBox( 0, Qt::Vertical, i18n( "Script-Hooks" ), generalPage );
  QGridLayout *grid = new QGridLayout( groupBox->layout(), 2, 2,
                                       KDialog::spacingHint() );
  label = new QLabel( i18n( "Phone:" ), groupBox );
  grid->addWidget( label, 0, 0 );

  mPhoneHook = new QLineEdit( groupBox );
  QToolTip::add( mPhoneHook, i18n( "<ul><li>%N: Phone Number</li></ul>" ) );
  grid->addWidget( mPhoneHook, 0, 1 );

  label = new QLabel( i18n( "Fax:" ), groupBox );
  grid->addWidget( label, 1, 0 );

  mFaxHook = new QLineEdit( groupBox );
  QToolTip::add( mFaxHook, i18n( "<ul><li>%N: Fax Number</li></ul>" ) );
  grid->addWidget( mFaxHook, 1, 1 );
  grid->setColStretch( 1, 1 );

  layout->addWidget( groupBox );

  groupBox = new QGroupBox( 0, Qt::Vertical, i18n( "Location Map" ), generalPage );
  boxLayout = new QVBoxLayout( groupBox->layout(), KDialog::spacingHint() );
  boxLayout->setAlignment( Qt::AlignTop );

  mLocationMapURL = new QComboBox( true, groupBox );
  mLocationMapURL->setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::Fixed ) );
  QToolTip::add( mLocationMapURL, i18n( "<ul> <li>%s: Street</li>"
                                 "<li>%r: Region</li>"
                                 "<li>%l: Location</li>"
                                 "<li>%z: Zip Code</li>"
                                 "<li>%c: Country ISO Code</li> </ul>" ) );
  mLocationMapURL->insertStringList( KABPrefs::instance()->mLocationMapURLs );
  boxLayout->addWidget( mLocationMapURL );
  layout->addWidget( groupBox );

  connect( mNameParsing, SIGNAL( toggled( bool ) ), SLOT( modified() ) );
  connect( mViewsSingleClickBox, SIGNAL( toggled( bool ) ), SLOT( modified() ) );
  connect( mTradeAsFamilyName, SIGNAL( toggled( bool ) ), SLOT( modified() ) );
  connect( mLimitContactDisplay, SIGNAL( toggled( bool ) ), SLOT( modified() ) );
  connect( mPhoneHook, SIGNAL( textChanged( const QString& ) ), SLOT( modified() ) );
  connect( mFaxHook, SIGNAL( textChanged( const QString& ) ), SLOT( modified() ) );
  connect( mLocationMapURL, SIGNAL( textChanged( const QString& ) ), SLOT( modified() ) );
  connect( mEditorCombo, SIGNAL( activated( int ) ), SLOT( modified() ) );

  tabWidget->addTab( generalPage, i18n( "General" ) );

  // Addressee page
  mAddresseeWidget = new AddresseeWidget( this );
  tabWidget->addTab( mAddresseeWidget, i18n( "Contact" ) );
  connect( mAddresseeWidget, SIGNAL( modified() ), SLOT( modified() ) );
}

void KABConfigWidget::restoreSettings()
{
  bool blocked = signalsBlocked();
  blockSignals( true );

  mNameParsing->setChecked( KABPrefs::instance()->mAutomaticNameParsing );
  mViewsSingleClickBox->setChecked( KABPrefs::instance()->mHonorSingleClick );
  mPhoneHook->setText( KABPrefs::instance()->mPhoneHookApplication );
  mFaxHook->setText( KABPrefs::instance()->mFaxHookApplication );
  mAddresseeWidget->restoreSettings();
  mEditorCombo->setCurrentItem( KABPrefs::instance()->mEditorType );
  mLocationMapURL->setCurrentText( KABPrefs::instance()->mLocationMapURL.arg( KGlobal::locale()->country() ) );
  mLocationMapURL->lineEdit()->setCursorPosition( 0 );

  KConfig config( "kabcrc", false, false );
  config.setGroup( "General" );
  mTradeAsFamilyName->setChecked( config.readBoolEntry( "TradeAsFamilyName", true ) );
  mLimitContactDisplay->setChecked( config.readBoolEntry( "LimitContactDisplay", true ) );

  blockSignals( blocked );

  emit changed( false );
}

void KABConfigWidget::saveSettings()
{
  KABPrefs::instance()->mAutomaticNameParsing = mNameParsing->isChecked();
  KABPrefs::instance()->mHonorSingleClick = mViewsSingleClickBox->isChecked();
  KABPrefs::instance()->mPhoneHookApplication = mPhoneHook->text();
  KABPrefs::instance()->mFaxHookApplication = mFaxHook->text();
  KABPrefs::instance()->mEditorType = mEditorCombo->currentItem();
  KABPrefs::instance()->mLocationMapURL = mLocationMapURL->currentText();
  mAddresseeWidget->saveSettings();

  KABPrefs::instance()->writeConfig();

  KConfig config( "kabcrc", false, false );
  config.setGroup( "General" );
  config.writeEntry( "TradeAsFamilyName", mTradeAsFamilyName->isChecked() );
  config.writeEntry( "LimitContactDisplay", mLimitContactDisplay->isChecked() );

  emit changed( false );
}

void KABConfigWidget::defaults()
{
  mNameParsing->setChecked( true );
  mViewsSingleClickBox->setChecked( false );
  mEditorCombo->setCurrentItem( 0 );
  mLimitContactDisplay->setChecked( true );

  emit changed( true );
}

void KABConfigWidget::modified()
{
  emit changed( true );
}

#include "kabconfigwidget.moc"
