/* findf.cpp
**
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
** MA 02111-1307, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#include "../config.h"

#include "kpackage.h"
#include "managementWidget.h"
#include "findf.h"
#include "options.h"
#include <klocale.h>
#include <qlineedit.h>
#include <kdebug.h>
#include <kurldrag.h>
#include "pkgInterface.h"

extern pkgInterface *kpinterface[];
extern Opts *opts;

FindF::FindF(QWidget *parent)
    : KDialogBase(parent, "find_file", false,
		i18n("Find File"),
		User1 | Close, User1, true,
		KGuiItem(i18n("&Find"),"filefind"))
{
    QFrame *page = makeMainWidget();

    setFocusPolicy(QWidget::StrongFocus);

    QGridLayout* gtop = new QGridLayout( page );
    gtop->setMargin( KDialog::marginHint() );
    gtop->setSpacing( KDialog::spacingHint() );

    value = new QLineEdit( page, "value" );
    connect(value,SIGNAL(textChanged ( const QString & )),this,SLOT(textChanged ( const QString & )));
    value->setFocus();

    QLabel *valueLabel = new QLabel(value, i18n("Find:"), page);

    tab = new KListView(page, "tab");
    connect(tab, SIGNAL(selectionChanged ( QListViewItem * )),
	    this, SLOT(search( QListViewItem * )));
    tab->addColumn(i18n("Type"),40);
    tab->addColumn(i18n("Package"),120);
    tab->addColumn(i18n("File Name"),300);
    tab->setAllColumnsShowFocus(TRUE);
    tab->setSorting(1);

    gtop->addWidget(valueLabel, 0, 0);
    gtop->addWidget(value, 0, 1);
    gtop->addMultiCellWidget(tab, 1, 1, 0, 1);

    connect(this, SIGNAL(user1Clicked()), this, SLOT(ok_slot()));
    connect(this, SIGNAL(closeClicked()), this, SLOT(done_slot()));
    enableButton(User1 , false);
    show();

    setAcceptDrops(true);
}

FindF::~FindF()
{
}

void FindF::textChanged ( const QString & text)
{
    enableButton(User1 , !text.isEmpty());
}

void FindF::ok_slot()
{
  doFind(value->text());
}

void FindF::doFind(const QString &str)
{
  QString t;
  int i, cnt = 0;

  QApplication::setOverrideCursor( waitCursor );

  tab->clear();

  for (i = 0; i < kpinterfaceN; i++) {
    if (kpinterface[i] && opts->handlePackage[i]) {
      QStringList filelist = kpinterface[i]->FindFile(str);

      if (filelist.count() > 0) {
	cnt++;

	for ( QStringList::Iterator it = filelist.begin(); it != filelist.end(); ++it ) {
	  t = kpinterface[i]->head;
	  if ((*it).find("diversion by") >= 0) {
	    new QListViewItem(tab, "", *it);
	  }

	  int t1 = (*it).find('\t');
	  QString s1 = (*it).left(t1);
	  QString s2 = (*it).right((*it).length()-t1);
	  s2 = s2.stripWhiteSpace();

	  new QListViewItem(tab, t, s1, s2);
	}
      }
    }
  }

  if (!cnt) {
    new QListViewItem(tab, "", i18n("--Nothing found--"));
  }

  QApplication::restoreOverrideCursor();
}

void FindF::done_slot()
{
  hide();
}

void FindF::resizeEvent(QResizeEvent *){
}

void FindF::search(QListViewItem *item)
{
  int p;

  QString s = item->text(1);
  s = s.stripWhiteSpace();
  kdDebug() << "searchF=" << s << "\n";

  p = s.find(',');
  if (p > 0) {
    s.truncate(p);
  }
  KPLVItem *k =  kpackage->management->search(s ,item->text(0));

  if (k)
    kpackage->management->changePack(k);
}

void FindF::dragEnterEvent(QDragEnterEvent* e)
{
  e->accept(KURLDrag::canDecode(e));
}

void FindF::dropEvent(QDropEvent *de) // something has been dropped
{
  KURL::List list;
  if (!KURLDrag::decode(de, list) || list.isEmpty())
     return;

  const KURL &url = list.first();

  if (url.isLocalFile()) {
    QString file = url.path(-1);
    value->setText(file);
    doFind(file);
  } else {
    KpMsgE(i18n("Incorrect URL type"),FALSE);
  }
}
#include "findf.moc"
