/*-
 * customsInfo.c --
 *	Return info on registered hosts
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#ifndef lint
static char *rcsid =
"$Id: customsInfo.c,v 1.1 1994/05/18 23:00:01 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */


#include    "customs.h"


/*-
 *-----------------------------------------------------------------------
 * Customs_Info --
 *	Acquire information about the registered hosts from the master
 *	agent at the given address.
 *
 * Results:
 *	The status of the call. If RPC_SUCCESS, the passed buffer is filled
 *	with information about the registered hosts.
 *
 * Side Effects:
 *	Not really.
 *
 *-----------------------------------------------------------------------
 */
Rpc_Stat
Customs_Info(masterAddrPtr, buf)
    struct sockaddr_in	*masterAddrPtr;
    char    	  	buf[MAX_INFO_SIZE];
{
    int tcpSock;

    if (customs_Socket == -1) {
	Customs_Init();
    }

    /*
     * Create a TCP socket for the call.  The returned data may be quite large.
     */
    tcpSock = Rpc_TcpCreate(False, 0);
    customs_Status = Rpc_Call(tcpSock, masterAddrPtr,
			  (Rpc_Proc)CUSTOMS_INFO,
			  0, (Rpc_Opaque)0,
			  MAX_INFO_SIZE, (Rpc_Opaque)buf,
			  CUSTOMS_NRETRY, &customs_RetryTimeOut);
    close (tcpSock);
    return(customs_Status);
}
