
#include "cwdaemon.h"

/* LP functions */

int lp_init(cwdevice *dev)
{
  if (ioperm (dev->base+2, 1, 1) == -1)
    {
      errmsg ("Open lp port 0x%x, %d", dev->base, dev->base);
      exit (1);
    }
  
  dev->reset(dev);  

  /* Enable CW & PTT - /STROBE bit (pin 1) */
  outb( inb(dev->base+2) |  0x01, dev->base+2);    
  
  return 0;
}

int lp_free(cwdevice *dev)
{
  dev->reset(dev);  
  /* Disable CW & PTT - /STROBE bit (pin 1) */
  outb( inb(dev->base+2) & ~0x01, dev->base+2);    

  if (ioperm (dev->base+2, 1, 0) == -1)
    errmsg ("Close lp port 0x%x, %d", dev->base, dev->base);
  
  return 0;
}

int lp_reset(cwdevice *dev)
{
  lp_cw_off(dev);
  lp_ptt_off(dev);
  lp_ssbway_mic(dev);
}
    
/* CW keying - SELECT IN bit (pin 17) */
int lp_cw_on(cwdevice *dev)
{
  outb( inb(dev->base+2) & ~0x08, dev->base+2);    
  return 0;
}

int lp_cw_off(cwdevice *dev)
{
  outb( inb(dev->base+2) |  0x08, dev->base+2);  
  return 0;
}

/* SSB PTT keying - /INIT bit (pin 16) (inverted) */
int lp_ptt_on(cwdevice *dev)
{
  outb( inb(dev->base+2) |  0x04, dev->base+2);  
  return 0;
}

int lp_ptt_off(cwdevice *dev)
{
  outb( inb(dev->base+2) & ~0x04, dev->base+2);    
  return 0;
}

/* SSB way from mic/soundcard - AUTOLF bit (pin 14) */
int lp_ssbway_soundcard(cwdevice *dev)
{
  outb( inb(dev->base+2) |  0x02, dev->base+2);  
  return 0;
}

int lp_ssbway_mic(cwdevice *dev)
{
  outb( inb(dev->base+2) & ~0x02, dev->base+2);    
  return 0;
}

