//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2003 by Luis Carvalho
    email                : lpassos@oninetspeed.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#include "pmlibraryiconview.h"

#include <qstring.h>
#include <qdir.h>

#include <kurl.h>

#include <stdlib.h>

#include "pmlibraryobject.h"
#include "pmdebug.h"

PMLibraryIconView::PMLibraryIconView( QWidget* parent, const char* name )
      : KIconView( parent, name )
{
   m_basePath = QString::null;
   m_currentPath = QString::null;
   setSelectionMode( Single );
   setItemsMovable( false );
   setAcceptDrops( false );
}

void PMLibraryIconView::setLibraryBasePath( const QString& s )
{
   if( s != m_basePath )
   {
      m_basePath = s;
      if( s != m_currentPath )
      {
         m_currentPath = s;
         refresh( );
      }
   }
}

void PMLibraryIconView::refresh( )
{
   QDir dir;

   // Clear all the icons
   clear( );

   // and then add the object files
   dir.setPath( m_currentPath );
   dir.setFilter( QDir::Files );
   dir.setNameFilter( "*.kpml" );
   for( uint i = 0; i<dir.count( ); i++ )
   {
      QString f_name = m_currentPath + "/" + dir[i];
      PMLibraryObject obj( f_name );

      if( obj.preview( ) )
         new PMLibraryIconViewItem( this, obj.name( ), obj.preview( )->copy( ), f_name );
      else
         new PMLibraryIconViewItem( this, obj.name( ), f_name );
   }
}

QDragObject* PMLibraryIconView::dragObject( )
{
   return NULL;
}

PMLibraryIconViewItem::PMLibraryIconViewItem( QIconView *parent, const QString &text, const QString& path )
   : KIconViewItem( parent, text )
{
   m_path = path;
}

PMLibraryIconViewItem::PMLibraryIconViewItem( QIconView *parent, const QString &text, const QImage& image, const QString& path )
   : KIconViewItem( parent, text, image )
{
   m_path = path;
}

#include "pmlibraryiconview.moc"
