// Copyright (c) 2003 Charles Samuels <charles@kde.org>
// See the file COPYING for redistribution terms.

#include "menu.h"
#include <kiconloader.h>
#include <klocale.h>

FileMenu::FileMenu(QWidget *parent, File file, bool deleteMe)
	: KPopupMenu(parent), mFile(file)
{
 	if (deleteMe)
		connect(this, SIGNAL(aboutToHide()), SLOT(deleteLater()));

	if (file)
	{
		insertItem(
			BarIconSet("delete"), i18n("&Remove From Playlist"),
			this, SLOT(removeFromList())
		);
		insertItem(i18n("&Properties..."), this, SLOT(properties()));
	}
}

void FileMenu::removeFromList()
{
	mFile.remove();
}

void FileMenu::properties()
{
	new ObliquePropertiesDialog(mFile, parentWidget());
}



ObliquePropertiesDialog::ObliquePropertiesDialog(File file, QWidget *parent)
	: KPropertiesDialog(file.url(), parent), mFile(file)
{
	connect(this, SIGNAL(propertiesClosed()), SLOT(deleteLater()));
	connect(this, SIGNAL(applied()), SLOT(modified()));

	show();
}

void ObliquePropertiesDialog::modified()
{
	// TODO reload the file's info
	mFile.base()->notifyChanged(mFile);
}


#include "menu.moc"
