#!/bin/sh
# Example for use of GNU gettext.
# Copyright (C) 2003 Free Software Foundation, Inc.
# This file is in the public domain.
#
# Script for cleaning all autogenerated files.

test ! -f Makefile || make distclean

# Brought in by explicit copy.
rm -f m4/nls.m4
rm -f m4/po.m4
rm -f po/remove-potcdate.sin

# Brought in by explicit copy.
rm -f m4/csharpcomp.m4
rm -f m4/csharpexec.m4
rm -f csharpcomp.sh.in
rm -f csharpexec.sh.in

# Generated by aclocal.
rm -f aclocal.m4

# Generated by autoconf.
rm -f configure

# Generated or brought in by automake.
rm -f Makefile.in
rm -f m4/Makefile.in
rm -f po/Makefile.in
rm -f install-sh
rm -f mkinstalldirs
rm -f missing
rm -f po/*.pot
rm -f po/stamp-po
for f in po/*/*.resources.dll; do
  rm -f $f
  rmdir `echo $f | sed -e 's,/[^/]*$,,'`
done
