/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2002 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmlibraryobject.h"
#include "pmlibraryobjectpreview.h"
#include "pmdialogeditbase.h"
#include "pmpart.h"
#include "pmtreeview.h"
#include "pmxmlparser.h"
#include "pmscene.h"
#include "pmobjectdrag.h"

#include <qlabel.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include <kurl.h>
#include <klocale.h>
#include <kdialog.h>
#include <kmessagebox.h>
#include <kfiledialog.h>

PMLibraryObjectPreview::PMLibraryObjectPreview( QWidget* parent ) :
   QWidget( parent )
{
   m_pPart = new PMPart( this, "treeview", this, "part", false, true );
   m_needsSave = false;

   setMaximumSize( 1000, 1000 );
   QVBoxLayout* vl = new QVBoxLayout( this, KDialog::spacingHint( ) );

   QHBoxLayout* hl = new QHBoxLayout( vl );
   hl->addStretch( 1 );

   QGridLayout* gl = new QGridLayout( vl, 4, 2 );
   gl->setColStretch( 1, 1 );
   QLabel* lbl = new QLabel( i18n( "Name: " ), this );
   m_pName = new QLineEdit( this );
   m_pName->setAlignment( Qt::AlignLeft );
   gl->addWidget( lbl, 0, 0 );
   gl->addWidget( m_pName, 0, 1 );

   lbl = new QLabel( i18n( "Description: " ), this );
   lbl->setAlignment( Qt::AlignTop );
   m_pDescription = new QMultiLineEdit( this );
   m_pDescription->setAlignment( Qt::AlignTop  | Qt::AlignLeft | 
                                 Qt::WordBreak | Qt::DontClip );
   gl->addWidget( lbl, 1, 0 );
   gl->addWidget( m_pDescription, 1, 1 );

   lbl = new QLabel( i18n( "Keywords: " ), this );
   lbl->setAlignment( Qt::AlignTop );
   m_pKeywords = new QMultiLineEdit( this );
   m_pKeywords->setAlignment( Qt::AlignTop  | Qt::AlignLeft | 
                                 Qt::WordBreak | Qt::DontClip );
   gl->addWidget( lbl, 2, 0 );
   gl->addWidget( m_pKeywords, 2, 1 );

   lbl = new QLabel( i18n( "Contents: " ), this );
   m_pContentsPreview = new PMTreeView( m_pPart, this );
   gl->addMultiCellWidget( lbl, 3, 3, 0, 1 );
   gl->addMultiCellWidget( m_pContentsPreview, 4, 4, 0, 1 );
   
   hl = new QHBoxLayout( vl );
   m_pSetPreviewImageButton = new QPushButton( i18n( "Change Preview Image" ), this );
   m_pSetPreviewImageButton->setEnabled( false );
   hl->addWidget( m_pSetPreviewImageButton );
   hl->addStretch( 1 );

   vl->addStretch( 1 );
}

bool PMLibraryObjectPreview::showPreview( KURL u )
{
   bool result = false;
   
   if( u.isLocalFile( ) )
   {
      if ( m_needsSave )
      {
         // ask if we must save the changes
         if( KMessageBox::questionYesNo( this, 
                                         i18n( "The object has been modified and not saved.\nDo you wish to save?" ),
                                         i18n( "Warning" ) ) == KMessageBox::Yes )
         {
            PMLibraryObject objToSave;
	    PMObjectList sortedList;
	    PMObject* tmp;

	    // First save the text parameters.
            objToSave.setName( m_pName->text( ) );
            objToSave.setDescription( m_pDescription->text( ) );
            objToSave.setKeywords( m_pKeywords->text( ) );
	    
	    // Gather the contents of the part.
	    tmp = m_pPart->scene( )->firstChild( );
	    while( tmp )
	    {
	       sortedList.append( tmp );
	       tmp = tmp->nextSibling();
	    }

	    // Add them to the object to save.
	    PMObjectDrag drag( m_pPart, sortedList );
	    objToSave.setObjects( drag.encodedData( "application/x-kpovmodeler" ) );

            // Add the preview image
            objToSave.setPreview( m_image.copy( ) );
	    
	    // Finally save the object to a file.
            objToSave.save( m_currentObjectURL.path( ) );
            result = true;
         }
      }

      // Load the new object to preview
      PMLibraryObject aux( u );

      m_pName->setText( aux.name( ) );
      m_pDescription->setText( aux.description( ) );
      m_pKeywords->setText( aux.keywords( ) );
      loadObjects( aux.objects( ) );
      m_image.reset( );
      if( aux.preview( ) )
         m_image = aux.preview( )->copy( );
      allowEdit( false );
      m_needsSave = false;

      // Save the preview location
      m_currentObjectURL = u;
   }
   return result;
}

void PMLibraryObjectPreview::loadObjects( QByteArray* obj )
{

   m_pPart->setReadWrite( true );
   m_pPart->setScene( new PMScene( m_pPart ) );
   if( obj )
   {
      PMXMLParser parser( m_pPart, *obj );
      m_pPart->insertFromParser( i18n( "Object Load" ), &parser, m_pPart->scene( ) );
   }
   m_pPart->setReadWrite( false );
   m_pContentsPreview->slotRefresh( );
}

void PMLibraryObjectPreview::clearPreview( )
{
   m_pName->setText( "" );
   m_pDescription->setText( "" );
   m_pKeywords->setText( "" );
   m_pPart->setReadWrite( true );
   m_pPart->setScene( new PMScene( m_pPart ) );
   m_pContentsPreview->slotRefresh( );
   m_pPart->setReadWrite( false );
   allowEdit( false );
}

void PMLibraryObjectPreview::allowEdit( bool b )
{
   if( b )
   {
      m_pName->setReadOnly( false );
      m_pDescription->setReadOnly( false );
      m_pKeywords->setReadOnly( false );
      m_pSetPreviewImageButton->setEnabled( true );
      connect( m_pName, SIGNAL( textChanged( const QString& ) ), 
                        SLOT( textChanged( const QString& ) ) );
      connect( m_pKeywords, SIGNAL( textChanged( ) ), 
                        SLOT( textChanged( ) ) );
      connect( m_pDescription, SIGNAL( textChanged( ) ), 
                               SLOT( textChanged( ) ) );
      connect( m_pSetPreviewImageButton, SIGNAL( clicked( ) ), SLOT( slotPreviewClicked( ) ) );
      connect( m_pPart, SIGNAL( modified( ) ), SLOT( textChanged( ) ) );
      m_pPart->setReadWrite( );
   }
   else
   {
      m_pName->setReadOnly( true );
      m_pDescription->setReadOnly( true );
      m_pKeywords->setReadOnly( true );
      m_pSetPreviewImageButton->setEnabled( false );
      disconnect( m_pName );
      disconnect( m_pKeywords );
      disconnect( m_pDescription );
      disconnect( m_pPart, SIGNAL( modified( ) ) );
      m_pPart->setReadWrite( false );
   }
}

void PMLibraryObjectPreview::textChanged( )
{
   m_needsSave = true;
}

void PMLibraryObjectPreview::textChanged( const QString& /* s */)
{
   m_needsSave = true;
}

void PMLibraryObjectPreview::slotPreviewClicked( )
{
   KFileDialog dlg( QString::null, "", NULL, "", false );

   dlg.setFilter( "image/jpeg image/gif image/tiff image/png image/x-bmp" );
   if( dlg.exec( ) == QDialog::Accepted )
   {
      m_image.load( dlg.selectedFile( ) );
      m_needsSave = true;
   }
}

#include "pmlibraryobjectpreview.moc"
