/*
 * Copyright (C) 2001-2005 the xine-project
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: utils.h,v 1.26.2.2 2005/07/06 19:13:45 dsalt Exp $
 *
 * needful things
 */

#ifndef HAVE_UTILS_H
#define HAVE_UTILS_H 

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pthread.h>

void utils_init (void);

void ensure_path_exists (char *path) ;

/* read an entire file and ensure that the buffer is LF+NUL-terminated
 * file_size may be NULL
 */
char *read_entire_file (const char *mrl, int *file_size);

/* display message boxes
 * if fmt==NULL, first vararg is format string and window is modal
 */
void v_display_message (const gchar *title, GtkMessageType,
			const gchar *fmt, va_list);
void display_error (const gchar *title, const gchar *fmt, ...) ;
void display_warning (const gchar *title, const gchar *fmt, ...);
void display_info (const gchar *title, const gchar *fmt, ...) ;
#define v_display_error(T,F,V)   v_display_message((T),GTK_MESSAGE_ERROR,  (F),(V))
#define v_display_warning(T,F,V) v_display_message((T),GTK_MESSAGE_WARNING,(F),(V))
#define v_display_info(T,F,V)    v_display_message((T),GTK_MESSAGE_INFO,   (F),(V))

void int_to_timestring (gint int_time, char* string_time, gint length) ;
int parse_timestring (const char *string_time);

gchar *modal_file_dialog (const char *title, const char *pattern);
gchar *modal_file_dialog_with_buttons (const char *title,
				       const gchar *pattern, ...);
/* use g_strfreev() to free the return value of this one: */
gchar **modal_multi_file_dialog (const char *title, const char *pattern);

/* attach to delete-event signal -> hide widget & set *visible = FALSE */
void hide_on_delete (GtkWidget *widget, gboolean *visible);

void add_table_row_items (GtkWidget *table, gint row,
			  const gchar *labeltext, int widgets, ...);

char *asreprintf (char **str, const char *fmt, ...);

char *unique_name (char *base);


/* UI status attributes */
typedef enum {
  UI_CURRENT_STATE = -1,
  /* Player state */
  UI_STOP = 0,
  UI_PAUSE,
  UI_PLAY_SLOW,
  UI_PLAY,
  UI_FAST_FORWARD,
  /* Mute */
  UI_AUDIO_UNMUTE, UI_AUDIO_MUTE,
  /* Full-screen toolbar */
  UI_TOOLBAR,
} ui_status_t;

/* Set/show play/pause/stop/mute status in control buttons */
void ui_set_status (ui_status_t);

/* UI button classes */
typedef enum {
  Control_PLAY,
  Control_REWIND,
  Control_FASTFWD,
  Control_PAUSE,
  Control_STOP,
  Control_MUTE,
  Control_Buttons,
  Control_PlayerButtons = Control_STOP + 1 /* MUTE is special-cased */
} control_button_t;

/* UI slider/spinner classes (adjustment types) */
typedef enum {
  Control_SEEKER,
  Control_AUDIO_CHANNEL,
  Control_VOLUME,
  Control_COMPRESSOR,
  Control_AMPLIFIER,
  Control_AV_SYNC,
  Control_HUE,
  Control_SATURATION,
  Control_CONTRAST,
  Control_BRIGHTNESS,
  Control_Adjustments
} control_adjustment_t;

/* Register a button for the above status functions */
void ui_register_control_button (control_button_t, GtkWidget *);
/* Get the adjustment object for a given adjustment type */
GtkObject *ui_register_control_adjustment (control_adjustment_t);

/* Callback functions for registered buttons and our adjustments must check
 * this and return without effect if this is TRUE.
 */
extern gboolean no_recursion;

extern gboolean toolbar_visible, toolbar_at_top;

void ui_toolbar_toggle (void);

/* Set a button's state or adjustment's value */
void ui_set_control_button (control_button_t, gboolean);
void ui_set_control_adjustment (control_adjustment_t, gdouble);
void ui_reset_control_adjustment (control_adjustment_t);
void ui_revert_control_adjustment (control_adjustment_t);
void ui_clear_control_adjustment (control_adjustment_t);
/* Update objects which use the given adjustment */
void ui_xine_set_param_from_adjustment (control_adjustment_t);

void ui_preferences_register (xine_t *);

/* In noskin_window.c, skin_window.c: */
void window_toolbar_show (gboolean);
void window_toolbar_position (gboolean top);
void window_toolbar_reset (void);
void window_toolbar_restore (void);
void window_check_vis (gboolean force);

void ui_init (void);

#endif
