#!/bin/sh

# shellcheck disable=SC1091
. /usr/lib/qubes/init/functions

if ! qsvc guivm; then

XDG_MENU_PREFIX="xfce-"
export XDG_MENU_PREFIX

DESKTOP_SESSION="xfce"
export DESKTOP_SESSION

XDG_CURRENT_DESKTOP="XFCE"
export XDG_CURRENT_DESKTOP

XDG_CONFIG_HOME=$HOME/.config
[ -d "$XDG_CONFIG_HOME" ] || mkdir "$XDG_CONFIG_HOME"

XDG_CACHE_HOME=$HOME/.cache
[ -d "$XDG_CACHE_HOME" ] || mkdir "$XDG_CACHE_HOME"

if which xdg-user-dirs-update >/dev/null 2>&1; then
    xdg-user-dirs-update
fi

export QT_QPA_PLATFORMTHEME=qt5ct

if [ "$XDG_CURRENT_DESKTOP" = "X-QUBES" ]; then
    # key repeat is handled on the gui-daemon side, do not duplicate the effort
    # on the gui-agent side, as that leads to spurious key events
    # xfsettingsd defaults to enable key repeat, unless it's disabled via a
    # setting not present in default xml description files...
    xfconf-query -c keyboards -p /Default/KeyRepeat -n -t bool -s false
fi

xfsettingsd --replace&
fi
