/*
 * Copyright (C) 1999, 2000, 2002, 2003  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "htmldocgenerator.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

void
HtmlDocGenerator::generate_top()
{
  bool cssUrl = (css_url.size() > 0);
  bool docTitle = (title.size () > 0);
  bool inputFileName = (input_file_name.size () > 0);
  bool docHeader = (doc_header.size () > 0);

  generate_doctype ();

  generateln( "<html>" ) ;
  generateln( "<head>" ) ;
  generateln( "<meta http-equiv=\"Content-Type\"" ) ;
  generate( "content=\"text/html; charset=iso-8859-1" ) ;
  close_meta ();
  generate( "<meta name=\"GENERATOR\" content=\"GNU " ) ;
  generate (PACKAGE);
  generate (" ");
  if (gen_source_highlight_version)
    generate (VERSION);
  generate( "\nby Lorenzo Bettini" ) ;
  generate( "\nhttp://www.lorenzobettini.it" ) ;
  generate( "\nhttp://www.gnu.org/software/src-highlite" ) ;
  close_meta ();
  generate( "<title>" ) ;
  generate( ( docTitle ? title :
              ( inputFileName ? input_file_name : "source file" ) ) ) ;
  generateln( "</title>" ) ;
  if( cssUrl ) {
    generate( "<link rel=\"stylesheet\" href=\"" );
    generate( css_url );
    generateln( "\" type=\"text/css\">");
  }
  generateln( "</head>" ) ;

  generate_standard_style ();

  if (docHeader)
    generateln (doc_header) ;
}

void
HtmlDocGenerator::close_meta()
{
  generateln( "\">" ) ;
}

void
HtmlDocGenerator::generate_doctype()
{
  if( css_url.size () == 0 ) {
    generateln( "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">" ) ;
  }
  else {
    generateln( "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"");
    generateln( "    \"http://www.w3.org/TR/REC-html40/strict.dtd\">");
  }
}

void
HtmlDocGenerator::generate_standard_style()
{
  if( css_url.size () == 0 && doc_header.size () == 0 ) {
    generate ("<body bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#0000EE\" ");
    generateln ( "vlink=\"#551A8B\" alink=\"#FF0000\">" );
  }
  else {
    generateln( "<body>" ) ;
  }
}

void
HtmlDocGenerator::generate_bottom()
{
  if ( doc_footer.size () > 0 )
    generateln( doc_footer ) ;

  generateln( "</body>" ) ;
  generateln( "</html>" ) ;
}

void
HtmlDocGenerator::generate_start_doc()
{
  generateln( "<pre>" ) ;
  generateln( "<tt>" ) ;
}

void
HtmlDocGenerator::generate_end_doc()
{
  generateln( "</tt>" ) ;
  generateln( "</pre>" ) ;
}
