/*
** Copyright (C) 1999, 2000, 2001 Lorenzo Bettini <bettini@gnu.org>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

// textgen.h : Text Generator class

#ifndef _TEXTGEN_H
#define _TEXTGEN_H

class CharTranslator;

class TextGenerator
{
 protected:
  CharTranslator *char_translator;

 public:
  TextGenerator(CharTranslator *);

  virtual void generate( const char *s );
  virtual void generate( const char *s, int start, int end );
  virtual void generate_preproc(const char *s);

  virtual void generateln( const char *s );

  virtual void generateEntire( const char *s );

  virtual void startTextGeneration() {}
  virtual void endTextGeneration() {}
  virtual void beginText( const char *s );
  virtual void endText( const char *s );
} ;

#endif
