#! @AWK@ -f

#######################################################################
#
#   Gtk wrapper creation scripts (creating hash table for callbacks)
#
########################################################################


#######################################################################
#
# Copyright 2003 Free Software Foundation, Inc.
# Written by Norman Jordan
#
# This file is part of the GNU Smalltalk class library.
#
# The GNU Smalltalk class library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1, or (at
# your option) any later version.
# 
# The GNU Smalltalk class library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
# General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the GNU Smalltalk class library; see the file COPYING.LESSER.
# If not, write to the Free Software Foundation, 59 Temple Place - Suite
# 330, Boston, MA 02111-1307, USA.  
#
########################################################################

BEGIN {
  print "/* Automatically generated, do not edit! */"
  print "#include <glib.h>\n"
  print "#include \"gst-gtk.h\"\n"
    
  print "GHashTable*"
  print "_blox_create_callback_hash()"
  print "{"
  print "  GHashTable *callBackHash, *currentHash;\n"
  printf "  callBackHash = g_hash_table_new(NULL, NULL);"
}

$1 == "struct" && $2 ~ /_Gtk[A-Z][a-zA-Z]+Class/ {
  className = $2
  numSignals = 0
  gsub(/_/, "", className)
  gsub(/Class$/, "", className)
    
  getline
  while($0 !~ /^};/) {
    if($0 ~ /[a-zA-Z0-9]+[ \t]+\(\*[a-zA-Z0-9_]+\)\([a-zA-Z_]+[ \t]+\**[a-zA-Z_]+[,\)]/) {
      declaration($1, $2, $2, $3)

    } else if($0 ~ /[a-zA-Z0-9]+[ \t]+\(\*[ \t]+[a-zA-Z0-9_]+\)\([a-zA-Z_]+[ \t]+\**[a-zA-Z)]+[,\)]/) {
      declaration($1, $3, $3, $4)

    } else if($0 ~ /[a-zA-Z0-9]+[ \t]+\(\*[a-zA-Z0-9_]+\)[ \t]+\([a-zA-Z_]+[ \t]+\**[a-zA-Z_]+[,\)]/) {
      declaration($1, $2, $3, $4)

    } else if($0 ~ /[a-zA-Z0-9]+[ \t]+\(\*[ \t]+[a-zA-Z0-9_]+\)[ \t]+\([a-zA-Z_]+[ \t]+\**[a-zA-Z_]+[,\)]/) {
      declaration($1, $3, $4, $5)
    }

    getline
  }
}

function declaration (returnType, signalName, firstType, firstName)
{
  split ("", argNames)

  argNames[0] = firstName

  sub(/\).*$/, "", signalName)
  sub(/^\(\*/, "", signalName)

  i = 1
  while($0 !~ /\);[ \t]*$/) {
    getline

    sub(/\/\*.*/, "")
    if(NF == 2) {
      argNames[i] = $2
    } else {
      argNames[i] = $3
    }
    i++
  }

  # Remove pointer and array markers from argument names
  for (i in argNames) {
    paramName = argNames[i]
    sub(/,$/, "", paramName)
    sub(/\);/, "", paramName)
    for (;;) {
      if(paramName ~ /^\*/) {
        paramName = substr(paramName, 2)
      } else if (paramName ~ /\[\]/) {
        sub(/\[\]/, "", paramName)
      } else {
        break
      }
    }

    argNames[i] = paramName
  }

  # and the local variables
  selector = getSelector(signalName, argNames)

  if (numSignals++ == 0) {
    print "\n  currentHash = g_hash_table_new(g_str_hash, g_str_equal);"
    printf "  g_hash_table_insert(callBackHash, (gpointer) g_quark_from_string (\"%s\"), currentHash);\n", className
  }

  gsub (/_/, "-", signalName);
  printf "  g_hash_table_insert(currentHash, \"%s\", \"%s\");\n", signalName, selector
}

END {
  print "\n  return(callBackHash);"
  print "}"
}

function getSelector(signalName, argNames) {
  string = smalltalkize(signalName) ":data:"
  for(i in argNames) {
    if (i >= 1)
      string = string smalltalkize(argNames[i]) ":"
  }
  return string
}

function smalltalkize( res )
{
  first = substr (res, 1, 1)
  res = tolower( substr (res, 2) )

  while (is = index (res, "_")) {
    first = first substr(res, 1, is - 1) toupper( substr (res, is + 1, 1))
    res = substr (res, is + 2)
  }

  return first res
}

