#! @AWK@ -f

#######################################################################
#
#   Gtk wrapper creation script (sorting of header files)
#
#   $Revision: 1.95.1$
#   $Date: 2000/12/27 10:45:49$
#   $Author: pb$
#
########################################################################


#######################################################################
#
# Copyright 2001 Free Software Foundation, Inc.
# Written by Paolo Bonzini
#
# This file is part of the GNU Smalltalk class library.
#
# The GNU Smalltalk class library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1, or (at
# your option) any later version.
# 
# The GNU Smalltalk class library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
# General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the GNU Smalltalk class library; see the file COPYING.LESSER.
# If not, write to the Free Software Foundation, 59 Temple Place - Suite
# 330, Boston, MA 02111-1307, USA.  
#
########################################################################

FNR == 1 {
  included[FILENAME] = FILENAME " "
  processed[FILENAME] = ""
}

/^ *# *include *<g.k/ {
  included[FILENAME] = included[FILENAME] " " substr($2, 2, length($2) - 2)
}

END {
  top = 1
  for (file in included) {
    recurse(file)
  }

  if (path ~ /.+[^/]$/)
    path = path "/"

  for (i = 1; i < top; i++)
    print path queue[i]
}

# The extra argument WHICH serves as a local variable
function recurse(file, save, which) {

  $0 = included[file]

  for(which = 1; $which != ""; which++) {
    if (!($which in printed)) {
      printed[$which] = ""
      recurse($which, $0)
      if ($which in processed) {
        queue[top++] = $which
      }
    }
  }

  # We need to reset $0!!! (AWK is not reentrant)
  $0 = save
}
