/* PSPP - computes sample statistics.
   Copyright (C) 1997-9, 2000 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 3 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA. */

#include <config.h>
#include "error.h"
#include <stdio.h>
#include "command.h"
#include "dictionary.h"
#include "error.h"
#include "lexer.h"
#include "str.h"
#include "var.h"

#include "gettext.h"
#define _(msgid) gettext (msgid)

/* WEIGHT transformation. */
struct weight_trns
  {
    struct trns_header h;
    int src;			/* `value' index of weighting variable. */
    int dest;			/* `value' index of $WEIGHT. */
  };

int
cmd_weight (void)
{
  if (lex_match_id ("OFF"))
    dict_set_weight (default_dict, NULL);
  else
    {
      struct variable *v;

      lex_match (T_BY);
      v = parse_variable ();
      if (!v)
	return CMD_FAILURE;
      if (v->type == ALPHA)
	{
	  msg (SE, _("The weighting variable must be numeric."));
	  return CMD_FAILURE;
	}
      if (dict_class_from_id (v->name) == DC_SCRATCH)
	{
	  msg (SE, _("The weighting variable may not be scratch."));
	  return CMD_FAILURE;
	}

      dict_set_weight (default_dict, v);
    }

  return lex_end_of_command ();
}
