/* sim.h

   originally written by Don Maszle

   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.siminit.h
    Revision:  1.6
        Date:  23 Nov 1996
     Modtime:  12:39:47
      Author:  @a
   -- SCCS  ---------

   Header file for simulation
*/

#ifndef _SIMINIT_H_
#define _SIMINIT_H_

/* -----------------------------------------------------------------------------
   Inclusions
*/

#include "sim.h"


/* -----------------------------------------------------------------------------
   Prototypes
*/

void CreateOutputSchedule (POUTSPEC pos);
BOOL FindNewPoint (POUTSPEC pos, PINT piPoint);
void GetModelInfo (PMODELINFO pmi);
void InitAnalysis (PANALYSIS panal);
void InitExperiment (PEXPERIMENT pexp, PMODELINFO pmodelinfo);
void InitIntegratorSpec (PINTSPEC pis);
void InitMonteCarlo (PMONTECARLO pmc);
void InitGibbs (PGIBBSDATA pgd);
int  InitOneOutVar (PVOID pData, PVOID pInfo);
int  InitOneDataVar (PVOID pData, PVOID pInfo);
BOOL InitOutputs (PEXPERIMENT pexp, PINT piOut, PDOUBLE pdTout);
void InitOutputSpec (POUTSPEC pos);
BOOL PrepareOutSpec (PEXPERIMENT pexp);
BOOL PrintOutSpec (PEXPERIMENT pexp);
void SetCmdLineOptions (PANALYSIS panal);
void SetOptions (PANALYSIS panal);


#endif /* _SIMINIT_H_ */

/* End */

