/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.S32Vector;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class U32Vector
extends SimpleVector
implements Externalizable,
Comparable {
    int[] data;

    public U32Vector() {
        this.data = S32Vector.empty;
    }

    public U32Vector(int n, int n2) {
        int[] nArray = new int[n];
        this.data = nArray;
        this.size = n;
        while (--n >= 0) {
            nArray[n] = n2;
        }
    }

    public U32Vector(int n) {
        this.data = new int[n];
        this.size = n;
    }

    public U32Vector(int[] nArray) {
        this.data = nArray;
        this.size = nArray.length;
    }

    public U32Vector(Sequence sequence) {
        this.data = new int[sequence.size()];
        this.addAll((Collection)sequence);
    }

    public int getBufferLength() {
        return this.data.length;
    }

    public void setBufferLength(int n) {
        int n2 = this.data.length;
        if (n2 != n) {
            int[] nArray = new int[n];
            System.arraycopy(this.data, 0, nArray, 0, n2 < n ? n2 : n);
            this.data = nArray;
        }
    }

    protected Object getBuffer() {
        return this.data;
    }

    public final int intAtBuffer(int n) {
        return this.data[n];
    }

    public final long longAtBuffer(int n) {
        return (long)this.data[n] & 0xFFFFFFFFL;
    }

    public final long longAt(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.longAtBuffer(n);
    }

    public final Object get(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObjectUnsigned(this.data[n]);
    }

    public final Object getBuffer(int n) {
        return Convert.toObjectUnsigned(this.data[n]);
    }

    public Object setBuffer(int n, Object object2) {
        int n2 = this.data[n];
        this.data[n] = Convert.toIntUnsigned(object2);
        return Convert.toObjectUnsigned(n2);
    }

    public final void setIntAt(int n, int n2) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[n] = n2;
    }

    public final void setIntAtBuffer(int n, int n2) {
        this.data[n] = n2;
    }

    protected void clearBuffer(int n, int n2) {
        while (--n2 >= 0) {
            this.data[n++] = 0;
        }
    }

    public int getElementKind() {
        return 19;
    }

    public String getTag() {
        return "u32";
    }

    public boolean consumeNext(int n, Consumer consumer) {
        int n2 = n >>> 1;
        if (n2 >= this.size) {
            return false;
        }
        consumer.writeInt(this.data[n2]);
        return true;
    }

    public void consumePosRange(int n, int n2, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        if (n4 > this.size) {
            n4 = this.size;
        }
        while (n3 < n4) {
            consumer.writeInt(this.data[n3]);
            ++n3;
        }
    }

    public int compareTo(Object object2) {
        return U32Vector.compareToLong(this, (U32Vector)object2);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.size;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeInt(this.data[i]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = objectInput.readInt();
        }
        this.data = nArray;
        this.size = n;
    }
}

