/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Target;
import gnu.expr.TypeValue;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.xml.Base64Binary;
import gnu.kawa.xml.BinaryObject;
import gnu.kawa.xml.HexBinary;
import gnu.kawa.xml.KNode;
import gnu.kawa.xml.Nodes;
import gnu.kawa.xml.UntypedAtomic;
import gnu.kawa.xml.XTimeType;
import gnu.lists.Consumer;
import gnu.lists.SeqPosition;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.math.DateTime;
import gnu.math.Duration;
import gnu.math.IntNum;
import gnu.math.RealNum;
import gnu.math.Unit;
import gnu.text.Path;
import gnu.text.Printable;
import gnu.text.URIPath;
import gnu.xml.TextUtils;
import java.math.BigDecimal;

public class XDataType
extends Type
implements TypeValue {
    Type implementationType;
    Object name;
    XDataType baseType;
    int typeCode;
    public static final int ANY_SIMPLE_TYPE_CODE = 2;
    public static final int ANY_ATOMIC_TYPE_CODE = 3;
    public static final int DECIMAL_TYPE_CODE = 4;
    public static final int INTEGER_TYPE_CODE = 5;
    public static final int NON_POSITIVE_INTEGER_TYPE_CODE = 6;
    public static final int NEGATIVE_INTEGER_TYPE_CODE = 7;
    public static final int LONG_TYPE_CODE = 8;
    public static final int INT_TYPE_CODE = 9;
    public static final int SHORT_TYPE_CODE = 10;
    public static final int BYTE_TYPE_CODE = 11;
    public static final int NONNEGATIVE_INTEGER_TYPE_CODE = 12;
    public static final int UNSIGNED_LONG_TYPE_CODE = 13;
    public static final int UNSIGNED_INT_TYPE_CODE = 14;
    public static final int UNSIGNED_SHORT_TYPE_CODE = 15;
    public static final int UNSIGNED_BYTE_TYPE_CODE = 16;
    public static final int POSITIVE_INTEGER_TYPE_CODE = 17;
    public static final int FLOAT_TYPE_CODE = 18;
    public static final int DOUBLE_TYPE_CODE = 19;
    public static final int DATE_TIME_TYPE_CODE = 20;
    public static final int DATE_TYPE_CODE = 21;
    public static final int TIME_TYPE_CODE = 22;
    public static final int G_YEAR_MONTH_TYPE_CODE = 23;
    public static final int G_YEAR_TYPE_CODE = 24;
    public static final int G_MONTH_DAY_TYPE_CODE = 25;
    public static final int G_DAY_TYPE_CODE = 26;
    public static final int G_MONTH_TYPE_CODE = 27;
    public static final int DURATION_TYPE_CODE = 28;
    public static final int YEAR_MONTH_DURATION_TYPE_CODE = 29;
    public static final int DAY_TIME_DURATION_TYPE_CODE = 30;
    public static final int BOOLEAN_TYPE_CODE = 31;
    public static final int QNAME_TYPE_CODE = 32;
    public static final int ANY_URI_TYPE_CODE = 33;
    public static final int BASE64_BINARY_TYPE_CODE = 34;
    public static final int HEX_BINARY_TYPE_CODE = 35;
    public static final int NOTATION_TYPE_CODE = 36;
    public static final int UNTYPED_ATOMIC_TYPE_CODE = 37;
    public static final int STRING_TYPE_CODE = 38;
    public static final int NORMALIZED_STRING_TYPE_CODE = 39;
    public static final int TOKEN_TYPE_CODE = 40;
    public static final int LANGUAGE_TYPE_CODE = 41;
    public static final int NMTOKEN_TYPE_CODE = 42;
    public static final int NAME_TYPE_CODE = 43;
    public static final int NCNAME_TYPE_CODE = 44;
    public static final int ID_TYPE_CODE = 45;
    public static final int IDREF_TYPE_CODE = 46;
    public static final int ENTITY_TYPE_CODE = 47;
    public static final int UNTYPED_TYPE_CODE = 48;
    public static final XDataType anySimpleType = new XDataType("anySimpleType", Type.objectType, 2);
    public static final XDataType anyAtomicType = new XDataType("anyAtomicType", Type.objectType, 3);
    public static final XDataType stringType = new XDataType("string", ClassType.make("java.lang.CharSequence"), 38);
    public static final XDataType stringStringType = new XDataType("String", ClassType.make("java.lang.String"), 38);
    public static final XDataType untypedAtomicType = new XDataType("string", ClassType.make("gnu.kawa.xml.UntypedAtomic"), 37);
    public static final XDataType base64BinaryType = new XDataType("base64Binary", ClassType.make("gnu.kawa.xml.Base64Binary"), 34);
    public static final XDataType hexBinaryType = new XDataType("hexBinary", ClassType.make("gnu.kawa.xml.HexBinary"), 35);
    public static final XDataType booleanType = new XDataType("boolean", Type.booleanType, 31);
    public static final XDataType anyURIType = new XDataType("anyURI", ClassType.make("gnu.text.Path"), 33);
    public static final XDataType NotationType = new XDataType("NOTATION", ClassType.make("gnu.kawa.xml.Notation"), 36);
    public static final XDataType decimalType = new XDataType("decimal", ClassType.make("java.lang.Number"), 4);
    public static final XDataType floatType = new XDataType("float", ClassType.make("java.lang.Float"), 18);
    public static final XDataType doubleType = new XDataType("double", ClassType.make("java.lang.Double"), 19);
    public static final XDataType durationType = new XDataType("duration", ClassType.make("gnu.math.Duration"), 28);
    public static final XDataType yearMonthDurationType = new XDataType("yearMonthDuration", ClassType.make("gnu.math.Duration"), 29);
    public static final XDataType dayTimeDurationType = new XDataType("dayTimeDuration", ClassType.make("gnu.math.Duration"), 30);
    public static final XDataType untypedType = new XDataType("untyped", Type.objectType, 48);
    public static final Double DOUBLE_ZERO = XDataType.makeDouble(0.0);
    public static final Double DOUBLE_ONE = XDataType.makeDouble(1.0);
    public static final Float FLOAT_ZERO = XDataType.makeFloat(0.0f);
    public static final Float FLOAT_ONE = XDataType.makeFloat(1.0f);
    public static final BigDecimal DECIMAL_ONE = BigDecimal.valueOf(1L);

    public XDataType(Object object2, Type type, int n) {
        super(type);
        this.name = object2;
        if (object2 != null) {
            this.setName(object2.toString());
        }
        this.implementationType = type;
        this.typeCode = n;
    }

    public Class getReflectClass() {
        return this.implementationType.getReflectClass();
    }

    public Type getImplementationType() {
        return this.implementationType;
    }

    public void emitCoerceFromObject(CodeAttr codeAttr) {
        Compilation compilation = Compilation.getCurrent();
        compilation.compileConstant(this, Target.pushObject);
        Method method = ClassType.make("gnu.kawa.xml.XDataType").getDeclaredMethod("coerceFromObject", 1);
        codeAttr.emitSwap();
        codeAttr.emitInvokeVirtual(method);
        this.implementationType.emitCoerceFromObject(codeAttr);
    }

    public void emitCoerceToObject(CodeAttr codeAttr) {
        if (this.typeCode == 31) {
            this.implementationType.emitCoerceToObject(codeAttr);
        } else {
            super.emitCoerceToObject(codeAttr);
        }
    }

    public void emitTestIf(Variable variable, Declaration declaration, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (this.typeCode == 31) {
            if (variable != null) {
                codeAttr.emitLoad(variable);
            }
            Type.javalangBooleanType.emitIsInstance(codeAttr);
            codeAttr.emitIfIntNotZero();
            if (declaration != null) {
                codeAttr.emitLoad(variable);
                Type.booleanType.emitCoerceFromObject(codeAttr);
                declaration.compileStore(compilation);
            }
            return;
        }
        compilation.compileConstant(this, Target.pushObject);
        if (variable == null) {
            codeAttr.emitSwap();
        } else {
            codeAttr.emitLoad(variable);
        }
        if (declaration != null) {
            codeAttr.emitDup();
            declaration.compileStore(compilation);
        }
        codeAttr.emitInvokeVirtual(Compilation.typeType.getDeclaredMethod("isInstance", 1));
        codeAttr.emitIfIntNotZero();
    }

    public boolean isInstance(Object object2) {
        switch (this.typeCode) {
            case 48: {
                return true;
            }
            case 2: {
                return !(object2 instanceof SeqPosition) && !(object2 instanceof Nodes);
            }
            case 3: {
                return !(object2 instanceof Values) && !(object2 instanceof SeqPosition);
            }
            case 38: {
                return object2 instanceof CharSequence;
            }
            case 37: {
                return object2 instanceof UntypedAtomic;
            }
            case 33: {
                return object2 instanceof Path;
            }
            case 31: {
                return object2 instanceof Boolean;
            }
            case 18: {
                return object2 instanceof Float;
            }
            case 19: {
                return object2 instanceof Double;
            }
            case 4: {
                return object2 instanceof BigDecimal || object2 instanceof IntNum;
            }
            case 28: {
                return object2 instanceof Duration;
            }
            case 29: {
                return object2 instanceof Duration && ((Duration)object2).unit() == Unit.month;
            }
            case 30: {
                return object2 instanceof Duration && ((Duration)object2).unit() == Unit.second;
            }
        }
        return super.isInstance(object2);
    }

    public void emitIsInstance(Variable variable, Compilation compilation, Target target) {
        InstanceOf.emitIsInstance(this, variable, compilation, target);
    }

    public String toString(Object object2) {
        return object2.toString();
    }

    public void print(Object object2, Consumer consumer) {
        if (object2 instanceof Printable) {
            ((Printable)object2).print(consumer);
        } else {
            consumer.write(this.toString(object2));
        }
    }

    public boolean castable(Object object2) {
        try {
            this.cast(object2);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public Object cast(Object object2) {
        if ((object2 = KNode.atomicValue(object2)) instanceof UntypedAtomic) {
            if (this.typeCode == 37) {
                return object2;
            }
            return this.valueOf(object2.toString());
        }
        if (object2 instanceof String) {
            return this.valueOf(object2.toString());
        }
        switch (this.typeCode) {
            case 38: {
                return TextUtils.asString(object2);
            }
            case 37: {
                return new UntypedAtomic(TextUtils.stringValue(object2));
            }
            case 33: {
                return URIPath.makeURI(object2);
            }
            case 31: {
                if (object2 instanceof Boolean) {
                    return (Boolean)object2 != false ? Boolean.TRUE : Boolean.FALSE;
                }
                if (!(object2 instanceof Number)) break;
                double d = ((Number)object2).doubleValue();
                return d == 0.0 || Double.isNaN(d) ? Boolean.FALSE : Boolean.TRUE;
            }
            case 4: {
                if (object2 instanceof BigDecimal) {
                    return object2;
                }
                if (object2 instanceof RealNum) {
                    return ((RealNum)object2).asBigDecimal();
                }
                if (object2 instanceof Float || object2 instanceof Double) {
                    double d = ((Number)object2).doubleValue();
                    return BigDecimal.valueOf(d);
                }
                if (!(object2 instanceof Boolean)) break;
                return this.cast((Boolean)object2 != false ? IntNum.one() : IntNum.zero());
            }
            case 18: {
                if (object2 instanceof Float) {
                    return object2;
                }
                if (object2 instanceof Number) {
                    return XDataType.makeFloat(((Number)object2).floatValue());
                }
                if (!(object2 instanceof Boolean)) break;
                return (Boolean)object2 != false ? FLOAT_ONE : FLOAT_ZERO;
            }
            case 19: {
                if (object2 instanceof Double) {
                    return object2;
                }
                if (object2 instanceof Number) {
                    return XDataType.makeDouble(((Number)object2).doubleValue());
                }
                if (!(object2 instanceof Boolean)) break;
                return (Boolean)object2 != false ? DOUBLE_ONE : DOUBLE_ZERO;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                DateTime dateTime;
                int n;
                if (!(object2 instanceof DateTime)) break;
                int n2 = XTimeType.components(((XTimeType)this).typeCode);
                if (n2 == (n = (dateTime = (DateTime)object2).components()) || (n & 0xE) == 14) {
                    return dateTime.cast(n2);
                }
                throw new ClassCastException();
            }
            case 20: 
            case 21: 
            case 22: {
                if (!(object2 instanceof DateTime)) break;
                int n = XTimeType.components(((XTimeType)this).typeCode);
                return ((DateTime)object2).cast(n);
            }
            case 28: {
                return this.castToDuration(object2, Unit.duration);
            }
            case 29: {
                return this.castToDuration(object2, Unit.month);
            }
            case 30: {
                return this.castToDuration(object2, Unit.second);
            }
            case 34: {
                if (object2 instanceof BinaryObject) {
                    return new Base64Binary(((BinaryObject)object2).getBytes());
                }
            }
            case 35: {
                if (!(object2 instanceof BinaryObject)) break;
                return new HexBinary(((BinaryObject)object2).getBytes());
            }
        }
        return this.coerceFromObject(object2);
    }

    Duration castToDuration(Object object2, Unit unit) {
        if (object2 instanceof Duration) {
            Duration duration = (Duration)object2;
            if (duration.unit() == unit) {
                return duration;
            }
            int n = duration.getTotalMonths();
            long l = duration.getTotalSeconds();
            int n2 = duration.getNanoSecondsOnly();
            if (unit == Unit.second) {
                n = 0;
            }
            if (unit == Unit.month) {
                l = 0L;
                n2 = 0;
            }
            return Duration.make(n, l, n2, unit);
        }
        return (Duration)this.coerceFromObject(object2);
    }

    public Object coerceFromObject(Object object2) {
        if (!this.isInstance(object2)) {
            throw new ClassCastException("cannot cast " + object2 + " to " + this.name);
        }
        return object2;
    }

    public int compare(Type type) {
        if (this == type || this == stringStringType && type == stringType || this == stringType && type == stringStringType) {
            return 0;
        }
        return this.implementationType.compare(type);
    }

    public Object valueOf(String string) {
        switch (this.typeCode) {
            case 38: {
                return string;
            }
            case 37: {
                return new UntypedAtomic(string);
            }
            case 33: {
                return URIPath.makeURI(TextUtils.replaceWhitespace(string, true));
            }
            case 31: {
                string = string.trim();
                if (string.equals("true") || string.equals("1")) {
                    return Boolean.TRUE;
                }
                if (string.equals("false") || string.equals("0")) {
                    return Boolean.FALSE;
                }
                throw new IllegalArgumentException("not a valid boolean: '" + string + "'");
            }
            case 18: 
            case 19: {
                string = string.trim();
                if ("INF".equals(string)) {
                    string = "Infinity";
                } else if ("-INF".equals(string)) {
                    string = "-Infinity";
                }
                return this.typeCode == 18 ? (Number)Float.valueOf(string) : (Number)Double.valueOf(string);
            }
            case 4: {
                string = string.trim();
                int n = string.length();
                while (--n >= 0) {
                    char c = string.charAt(n);
                    if (c != 'e' && c != 'E') continue;
                    throw new IllegalArgumentException("not a valid decimal: '" + string + "'");
                }
                return new BigDecimal(string);
            }
            case 28: {
                return Duration.parseDuration(string);
            }
            case 29: {
                return Duration.parseYearMonthDuration(string);
            }
            case 30: {
                return Duration.parseDayTimeDuration(string);
            }
            case 34: {
                return Base64Binary.valueOf(string);
            }
            case 35: {
                return HexBinary.valueOf(string);
            }
        }
        throw new RuntimeException("valueOf not implemented for " + this.name);
    }

    public static Float makeFloat(float f) {
        return Float.valueOf(f);
    }

    public static Double makeDouble(double d) {
        return d;
    }

    public Procedure getConstructor() {
        return null;
    }
}

