/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ClassFileInput;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ListCodeSize {
    public static void usage() {
        System.err.println("Usage: class methodname ...");
        System.exit(-1);
    }

    static void print(Method method) {
        System.out.print(method);
        CodeAttr codeAttr = method.getCode();
        if (codeAttr == null) {
            System.out.print(": no code");
        } else {
            System.out.print(": ");
            System.out.print(codeAttr.getPC());
            System.out.print(" bytes");
        }
        System.out.println();
    }

    public static final void main(String[] stringArray) {
        if (stringArray.length == 0) {
            ListCodeSize.usage();
        }
        String string = stringArray[0];
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ClassType classType = new ClassType();
            new ClassFileInput(classType, fileInputStream);
            if (stringArray.length == 1) {
                for (Method method = classType.getMethods(); method != null; method = method.getNext()) {
                    ListCodeSize.print(method);
                }
            } else {
                for (int i = 1; i < stringArray.length; ++i) {
                    for (Method method = classType.getMethods(); method != null; method = method.getNext()) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(method.getName());
                        method.listParameters(stringBuffer);
                        stringBuffer.append(method.getReturnType().getName());
                        if (!stringBuffer.toString().startsWith(stringArray[i])) continue;
                        ListCodeSize.print(method);
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File " + string + " not found");
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            iOException.printStackTrace();
            System.exit(-1);
        }
    }
}

