/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.ReportFormat;
import java.io.IOException;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class CompoundFormat
extends ReportFormat {
    protected int length;
    protected Format[] formats;

    public CompoundFormat(Format[] formatArray, int n) {
        this.formats = formatArray;
        this.length = n;
    }

    public CompoundFormat(Format[] formatArray) {
        this.formats = formatArray;
        this.length = formatArray.length;
    }

    public int format(Object[] objectArray, int n, Writer writer, FieldPosition fieldPosition) throws IOException {
        int n2 = 0;
        while (n2 < this.length) {
            Format format = this.formats[n2];
            if (format instanceof ReportFormat) {
                if ((n = ((ReportFormat)format).format(objectArray, n, writer, fieldPosition)) < 0) {
                    return n;
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                format.format(objectArray[n], stringBuffer, fieldPosition);
                writer.write(stringBuffer.toString());
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public final int format(Object[] objectArray, int n, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n2 = 0;
        while (n2 < this.length) {
            Format format = this.formats[n2];
            if (format instanceof ReportFormat) {
                if ((n = ((ReportFormat)format).format(objectArray, n, stringBuffer, fieldPosition)) < 0) {
                    return n;
                }
            } else {
                format.format(objectArray[n], stringBuffer, fieldPosition);
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new Error("CompoundFormat.parseObject - not implemented");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CompoundFormat[");
        int n = 0;
        while (n < this.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.formats[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

