/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.kawa.functions.Convert;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.reflect.OccurrenceType;
import gnu.kawa.xml.AncestorAxis;
import gnu.kawa.xml.AncestorOrSelfAxis;
import gnu.kawa.xml.AttributeAxis;
import gnu.kawa.xml.AttributeConstructor;
import gnu.kawa.xml.AttributeType;
import gnu.kawa.xml.ChildAxis;
import gnu.kawa.xml.DescendantAxis;
import gnu.kawa.xml.DescendantOrSelfAxis;
import gnu.kawa.xml.ElementConstructor;
import gnu.kawa.xml.ElementType;
import gnu.kawa.xml.FollowingAxis;
import gnu.kawa.xml.FollowingSiblingAxis;
import gnu.kawa.xml.NodeType;
import gnu.kawa.xml.ParentAxis;
import gnu.kawa.xml.PrecedingAxis;
import gnu.kawa.xml.PrecedingSiblingAxis;
import gnu.kawa.xml.SelfAxis;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.WrappedException;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xquery.lang.XQuery;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Vector;
import kawa.standard.require;

public class XQParser
extends LispReader {
    int curToken;
    Object curValue;
    XQuery interpreter;
    int seenPosition;
    int seenLast;
    public static boolean warnOldVersion;
    static final String DOT_VARNAME = "$dot$";
    static final String POSITION_VARNAME = "$position$";
    static final String LAST_VARNAME = "$last$";
    public static final InstanceOf instanceOf;
    int nesting;
    boolean preserveBoundarySpace;
    static final int EOF_TOKEN = -1;
    static final int EOL_TOKEN = 10;
    static final char INTEGER_TOKEN = '0';
    static final char FLOAT_TOKEN = '1';
    static final int STRING_TOKEN = 34;
    static final int SLASHSLASH_TOKEN = 68;
    static final int DOTDOT_TOKEN = 50;
    static final int COLON_EQUAL_TOKEN = 76;
    static final int COLONCOLON_TOKEN = 88;
    static final int NCNAME_TOKEN = 65;
    static final int NCNAME_COLON_TOKEN = 67;
    static final int QNAME_TOKEN = 81;
    static final int ARROW_TOKEN = 82;
    static final int FNAME_TOKEN = 70;
    static final int IMPORT_MODULE_TOKEN = 73;
    static final int IMPORT_SCHEMA_TOKEN = 84;
    static final int MODULE_NAMESPACE_TOKEN = 77;
    static final int DECLARE_NAMESPACE_TOKEN = 78;
    static final int DECLARE_XMLSPACE_TOKEN = 83;
    static final int DEFAULT_ELEMENT_TOKEN = 69;
    static final int DEFAULT_FUNCTION_TOKEN = 79;
    static final int DECLARE_FUNCTION_TOKEN = 80;
    static final int DECLARE_VARIABLE_TOKEN = 86;
    static final int DEFINE_QNAME_TOKEN = 87;
    static final int OP_AXIS_FIRST = 100;
    static final int COUNT_OP_AXIS = 13;
    static final int AXIS_ANCESTOR = 0;
    static final int AXIS_ANCESTOR_OR_SELF = 1;
    static final int AXIS_ATTRIBUTE = 2;
    static final int AXIS_CHILD = 3;
    static final int AXIS_DESCENDANT = 4;
    static final int AXIS_DESCENDANT_OR_SELF = 5;
    static final int AXIS_FOLLOWING = 6;
    static final int AXIS_FOLLOWING_SIBLING = 7;
    static final int AXIS_NAMESPACE = 8;
    static final int AXIS_PARENT = 9;
    static final int AXIS_PRECEDING = 10;
    static final int AXIS_PRECEDING_SIBLING = 11;
    static final int AXIS_SELF = 12;
    static final int OP_WHERE = 196;
    static final int OP_BASE = 400;
    static final int OP_OR = 400;
    static final int OP_AND = 404;
    static final int OP_EQU = 408;
    static final int OP_NEQ = 409;
    static final int OP_INSTANCEOF = 410;
    static final int OP_RANGE_TO = 411;
    static final int OP_LSS = 412;
    static final int OP_GRT = 413;
    static final int OP_LEQ = 414;
    static final int OP_GEQ = 415;
    static final int OP_IS = 416;
    static final int OP_ISNOT = 417;
    static final int OP_GRTGRT = 418;
    static final int OP_LSSLSS = 419;
    static final int OP_ADD = 420;
    static final int OP_SUB = 421;
    static final int OP_MUL = 424;
    static final int OP_DIV = 425;
    static final int OP_MOD = 426;
    static final int OP_INTERSECT = 428;
    static final int OP_EXCEPT = 429;
    static final int OP_UNION = 430;
    static final int OP_NODE = 231;
    static final int OP_TEXT = 232;
    private int saveToken;
    private Object saveValue;
    public static ReadTable xqlReadTable;
    int count = 0;
    private boolean warnedOldStyleKindTest;
    String prevPrefix;
    Compilation parser;
    String defaultElementNamespace = "";
    String defaultFunctionNamespace = "http://www.w3.org/2003/05/xpath-functions";
    Hashtable namespaces = new Hashtable(50);
    public static final String[] axisNames;
    static final Expression funcForwardFilter;
    static final Expression funcReverseFilter;
    static final Expression funcExprFilter;
    static final NodeType textNodeTest;
    static final NodeType anyNodeTest;

    protected char pushNesting(char c) {
        ++this.nesting;
        InPort inPort = (InPort)this.getPort();
        char c2 = inPort.readState;
        inPort.readState = c;
        return c2;
    }

    protected void popNesting(char c) {
        InPort inPort = (InPort)this.getPort();
        inPort.readState = c;
        --this.nesting;
    }

    final int skipSpace() throws IOException, SyntaxException {
        return this.skipSpace(true);
    }

    final int skipSpace(boolean bl) throws IOException, SyntaxException {
        int n;
        while (true) {
            if ((n = this.read()) == 40) {
                if (!this.checkNext(':')) {
                    return 40;
                }
                this.skipComment();
                continue;
            }
            if (n == 123) {
                n = this.read();
                if (n != 45) {
                    this.unread(n);
                    return 123;
                }
                n = this.read();
                if (n != 45) {
                    this.unread(n);
                    this.unread(45);
                    return 123;
                }
                this.skipOldComment();
                continue;
            }
            if (bl ? n < 0 || !Character.isWhitespace((char)n) : n != 32 && n != 9) break;
        }
        return n;
    }

    final void skipOldComment() throws IOException, SyntaxException {
        int n = 0;
        int n2 = this.getLineNumber() + 1;
        while (true) {
            int n3;
            if ((n3 = this.read()) == 45) {
                ++n;
                continue;
            }
            if (n3 == 125 && n >= 2) {
                return;
            }
            if (n3 < 0) {
                this.eofError("non-terminated comment starting at line " + n2);
                continue;
            }
            n = 0;
        }
    }

    final void skipComment() throws IOException, SyntaxException {
        int n = this.getLineNumber() + 1;
        int n2 = 0;
        int n3 = 0;
        char c = this.pushNesting(':');
        while (true) {
            int n4;
            if ((n4 = this.read()) == 58) {
                if (n2 == 40) {
                    ++n3;
                    n4 = 0;
                }
            } else if (n4 == 41 && n2 == 58) {
                if (n3 == 0) {
                    this.popNesting(c);
                    return;
                }
                --n3;
            } else if (n4 < 0) {
                this.eofError("non-terminated comment starting at line " + n);
            }
            n2 = n4;
        }
    }

    final int peekNonSpace(String string) throws IOException, SyntaxException {
        int n = this.skipSpace();
        if (n < 0) {
            this.eofError(string);
        }
        this.unread(n);
        return n;
    }

    public static boolean isNameStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    public static boolean isNamePart(char c) {
        return Character.isUnicodeIdentifierPart(c) || c == '-' || c == '.';
    }

    public void mark() throws IOException {
        super.mark();
        this.saveToken = this.curToken;
        this.saveValue = this.curValue;
    }

    public void reset() throws IOException {
        this.curToken = this.saveToken;
        this.curValue = this.saveValue;
        super.reset();
    }

    int getRawToken() throws IOException, SyntaxException {
        int n;
        while (true) {
            if ((n = this.read()) < 0) {
                this.curToken = -1;
                return -1;
            }
            if (n == 10 || n == 13) {
                if (this.nesting > 0) continue;
                this.curToken = 10;
                return 10;
            }
            if (n == 40) {
                if (this.checkNext(':')) {
                    this.skipComment();
                    continue;
                }
                this.curToken = 40;
                return 40;
            }
            if (n == 123) {
                if (!this.checkNext('-')) {
                    this.curToken = 123;
                    return 123;
                }
                n = this.read();
                if (n != 45) {
                    this.unread();
                    this.unread();
                    this.curToken = 123;
                    return 123;
                }
                this.skipOldComment();
                continue;
            }
            if (n != 32 && n != 9) break;
        }
        this.tokenBufferLength = 0;
        int n2 = n;
        switch (n2) {
            case 36: 
            case 41: 
            case 44: 
            case 59: 
            case 63: 
            case 64: 
            case 91: 
            case 93: 
            case 125: {
                break;
            }
            case 58: {
                if (!this.checkNext('=')) break;
                n2 = 76;
                break;
            }
            case 124: {
                n2 = 430;
                break;
            }
            case 42: {
                n2 = 424;
                break;
            }
            case 43: {
                n2 = 420;
                break;
            }
            case 45: {
                n2 = 421;
                break;
            }
            case 33: {
                if (!this.checkNext('=')) break;
                n2 = 409;
                break;
            }
            case 47: {
                if (!this.checkNext('/')) break;
                n2 = 68;
                break;
            }
            case 61: {
                if (this.checkNext('>')) {
                    n2 = 82;
                }
                n2 = 408;
                break;
            }
            case 62: {
                n2 = this.checkNext('=') ? 415 : (this.checkNext('>') ? 418 : 413);
                break;
            }
            case 60: {
                n2 = this.checkNext('=') ? 414 : (this.checkNext('<') ? 419 : 412);
                break;
            }
            case 46: {
                if (this.checkNext('.')) {
                    n2 = 50;
                    break;
                }
                n = this.peek();
                if (!Character.isDigit((char)n)) break;
                this.tokenBufferAppend(46);
                do {
                    this.tokenBufferAppend((char)n);
                    this.skip();
                } while (Character.isDigit((char)(n = this.peek())));
                n2 = 49;
                break;
            }
            case 34: 
            case 39: {
                char c = this.pushNesting((char)n);
                while (true) {
                    if ((n = this.read()) < 0) {
                        this.eofError("unexpected end-of-file in string");
                    }
                    if (n == 38) {
                        this.parseEntityOrCharRef();
                        continue;
                    }
                    if (n2 == n && n2 != (n = this.read())) break;
                    this.tokenBufferAppend((char)n);
                }
                this.unread(n);
                this.popNesting(c);
                n2 = 34;
                break;
            }
            default: {
                if (Character.isDigit((char)n2)) {
                    boolean bl = false;
                    while (true) {
                        this.tokenBufferAppend(n2);
                        n = this.read();
                        if (n < 0) break;
                        n2 = (char)n;
                        if (n2 == 46) {
                            if (bl) break;
                            bl = true;
                            continue;
                        }
                        if (!Character.isDigit((char)n2)) break;
                    }
                    if (n == 101 || n == 69) {
                        this.tokenBufferAppend((char)n);
                        n = this.read();
                        if (n == 43 || n == 45) {
                            this.tokenBufferAppend((char)n);
                            n = this.read();
                        }
                        int n3 = 0;
                        while (n >= 0) {
                            n2 = (char)n;
                            if (!Character.isDigit((char)n2)) {
                                this.unread();
                                break;
                            }
                            this.tokenBufferAppend(n2);
                            n = this.read();
                            ++n3;
                        }
                        if (n3 == 0) {
                            this.error("no digits following exponent");
                        }
                        n2 = 49;
                        break;
                    }
                    int n4 = n2 = bl ? 49 : 48;
                    if (n < 0) break;
                    this.unread(n);
                    break;
                }
                if (XQParser.isNameStart((char)n2)) {
                    do {
                        this.tokenBufferAppend(n2);
                    } while (XQParser.isNamePart((char)(n2 = (int)((char)(n = this.read())))));
                    if (n < 0) {
                        n2 = 65;
                        break;
                    }
                    if (n != 58) {
                        n2 = 65;
                    } else {
                        n = this.read();
                        if (n < 0) {
                            this.eofError("unexpected end-of-file after NAME ':'");
                        }
                        if (XQParser.isNameStart((char)(n2 = (int)((char)n)))) {
                            this.tokenBufferAppend(58);
                            do {
                                this.tokenBufferAppend(n2);
                            } while (XQParser.isNamePart((char)(n2 = (int)((char)(n = this.read())))));
                            n2 = 81;
                        } else if (n2 == 61) {
                            this.unread(n2);
                            n2 = 65;
                        } else {
                            n2 = 67;
                        }
                    }
                    this.unread(n);
                    break;
                }
                if (n2 >= 32 && n2 < 127) {
                    this.syntaxError("invalid character '" + (char)n2 + '\'', 1);
                    break;
                }
                this.syntaxError("invalid character '\\u" + Integer.toHexString(n2) + '\'', 1);
            }
        }
        this.curToken = n2;
        return n2;
    }

    public void appendNamedEntity(String string) {
        string = string.intern();
        int n = 63;
        if (string == "lt") {
            n = 60;
        } else if (string == "gt") {
            n = 62;
        } else if (string == "amp") {
            n = 38;
        } else if (string == "quot") {
            n = 34;
        } else if (string == "apos") {
            n = 39;
        } else {
            this.error("unknown enity reference: '" + string + "'");
        }
        this.tokenBufferAppend(n);
    }

    int peekOperator() throws IOException, SyntaxException {
        while (this.curToken == 10) {
            if (this.nesting == 0) {
                return 10;
            }
            this.getRawToken();
        }
        if (this.curToken == 65) {
            int n = this.tokenBufferLength;
            if (n == 2 || n == 3) {
                char c = this.tokenBuffer[0];
                if (n == 2) {
                    char c2 = this.tokenBuffer[1];
                    if (c == 'o' && c2 == 'r') {
                        this.curToken = 400;
                    } else if (c == 't' && c2 == 'o') {
                        this.curToken = 411;
                    } else if (c == 'i' && c2 == 's') {
                        this.curToken = 416;
                    } else if (c == 'e' && c2 == 'q') {
                        this.curToken = 408;
                    } else if (c == 'n' && c2 == 'e') {
                        this.curToken = 409;
                    } else if (c == 'g') {
                        if (c2 == 'e') {
                            this.curToken = 415;
                        } else if (c2 == 't') {
                            this.curToken = 413;
                        }
                    } else if (c == 'l') {
                        if (c2 == 'e') {
                            this.curToken = 414;
                        } else if (c2 == 't') {
                            this.curToken = 412;
                        }
                    }
                } else {
                    char c3 = this.tokenBuffer[1];
                    char c4 = this.tokenBuffer[2];
                    if (c == 'a') {
                        if (c3 == 'n' && c4 == 'd') {
                            this.curToken = 404;
                        }
                    } else if (c == 'm') {
                        if (c3 == 'u' && c4 == 'l') {
                            this.curToken = 424;
                        }
                        if (c3 == 'o' && c4 == 'd') {
                            this.curToken = 426;
                        }
                    } else if (c == 'd' && c3 == 'i' && c4 == 'v') {
                        this.curToken = 425;
                    }
                }
            } else if (n == 5) {
                if (this.match("where")) {
                    this.curToken = 196;
                } else if (this.match("isnot")) {
                    this.curToken = 417;
                } else if (this.match("union")) {
                    this.curToken = 430;
                }
            } else if (n == 6) {
                if (this.match("except")) {
                    this.curToken = 429;
                }
            } else if (n == 9) {
                if (this.match("intersect")) {
                    this.curToken = 428;
                }
            } else if (n == 10) {
                int n2 = 0;
                while (true) {
                    if (n2 == 10) {
                        this.curToken = 410;
                        break;
                    }
                    if (this.tokenBuffer[n2] != "instanceof".charAt(n2)) break;
                    ++n2;
                }
            }
        }
        return this.curToken;
    }

    private boolean lookingAt(String string, String string2) throws IOException, SyntaxException {
        int n;
        if (!string.equals(this.curValue)) {
            return false;
        }
        int n2 = 0;
        int n3 = string2.length();
        do {
            n = this.read();
            if (n2 != n3) continue;
            if (n < 0) {
                return true;
            }
            if (!XQParser.isNamePart((char)n)) {
                this.unread();
                return true;
            }
            ++n2;
            break;
        } while (n >= 0 && n == string2.charAt(n2++));
        this.port.skip(-n2);
        return false;
    }

    int peekOperand() throws IOException, SyntaxException {
        while (this.curToken == 10) {
            this.getRawToken();
        }
        if (this.curToken == 65 || this.curToken == 81) {
            int n = this.skipSpace(this.nesting != 0);
            if (n == 40 && this.peek() != 58) {
                int n2 = 70;
                switch (this.tokenBuffer[0]) {
                    case 'i': {
                        if (!this.match("if")) break;
                        this.unread();
                        return this.curToken;
                    }
                    case 'n': {
                        if (!this.match("node")) break;
                        n2 = 231;
                        break;
                    }
                    case 't': {
                        if (!this.match("text")) break;
                        n2 = 232;
                    }
                }
                this.curToken = n2;
                return this.curToken;
            }
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            this.curValue = string;
            switch (n) {
                case 101: {
                    if (!this.lookingAt("default", "lement")) break;
                    this.curToken = 69;
                    return 69;
                }
                case 102: {
                    if (this.lookingAt("declare", "unction")) {
                        this.curToken = 80;
                        return 80;
                    }
                    if (this.lookingAt("define", "unction")) {
                        if (warnOldVersion) {
                            this.error('w', "replace 'define function' by 'declare function'");
                        }
                        this.curToken = 80;
                        return 80;
                    }
                    if (!this.lookingAt("default", "unction")) break;
                    this.curToken = 79;
                    return 79;
                }
                case 109: {
                    if (!this.lookingAt("import", "odule")) break;
                    this.curToken = 73;
                    return 73;
                }
                case 110: {
                    if (this.lookingAt("declare", "amespace")) {
                        this.curToken = 78;
                        return 78;
                    }
                    if (!this.lookingAt("module", "amespace")) break;
                    this.curToken = 77;
                    return 77;
                }
                case 118: {
                    if (this.lookingAt("declare", "ariable")) {
                        this.curToken = 86;
                        return 86;
                    }
                    if (!this.lookingAt("define", "ariable")) break;
                    if (warnOldVersion) {
                        this.error('w', "replace 'define variable' by 'declare variable'");
                    }
                    this.curToken = 86;
                    return 86;
                }
                case 120: {
                    if (!this.lookingAt("declare", "mlspace")) break;
                    this.curToken = 83;
                    return 83;
                }
            }
            if (n >= 0) {
                this.unread();
                if (XQParser.isNameStart((char)n) && this.curValue.equals("define")) {
                    this.getRawToken();
                    this.curToken = 87;
                }
            }
            return this.curToken;
        }
        if (this.curToken == 67) {
            int n = this.read();
            if (n == 58) {
                String string = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
                int n3 = 13;
                while (--n3 >= 0 && axisNames[n3] != string) {
                }
                if (n3 >= 0) {
                    this.curToken = (char)(100 + n3);
                } else {
                    this.error("unknown axis name '" + string + '\'');
                }
                this.curValue = string;
            } else {
                this.unread(n);
            }
        }
        return this.curToken;
    }

    private void pushStandardNamespaces() {
        this.namespaces.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.namespaces.put("xs", "http://www.w3.org/2001/XMLSchema");
        this.namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.namespaces.put("fn", "http://www.w3.org/2003/05/xpath-functions");
        this.namespaces.put("kawa", "http://kawa.gnu.org/");
        this.namespaces.put("qexo", "http://kawa.gnu.org/");
        this.namespaces.put("local", "http://www.w3.org/2003/08/xquery-local-functions");
    }

    public XQParser(InPort inPort) {
        this(inPort, null);
    }

    public XQParser(InPort inPort, SourceMessages sourceMessages) {
        super(inPort, sourceMessages);
        this.pushStandardNamespaces();
        this.nesting = 1;
    }

    public void setInteractive(boolean bl) {
        if (this.interactive != bl) {
            this.nesting = bl ? --this.nesting : ++this.nesting;
        }
        this.interactive = bl;
    }

    protected ReadTable getReadTable() {
        return xqlReadTable;
    }

    public static Object readObject(InPort inPort) throws IOException, SyntaxException {
        return new XQParser(inPort).readObject();
    }

    private static final int priority(int n) {
        return n >> 2;
    }

    static Expression makeBinary(Expression expression, Expression expression2, Expression expression3) {
        Expression[] expressionArray = new Expression[]{expression2, expression3};
        return new ApplyExp(expression, expressionArray);
    }

    static Expression makeExprSequence(Expression expression, Expression expression2) {
        return XQParser.makeBinary(XQParser.makeFunctionExp("gnu.kawa.functions.AppendValues", "appendValues"), expression, expression2);
    }

    Expression makeBinary(int n, Expression expression, Expression expression2) throws IOException, SyntaxException {
        Expression expression3;
        switch (n) {
            case 420: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.AddOp", "+");
                break;
            }
            case 421: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.AddOp", "-");
                break;
            }
            case 424: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.MultiplyOp", "$St", "mul");
                break;
            }
            case 425: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.functions.DivideOp", "$Sl", "div");
                break;
            }
            case 426: {
                expression3 = new QuoteExp(new PrimProcedure(ClassType.make("gnu.math.IntNum").getDeclaredMethod("remainder", 2)));
                break;
            }
            case 408: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "=");
                break;
            }
            case 409: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "!=");
                break;
            }
            case 412: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "<");
                break;
            }
            case 414: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "<=");
                break;
            }
            case 413: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", ">");
                break;
            }
            case 415: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", ">=");
                break;
            }
            case 416: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.NodeCompare", "$Eq", "is");
                break;
            }
            case 417: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.NodeCompare", "$Ne", "isnot");
                break;
            }
            case 418: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.NodeCompare", "$Gr", ">>");
                break;
            }
            case 419: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.NodeCompare", "$Ls", "<<");
                break;
            }
            case 411: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.IntegerRange", "integerRange");
                break;
            }
            case 430: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.UnionNodes", "unionNodes");
                break;
            }
            case 428: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.IntersectNodes", "intersectNodes");
                break;
            }
            case 429: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.IntersectNodes", "exceptNodes");
                break;
            }
            default: {
                return this.syntaxError("unimplemented binary op: " + n);
            }
        }
        return XQParser.makeBinary(expression3, expression, expression2);
    }

    Expression parseSortExpr() throws IOException, SyntaxException {
        Expression expression = this.parseBinaryExpr(XQParser.priority(400));
        return expression;
    }

    private void parseSimpleKindType() throws IOException, SyntaxException {
        this.getRawToken();
        if (this.curToken == 40) {
            this.getRawToken();
            if (this.curToken == 41) {
                this.getRawToken();
            } else {
                this.error("expected ')'");
            }
        } else {
            this.warnOldStyleKindTest();
        }
    }

    public Type parseElementType() throws IOException, SyntaxException {
        Symbol symbol;
        if (this.curToken == 40) {
            this.getRawToken();
            if (this.curToken == 41) {
                symbol = new Symbol(null);
                this.getRawToken();
            } else {
                symbol = this.parseNameTest(this.defaultElementNamespace);
                this.getRawToken();
                if (this.curToken == 44) {
                    this.getRawToken();
                    Symbol symbol2 = this.parseNameTest(this.defaultElementNamespace);
                    this.getRawToken();
                }
                if (this.curToken == 41) {
                    this.getRawToken();
                } else {
                    this.error("expected ')' after element");
                }
            }
        } else {
            this.warnOldStyleKindTest();
            if (this.curToken == 81 || this.curToken == 424 || this.curToken == 65 || this.curToken == 67) {
                symbol = this.parseNameTest(this.defaultElementNamespace);
                this.getRawToken();
            } else {
                symbol = new Symbol(null);
            }
        }
        return new ElementType(symbol);
    }

    private void warnOldStyleKindTest() {
        if (this.warnedOldStyleKindTest) {
            return;
        }
        this.error('w', "old-style KindTest - first one here");
        this.warnedOldStyleKindTest = true;
    }

    public Expression parseOptionalTypeDeclaration() throws IOException, SyntaxException {
        if (!this.match("as")) {
            return null;
        }
        this.getRawToken();
        return this.parseDataType();
    }

    public void setType(Declaration declaration, Expression expression) {
        if (expression instanceof QuoteExp) {
            declaration.setType((Type)((QuoteExp)expression).getValue());
        } else if (expression != null) {
            this.error('w', "type is too complex");
        }
    }

    public Expression parseDataType() throws IOException, SyntaxException {
        int n;
        int n2;
        Type type = this.parseItemType();
        if (type == null) {
            return this.syntaxError("bad syntax - expected DataType");
        }
        if (this.curToken == 63) {
            n2 = 0;
            n = 1;
        } else if (this.curToken == 420) {
            n2 = 1;
            n = -1;
        } else if (this.curToken == 424) {
            n2 = 0;
            n = -1;
        } else {
            n2 = 1;
            n = 1;
        }
        if (n2 != n) {
            this.getRawToken();
            return new QuoteExp(new OccurrenceType(type, n2, n));
        }
        return new QuoteExp(type);
    }

    public Type parseItemType() throws IOException, SyntaxException {
        if (this.curToken == 65 || this.curToken == 81) {
            if (this.match("element")) {
                this.getRawToken();
                return this.parseElementType();
            }
            if (this.match("text")) {
                this.parseSimpleKindType();
                return textNodeTest;
            }
            if (this.match("node")) {
                this.parseSimpleKindType();
                return anyNodeTest;
            }
            if (this.match("empty")) {
                this.parseSimpleKindType();
                return Type.void_type;
            }
            if (this.match("item")) {
                this.parseSimpleKindType();
                return Type.pointer_type;
            }
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            this.getRawToken();
            Type type = this.interpreter.getTypeFor(string);
            if (type == null) {
                type = ClassType.make(string);
            }
            return type;
        }
        return null;
    }

    Expression parseExpr() throws IOException, SyntaxException {
        return this.parseSortExpr();
    }

    final Expression parseExprSingle() throws IOException, SyntaxException {
        return this.parseBinaryExpr(XQParser.priority(400));
    }

    Expression parseBinaryExpr(int n) throws IOException, SyntaxException {
        Expression expression = this.parseUnaryExpr();
        int n2;
        while ((n2 = this.peekOperator()) != 10 && (n2 != 412 || this.peek() != 47)) {
            Expression[] expressionArray;
            int n3 = XQParser.priority(n2);
            if (n3 < n || n3 > 106) {
                return expression;
            }
            char c = this.pushNesting('%');
            this.getRawToken();
            this.popNesting(c);
            if (n2 == 410) {
                expressionArray = new Expression[]{expression, this.parseDataType()};
                expression = new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.lang.XQParser", "instanceOf"), expressionArray);
                continue;
            }
            expressionArray = this.parseBinaryExpr(n3 + 1);
            if (n2 == 404) {
                expression = new IfExp(XQParser.booleanValue(expression), (Expression)expressionArray, QuoteExp.falseExp);
                continue;
            }
            if (n2 == 400) {
                expression = new IfExp(XQParser.booleanValue(expression), QuoteExp.trueExp, (Expression)expressionArray);
                continue;
            }
            expression = this.makeBinary(n2, expression, (Expression)expressionArray);
        }
        return expression;
    }

    Expression parseUnaryExpr() throws IOException, SyntaxException {
        Expression expression;
        if (this.curToken == 421 || this.curToken == 420) {
            int n = this.curToken;
            this.getRawToken();
            expression = this.parseUnionExpr();
            expression = this.makeBinary(n, new QuoteExp(IntNum.zero()), expression);
        } else {
            expression = this.parseUnionExpr();
        }
        return expression;
    }

    Expression parseUnionExpr() throws IOException, SyntaxException {
        int n;
        Expression expression = this.parseIntersectExceptExpr();
        while ((n = this.peekOperator()) == 430) {
            this.getRawToken();
            Expression expression2 = this.parseIntersectExceptExpr();
            expression = this.makeBinary(n, expression, expression2);
        }
        return expression;
    }

    Expression parseIntersectExceptExpr() throws IOException, SyntaxException {
        int n;
        Expression expression = this.parsePathExpr();
        while ((n = this.peekOperator()) == 428 || n == 429) {
            this.getRawToken();
            Expression expression2 = this.parsePathExpr();
            expression = this.makeBinary(n, expression, expression2);
        }
        return expression;
    }

    Expression parsePathExpr() throws IOException, SyntaxException {
        Expression expression;
        if (this.curToken == 47 || this.curToken == 68) {
            Declaration declaration = this.parser.lookup(DOT_VARNAME, -1);
            if (declaration == null) {
                this.error("node test when focus is undefined");
            }
            ReferenceExp referenceExp = new ReferenceExp(DOT_VARNAME, declaration);
            expression = new ApplyExp(ClassType.make("gnu.kawa.xml.Nodes").getDeclaredMethod("root", 1), new Expression[]{referenceExp});
        } else {
            expression = this.parseStepExpr();
        }
        return this.parseRelativePathExpr(expression);
    }

    Symbol parseNameTest(String string) throws IOException, SyntaxException {
        String string2 = null;
        String string3 = null;
        if (this.curToken == 81) {
            int n = this.tokenBufferLength;
            while (this.tokenBuffer[--n] != ':') {
            }
            String string4 = new String(this.tokenBuffer, 0, n);
            string2 = new String(this.tokenBuffer, ++n, this.tokenBufferLength - n);
            string3 = (String)this.namespaces.get(string4);
            if (string3 == null) {
                this.syntaxError("unknown namespace '" + string4 + "'");
            }
        } else if (this.curToken == 424) {
            int n = this.read();
            if (n != 58) {
                this.unread(n);
            } else {
                n = this.read();
                if (n < 0) {
                    this.eofError("unexpected end-of-file after '*:'");
                }
                if (XQParser.isNameStart((char)n)) {
                    this.unread();
                    this.getRawToken();
                    if (this.curToken != 65) {
                        this.syntaxError("invalid name test");
                    } else {
                        string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    }
                } else if (n != 42) {
                    this.syntaxError("missing local-name after '*:'");
                }
            }
        } else if (this.curToken == 65) {
            string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            string3 = string;
        } else if (this.curToken == 67) {
            String string5 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            int n = this.read();
            if (n != 42) {
                this.syntaxError("invalid characters after 'NCName:'");
                return Symbol.make(string, string5);
            }
            string3 = (String)this.namespaces.get(string5);
            if (string3 == null) {
                this.syntaxError("unknown namespace '" + string5 + "'");
            }
            string2 = null;
        }
        if (string3 == null) {
            return new Symbol(string2 == null ? null : string2.intern());
        }
        return Symbol.make(string3, string2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Expression parseNodeTest(int n) throws IOException, SyntaxException {
        ApplyExp applyExp;
        Declaration declaration = this.parser.lookup(DOT_VARNAME, -1);
        if (declaration == null) {
            this.error("node test when focus is undefined");
        }
        ReferenceExp referenceExp = new ReferenceExp(DOT_VARNAME, declaration);
        int n2 = this.peekOperand();
        if (n2 == 70) {
            // empty if block
        }
        if (this.curToken == 64 && n < 0) {
            this.getRawToken();
            n = 2;
        }
        if (n == 2) {
            if (this.curToken != 65 && this.curToken != 81 && this.curToken != 67 && this.curToken != 424) return this.syntaxError("missing name or '*' after '@' or attribute::");
            Symbol symbol = this.parseNameTest("");
            Expression[] expressionArray = new Expression[]{referenceExp};
            AttributeAxis attributeAxis = AttributeAxis.make(new AttributeType(symbol));
            applyExp = new ApplyExp(attributeAxis, expressionArray);
        } else if (this.curToken == 65 || this.curToken == 81 || this.curToken == 67 || this.curToken == 424 || this.curToken == 231 || this.curToken == 232) {
            void var8_21;
            Expression[] expressionArray;
            NodeType nodeType;
            if (this.curToken == 231 || this.curToken == 232) {
                nodeType = this.curToken == 231 ? anyNodeTest : textNodeTest;
                if (this.getRawToken() != 41) {
                    return this.syntaxError("missing '()' after node test");
                }
            } else {
                expressionArray = this.parseNameTest(this.defaultElementNamespace);
                nodeType = new ElementType((Symbol)expressionArray);
            }
            expressionArray = new Expression[]{referenceExp};
            switch (n) {
                default: {
                    ChildAxis childAxis = ChildAxis.make(nodeType);
                    break;
                }
                case 4: {
                    DescendantAxis descendantAxis = DescendantAxis.make(nodeType);
                    break;
                }
                case 5: {
                    DescendantOrSelfAxis descendantOrSelfAxis = DescendantOrSelfAxis.make(nodeType);
                    break;
                }
                case 12: {
                    SelfAxis selfAxis = SelfAxis.make(nodeType);
                    break;
                }
                case 9: {
                    ParentAxis parentAxis = ParentAxis.make(nodeType);
                    break;
                }
                case 0: {
                    AncestorAxis ancestorAxis = AncestorAxis.make(nodeType);
                    break;
                }
                case 1: {
                    AncestorOrSelfAxis ancestorOrSelfAxis = AncestorOrSelfAxis.make(nodeType);
                    break;
                }
                case 6: {
                    FollowingAxis followingAxis = FollowingAxis.make(nodeType);
                    break;
                }
                case 7: {
                    FollowingSiblingAxis followingSiblingAxis = FollowingSiblingAxis.make(nodeType);
                    break;
                }
                case 10: {
                    PrecedingAxis precedingAxis = PrecedingAxis.make(nodeType);
                    break;
                }
                case 11: {
                    PrecedingSiblingAxis precedingSiblingAxis = PrecedingSiblingAxis.make(nodeType);
                }
            }
            applyExp = new ApplyExp((Procedure)var8_21, expressionArray);
        } else {
            if (n < 0) return null;
            return this.syntaxError("unsupported axis '" + axisNames[n] + "::'");
        }
        this.getRawToken();
        return applyExp;
    }

    Expression parseRelativePathExpr(Expression expression) throws IOException, SyntaxException {
        while (this.curToken == 47 || this.curToken == 68) {
            Object object2;
            Expression[] expressionArray;
            boolean bl = this.curToken == 68;
            LambdaExp lambdaExp = new LambdaExp(3);
            Declaration declaration = lambdaExp.addDeclaration(DOT_VARNAME);
            declaration.setFlag(262144);
            declaration.noteValue(null);
            lambdaExp.addDeclaration(POSITION_VARNAME, Type.int_type);
            lambdaExp.addDeclaration(LAST_VARNAME, Type.int_type);
            this.parser.push(lambdaExp);
            if (bl) {
                this.curToken = 47;
                expressionArray = new ReferenceExp(DOT_VARNAME, declaration);
                object2 = new Expression[]{expressionArray};
                DescendantOrSelfAxis descendantOrSelfAxis = DescendantOrSelfAxis.make(anyNodeTest);
                lambdaExp.body = new ApplyExp(descendantOrSelfAxis, (Expression[])object2);
            } else {
                this.getRawToken();
                lambdaExp.body = this.parseStepExpr();
            }
            this.parser.pop(lambdaExp);
            expressionArray = new Expression[]{expression, lambdaExp};
            object2 = XQParser.makeFunctionExp("gnu.xquery.util.RelativeStep", "relativeStep");
            expression = new ApplyExp((Expression)object2, expressionArray);
        }
        return expression;
    }

    Expression parseStepExpr() throws IOException, SyntaxException {
        if (this.curToken == 46 || this.curToken == 50) {
            int n = this.curToken == 46 ? 12 : 9;
            this.getRawToken();
            Declaration declaration = this.parser.lookup(DOT_VARNAME, -1);
            if (declaration == null) {
                this.error("node test when focus is undefined");
            }
            Expression expression = new ReferenceExp(DOT_VARNAME, declaration);
            if (n == 9) {
                Expression[] expressionArray = new Expression[]{expression};
                expression = new ApplyExp(ParentAxis.make(anyNodeTest), expressionArray);
            }
            return this.parseStepQualifiers(expression, n);
        }
        int n = this.peekOperand() - 100;
        if (n >= 0 && n < 13) {
            this.getRawToken();
            return this.parseStepQualifiers(this.parseNodeTest(n), n);
        }
        return this.parseOtherStepExpr();
    }

    Expression parseStepQualifiers(Expression expression, int n) throws IOException, SyntaxException {
        while (this.curToken == 91) {
            Expression expression2;
            int n2;
            int n3 = this.getLineNumber() + 1;
            int n4 = this.getColumnNumber() + 1;
            int n5 = this.seenPosition;
            int n6 = this.seenLast;
            this.getRawToken();
            LambdaExp lambdaExp = new LambdaExp(3);
            lambdaExp.setFile(this.getName());
            lambdaExp.setLine(n3, n4);
            Declaration declaration = lambdaExp.addDeclaration(DOT_VARNAME);
            lambdaExp.addDeclaration(POSITION_VARNAME, Type.int_type);
            lambdaExp.addDeclaration(LAST_VARNAME, Type.int_type);
            this.parser.push(lambdaExp);
            declaration.noteValue(null);
            Expression expression3 = this.parseExpr();
            if (n < 0) {
                n2 = 80;
                expression2 = funcExprFilter;
            } else if (n == 0 || n == 1 || n == 9 || n == 10 || n == 11) {
                n2 = 82;
                expression2 = funcReverseFilter;
            } else {
                n2 = 70;
                expression2 = funcForwardFilter;
            }
            expression3.setFile(this.getName());
            expression3.setLine(n3, n4);
            this.parser.pop(lambdaExp);
            lambdaExp.body = expression3;
            if (this.curToken != 93) {
                return this.syntaxError("missing ']'");
            }
            this.getRawToken();
            Expression[] expressionArray = new Expression[]{expression, lambdaExp};
            expression = new ApplyExp(expression2, expressionArray);
        }
        return expression;
    }

    Expression parseOtherStepExpr() throws IOException, SyntaxException {
        Expression expression = this.parsePrimaryExpr();
        expression = this.parseStepQualifiers(expression, -1);
        return expression;
    }

    Expression parsePrimaryExpr() throws IOException, SyntaxException {
        Expression expression = this.parseMaybePrimaryExpr();
        if (expression == null) {
            return this.syntaxError("missing expression");
        }
        return expression;
    }

    void parseEntityOrCharRef() throws IOException, SyntaxException {
        int n = this.read();
        if (n == 35) {
            int n2;
            char c;
            int n3;
            int n4;
            n = this.read();
            if (n == 120) {
                n4 = 16;
                n = this.read();
            } else {
                n4 = 10;
            }
            for (n2 = 0; n >= 0 && (n3 = Character.digit(c = (char)n, n4)) >= 0 && n2 < 0x8000000; n2 += n3) {
                n2 *= n4;
                n = this.read();
            }
            if (n != 59) {
                this.unread();
                this.error("invalid character reference");
            } else {
                this.tokenBufferAppend(n2);
            }
        } else {
            char c;
            int n5 = this.tokenBufferLength;
            while (n >= 0 && XQParser.isNamePart(c = (char)n)) {
                this.tokenBufferAppend(c);
                n = this.read();
            }
            if (n != 59) {
                this.unread();
                this.error("invalid entity reference");
                return;
            }
            String string = new String(this.tokenBuffer, n5, this.tokenBufferLength - n5);
            this.tokenBufferLength = n5;
            this.appendNamedEntity(string);
        }
    }

    void parseContent(char c, Vector vector) throws IOException, SyntaxException {
        boolean bl;
        this.tokenBufferLength = 0;
        boolean bl2 = bl = this.preserveBoundarySpace || c != '<';
        while (true) {
            Object object2;
            int n;
            if (((n = this.read()) < 0 || n == 123 || n == c) && this.tokenBufferLength > 0) {
                if (bl) {
                    object2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    vector.addElement(new QuoteExp(object2));
                }
                this.tokenBufferLength = 0;
            }
            if (n < 0) {
                this.eofError("unexpected end-of-file");
            }
            if (n == 123) {
                n = this.read();
                if (n == 123) {
                    this.tokenBufferAppend(123);
                    bl = true;
                    continue;
                }
                this.unread(n);
                object2 = this.parseEnclosedExpr();
                if (c != '<') {
                    object2 = XQParser.stringValue((Expression)object2);
                }
                vector.addElement(object2);
                this.tokenBufferLength = 0;
                continue;
            }
            if (n == 125) {
                n = this.read();
                if (n == 125) {
                    this.tokenBufferAppend(125);
                    bl = true;
                    continue;
                }
                this.error("unexpected '}' in element content");
                this.unread(n);
                continue;
            }
            if (n == c) {
                if (c != '<') {
                    if (!this.checkNext(c)) break;
                    this.tokenBufferAppend(c);
                    continue;
                }
                if (this.checkNext('/')) break;
                this.getRawToken();
                vector.addElement(this.parseElementConstructor());
                this.tokenBufferLength = 0;
                continue;
            }
            if (n == 38) {
                this.parseEntityOrCharRef();
                bl = true;
                continue;
            }
            if (!bl) {
                bl = !Character.isWhitespace((char)n);
            }
            this.tokenBufferAppend((char)n);
        }
    }

    Expression parseEnclosedExpr() throws IOException, SyntaxException {
        char c = this.pushNesting('{');
        this.peekNonSpace("unexpected end-of-file after '{'");
        int n = this.getLineNumber() + 1;
        int n2 = this.getColumnNumber() + 1;
        this.getRawToken();
        Expression expression = this.parseExpr();
        while (this.curToken != 125) {
            if (this.curToken == -1 || this.curToken == 41 || this.curToken == 93) {
                expression = this.syntaxError("missing '}'");
                break;
            }
            if (this.curToken != 44) {
                expression = this.syntaxError("missing '}' or ','");
            }
            this.getRawToken();
            expression = XQParser.makeExprSequence(expression, this.parseExpr());
        }
        expression.setFile(this.getName());
        expression.setLine(n, n2);
        this.popNesting(c);
        return expression;
    }

    public static Expression stringValue(Expression expression) {
        Expression[] expressionArray = new Expression[]{expression};
        Expression expression2 = XQParser.makeFunctionExp("gnu.xquery.util.StringValue", "string");
        return new ApplyExp(expression2, expressionArray);
    }

    public static Expression booleanValue(Expression expression) {
        Expression[] expressionArray = new Expression[]{expression};
        Expression expression2 = XQParser.makeFunctionExp("gnu.xquery.util.BooleanValue", "booleanValue");
        return new ApplyExp(expression2, expressionArray);
    }

    Expression parseNameSpec(String string, boolean bl) throws IOException, SyntaxException {
        if (this.curToken == 65 || this.curToken == 81) {
            String string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            Symbol symbol = this.curToken == 65 ? Symbol.make(string, string2) : this.parseNameTest(null);
            return new QuoteExp(bl ? AttributeConstructor.make(string2, symbol) : ElementConstructor.make(string2, symbol));
        }
        if (this.curToken == 123) {
            return this.parseEnclosedExpr();
        }
        return null;
    }

    Expression parseElementConstructor() throws IOException, SyntaxException {
        Object[] objectArray;
        Object object2;
        int n;
        int n2;
        Vector<Expression> vector = new Vector<Expression>();
        Expression expression = this.parseNameSpec(this.defaultElementNamespace, false);
        vector.addElement(expression);
        if (expression == null) {
            return this.syntaxError("missing NameSpec");
        }
        while ((n2 = this.skipSpace()) >= 0 && n2 != 62 && n2 != 47) {
            this.unread(n2);
            this.getRawToken();
            n = vector.size();
            object2 = this.parseNameSpec("", true);
            if (object2 == null) break;
            if (!(object2 instanceof QuoteExp) || !(((QuoteExp)object2).getValue() instanceof AttributeConstructor)) {
                vector.addElement((Expression)object2);
                object2 = XQParser.makeFunctionExp("gnu.xquery.util.MakeAttribute", "makeAttribute");
            }
            if ((n2 = this.skipSpace()) != 61) {
                return this.syntaxError("missing '=' after attribute");
            }
            n2 = this.skipSpace();
            if (n2 == 123) {
                vector.addElement(XQParser.stringValue(this.parseEnclosedExpr()));
            } else {
                this.parseContent((char)n2, vector);
            }
            objectArray = new Expression[vector.size() - n];
            int n3 = objectArray.length;
            while (--n3 >= 0) {
                objectArray[n3] = (Expression)vector.elementAt(n + n3);
            }
            vector.setSize(n);
            vector.addElement(new ApplyExp((Expression)object2, (Expression[])objectArray));
        }
        n = 0;
        if (n2 == 47) {
            n2 = this.read();
            if (n2 == 62) {
                n = 1;
            } else {
                this.unread(n2);
            }
        }
        if (n == 0) {
            if (n2 != 62) {
                return this.syntaxError("missing '>' after start element");
            }
            this.parseContent('<', vector);
            n2 = this.skipSpace();
            if (n2 >= 0 && n2 != 62) {
                String string;
                this.unread(n2);
                this.getRawToken();
                if (this.curToken != 65 && this.curToken != 81) {
                    return this.syntaxError("invalid tag syntax after '</'");
                }
                if (!(expression instanceof QuoteExp)) {
                    return this.syntaxError("'<{'expression'}>' must be closed by '</>'");
                }
                object2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                Object object3 = ((QuoteExp)expression).getValue();
                String string2 = string = object3 instanceof ElementConstructor ? ((ElementConstructor)object3).getXmlName() : object3.toString();
                if (!((String)object2).equals(string)) {
                    return this.syntaxError("'<" + string + ">' closed by '</" + (String)object2 + ">'");
                }
                n2 = this.skipSpace();
            }
            if (n2 != 62) {
                return this.syntaxError("missing '>' after end element");
            }
        }
        objectArray = new Expression[vector.size()];
        vector.copyInto(objectArray);
        return new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.util.MakeElement", "makeElement"), (Expression[])objectArray);
    }

    Expression parseExprSequence(int n) throws IOException, SyntaxException {
        if (this.curToken == n || this.curToken == -1) {
            return QuoteExp.voidExp;
        }
        Expression expression = null;
        while (true) {
            Expression expression2 = this.parseExpr();
            Expression expression3 = expression = expression == null ? expression2 : XQParser.makeExprSequence(expression, expression2);
            if (this.curToken == n || this.curToken == -1) break;
            if (this.nesting == 0 && this.curToken == 10) {
                return expression;
            }
            if (this.curToken != 44) {
                return this.syntaxError(n == 41 ? "expected ')'" : "confused by syntax error");
            }
            this.getRawToken();
        }
        return expression;
    }

    Expression parseTypeSwitch() throws IOException, SyntaxException {
        Object[] objectArray;
        Object object2;
        Expression expression;
        Object object3;
        char c = this.pushNesting('t');
        this.getRawToken();
        Expression expression2 = this.parseExpr();
        if (this.curToken != 41) {
            return this.syntaxError("missing ')' after 'typeswitch' selector");
        }
        this.getRawToken();
        Object var3_3 = null;
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(expression2);
        while (this.match("case")) {
            Expression expression3;
            this.pushNesting('c');
            this.getRawToken();
            object3 = "(arg)";
            if (this.curToken == 36) {
                object3 = this.parseVariable();
                if (object3 == null) {
                    return this.syntaxError("missing Variable after '$'");
                }
                this.getRawToken();
                if (this.match("as")) {
                    this.getRawToken();
                } else {
                    this.error('e', "missing 'as'");
                }
            }
            expression = this.parseDataType();
            this.popNesting('t');
            object2 = new LambdaExp(1);
            objectArray = ((ScopeExp)object2).addDeclaration(object3, (Type)((QuoteExp)expression).getValue());
            if (this.match("return")) {
                this.getRawToken();
            } else {
                this.error("missing 'return' after 'case'");
            }
            this.parser.push((ScopeExp)object2);
            this.pushNesting('r');
            ((LambdaExp)object2).body = expression3 = this.parseExpr();
            this.popNesting('t');
            this.parser.pop((ScopeExp)object2);
            vector.addElement(object2);
        }
        object3 = "(arg)";
        if (this.curToken == 36) {
            object3 = this.parseVariable();
            if (object3 == null) {
                return this.syntaxError("missing Variable after '$'");
            }
            this.getRawToken();
        }
        expression = new LambdaExp(0);
        object2 = expression.addDeclaration(object3, Type.pointer_type);
        if (this.match("default")) {
            this.getRawToken();
            if (this.match("return")) {
                this.getRawToken();
            } else {
                this.error("missing 'return' after 'default'");
            }
            this.parser.push((ScopeExp)expression);
            expression.body = objectArray = this.parseExpr();
            this.parser.pop((ScopeExp)expression);
        } else {
            expression.body = QuoteExp.voidExp;
            this.error('w', "no 'default' clause in 'typeswitch'");
        }
        vector.addElement(expression);
        this.popNesting(c);
        objectArray = new Expression[vector.size()];
        vector.copyInto(objectArray);
        return new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.reflect.TypeSwitch", "typeSwitch"), (Expression[])objectArray);
    }

    char matchConstructorKeyword(int n) throws IOException, SyntaxException {
        if (this.curToken == 65) {
            int n2;
            if (this.match("element")) {
                n2 = 101;
            } else if (this.match("attribute")) {
                n2 = 97;
            } else if (this.match("document") && n == 123) {
                n2 = 100;
            } else if (this.match("text") && n == 123) {
                n2 = 116;
            } else {
                return '\u0000';
            }
            if (n != 123 && (n2 == 101 || n2 == 97)) {
                if (!XQParser.isNameStart((char)n)) {
                    return '\u0000';
                }
                this.unread();
                this.mark();
                this.getRawToken();
                this.getRawToken();
                if (this.curToken != 123) {
                    n2 = 0;
                }
                this.reset();
                this.read();
            }
            return (char)n2;
        }
        return '\u0000';
    }

    Expression parseMaybePrimaryExpr() throws IOException, SyntaxException {
        Expression expression;
        int n = this.getLineNumber() + 1;
        int n2 = this.getColumnNumber() + 1;
        int n3 = this.peekOperand();
        if (n3 == 40) {
            this.getRawToken();
            char c = this.pushNesting('(');
            expression = this.parseExprSequence(41);
            this.popNesting(c);
            if (this.curToken == -1) {
                this.eofError("missing ')' - unexpected end-of-file");
            }
        } else if (n3 == 412) {
            --n2;
            this.getRawToken();
            if (this.curToken == 47) {
                this.getRawToken();
                String string = this.curToken == 65 || this.curToken == 81 || this.curToken == 67 ? "saw end tag '</" + new String(this.tokenBuffer, 0, this.tokenBufferLength) + ">' not in an element constructor" : "saw end tag '</' not in an element constructor";
                Expression expression2 = this.syntaxError(string);
                while (this.curToken != 413 && this.curToken != -1 && this.curToken != 10) {
                    this.getRawToken();
                }
                return expression2;
            }
            char c = this.pushNesting('<');
            expression = this.parseElementConstructor();
            expression.setFile(this.getName());
            expression.setLine(n, n2);
            this.popNesting(c);
        } else if (n3 == 34) {
            expression = new QuoteExp(new String(this.tokenBuffer, 0, this.tokenBufferLength).intern());
        } else if (n3 == 48) {
            IntNum intNum = IntNum.valueOf(this.tokenBuffer, 0, this.tokenBufferLength, 10, false);
            expression = new QuoteExp(intNum);
        } else if (n3 == 49) {
            DFloNum dFloNum = new DFloNum(new String(this.tokenBuffer, 0, this.tokenBufferLength));
            expression = new QuoteExp(dFloNum);
        } else if (n3 == 36) {
            Symbol symbol = this.parseVariable();
            if (symbol == null) {
                return this.syntaxError("missing Variable");
            }
            Declaration declaration = this.parser.lookup(symbol, -1);
            expression = null;
            if (declaration == null && this.prevPrefix == null) {
                String string = symbol.getName();
                if ("request".equals(string)) {
                    expression = XQParser.makeFunctionExp("gnu.kawa.servlet.GetRequest", "getRequest");
                }
                if ("response".equals(string)) {
                    expression = XQParser.makeFunctionExp("gnu.kawa.servlet.GetResponse", "getResponse");
                }
                if (expression != null) {
                    expression = new ApplyExp(expression, Expression.noExpressions);
                }
            }
            if (expression == null) {
                expression = new ReferenceExp(symbol, declaration);
            }
        } else if (n3 == 70) {
            Object object2;
            Object[] objectArray;
            String string;
            String string2;
            Object object3;
            int n4 = this.tokenBufferLength;
            while (--n4 >= 0 && this.tokenBuffer[n4] != ':') {
            }
            if (n4 >= 0) {
                object3 = new String(this.tokenBuffer, 0, n4);
                string2 = new String(this.tokenBuffer, ++n4, this.tokenBufferLength - n4);
                string = (String)this.namespaces.get(object3);
                if (string == null) {
                    try {
                        Class<?> clazz = Class.forName((String)object3);
                        string = "class:" + (String)object3;
                    }
                    catch (Exception exception) {
                        this.syntaxError("unknown namespace '" + (String)object3 + "'");
                        string = this.defaultFunctionNamespace;
                    }
                }
            } else {
                string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                if (string2.equals("typeswitch")) {
                    return this.parseTypeSwitch();
                }
                string = this.defaultFunctionNamespace;
            }
            object3 = Symbol.make(string, string2);
            n2 -= this.tokenBufferLength;
            char c = this.pushNesting('(');
            this.getRawToken();
            Vector<Object[]> vector = new Vector<Object[]>(10);
            if (this.curToken != 41) {
                while (true) {
                    objectArray = this.parseExpr();
                    vector.addElement(objectArray);
                    if (this.curToken == 41) break;
                    if (this.curToken != 44) {
                        return this.syntaxError("missing ')' after function call");
                    }
                    this.getRawToken();
                }
            }
            objectArray = new Expression[vector.size()];
            String string3 = null;
            if (object3 instanceof Symbol) {
                object2 = (Symbol)object3;
                String string4 = ((Symbol)object2).getLocalName();
                if (((Symbol)object2).getNamespaceURI() == "http://www.w3.org/2003/05/xpath-functions") {
                    if (string4 == "position") {
                        ++this.seenPosition;
                        string3 = POSITION_VARNAME;
                    }
                    if (string4 == "last") {
                        ++this.seenLast;
                        string3 = LAST_VARNAME;
                    }
                }
            }
            if (string3 != null) {
                if (objectArray.length != 0) {
                    this.error("arguments in call to " + object3);
                }
                if ((object2 = this.parser.lookup(string3, -1)) == null) {
                    this.error("undefined context for " + object3);
                }
                expression = new ReferenceExp(string3, (Declaration)object2);
            } else {
                vector.copyInto(objectArray);
                object2 = new ReferenceExp(object3, null);
                ((ReferenceExp)object2).setProcedureName(true);
                expression = new ApplyExp((Expression)object2, (Expression[])objectArray);
            }
            expression.setFile(this.getName());
            expression.setLine(n, n2);
            this.popNesting(c);
        } else {
            if (n3 == 65 || n3 == 81) {
                int n5 = this.skipSpace(this.nesting != 0);
                if (n5 == 36) {
                    Expression expression3;
                    if (this.match("let")) {
                        expression3 = this.parseFLWRExpression(false);
                    } else if (this.match("for")) {
                        expression3 = this.parseFLWRExpression(true);
                    } else if (this.match("some")) {
                        expression3 = this.parseQuantifiedExpr(false);
                    } else if (this.match("every")) {
                        expression3 = this.parseQuantifiedExpr(true);
                    } else {
                        return this.syntaxError("invalid syntax - variable following name");
                    }
                    expression3.setFile(this.getName());
                    expression3.setLine(n, n2 - 3);
                    return expression3;
                }
                char c = this.matchConstructorKeyword(n5);
                if (c != '\u0000') {
                    Expression expression4;
                    if (n5 >= 0) {
                        this.unread();
                    }
                    this.getRawToken();
                    Vector<Expression> vector = new Vector<Expression>();
                    if (c == 'e' || c == 'a') {
                        Expression expression5 = this.parseNameSpec(this.defaultElementNamespace, c == 'a');
                        if (expression5 == null) {
                            return this.syntaxError("missing element/attribute name");
                        }
                        vector.addElement(expression5);
                        expression4 = c == 'e' ? XQParser.makeFunctionExp("gnu.xquery.util.MakeElement", "makeElement") : XQParser.makeFunctionExp("gnu.xquery.util.MakeAttribute", "makeAttribute");
                        this.getRawToken();
                    } else {
                        expression4 = c == 'd' ? XQParser.makeFunctionExp("gnu.kawa.xml.DocumentConstructor", "documentConstructor") : XQParser.makeFunctionExp("gnu.kawa.xml.TextConstructor", "textConstructor");
                    }
                    char c2 = this.pushNesting('{');
                    this.peekNonSpace("unexpected end-of-file after '{'");
                    if (this.curToken != 123) {
                        return this.syntaxError("missing '{'");
                    }
                    this.getRawToken();
                    if (this.curToken != 125) {
                        vector.addElement(this.parseExpr());
                        while (this.curToken == 44) {
                            this.getRawToken();
                            vector.addElement(this.parseExpr());
                        }
                    }
                    this.popNesting(c2);
                    if (this.curToken != 125) {
                        return this.syntaxError("missing '}'");
                    }
                    Object[] objectArray = new Expression[vector.size()];
                    vector.copyInto(objectArray);
                    ApplyExp applyExp = new ApplyExp(expression4, (Expression[])objectArray);
                    applyExp.setFile(this.getName());
                    applyExp.setLine(n, n2);
                    this.getRawToken();
                    return applyExp;
                }
                if (n5 == 40 && this.tokenBufferLength == 2 && this.tokenBuffer[0] == 'i' && this.tokenBuffer[1] == 'f') {
                    return this.parseIfExpr();
                }
                if (n5 >= 0) {
                    this.unread();
                }
                return this.parseNodeTest(-1);
            }
            if (n3 == 424 || n3 == 67 || n3 == 64 || n3 == 231 || n3 == 232) {
                return this.parseNodeTest(-1);
            }
            return null;
        }
        int n6 = this.curToken;
        this.getRawToken();
        return expression;
    }

    public Expression parseIfExpr() throws IOException, SyntaxException {
        this.getRawToken();
        char c = this.pushNesting('i');
        Expression expression = this.parseExpr();
        if (this.curToken != 41) {
            return this.syntaxError("missing ')' after 'if (EXPR'");
        }
        this.getRawToken();
        if (this.curToken != 65 || this.tokenBufferLength != 4 || !new String(this.tokenBuffer, 0, 4).equalsIgnoreCase("then")) {
            this.syntaxError("missing 'then'");
        } else {
            this.getRawToken();
        }
        Expression expression2 = this.parseExpr();
        if (this.curToken != 65 || this.tokenBufferLength != 4 || !new String(this.tokenBuffer, 0, 4).equalsIgnoreCase("else")) {
            this.syntaxError("missing 'else'");
        } else {
            this.getRawToken();
        }
        this.popNesting(c);
        Expression expression3 = this.parseExpr();
        return new IfExp(XQParser.booleanValue(expression), expression2, expression3);
    }

    public boolean match(String string) {
        if (this.curToken != 65) {
            return false;
        }
        int n = string.length();
        if (this.tokenBufferLength != n) {
            return false;
        }
        int n2 = n;
        while (--n2 >= 0) {
            char c;
            char c2 = string.charAt(n2);
            if (c2 == (c = this.tokenBuffer[n2])) continue;
            return false;
        }
        return true;
    }

    public Symbol resolveQName(String string) throws IOException, SyntaxException {
        String string2;
        String string3;
        this.prevPrefix = null;
        if (this.curToken == 81) {
            String string4;
            int n = this.tokenBufferLength;
            while (this.tokenBuffer[--n] != ':') {
            }
            this.prevPrefix = string4 = new String(this.tokenBuffer, 0, n);
            string3 = new String(this.tokenBuffer, ++n, this.tokenBufferLength - n);
            string2 = (String)this.namespaces.get(string4);
            if (string2 == null) {
                this.syntaxError("unknown namespace '" + string4 + "'");
            }
        } else if (this.curToken == 65) {
            string3 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            string2 = string;
        } else {
            return null;
        }
        return Symbol.make(string2, string3);
    }

    public Symbol parseVariable() throws IOException, SyntaxException {
        if (this.curToken == 36) {
            this.getRawToken();
        } else {
            this.syntaxError("missing '$' before variable name");
        }
        return this.resolveQName("");
    }

    public Expression parseFLWRExpression(boolean bl) throws IOException, SyntaxException {
        Expression expression;
        ScopeExp scopeExp;
        Object object2;
        char c = this.pushNesting(bl ? (char)'f' : 'l');
        this.curToken = 36;
        Symbol symbol = this.parseVariable();
        if (symbol == null) {
            return this.syntaxError("missing Variable token:" + this.curToken);
        }
        this.getRawToken();
        Expression expression2 = this.parseOptionalTypeDeclaration();
        Expression[] expressionArray = new Expression[1];
        Symbol symbol2 = null;
        if (bl) {
            boolean bl2 = this.match("at");
            object2 = new LambdaExp(bl2 ? 2 : 1);
            if (bl2) {
                this.getRawToken();
                if (this.curToken == 36) {
                    symbol2 = this.parseVariable();
                    this.getRawToken();
                }
                if (symbol2 == null) {
                    this.syntaxError("missing Variable");
                }
            }
            scopeExp = object2;
            if (this.match("in")) {
                this.getRawToken();
            } else {
                if (this.curToken == 76) {
                    this.getRawToken();
                }
                this.syntaxError("missing 'in' in 'for' clause");
            }
        } else {
            if (this.curToken == 76) {
                this.getRawToken();
            } else {
                if (this.match("in")) {
                    this.getRawToken();
                }
                this.syntaxError("missing ':=' in 'let' clause");
            }
            LetExp letExp = new LetExp(expressionArray);
            scopeExp = letExp;
        }
        expressionArray[0] = this.parseExprSingle();
        this.popNesting(c);
        Declaration declaration = scopeExp.addDeclaration(symbol);
        this.setType(declaration, expression2);
        if (bl) {
            declaration.noteValue(null);
            declaration.setFlag(262144);
        }
        if (symbol2 != null) {
            object2 = scopeExp.addDeclaration(symbol2, Type.int_type);
            ((Declaration)object2).noteValue(null);
            ((Declaration)object2).setFlag(262144);
        }
        this.parser.push(scopeExp);
        if (this.curToken == 44) {
            this.getRawToken();
            if (this.curToken != 36) {
                return this.syntaxError("missing $NAME after ','");
            }
            object2 = this.parseFLWRExpression(bl);
        } else if (this.match("for")) {
            this.getRawToken();
            if (this.curToken != 36) {
                return this.syntaxError("missing $NAME after 'for'");
            }
            object2 = this.parseFLWRExpression(true);
        } else if (this.match("let")) {
            this.getRawToken();
            if (this.curToken != 36) {
                return this.syntaxError("missing $NAME after 'let'");
            }
            object2 = this.parseFLWRExpression(false);
        } else {
            char c2 = this.pushNesting('w');
            if (this.curToken == 196) {
                this.getRawToken();
                expression = this.parseExprSingle();
            } else {
                expression = this.match("where") ? this.parseExprSingle() : null;
            }
            this.popNesting(c2);
            boolean bl3 = this.match("stable");
            if (bl3) {
                this.getRawToken();
            }
            if (this.match("order")) {
                return this.syntaxError("'order by' clause not implemented yet");
            }
            boolean bl4 = this.match("return");
            if (!(bl4 || this.match("let") || this.match("for"))) {
                return this.syntaxError("missing 'return' clause tok:" + this.curToken + " str: '" + new String(this.tokenBuffer, 0, this.tokenBufferLength) + "'");
            }
            this.peekNonSpace("unexpected eof-of-file after 'return'");
            int n = this.getLineNumber() + 1;
            int n2 = this.getColumnNumber() + 1;
            if (bl4) {
                this.getRawToken();
            }
            object2 = this.parseExprSingle();
            if (expression != null) {
                object2 = new IfExp(XQParser.booleanValue(expression), (Expression)object2, QuoteExp.voidExp);
            }
            ((Expression)object2).setFile(this.getName());
            ((Expression)object2).setLine(n, n2);
        }
        this.parser.pop(scopeExp);
        if (bl) {
            expression = (LambdaExp)scopeExp;
            expression.body = object2;
            Expression[] expressionArray2 = new Expression[]{scopeExp, expressionArray[0]};
            return new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.functions.ValuesMap", expression.min_args == 1 ? "valuesMap" : "valuesMapWithPos"), expressionArray2);
        }
        ((LetExp)scopeExp).setBody((Expression)object2);
        return scopeExp;
    }

    public Expression parseQuantifiedExpr(boolean bl) throws IOException, SyntaxException {
        Expression expression;
        char c = this.pushNesting(bl ? (char)'e' : 's');
        this.curToken = 36;
        Symbol symbol = this.parseVariable();
        if (symbol == null) {
            return this.syntaxError("missing Variable token:" + this.curToken);
        }
        this.getRawToken();
        LambdaExp lambdaExp = new LambdaExp(1);
        Declaration declaration = lambdaExp.addDeclaration(symbol);
        declaration.noteValue(null);
        declaration.setFlag(262144);
        this.setType(declaration, this.parseOptionalTypeDeclaration());
        if (this.match("in")) {
            this.getRawToken();
        } else {
            if (this.curToken == 76) {
                this.getRawToken();
            }
            this.syntaxError("missing 'in' in QuantifiedExpr");
        }
        Expression[] expressionArray = new Expression[]{this.parseExprSingle()};
        this.popNesting(c);
        this.parser.push(lambdaExp);
        if (this.curToken == 44) {
            this.getRawToken();
            if (this.curToken != 36) {
                return this.syntaxError("missing $NAME after ','");
            }
            expression = this.parseQuantifiedExpr(bl);
        } else {
            boolean bl2 = this.match("satisfies");
            if (!(bl2 || this.match("every") || this.match("some"))) {
                return this.syntaxError("missing 'satisfies' clause");
            }
            this.peekNonSpace("unexpected eof-of-file after 'satisfies'");
            int n = this.getLineNumber() + 1;
            int n2 = this.getColumnNumber() + 1;
            if (bl2) {
                this.getRawToken();
            }
            expression = this.parseExprSingle();
            expression.setFile(this.getName());
            expression.setLine(n, n2);
        }
        this.parser.pop(lambdaExp);
        lambdaExp.body = expression;
        Expression[] expressionArray2 = new Expression[]{lambdaExp, expressionArray[0]};
        return new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.util.ValuesEvery", bl ? "every" : "some"), expressionArray2);
    }

    public Expression parseFunctionDefinition(int n, int n2) throws IOException, SyntaxException {
        Object object2;
        Object object3;
        Symbol symbol = this.resolveQName(this.defaultFunctionNamespace);
        if (symbol == null) {
            return this.syntaxError("missing function name");
        }
        boolean bl = "local".equals(this.prevPrefix);
        this.getRawToken();
        if (this.curToken != 40) {
            return this.syntaxError("missing parameter list:" + this.curToken);
        }
        this.getRawToken();
        LambdaExp lambdaExp = new LambdaExp();
        lambdaExp.setFile(this.getName());
        lambdaExp.setLine(n, n2);
        lambdaExp.setName(symbol);
        Declaration declaration = this.parser.currentScope().addDeclaration(symbol);
        if (bl && !this.parser.immediate) {
            declaration.setFlag(262144);
            declaration.setPrivate(true);
        }
        if (this.parser.getModule().isStatic()) {
            declaration.setFlag(2048);
        }
        this.parser.push(declaration);
        declaration.setCanRead(true);
        declaration.setProcedureDecl(true);
        declaration.setFile(this.getName());
        declaration.setLine(n, n2);
        this.parser.push(lambdaExp);
        if (this.curToken != 41) {
            while (true) {
                if ((object3 = this.parseVariable()) == null) {
                    this.error("missing parameter name");
                } else {
                    object2 = lambdaExp.addDeclaration(object3);
                    this.parser.push((Declaration)object2);
                    this.getRawToken();
                    ++lambdaExp.min_args;
                    ++lambdaExp.max_args;
                    this.setType((Declaration)object2, this.parseOptionalTypeDeclaration());
                }
                if (this.curToken == 41) break;
                if (this.curToken != 44) {
                    return this.syntaxError("missing ',' in parameter list");
                }
                this.getRawToken();
            }
        }
        this.getRawToken();
        object3 = this.parseOptionalTypeDeclaration();
        lambdaExp.body = this.parseEnclosedExpr();
        this.parser.pop(lambdaExp);
        if (object3 != null) {
            Convert.setCoercedReturnValue(lambdaExp, (Expression)object3, this.interpreter);
        }
        object2 = new SetExp(symbol, (Expression)lambdaExp);
        ((SetExp)object2).setDefining(true);
        ((SetExp)object2).binding = declaration;
        declaration.noteValue(lambdaExp);
        return object2;
    }

    public Object readObject() throws IOException, SyntaxException {
        return this.parse(null);
    }

    void parseSeparator() throws IOException, SyntaxException {
        int n = this.skipSpace(this.nesting != 0);
        if (n == 59) {
            return;
        }
        if (warnOldVersion && n != 10) {
            this.error('w', "missing ';' after declaration");
        }
        if (n >= 0) {
            this.unread(n);
        }
    }

    public Expression parse(Compilation compilation) throws IOException, SyntaxException {
        int n;
        int n2;
        this.parser = compilation;
        int n3 = this.skipSpace();
        if (n3 < 0) {
            return null;
        }
        this.unread(n3);
        int n4 = this.getLineNumber() + 1;
        int n5 = this.getColumnNumber() + 1;
        if (n3 == 35 && n4 == 1 && n5 == 1) {
            this.read();
            n3 = this.read();
            if (n3 != 33 || (n3 = this.read()) != 47) {
                this.error("'#' is only allowed in initial '#!/PROGRAM'");
            }
            while (n3 != 13 && n3 != 10 && n3 >= 0) {
                n3 = this.read();
            }
        }
        if (this.getRawToken() == -1) {
            return null;
        }
        this.peekOperand();
        if (this.curToken == 87) {
            int n6 = this.getLineNumber() + 1;
            int n7 = this.getColumnNumber() + 1;
            int n8 = this.peekNonSpace("unexpected end-of-file after 'define QName'");
            if (n8 == 40) {
                this.syntaxError("'missing 'function' after 'define'");
                this.curToken = 65;
                return this.parseFunctionDefinition(n6, n7);
            }
            return this.syntaxError("missing keyword after 'define'");
        }
        if (this.curToken == 80) {
            int n9 = this.getLineNumber() + 1;
            int n10 = this.getColumnNumber() + 1;
            this.getRawToken();
            this.peekNonSpace("unexpected end-of-file after 'define function'");
            char c = this.pushNesting('d');
            Expression expression = this.parseFunctionDefinition(n9, n10);
            this.popNesting(c);
            this.parseSeparator();
            expression.setFile(this.getName());
            expression.setLine(n4, n5);
            return expression;
        }
        if (this.curToken == 86) {
            Expression expression;
            this.getRawToken();
            Symbol symbol = this.parseVariable();
            if (symbol == null) {
                return this.syntaxError("missing Variable");
            }
            this.getRawToken();
            Expression expression2 = this.parseOptionalTypeDeclaration();
            Declaration declaration = compilation.currentScope().addDeclaration(symbol);
            compilation.push(declaration);
            if ("local".equals(this.prevPrefix)) {
                declaration.setFlag(262144);
                declaration.setPrivate(true);
            } else {
                declaration.setCanRead(true);
            }
            declaration.setFlag(16384);
            Expression expression3 = null;
            boolean bl = false;
            if (this.curToken == 408 || this.curToken == 76) {
                this.error("declare variable should not use '=' or ':=' - skipped");
                this.getRawToken();
                bl = true;
            }
            if (this.curToken == 123) {
                expression3 = this.parseEnclosedExpr();
                this.parseSeparator();
            } else if (this.match("external")) {
                this.error("external variables not implemented yet");
            } else {
                expression3 = this.parseMaybePrimaryExpr();
                expression = null;
                if (!bl || expression3 == null) {
                    expression = this.syntaxError("expected {expression} or external");
                }
                if (expression3 == null) {
                    expression3 = expression;
                }
            }
            expression = new SetExp(declaration, expression3);
            expression.setDefining(true);
            declaration.noteValue(expression3);
            return expression;
        }
        if (this.curToken == 65 && "namespace".equals((String)this.curValue)) {
            if (warnOldVersion) {
                this.error('w', "use 'declare namespace' instead of 'namespace'");
            }
            this.curToken = 78;
        }
        if (this.curToken == 78 || this.curToken == 77) {
            n2 = this.curToken;
            n = this.skipSpace(this.nesting != 0);
            if (n >= 0) {
                this.unread();
                if (XQParser.isNameStart((char)n)) {
                    this.getRawToken();
                    if (this.curToken != 65) {
                        return this.syntaxError("missing namespace prefix");
                    }
                    String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    this.getRawToken();
                    if (this.curToken != 408) {
                        return this.syntaxError("missing '=' in namespace declaration");
                    }
                    this.getRawToken();
                    if (this.curToken != 34) {
                        return this.syntaxError("missing uri in namespace declaration");
                    }
                    String string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    this.namespaces.put(string, string2);
                    this.parseSeparator();
                    if (n2 == 77) {
                        compilation.getModule().setName(Compilation.mangleURI(string2));
                    }
                    return QuoteExp.voidExp;
                }
            }
        }
        if (this.curToken == 84) {
            return this.syntaxError("'import schema' not implemented");
        }
        if (this.curToken == 73) {
            Object object2;
            this.getRawToken();
            String string = null;
            if (this.match("namespace")) {
                this.getRawToken();
                if (this.curToken != 65) {
                    return this.syntaxError("missing namespace prefix");
                }
                string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                this.getRawToken();
                if (this.curToken != 408) {
                    return this.syntaxError("missing '=' in namespace declaration");
                }
                this.getRawToken();
            }
            if (this.curToken != 34) {
                return this.syntaxError("missing uri in namespace declaration");
            }
            String string3 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            if (string != null) {
                this.namespaces.put(string, string3);
            }
            this.getRawToken();
            if (this.match("at")) {
                this.getRawToken();
                if (this.curToken != 34) {
                    return this.syntaxError("missing module location");
                }
                object2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                this.parseSeparator();
            } else if (this.curToken != 59) {
                this.parseSeparator();
            }
            object2 = compilation.getModule();
            Vector vector = new Vector();
            ClassType classType = ClassType.make(Compilation.mangleURI(string3));
            require.importDefinitions(classType, string3, vector, (ScopeExp)object2, compilation);
            Expression[] expressionArray = new Expression[vector.size()];
            vector.toArray(expressionArray);
            return BeginExp.canonicalize(expressionArray);
        }
        if ((this.curToken == 69 || this.curToken == 79 || this.curToken == 65 && "default".equals((String)this.curValue)) && (n2 = this.skipSpace(this.nesting != 0)) >= 0) {
            this.unread();
            if (XQParser.isNameStart((char)n2)) {
                int n11 = n = this.curToken == 79 ? 1 : 0;
                if (this.curToken == 65 && warnOldVersion) {
                    this.error('w', "use 'default element namespace' instead of 'default namespace'");
                }
                this.getRawToken();
                this.curValue = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                if (this.curToken != 65 || !"namespace".equalsIgnoreCase((String)this.curValue)) {
                    return this.syntaxError("expected 'namespace' after 'default'");
                }
                this.getRawToken();
                if (this.curToken != 408) {
                    return this.syntaxError("missing '=' in namespace declaration");
                }
                this.getRawToken();
                if (this.curToken != 34) {
                    return this.syntaxError("missing uri namespace declaration");
                }
                String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                if (n != 0) {
                    this.defaultFunctionNamespace = string;
                } else {
                    this.defaultElementNamespace = string;
                }
                return QuoteExp.voidExp;
            }
        }
        if (this.curToken == 83) {
            this.getRawToken();
            if (this.curToken == 408) {
                if (warnOldVersion) {
                    this.error('w', "obsolate '=' in xmlspace declaration");
                }
                this.getRawToken();
            }
            if (this.match("preserve")) {
                this.preserveBoundarySpace = true;
            } else if (this.match("skip")) {
                this.preserveBoundarySpace = false;
            } else {
                return this.syntaxError("xmlspace declaration must be preserve or strip");
            }
            this.parseSeparator();
            return QuoteExp.voidExp;
        }
        Expression expression = this.parseExprSequence(-1);
        if (this.curToken == 10) {
            this.unread(10);
        }
        expression.setFile(this.getName());
        expression.setLine(n4, n5);
        return expression;
    }

    public static Expression makeFunctionExp(String string, String string2) {
        return XQParser.makeFunctionExp(string, Compilation.mangleNameIfNeeded(string2), string2);
    }

    public static Expression makeFunctionExp(String string, String string2, String string3) {
        try {
            Class<?> clazz = Class.forName(string);
            Field field = clazz.getDeclaredField(string2);
            Procedure procedure = (Procedure)field.get(null);
            ClassType classType = ClassType.make(string);
            gnu.bytecode.Field field2 = classType.getDeclaredField(string2);
            Declaration declaration = new Declaration((Object)string3, field2);
            declaration.noteValue(new QuoteExp(procedure));
            declaration.setFlag(16384);
            return new ReferenceExp(string3, declaration);
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
    }

    public void error(String string) {
        super.error(string);
    }

    public Expression syntaxError(String string) throws IOException, SyntaxException {
        return this.syntaxError(string, this.tokenWidth());
    }

    String tokenString() {
        switch (this.curToken) {
            case 65: 
            case 81: {
                return new String(this.tokenBuffer, 0, this.tokenBufferLength);
            }
            case -1: {
                return "<EOF>";
            }
        }
        return Integer.toString(this.curToken);
    }

    private int tokenWidth() {
        switch (this.curToken) {
            case -1: {
                return 0;
            }
            case 48: 
            case 49: 
            case 65: 
            case 81: {
                return this.tokenBufferLength;
            }
        }
        return 1;
    }

    public Expression syntaxError(String string, int n) throws IOException, SyntaxException {
        int n2 = this.port.getLineNumber();
        int n3 = this.port.getColumnNumber();
        this.error('e', this.port.getName(), n2 + 1, n3 < 0 ? 0 : n3 + 1 - n, string);
        if (this.interactive) {
            int n4;
            this.curToken = 0;
            this.curValue = null;
            this.nesting = 0;
            ((InPort)this.getPort()).readState = (char)10;
            while ((n4 = this.read()) >= 0) {
                if (n4 != 13 && n4 != 10) continue;
                this.unread(n4);
                break;
            }
            throw new SyntaxException(this.getMessages());
        }
        return new ErrorExp(string);
    }

    static {
        instanceOf = new InstanceOf(XQuery.getInstance(), "instance");
        xqlReadTable = ReadTable.getInitial();
        axisNames = new String[13];
        XQParser.axisNames[0] = "ancestor";
        XQParser.axisNames[1] = "ancestor-or-self";
        XQParser.axisNames[2] = "attribute";
        XQParser.axisNames[3] = "child";
        XQParser.axisNames[4] = "descendant";
        XQParser.axisNames[5] = "descendant-or-self";
        XQParser.axisNames[6] = "following";
        XQParser.axisNames[7] = "following-sibling";
        XQParser.axisNames[8] = "namespace";
        XQParser.axisNames[9] = "parent";
        XQParser.axisNames[10] = "preceding";
        XQParser.axisNames[11] = "preceding-sibling";
        XQParser.axisNames[12] = "self";
        funcForwardFilter = XQParser.makeFunctionExp("gnu.xquery.util.ValuesFilter", "forwardFilter");
        funcReverseFilter = XQParser.makeFunctionExp("gnu.xquery.util.ValuesFilter", "reverseFilter");
        funcExprFilter = XQParser.makeFunctionExp("gnu.xquery.util.ValuesFilter", "exprFilter");
        textNodeTest = new NodeType("text", 1);
        anyNodeTest = new NodeType("node");
    }
}

