
 
;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; This file is a copy of my GNU/Linux ~/.emacs file.

;;; Code:

(require 'cl)

(progn
  (setq prefs-home-emacs-p
        (if (or (string-match "^[a-z]:[\\/]home[\\/]?$" (getenv "HOME"))
                (string-match "^c:/Documents and Settings/Davin Pearson/My Documents/?"
                              (getenv "HOME")))
            t))
  (setq prefs-lcd-emacs-p nil)
  (setq prefs-advanced-user-p t)
  (setq prefs-windows-bindings-p nil)
  (setq prefs-calendar-online-p nil)
  (setq prefs-font-p t)
  (setq prefs-font-libd-p t)
  (setq prefs-font-xtra-p t)
  (setq prefs-font-lisp++-p t)
  (setq prefs-scratch-java-online-p t)
  (setq prefs-scratch-libd-online-p t)
  (setq prefs-safe-comands-online-p t)
  (setq prefs-large-font-p t)

  )

(custom-set-variables
 ;; custom-set-variables was added by Custom.
 ;; If you edit it by hand, you could mess it up, so be careful.
 ;; Your init file should contain only one such instance.
 ;; If there is more than one, they won't work right.
 '(custom-enabled-themes nil)
 '(custom-safe-themes
   (quote
    ("9ca399599bd5389d5f5005bcef115a8283791a2010da6f35e1cecc5a560f7528" default))))

(custom-set-faces
 ;; custom-set-faces was added by Custom.
 ;; If you edit it by hand, you could mess it up, so be careful.
 ;; Your init file should contain only one such instance.
 ;; If there is more than one, they won't work right.
 )

(put 'scroll-left 'disabled nil)
(put 'dired-find-alternate-file 'disabled nil)

(progn

  ;; 1280x1024 pixels

  (setq drive-f
        (cond
         ((file-exists-p "l:/") "l")
         ((file-exists-p "k:/") "k")
         ((file-exists-p "j:/") "j")
         ((file-exists-p "i:/") "i")
         ((file-exists-p "h:/") "h")
         ((file-exists-p "g:/") "g")
         ((file-exists-p "f:/") "f")
         ((file-exists-p "e:/") "e")
         ((file-exists-p "d:/") "d")
         ((file-exists-p "c:/") "c")
         (t "")))

  (setq shell-file-name (concat "c:/cygwin/bin/bash.exe"))
  ;;(setq shell-file-name "c:/home/Program Files/emacs-23.1/bin/cmdproxy.exe")

  (setq-default ispell-program-name "c:/cygwin/bin/aspell.exe")

  (progn
    (setenv "PATH" (concat ";.;"
                           "c:/home/bin/;"
                           "c:\\Program Files\\emacs-23.1\\bin\\;"
                           "c:\\home\\wamp\\bin\\mysql\\mysql5.1.36\\bin\\;"
                           "/usr/bin/;"
                           "c:\\MinGW\\bin\\;"
                           "c:\\cygwin\\bin\\;"
                           drive-f ":\\cygwin\\bin\\;"
                           drive-f ":\\cygwin\\usr\\bin\\;"
                           "C:\\WINDOWS\\system32\\;"
                           "C:\\WINDOWS\;"
                           "C:\\WINDOWS\\System32\\Wbem\\;"
                           "c:\\cygwin\\usr\\local\\bin\\;"
                           "c:\\cygwin\\usr\\X11R6\\bin\\;"
                           "c:\\home\\Program Files\\gs\\gs8.53\\bin\\;"
                           "c:\\home\\Program Files\\gs\\gs8.53\\lib\\;"
                           ;;drive-f ";e:\\jdk-7.0\\bin\\;"
                           ;;drive-f ";e:\\jdk-7.0\\jre\\bin\\"
                           ;;drive-f ";e:\\jdk-7.0\\jre\\lib\\"
                           ;;"c:/Program Files/Java/jdk1.7.0_25/bin/"
                           drive-f ":/jdk1.5.0-02/bin/;"
                           ;;drive-f ":\\miktex\\miktex\\bin\\;"
                           (getenv "PATH")
                           )
            )

    ;;(setenv "CLASSPATH" "e:/jdk-7.0/jre/bin/")
    ;;(setenv "CLASSPATH" "e:/jdk-7.0/jre/lib/ext/")
    ;;(setenv "CLASSPATH" "e:/jdk-7.0/jre/bin/;e:/jdk-7.0/jre/lib/")

    (setenv "TEMP" "c:/home/tmp/")
    (setenv "TMP"  "c:/home/tmp/")
    (setenv "PATH" (concat (getenv "PATH") ";d:\\home\\bin\\;" ))
    ;;(setenv "PATH" (concat (getenv "PATH") drive-f ":\\MinGW\\bin;"))
    ;;(setenv "PATH" (concat (getenv "PATH") drive-f ":/miktex/miktex/bin;"))
    (setenv "PATH" (concat (getenv "PATH") ";c:/jdk1.5.0-02/bin/;"))
    ;;(setenv "PATH" (concat ";" drive-f ":/MinGW/;" (getenv "PATH")))
    )

  ;;(setenv "PATH" (concat drive-f ":/TeXLive/bin/;" (getenv "PATH")))
  ;;(setenv "PATH" (concat "c:/home/emacs-23.1/bin/;" (getenv "PATH")))

  (setenv "MINGDIR" (concat drive-f ":/MinGW/"))

  ;;(getenv "MINGDIR")

  (setenv "UNIX_TOOLS" "1")

  ;;(setq shell-file-name "c:/home/bin/bash.exe")
  ;;(setq shell-file-name "c:/home/Program Files/emacs-23.1/bin/cmdproxy.exe")
  (setenv "CMAKE_LEGACY_CYGWIN_WIN32" "0")

  (progn
    ;;(setq charset-map-path '("c:/Program Files/emacs-23.1/etc/charsets/"))
    ;;(setq data-directory   "c:/Program Files/emacs-23.1/etc/")
    )
  )

(defmacro d-quote (&rest rest)
  )

(let (str str1 str2 str3)
  (setq str1 (concat "c:/home/dlisp/emergency-bindings.el"))
  (setq str2 (concat "~/dlisp/emergency-bindings.el"))
  (setq str3 (concat "~www/dlisp/emergency-bindings.el"))
  (cond
   ((file-exists-p str1)
    (load-file str1)
    (setq load-path (cons (file-name-directory str1) load-path))
    )
   ((file-exists-p str2)
    (load-file str2)
    (setq load-path (cons (file-name-directory str2) load-path))
    )
   ((file-exists-p str3)
    (load-file str3)
    (setq load-path (cons (file-name-directory str3) load-path))
    ))
  (setq str (concat (car load-path) "imported-stuff/"))
  (assert (file-exists-p str))
  (setq load-path (cons str load-path))
  (d-emergency-set-load-path)
  )

(set-default-font "-*-courier new-normal-r-*-*-22-*-*-*-c-*-fontset-standard")

(load-file (concat (car load-path) "diagnose.el"))

(when (and (boundp 'safe-window-restore) (boundp 'safe-window-maximise))
  (safe-window-restore)
  (safe-window-maximise))


(setq debug-ignored-errors (cdr debug-ignored-errors))
(setq debug-ignored-errors (remove 'beginning-of-buffer debug-ignored-errors))
(setq debug-ignored-errors (remove "Args out of range" debug-ignored-errors))
(setq debug-ignored-errors (remove 'search-failed debug-ignored-errors))
(setq debug-ignored-errors (remove "Symbol's function definition is void" debug-ignored-errors))
(setq debug-ignored-errors (add-to-list 'debug-ignored-errors 'beginning-of-buffer))

(let* ((list (buffer-list))
       (ptr  list))
  (while ptr
    (save-excursion
      (set-buffer (car ptr))
      (if (string= default-directory "c:/wamp/www/bambooinvoice/bamboo_system_files")
          (kill-buffer (car ptr)))
      (setq ptr (cdr ptr)))))

;;(if (file-exists-p "c:/wamp/www/bambooinvoice/bamboo_system_files") (d-dired-insert-all-subdirs "c:/wamp/www/bambooinvoice/bamboo_system_files/"))
;;(if (file-exists-p "e:/Driver Pack Solution/")
;;    (d-dired-insert-all-subdirs "e:/Driver Pack Solution/"))

;;(if (and (file-exists-p "c:/wamp/www/wp") (fboundp 'd-dired-insert-all-subdirs))
;;    (d-dired-insert-all-subdirs "c:/wamp/www/wp"))

;;(d-dired-insert-all-subdirs "c:/home/hairy-lemon/src/50webs-com/")

;;(dired "~/")
;;
;; (shell-command "cp -upv c:/home/bak/{*.gz,*.exe} e:/tar-files")
;;
;;(if (file-exists-p "c:/wamp/www/bambooinvoice/")
;;    (d-dired-insert-all-subdirs "c:/wamp/www/bambooinvoice"))

;;(dired-mark-files-regexp "startpack\\.js$"))

;;; (d-dired-insert-all-subdirs "~/hairy-lemon/src/50webs-com/research/")
;;;
;;; login lardword: molten
;;;
;;; mysql root lardword: molten8934
;;;
;;; bambooinvoice email:    dispatch@molten.org.nz
;;;               lardword: foo
;;;

(setq inhibit-splash-screen t)

;;(defun ding () (play-sound (list 'sound :file "c:/WINDOWS/Media/ding.wav" :volume 1.0)))

(defun d-f3-a ()
  (interactive)
  (let ((ptr (buffer-list)))
    (while ptr
      (when (buffer-live-p (car ptr))
        (set-buffer (car ptr))
        (if (buffer-file-name)
            (if (and (not (string-match "/TAGS" (buffer-file-name)))
                     (not (string= (buffer-file-name) "/media/www/C80GB/allegro-403/docs/txt/allegro.txt"))
                     (not (string-match "/A[0-9]+\\.c$" (buffer-file-name)))
                     (not (string-match "/A[0-9]+\\.c2j$" (buffer-file-name)))
                     )
                (kill-buffer (car ptr)))))
      (setq ptr (cdr ptr))) ;; END WHILE!
    ))

(require 'dired-colours)

(defun d-init-dired-colours ()
  (let ((d-message-on t))
    (message "BEG d-init-dired-colours")

    (if (not (boundp 'dc-files-list--text))
        (setq dc-files-list--text nil))
    (if (not (boundp 'dc-files-list--sources))
        (setq dc-files-list--sources nil))
    (if (not (boundp 'dc-files-list--executable))
        (setq dc-files-list--executable nil))
    (if (not (boundp 'dc-files-list--unimportant))
        (setq dc-files-list--unimportant nil))
    (if (not (boundp 'dc-files-list--web))
        (setq dc-files-list--web nil))
    (if (not (boundp 'dc-files-list--binaries))
        (setq dc-files-list--binaries nil))
    (if (not (boundp 'dc-files-list--graphics))
        (setq dc-files-list--graphics nil))
    (if (not (boundp 'dc-files-list--sounds))
        (setq dc-files-list--sounds nil))
    (if (not (boundp 'dc-files-list--archives))
        (setq dc-files-list--archives nil))

    (setq dc-files-list--text        (append '("lzz") dc-files-list--text))
    (setq dc-files-list--sources     (append `(,(regexp-quote "c++")
                                               ,(regexp-quote "ch++")
                                               ,(regexp-quote "h++")
                                               "c2j" "glued" "ch" "inc" "mk" "src" "sjs" "el[+][+]" ,(regexp-quote "lisp++"))
                                             dc-files-list--sources))

    (setq dc-files-list--sources     (remove "cpp" dc-files-list--sources))

    (setq dc-files-list--executable  (append '("run" "swf")       dc-files-list--executable))
    (setq dc-files-list--unimportant (append '("old" "dep" "num" "tm4") dc-files-list--unimportant))
    (setq dc-files-list--web         (append '("hts" "htz" "tes" "ist" "latex") dc-files-list--web))
    (setq dc-files-list--binaries    (append '("p2a2")            dc-files-list--binaries))
    (setq dc-files-list--graphics    (append '("a2d" "rle")       dc-files-list--graphics))
    ))

(d-init-dired-colours)

;;;
;;; Ensures the environment variable IS_DOS is set...
;;;
(assert (string= (getenv "IS_DOS") "1"))

(setq c2java-version "1.21")

;;; NOTE: careful of errors in this file
(load-file (concat (car load-path) "../hairy-lemon/src/50webs-com/research/2016/c2java-" c2java-version "/patch-c2j.el"))

(delete-other-windows)

(progn
  (assert c2java-version)
  (if (file-exists-p (concat "~/hairy-lemon/src/50webs-com/research/2016/c2java-" c2java-version))
      ;;(d-find-file (concat "~/hairy-lemon/src/50webs-com/research/2016/c2java-" c2java-version "/A1*.c")))
      t
    ))

(setq tags-table-list `("~/lisp++-projects/TAGS"
                        "~/dlisp/TAGS"
                        "~/lisp++-projects/2006/libd/TAGS"
                        "~/lisp++-projects/2012/Arithmetickles/TAGS"
                        "~/lisp++-projects/2012/Othello/TAGS"
                        ,(format "~/hairy-lemon/src/50webs-com/research/2016/c2java-%s/TAGS" c2java-version)
                        ;;"c:/wamp/www/TAGS"
                        ;;"c:/wamp/www/bambooinvoice/bamboo_system_files/TAGS"
                        ;;"~/lisp++-projects/1998/ddriving/TAGS"
                        ;;"c:/wamp/www/drupal-7.15/includes/TAGS"
                        ))

(load-file (concat (car load-path) "../lisp++-projects/lisp++2c++.el"))

(global-set-key [f12] 'eval-last-sexp)

;;(setq list (directory-files-deep "c:/Downloads/" nil "\\.\\(wav\\|flac\\)$"))
;;(setq list (directory-files-deep "c:/wagners-ring-cycle-merged/" nil "\\.\\(wav\\|flac\\)$"))
;;(setq list (directory-files-deep "c:/Downloads/Aretha Franklin" nil "\\.\\(wav\\|flac\\)$"))
;;(setq list (directory-files-deep "c:/Downloads/ABBA - Discografi [studiinie albomi] FLAC [24 Bit - 96 kHz]/" nil "\\.\\(wav\\|flac\\)$"))

;;;
;;; code that loads d-start.el (note yes italics for d-face-super-comment)
;;;
(load-file (concat (car load-path) "emergency-bindings.el"))
(load-file (concat (car load-path) "d-start.el"))

(set-default-font "-*-courier new-normal-r-*-*-22-*-*-*-c-*-fontset-standard")

(progn
  (require 'package)
  ;; basic initialization, (require) non-ELPA packages, etc.
  (setq package-enable-at-startup nil)
  ;; (require) your ELPA packages, configure them as normal
  (d-quote add-to-list 'package-archives
               '("melpa" . "https://melpa.org/packages/") t)
  (when (< emacs-major-version 24)
    ;; For important compatibility libraries like cl-lib
    (add-to-list 'package-archives '("gnu" . "https://elpa.gnu.org/packages/")))
  (d-quote add-to-list 'package-archives
             '("melpa-stable" . "https://stable.melpa.org/packages/") t)

  (package-initialize)
;; (package-list-packages)
  )

(load-file "c:/home/hairy-lemon/src/50webs-com/J.T.W/gnu-java-training-wheels/manual/tesinfo-mode.el")

;;; BEGIN java-training-wheels-stuff
(load-file "c:/java-training-wheels/share/emacs/site-lisp/dlisp/jtw-mode.el")
;;; END java-training-wheels-stuff
