
;;; d-math.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-math.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Math code
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defun pow (x y)
  (exp (* y (log x))))

;; (pow 2 (- 16 4)) = 4095 tiles


(defun fact (n)
  "Inefficient"
  (if (> n 1)
      (* n (fact (- n 1)))
    1))

(defun fact (n)
  "Efficient"
  (let ((answer 1)
        (count  1))
    (while (<= count n)
      (setq answer (* count answer))
      (incf count))
    answer))

;; (fact 4) (fact 7) (fact 3)

;; nCr = n! / (n-r)! r!

(defun combinations (n r)
  (/ (fact n) (fact (- n r)) (fact r)))

;; (combinations 4 0)

;; (setq shift 2)
;; (setq i 22)
;; (lsl 2 10)
(defun lsl (i shift)
  (while (> shift 0)
    (setq i (* i 2))
    (setq shift (- shift 1)))
  i)

(provide 'd-math)
;;; d-math.el ends here
