;;; autogc-nostuff.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: autogc-nostuff.el
;; Author/Maintainer: m4_davin_pearson
;; Keywords: autogc
;; Version: 1.2

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; m4_limitation_of_warranty

;;; Known Bugs:

;; None so far!

;;; Code:

;;; autogc-nostuff--list picks up situations like this:
;;;
;;;  (1) Bool_A* b = ...
;;;
;;; and
;;;
;;;  (2) bool* b = ...
;;;  (3) new bool()
;;;
;;; G++ compiler picks up attempts to create inline objects like "Bool_A b;"
;;;
;;; (because Bool_A::Bool_A(/* ... */) is private)
;;;
;;; instead use "bool b;" or "ptr<Bool_A> b;"
;;;

(let ((identifier-regexp "\\<[a-zA-Z_][a-zA-Z0-9_]*_A\\>"))
  (setq autogc-nostuff--list-nostar
        (list identifier-regexp
              (concat "Array_A<"                         identifier-regexp ">")
              (concat "Array_A<Array_A<"                 identifier-regexp "> >")
              (concat "Array_A<Array_A<Array_A<"         identifier-regexp "> > >")
              (concat "Array_A<Array_A<Array_A<Array_A<" identifier-regexp "> > > >")
              (concat "List_A<"                          identifier-regexp ">")))

  (setq autogc-nostuff--list-nostar-nonew
        (list "bool" "int" "quick" "double"
              "v3i" "v3q" "v3d"
              "xyi" "xyq" "xyd")))


;;;
;;; TODO: autogc--are-we-editing-p
;;;
;;; TODO: autogc--error
;;;
;;; TODO: why does it delete buffer ~/dlisp/a.cc
;;;
;;; TODO: where is "**** Here is the list of errors"
;;;
;;; TODO: where is "**** End of autogc"
;;;
;;;
(defun autogc-nostuff--test-file (filename)

  (let ((case-fold-search nil)
        (were-editing     nil))

    (let ((auto-mode-alist (cons '("" . c++-no-fonts-mode) auto-mode-alist)))
      (setq were-editing (autogc--are-we-editing-p filename))
      (save-buffer (find-file-read-only filename))
      (goto-char (point-min)))

    (let ((ptr  (append autogc-nostuff--list-nostar autogc-nostuff--list-nostar-nonew))
          (line nil)
          (expr nil))
      (while ptr
        (goto-char (point-min))
        (setq expr (concat (car ptr) "\\*"))
        (while (re-search-forward expr nil t)
          (setq line (d-what-line))
          (autogc--error "*** Error (%s:%d) searching for %s"
                        filename
                        line
                        (prin1-to-string expr)))
        (setq ptr (cdr ptr))))

    (let ((ptr  autogc-nostuff--list-nostar-nonew)
          (line nil)
          (expr nil))
      (while ptr
        (goto-char (point-min))
        (setq expr (concat "new " (car ptr) "("))
        (while (re-search-forward expr nil t)
          (setq line (d-what-line))
          (autogc--error "*** Error (%s:%d) searching for %s"
                        filename
                        line
                        (prin1-to-string expr)))
        (setq ptr (cdr ptr))))

    ;;
    ;; NOTE: were-editing is true, so it doesn't delete the buffer...
    ;;
    (if were-editing
        (setq buffer-read-only nil)
      (kill-buffer nil))

    )
  )

(defun autogc-nostuff--do-all (file-list)

  ;;(when (not noninteractive)
  ;;  (if (get-buffer autogc--log-buffer-name)
  ;;      (kill-buffer autogc--log-buffer-name))
  ;;  (save-excursion
  ;;    (set-buffer (generate-new-buffer autogc--log-buffer-name))
  ;;    (compilation-mode)))

  (let ((ptr file-list))
    (while ptr
      (autogc-nostuff--test-file (car ptr))
      (setq ptr (cdr ptr))))

  ;;(when (not noninteractive)
  ;;  (switch-to-buffer autogc--log-buffer-name))
  )

;;;
;;; NOTE: not intended for normal use as the autogc buffer is not reset as it should be...
;;;
(defun autogc-nostuff--do-me ()
  (autogc-nostuff--do-all (list (buffer-file-name))))

(provide 'autogc-nostuff)
