/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *    Create May 25, 1998 Matthew L. Welborn
 */

#include <VrFileSource.h>
#include <VrSigSource.h>
#include <VrDigMod.h>
#include <VrFFTSink.h>
#include <VrSyncFilter.h>
#include <VrScopeSink.h>
#include <VrMultiTask.h>

  //jca VrGUILayout *horiz = guimain->top->horizontal();
  //jca VrGUILayout *vert = horiz->vertical();
#define DEFAULT_TPD 2000.0

VrScopeSink<char>* sink;
void set_my_scale(double f) {
printf ("set scale %f\n", f);
  sink->setScale(f);
}

int main(int argc,char** argv)
{
  VrGUI *guimain = new VrGUI(argc, argv);
  int out_rate = 1000000;
  int in_rate = 10000; 
  float symbol_phase[4] = {0,0,0,0};
  float symbol_amplitude[4] = {-0.875,-0.375,0.375,0.875};

  VrFileSource<char>* source =
    new VrFileSource<char>(in_rate, "../../data_files/four_symb_sync.char", 1);

  VrDigMod<char,char>* proc =
    new VrDigMod<char,char>(out_rate/in_rate,65000.0,80,
			    4, symbol_phase, symbol_amplitude,
			    6, .7, 0);

  sink = new VrScopeSink<char>(guimain->top, DEFAULT_TPD, -128, 128, 1);
  (void) new VrGUISlider(guimain->top, set_my_scale, "Time", DEFAULT_TPD/1000, DEFAULT_TPD);

  NWO_CONNECT (source, proc);
  NWO_CONNECT (proc, sink);

  VrMultiTask *m = new VrMultiTask ();
  m->add (sink);

  m->start(); 
  guimain->start(); 

  int i = 0;
  while(1) {
    m->process(); 
    guimain->processEvents(10 /*ms*/);
    if (i++ > 40)
      sink->clear();
  }
}
