/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <GrFileDescriptorSource.h>
#include <unistd.h>
#include <errno.h>
#include <stdexcept>

GrFileDescriptorSource::GrFileDescriptorSource (size_t itemsize,
						double sampling_freq,
						int file_descriptor)
  : GrSource (itemsize, 1), d_itemsize (itemsize), d_fd (file_descriptor)
{
  setSamplingFrequency (sampling_freq);
}

GrFileDescriptorSource::~GrFileDescriptorSource ()
{
  close (d_fd);
}

int
GrFileDescriptorSource::work2 (VrSampleRange output, void *ao[])
{
  char		*outbuf = ((char **) ao)[0];
  unsigned long	byte_size = output.size * d_itemsize;

  sync (output.index);		// force in-order execution

  while (byte_size > 0){
    ssize_t	r;

    r = read (d_fd, outbuf, byte_size);
    if (r == -1){
      if (errno == EINTR)
	continue;
      else {
	perror ("GrFileDescriptorSource");
	throw std::runtime_error ("GrFileDescriptorSink: write");
      }
    }
    else if (r == 0){
      fprintf (stderr, "end of file, throwing...\n");
      throw std::runtime_error ("end of file");
    }
    else {
      byte_size -= r;
      outbuf += r;
    }
  }

  return output.size;
}
