/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.interpreter;

import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologCode;
import gnu.prolog.vm.interpreter.CallBacktrackInfo;
import gnu.prolog.vm.interpreter.EnterBacktrackInfo;
import gnu.prolog.vm.interpreter.LeaveBacktrackInfo;
import gnu.prolog.vm.interpreter.RetryBacktrackInfo;
import java.util.ArrayList;
import java.util.List;

public class ExecutionState {
    public static final int BACKTRACK = -1;
    public static final int NEXT = 0;
    public static final int JUMP = 1;
    public static final int RETURN = 2;
    public Interpreter interpreter;
    public BacktrackInfo startBacktrackInfo;
    public Term[] environment;
    public List<Term> pushdown = new ArrayList<Term>();
    public int jumpPosition;
    public Term[] args;

    public BacktrackInfo popBacktrackInfo() {
        return this.interpreter.popBacktrackInfo();
    }

    public BacktrackInfo peekBacktrackInfo() {
        return this.interpreter.peekBacktrackInfo();
    }

    public void pushBacktrackInfo(BacktrackInfo cbi) {
        this.interpreter.pushBacktrackInfo(cbi);
    }

    public CallBacktrackInfo getCallBacktrackInfo(int codePosition, Term[] args, PrologCode code, CompoundTermTag tag) {
        return new CallBacktrackInfo(this.interpreter.getUndoPosition(), codePosition, args, code, tag);
    }

    public RetryBacktrackInfo getRetryBacktrackInfo(int retryPosition) {
        return new RetryBacktrackInfo(this.interpreter.getUndoPosition(), retryPosition);
    }

    public Term popPushDown() {
        return this.pushdown.remove(this.pushdown.size() - 1);
    }

    public void pushPushDown(Term term) {
        this.pushdown.add(term);
    }

    public Term getEnvironment(int environmentIndex) {
        return this.environment[environmentIndex];
    }

    public void putEnvironment(int environmentIndex, Term term) {
        this.environment[environmentIndex] = term;
    }

    public LeaveBacktrackInfo getLeaveBacktrackInfo() {
        return new LeaveBacktrackInfo(this.interpreter.getUndoPosition(), this);
    }

    public EnterBacktrackInfo getEnterBacktrackInfo() {
        return new EnterBacktrackInfo(this.interpreter.getUndoPosition());
    }
}

