/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.rules.Condition;
import java.util.ArrayList;
import java.util.List;

public class ConditionHistory {
    private Condition condition;
    private List<Object[]> values;
    private boolean newcondition;
    private boolean changedcondition;

    public ConditionHistory(Condition condition) {
        this.condition = condition;
        this.values = new ArrayList<Object[]>();
        this.newcondition = true;
        this.changedcondition = true;
    }

    public void addValue(boolean bl, String string) {
        if (this.values.size() == 0 || bl != this.getLastValue()) {
            Object[] objectArray = new Object[]{bl, string};
            this.values.add(objectArray);
            if (this.values.size() == 1) {
                this.newcondition = true;
                this.changedcondition = true;
            } else {
                this.changedcondition = true;
            }
        }
    }

    public boolean getLastValue() {
        if (this.values.size() > 0) {
            return (Boolean)this.values.get(this.values.size() - 1)[0];
        }
        return false;
    }

    public int getValueCount() {
        return this.values.size();
    }

    public void clearState() {
        this.newcondition = false;
        this.changedcondition = false;
    }

    public boolean isNewcondition() {
        return this.newcondition;
    }

    public boolean isChangedcondition() {
        return this.changedcondition;
    }

    public String toString() {
        return Boolean.toString(this.getLastValue());
    }

    public String getConditionHistoryDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body>");
        stringBuffer.append("<h3>Details of <b>");
        stringBuffer.append(this.condition.getId());
        stringBuffer.append("</b></h3>");
        for (int i = this.values.size() - 1; i >= 0; --i) {
            Object[] objectArray = this.values.get(i);
            stringBuffer.append(i + 1);
            stringBuffer.append(". ");
            stringBuffer.append(((Boolean)objectArray[0]).toString());
            stringBuffer.append(" (");
            stringBuffer.append(objectArray[1]);
            stringBuffer.append(")<br>");
        }
        stringBuffer.append("<h4>Dependencies</h4>");
        stringBuffer.append(this.condition.getDependenciesDetails());
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }
}

