/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.voting;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.gnunet.consensus.Consensus;
import org.gnunet.consensus.ConsensusCallback;
import org.gnunet.consensus.ConsensusElement;
import org.gnunet.construct.Construct;
import org.gnunet.mesh.ChannelEndHandler;
import org.gnunet.mesh.Mesh;
import org.gnunet.mesh.MeshRunabout;
import org.gnunet.secretsharing.Ciphertext;
import org.gnunet.secretsharing.DecryptCallback;
import org.gnunet.secretsharing.Decryption;
import org.gnunet.secretsharing.KeyGeneration;
import org.gnunet.secretsharing.Plaintext;
import org.gnunet.secretsharing.SecretReadyCallback;
import org.gnunet.secretsharing.Share;
import org.gnunet.testbed.CompressedConfig;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.HashCode;
import org.gnunet.util.PeerIdentity;
import org.gnunet.util.Program;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.Scheduler;
import org.gnunet.util.crypto.EcdsaPublicKey;
import org.gnunet.util.crypto.EddsaPrivateKey;
import org.gnunet.util.crypto.EddsaPublicKey;
import org.gnunet.util.crypto.EddsaSignature;
import org.gnunet.voting.Ballot;
import org.gnunet.voting.EncryptedVote;
import org.gnunet.voting.InvalidBallotException;
import org.gnunet.voting.messages.BallotRegisterFailureMessage;
import org.gnunet.voting.messages.BallotRegisterRequestMessage;
import org.gnunet.voting.messages.BallotRegisterSuccessMessage;
import org.gnunet.voting.messages.KeyQueryFailureMessage;
import org.gnunet.voting.messages.KeyQueryMessage;
import org.gnunet.voting.messages.KeyQueryResponseMessage;
import org.gnunet.voting.messages.ResultQueryFailureMessage;
import org.gnunet.voting.messages.ResultQueryMessage;
import org.gnunet.voting.messages.ResultQueryResponseMessage;
import org.gnunet.voting.messages.SubmitFailureMessage;
import org.gnunet.voting.messages.SubmitMessage;
import org.gnunet.voting.messages.SubmitSuccessMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TallyAuthorityDaemon
extends Program {
    private static final Logger logger = LoggerFactory.getLogger(TallyAuthorityDaemon.class);
    public static final int MESH_PORT = 1002;
    private Mesh mesh;
    private EddsaPrivateKey authorityPrivateKey;
    private EddsaPublicKey authorityPublicKey;
    private HashMap<HashCode, ElectionState> elections = Maps.newHashMap();

    private SubmitFailureMessage.SignedAuthorityTime getTimeSigMessage() {
        SubmitFailureMessage.SignedAuthorityTime tm = new SubmitFailureMessage.SignedAuthorityTime();
        tm.purpose = 0;
        tm.time = AbsoluteTime.now().asMessage();
        tm.signature = this.authorityPrivateKey.sign(Construct.toBinary(tm.time), tm.purpose, this.authorityPublicKey);
        return tm;
    }

    public TallyAuthorityDaemon() {
        this.authorityPrivateKey = EddsaPrivateKey.createRandom();
        this.authorityPublicKey = this.authorityPrivateKey.getPublicKey();
    }

    public static void main(String[] args) {
        TallyAuthorityDaemon daemon = new TallyAuthorityDaemon();
        int ret = daemon.start(args);
        System.exit(ret);
    }

    @Override
    public void run() {
        logger.info("running tally daemon");
        this.mesh = new Mesh(this.getConfiguration(), null, new ChannelEndHandler(){

            @Override
            public void onChannelEnd(Mesh.Channel channel) {
                logger.warn("on channel end");
            }
        }, new TallyMeshReceiver(), 1002);
        Scheduler.addDelayed(RelativeTime.FOREVER, new Scheduler.Task(){

            @Override
            public void run(Scheduler.RunContext ctx) {
                if (null != TallyAuthorityDaemon.this.mesh) {
                    TallyAuthorityDaemon.this.mesh.destroy();
                    TallyAuthorityDaemon.this.mesh = null;
                }
            }
        });
    }

    private class TallyMeshReceiver
    extends MeshRunabout {
        private TallyMeshReceiver() {
        }

        public void visit(SubmitMessage m) {
            logger.debug("got submit message");
            ElectionState electionState = (ElectionState)TallyAuthorityDaemon.this.elections.get(m.ballotGuid);
            if (null == electionState) {
                SubmitFailureMessage fm = new SubmitFailureMessage();
                fm.reason = "no matching ballot found";
                this.getSender().send(fm);
            } else if (!electionState.ballot.startTime.isDue()) {
                SubmitFailureMessage fm = new SubmitFailureMessage();
                fm.reason = "too early to submit vote";
                fm.signedAuthorityTime = TallyAuthorityDaemon.this.getTimeSigMessage();
                this.getSender().send(fm);
            } else if (electionState.ballot.closingTime.isDue()) {
                SubmitFailureMessage fm = new SubmitFailureMessage();
                fm.reason = "too late to submit vote";
                fm.signedAuthorityTime = TallyAuthorityDaemon.this.getTimeSigMessage();
                this.getSender().send(fm);
            } else {
                byte[] elem = Construct.toBinary(m.encryptedVote);
                electionState.consensus.insertElement(new ConsensusElement(elem, 0));
                SubmitSuccessMessage sm = new SubmitSuccessMessage();
                sm.confirmationSig = EddsaSignature.randomGarbage();
                this.getSender().send(sm);
            }
            this.getSender().receiveDone();
        }

        public void visit(BallotRegisterRequestMessage m) {
            HashCode guid;
            Ballot b;
            logger.info("ballot register requested");
            CompressedConfig ccfg = new CompressedConfig(m.compressedBallotConfig);
            try {
                b = new Ballot(ccfg.decompress());
                guid = b.getBallotGuid();
            }
            catch (InvalidBallotException e) {
                BallotRegisterFailureMessage fm = new BallotRegisterFailureMessage();
                fm.reason = "invalid ballot (" + e.getMessage() + ")";
                this.getSender().send(fm);
                this.getSender().receiveDone();
                return;
            }
            if (TallyAuthorityDaemon.this.elections.containsKey(guid)) {
                BallotRegisterFailureMessage fm = new BallotRegisterFailureMessage();
                fm.reason = "ballot with same GUID already registered";
                this.getSender().send(fm);
                return;
            }
            ElectionState electionState = new ElectionState();
            electionState.ballot = b;
            PeerIdentity[] ids = new PeerIdentity[b.getAuthorities().size()];
            ids = b.getAuthorities().toArray(ids);
            electionState.consensus = new Consensus(TallyAuthorityDaemon.this.getConfiguration(), ids, b.getBallotGuid(), electionState.ballot.closingTime, electionState.ballot.concludeTime);
            ConsensusConcludeTask t = new ConsensusConcludeTask(electionState);
            if (b.concludeTime.isDue()) {
                logger.info("concluding now");
                Scheduler.add(t);
            } else {
                logger.info("concluding in {}", (Object)b.closingTime.getRemaining().getSeconds());
                Scheduler.addDelayed(b.closingTime.getRemaining(), t);
            }
            System.out.println("authority threshold: " + electionState.ballot.threshold);
            System.out.println("authority num_peers: " + electionState.ballot.authorities.size());
            electionState.keyGeneration = new KeyGeneration(TallyAuthorityDaemon.this.getConfiguration(), ids, HashCode.hash(b.getBallotGuid().data), electionState.ballot.keygenStartTime, electionState.ballot.keygenEndTime, electionState.ballot.threshold, new SecretReady(electionState));
            TallyAuthorityDaemon.this.elections.put(guid, electionState);
            BallotRegisterSuccessMessage rm = new BallotRegisterSuccessMessage();
            rm.registrationSignature = EddsaSignature.randomGarbage();
            this.getSender().send(rm);
        }

        public void visit(ResultQueryMessage m) {
            logger.debug("got result query message");
            ElectionState electionState = (ElectionState)TallyAuthorityDaemon.this.elections.get(m.ballotGuid);
            if (null == electionState) {
                ResultQueryFailureMessage rm = new ResultQueryFailureMessage();
                rm.reason = "no matching ballot found";
                this.getSender().send(rm);
            } else if (!electionState.ballot.queryTime.isDue()) {
                ResultQueryFailureMessage rm = new ResultQueryFailureMessage();
                rm.reason = "result query not allowed yet";
                this.getSender().send(rm);
            } else if (null == electionState.tally) {
                ResultQueryFailureMessage rm = new ResultQueryFailureMessage();
                rm.reason = "tally not yet available";
                this.getSender().send(rm);
            } else {
                ResultQueryResponseMessage rm = new ResultQueryResponseMessage();
                rm.results = electionState.tally;
                this.getSender().send(rm);
            }
            this.getSender().receiveDone();
        }

        public void visit(KeyQueryMessage m) {
            logger.debug("got key query message");
            this.getSender().receiveDone();
            ElectionState electionState = (ElectionState)TallyAuthorityDaemon.this.elections.get(m.ballotGuid);
            if (null == electionState) {
                KeyQueryFailureMessage rm = new KeyQueryFailureMessage();
                rm.reason = "no matching ballot found";
                this.getSender().send(rm);
                return;
            }
            if (!electionState.ballot.keygenEndTime.isDue()) {
                KeyQueryFailureMessage rm = new KeyQueryFailureMessage();
                rm.reason = "key query not allowed yet";
                this.getSender().send(rm);
                return;
            }
            if (null == electionState.share) {
                KeyQueryFailureMessage rm = new KeyQueryFailureMessage();
                rm.reason = "key not yet established";
                this.getSender().send(rm);
                return;
            }
            KeyQueryResponseMessage.BallotPublicKey ballotPublicKey = new KeyQueryResponseMessage.BallotPublicKey();
            ballotPublicKey.ballotGuid = electionState.ballot.getBallotGuid();
            ballotPublicKey.publicKey = electionState.share.publicKey;
            KeyQueryResponseMessage rm = new KeyQueryResponseMessage();
            rm.signedGuidKey = ballotPublicKey;
            rm.purpose = 0;
            rm.signature = TallyAuthorityDaemon.this.authorityPrivateKey.sign(Construct.toBinary(rm.signedGuidKey), rm.purpose, TallyAuthorityDaemon.this.authorityPublicKey);
            this.getSender().send(rm);
        }
    }

    static class SecretReady
    implements SecretReadyCallback {
        private final ElectionState electionState;

        public SecretReady(ElectionState electionState) {
            this.electionState = electionState;
        }

        @Override
        public void onSecretReady(Share share) {
            this.electionState.keyGeneration = null;
            this.electionState.share = share;
        }
    }

    class ConsensusConcludeTask
    implements Scheduler.Task {
        private final ElectionState electionState;

        public ConsensusConcludeTask(ElectionState electionState) {
            this.electionState = electionState;
        }

        @Override
        public void run(Scheduler.RunContext ctx) {
            this.electionState.consensus.conclude(new ElectionConsensusConclude(this.electionState));
        }
    }

    class ElectionConsensusConclude
    implements ConsensusCallback {
        private final ElectionState electionState;

        public ElectionConsensusConclude(ElectionState electionState) {
            this.electionState = electionState;
        }

        @Override
        public void onElement(ConsensusElement element) {
            System.out.println("got element from consensus");
            EncryptedVote vote = Construct.parseAs(element.data, EncryptedVote.class);
            System.out.println("got vote from consensus, ciphertext: " + vote.v.toString());
            if (this.electionState.countedVoters.contains(vote.voterPublicKey)) {
                logger.error("voter {} voted twice", (Object)vote.voterPublicKey);
                return;
            }
            this.electionState.voteProduct = this.electionState.voteProduct.multiply(vote.v);
            this.electionState.countedVoters.add(vote.voterPublicKey);
            System.out.println("threshold key (of this authority): " + this.electionState.share.publicKey.toString());
        }

        @Override
        public void onDone() {
            System.out.println("consensus concluded");
            this.electionState.consensusDone = true;
            this.electionState.consensus.destroy();
            this.electionState.consensus = null;
            this.electionState.decryption = new Decryption(TallyAuthorityDaemon.this.getConfiguration(), this.electionState.share, this.electionState.voteProduct, this.electionState.ballot.concludeTime, this.electionState.ballot.queryTime, new DecryptCallback(){

                @Override
                public void onResult(Plaintext plaintext) {
                    logger.info("got decypt result");
                    long l = ((ElectionConsensusConclude)ElectionConsensusConclude.this).electionState.countedVoters.size();
                    long[] t = plaintext.bruteForceDiscreteLog(l, ((ElectionConsensusConclude)ElectionConsensusConclude.this).electionState.ballot.generators);
                    if (null == t) {
                        logger.warn("could not brute-force result");
                    } else {
                        logger.info("brute-forced result");
                        ((ElectionConsensusConclude)ElectionConsensusConclude.this).electionState.tally = t;
                    }
                }
            });
        }
    }

    class ElectionState {
        Ballot ballot;
        Share share;
        Set<EcdsaPublicKey> countedVoters = new HashSet<EcdsaPublicKey>();
        KeyGeneration keyGeneration;
        Consensus consensus;
        boolean consensusDone;
        Ciphertext voteProduct = Ciphertext.identity();
        long[] tally;
        Decryption decryption;

        ElectionState() {
        }
    }
}

