/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util;

import com.google.common.base.Charsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.Message;
import org.gnunet.util.Strings;

public class HashCode
implements Message {
    @FixedSizeIntegerArray(length=64, signed=false, bitSize=8)
    public byte[] data;

    public HashCode() {
        this.data = new byte[64];
    }

    public static HashCode fromHashCode(byte[] hash) {
        return new HashCode(hash);
    }

    public static HashCode hash(byte[] data) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("crypto algorithm 'SHA-512' required but not provided");
        }
        byte[] hb = digest.digest(data);
        HashCode h = new HashCode(hb);
        return h;
    }

    private HashCode(byte[] hash) {
        if (hash.length != 64) {
            throw new AssertionError((Object)"HashCode has to have length 64");
        }
        this.data = Arrays.copyOf(hash, hash.length);
    }

    public HashCode(String s) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("crypto algorithm required but not provided");
        }
        byte[] data = digest.digest(s.getBytes(Charsets.UTF_8));
        if (data.length != 64) {
            throw new RuntimeException("error in SHA512 algorithm");
        }
        this.data = data;
    }

    public boolean isAllZero() {
        for (byte aData : this.data) {
            if (aData == 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof HashCode)) {
            return false;
        }
        HashCode hashCode = (HashCode)other;
        return Arrays.equals(this.data, hashCode.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return Strings.dataToString(this.data);
    }

    public static HashCode random() {
        HashCode hashCode = new HashCode();
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(hashCode.data);
        return hashCode;
    }
}

