/* -*- buffer-read-only: t -*- vi: set ro:
 *
 *  This file is part of gnu-pw-mgr.
 *
 *  Copyright (C) 2013-2018 Bruce Korb, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 * This file is generated.  gnu-pw-mgr is built with most all symbols
 * having static scope and is compiled all at once.  So all the static
 * functions are declared here and all the C files that are part of it
 * are #included here at the bottom (with two exceptions: the main code
 * gnu-pw-mgr.c and gpw-str.c, which is needed early).
 */

#ifndef GPW_FWD_GUARD
#define GPW_FWD_GUARD 1

////HEADER-FILES:

#include "config.h"

#include <assert.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <inttypes.h>
#include <pwd.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdnoreturn.h>
#include <string.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <termios.h>
#include <time.h>
#include <unistd.h>

#include "base64.h"
#include "gc.h"
#include "nonblocking.h"
#include "sha256.h"
#include "timespec.h"
#include "opts.h"

////DEFINES:
#ifndef PVT_static
#define PVT_static static
#endif

#ifdef __GNUC__
# define UNLIKELY(_e) __builtin_expect ((_e), 0)
# define ISLIKELY(_e) __builtin_expect ((_e), 1)
#else
# define UNLIKELY(_e) (_e)
# define ISLIKELY(_e) (_e)
#endif

#define MIN_PW_LEN            	 8
#define MIN_SEED_TEXT_LEN     	64
#define MARK_TEXT_LEN         	24
#define CONFIRM_LEN           	12
#define MAX_CFG_NAME_SIZE     	32
#define MIN_BUF_LEN           	((256 / NBBY) + (256 / (NBBY * 2))) // 48
#define VER_TO_INT(_maj, _min, _rev) \
	(((_maj)<<20) + ((_min)<<10) + (_rev))
#define CCLASS_NO_THREE 	(CCLASS_NO_TRIPLETS | CCLASS_NO_SEQUENCE)
#define SECONDS_IN_DAY  	(60UL * 60UL * 24UL)

#define MAX_REHASH_CT   	100000

#ifndef MAXPATHLEN
# define MAXPATHLEN 4096
#endif

#ifndef   ACCESSPERMS
# define  ACCESSPERMS 0777
#endif // ACCESSPERMS

typedef enum {
    HOME_DIR_IX = 0,
    XDG_DATA_HOME_IX = 1,
    XDG_CONFIG_HOME_IX = 2,
#ifdef __APPLE__
    APPLE_LOCAL_IX = 3,
#endif // __APPLE__
    HOME_IX_CT
} home_ix_t;

typedef struct str_list str_list_t;
struct str_list {
    str_list_t *    next;
    char            buf[0];
};


/*
 * Generated local headers:
 */
#include "gpw-str.h"
#include "set-opt.h"

/*
 * FILE: cclass.c
 */
static void
reprocess_cclass(tOptDesc * od, str_list_t * str_list);

static void
adjust_pin_n_alnum(tOptDesc * od);

static void
fix_cclass_bits(tOptDesc * od);

static void
sanity_check_cclass(void);


/*
 * FILE: cfg-file.c
 */
#ifndef SORT_PW_CFG // code for gnu-pw-mgr only
static void
set_config_name(char const * nm);

static char const *
access_config_file(void);

static void
secure_cfg_file(void);

static void
load_config_file(void);

#endif // not SORT_PW_CFG only
static char const *
find_home_dir(void);

#ifndef SORT_PW_CFG // no --config-file option for sort
#endif // SORT_PW_CFG not defined
# if defined(HAVE_GETPWUID)
# else
# endif
static char *
check_home_dir(char const * cfg_home, bool * used_cfg_name, bool check_cfg_file);

#ifdef SORT_PW_CFG
#else
#endif // ! SORT_PW_CFG
#ifdef __APPLE__
static void
find_apple_cfg_dir(void);

#endif // __APPLE__
static char *
set_cfg_dir(bool * used_cfg_name);

#ifndef SORT_PW_CFG
#endif // ! SORT_PW_CFG
#ifdef __APPLE__
#endif //  __APPLE__
#ifndef SORT_PW_CFG
#endif // ! SORT_PW_CFG
static char *
find_cfg_name(void);

#ifndef SORT_PW_CFG
#endif // ! SORT_PW_CFG

/*
 * FILE: domains.c
 */
static char *
load_domain_file(char const * fname);

static void
list_domains(void);

static void
write_dom_file(void);

static void
insert_domain(char const * dom);

static char *
find_dom_file(void);

static void
proc_dom_opts(int rem_arg_ct);


/*
 * FILE: fix-pw.c
 */
static bool
clean_triplets(char * pw, bool sequence);

static bool
clean_sequence(char * pw);

static bool
clean_no_three(char * pw);

static void
fix_no_alpha_pw(char * pw);

static void
fix_lower_only_pw(char * pw);

static uintptr_t
pick_something(uintptr_t ccls, char * pch, int * cta);

static uintptr_t
count_pw_class(char * pw, bool no_spec, int * cta);

static char *
find_upper(char * pw);

static char *
find_lower(char * pw);

static char *
find_digit(char * pw);

static char *
find_special(char * pw);

static void
add_upper(char * pw, int * cta);

static void
add_lower(char * pw, int * cta);

static void
add_digit(char * pw, int * cta);

static void
add_special(char * pw, int * cta);

static void
fix_std_pw(char * pw);

static void
fix_digit_pw(char * pw, uintptr_t * sums);


/*
 * FILE: gnu-pw-mgr.c
 */
static void
set_confirm_value(char * buf, size_t bsz, unsigned char * data, size_t d_len,
                  char const * pwd_id_str);

static void
adjust_pw(char * buf, size_t bsz, unsigned char * data, size_t d_len,
          char const * pwd_id_str);

#if SIZEOF_CHARP > 4
#endif
static void
get_dft_pw(char * buf, size_t bsz,
           char const * tag, char const * txt, char const * pwd_id_str);

static void
get_rehashed_pw(char * buf, size_t bsz,
                char const * tag, char const * salt, char const * pwd_id_str);

static void
print_pwid_header(char const * pwd_id_str);

static void
print_pwid_status(char const * pwd_id_str);

static void
select_chars(unsigned char * txtbuf);

static bool
print_one_pwid(tOptionValue const * seed_opt, char const * pwd_id_str);

static void
print_pwid(char const * pwd_id_str);

static char const *
assemble_arg(int argc, char ** argv);

static char *
trim(char * in);

static void
stdin_pwid(void);

# ifdef HAVE_TCGETATTR
# else
# endif
# ifdef HAVE_TCGETATTR
# endif
# ifdef HAVE_TCGETATTR
# endif
# ifdef HAVE_TCGETATTR
# endif

/*
 * FILE: pw-opts.c
 */
static char *
make_pwid_mark(char const * name, size_t * len);

static char const *
day_to_string(char const * day_str);

static char const *
next_pwid_opt(char const * scan, char const * mark, size_t mark_len);

static char *
load_one_stored_opt(char const * opt_text);

static bool
set_stored_opts(char * mark, size_t mark_len);

static char *
search_for_option(char * buf, char const * mark, size_t m_len, set_opt_enum_t typ);

static void
adjust_cclass_val(char const * mark, size_t m_len);

static void
adjust_pbkdf2_val(char const * mark, size_t m_len);

static bool
remove_opt(char const * mark, size_t m_len, set_opt_enum_t typ);

static bool
remove_defined_opts(char * mark, size_t mark_len);

static void
set_pwid_opts(char const * pw_id);

static void
update_pwid_opts(char const * name);

static void
remove_pwid(char const * name);

static void
insert_load_opts(int * ac, char *** av);

static void
create_cfg_file(char * opt, char * opt1);

static void
fix_options(int * ac, char *** av);


/*
 * FILE: scribble.c
 */
static void
scribble_init(void);

static void
scribble_deinit(void);

static void
scribble_free(void);

static void *
scribble_get(ssize_t size);

static void *
xscribble_get(ssize_t sz);


/*
 * FILE: seed.c
 */
static void
randomize_seed(int wiggle);

static char const *
get_seed_text(void);

static uint32_t
ver_str_to_number(void);

static char const *
skip_cfg_header(FILE * fp);

static char const *
replace_default_cclass(FILE * fp);

static void
set_default_cclass(void);

static void
add_seed(void);

static void
rm_seed(void);


/*
 * FILE: wrap-libnettle.c
 */
#ifdef HAVE_LIBNETTLE
static void
gpw_init_ctx(struct sha256_ctx *ctx);

static void
gpw_process(const void *buffer, size_t len, struct sha256_ctx *ctx);

static void *
gpw_finish(struct sha256_ctx *ctx, void *resbuf);

#endif /* HAVE_LIBNETTLE */

////GLOBALS:
static char const * home_dirs[HOME_IX_CT] = { NULL };
static unsigned int const secure_mask     = S_IRWXG | S_IRWXO;
static char const * config_file_name      = NULL;
static char const   empty_config_data[]   = "";
static char *       config_file_text      = (char *)(void *)empty_config_data;
static size_t       config_file_size      = 0;
static uintptr_t    post_cfg_setting      = 0UL;
static char const * rehash_date           = pw_undated;
static bool         have_stored_opts      = false;
static bool         update_stored_opts    = false;
static int          tweak_prev_cclass     = 0;
static int          tweak_prev_rehash     = 0;

static char *       dom_text      = NULL;
static char const * dom_file_name = NULL;
static struct stat  dom_file_stat = { .st_size = 0 };
static off_t        dom_text_len  = 0;

#include "opts.c"
#include "gpw-str.c"
#include "set-opt.c"


#include "cclass.c"
#include "cfg-file.c"
#include "domains.c"
#include "fix-pw.c"
#include "pw-opts.c"
#include "scribble.c"
#include "seed.c"
#include "wrap-libnettle.c"
#endif //  GPW_FWD_GUARD
