#!/bin/sh
# Check whether a PR has been analyzed within the acknowledgment period.
# Copyright (C) 1993, 1994, 1995, 1999 Free Software Foundation, Inc.
# Contributed by Brendan Kehoe (brendan@cygnus.com).
#
# This file is part of GNU GNATS.
#
# GNU GNATS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU GNATS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU GNATS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

prog=at-pr
USAGE="Usage: $prog [-h|--help] [-d|--database database_name] arguments

 Arguments coming in are (all are required):

 1 - response time
 2 - PR number
 3 - path to the PR file (unused)
 4 - submitter-id
 5 - full name of the submitter
 6 - contact for the submitter
 7 - address for GNATS_ADMIN
"

PATH=/bin:/usr/bin; export PATH

if [ $# -eq 0 ]
then
  echo "$USAGE" >&2
  exit 1
fi

if [ "x$1" = "x-h" -o "x$1" = "x--help" ]
then
  echo "$USAGE"
  exit 0
fi

# process command line options
while [ $# -gt 7 ]; do
  case "$1" in
    -d | --database)
      if [ $# -eq 8 ]
      then 
        echo "ERROR: value required for $1 option" >&2
        echo "$USAGE" >&2
        exit 1
      fi
      shift 
      GNATSDB="$1" ;;
    -d=* | --database=*) GNATSDB="`echo $1 | sed 's/^[-a-z]*=//'`" ;;

    -*) echo "$USAGE" >&2; exit 1 ;;
  esac
  shift
done

export GNATSDB
VERSION=xVERSIONx
LIBEXECDIR="xLIBEXECDIRx/gnats"
QUERY_PR="xBINDIRx/query-pr"

eval `$QUERY_PR --print-sh-vars`

if [ "x$GNATSDB_VALID" = x0 ]
then
    echo "Invalid database name $GNATSDB"
    exit 1
fi

if [ $# != 7 ]; then
  echo "ERROR: $prog called with the incorrect number of arguments" >&2
  echo "$USAGE" >&2
  exit 1
fi

# See if the PR number is still valid.

$QUERY_PR --format Number $2 > /dev/null 2>&1

if [ $? ! = 0 ]
then
    # Maybe the PR is gone?
    exit 0
fi
 
# Grab the current state of the PR, and the synopsis.

# XXX ??? !!! Instead  of calling query-pr 3 times, why not do it once and
# use read or something?

STATE="`$QUERY_PR --format State $2`"
SYNOPSIS="`$QUERY_PR --format Synopsis $2`"
RESPONSIBLE="`$QUERY_PR --format Responsible $2`"
RESP_ADDR=`$LIBEXECDIR/pr-addr "$RESPONSIBLE"`

# $DEBUG_MODE is set to 0 when debug is off in the config file
if [ "x$DEBUG_MODE" = "x1" ]; then
  STEALTH_HEADER="From: $7 (GNATS Management)
To: $7
Subject: mail output from at-pr


"
fi

if [ "$STATE" = "${DEFAULTSTATE}" ]; then
  $LIBEXECDIR/mail-agent << __EOF__
${STEALTH_HEADER}From: $7 (GNATS Management)
To: $6, $RESP_ADDR, $7
Subject: PR $2 not analyzed in $1 hours


PR $2 was not analyzed within the acknowledgment period
of $1 business hours.  The pertinent information is:

 Submitter-Id: $4
 Originator: $5
 Synopsis: $SYNOPSIS
 Person responsible for the PR: $RESPONSIBLE

--
The GNU Problem Report Management System (GNATS)
__EOF__
fi

exit 0
