/* Copyright (C) 2000, 2001 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/*
    General Purpose Register (GPR) save routine
    when Floating Point Registers (FPRs) are not saved

    Note: This save routine must not be called when GPR30 or
    GPR31, or both, are the only registers beings saved. In these
    cases, the saving and restoring must be done inline.
*/

#include <sysdep.h>

ENTRY(_savegpr0_all)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_13)
C_TEXT(_savegpr0_13):	stw	r13,-76(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_14)
C_TEXT(_savegpr0_14):	stw	r14,-72(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_15)
C_TEXT(_savegpr0_15):	stw	r15,-68(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_16)
C_TEXT(_savegpr0_16):	stw	r16,-64(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_17)
C_TEXT(_savegpr0_17):	stw	r17,-60(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_18)
C_TEXT(_savegpr0_18):	stw	r18,-56(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_19)
C_TEXT(_savegpr0_19):	stw	r19,-52(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_20)
C_TEXT(_savegpr0_20):	stw	r20,-48(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_21)
C_TEXT(_savegpr0_21):	stw	r21,-44(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_22)
C_TEXT(_savegpr0_22):	stw	r22,-40(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_23)
C_TEXT(_savegpr0_23):	stw	r23,-36(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_24)
C_TEXT(_savegpr0_24):	stw	r24,-32(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_25)
C_TEXT(_savegpr0_25):	stw	r25,-28(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_26)
C_TEXT(_savegpr0_26):	stw	r26,-24(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_27)
C_TEXT(_savegpr0_27):	stw	r27,-20(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_28)
C_TEXT(_savegpr0_28):	stw	r28,-16(r1)
		ASM_GLOBAL_DIRECTIVE C_TEXT(_savegpr0_29)
C_TEXT(_savegpr0_29):	stw	r29,-12(r1) #save r29
			stw	r30,-8(r1)  #save r30
			stw	r31,-4(r1)  #save r31
			stw	r0,8(r1)    #save LR in callers frame
			blr		    #return
