/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected1.metric;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected1.metric.AbstractMetric;
import java.awt.geom.Point2D;
import java.util.List;

public class BBMetric
extends AbstractMetric {
    @Override
    public String getMetricName() {
        return "Bounding Box Metric";
    }

    @Override
    public double compute() {
        double sum2 = 0.0;
        for (PlacementFrame.PlacementNetwork net : this.allNetworks) {
            sum2 += this.compute(net);
        }
        return sum2;
    }

    private double compute(PlacementFrame.PlacementNetwork net) {
        List<PlacementFrame.PlacementPort> portsOnNet = net.getPortsOnNet();
        double leftmost = Double.MAX_VALUE;
        double rightmost = -1.7976931348623157E308;
        double uppermost = -1.7976931348623157E308;
        double undermost = Double.MAX_VALUE;
        for (PlacementFrame.PlacementPort port : portsOnNet) {
            Point2D.Double position = this.getPortPosition(port);
            if (position.getX() < leftmost) {
                leftmost = position.getX();
            }
            if (position.getX() > rightmost) {
                rightmost = position.getX();
            }
            if (position.getY() > uppermost) {
                uppermost = position.getY();
            }
            if (!(position.getY() < undermost)) continue;
            undermost = position.getY();
        }
        return rightmost - leftmost + (uppermost - undermost);
    }

    private Point2D.Double getPortPosition(PlacementFrame.PlacementPort port) {
        double x2 = port.getRotatedOffX() + port.getPlacementNode().getPlacementX();
        double y = port.getRotatedOffY() + port.getPlacementNode().getPlacementY();
        return new Point2D.Double(x2, y);
    }
}

