/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Gerber
extends Input<Object> {
    private static double UNSCALE = 1000.0;
    private GerberPreferences localPrefs;
    private Cell curCell;
    private Map<Integer, StandardCircle> standardCircles = new HashMap<Integer, StandardCircle>();
    private Map<Integer, StandardRectangle> standardRectangles = new HashMap<Integer, StandardRectangle>();
    private NumberFormat currentNumberFormat = NumberFormat.EXPLICIT_DECIMAL_POINT;
    private boolean absoluteCoordinates;
    private int xFormatLeft;
    private int xFormatRight;
    private int yFormatLeft;
    private int yFormatRight;
    private double scaleFactor;
    private boolean fullCircle = false;
    private int currentPrepCode;
    private int currentDCode;
    private double lastXValue = 0.0;
    private double lastYValue = 0.0;
    private double curXValue;
    private double curYValue;
    private double curIValue;
    private double curJValue;
    private String lastPart;
    private static GerberLayer defaultGerberLayer = new GerberLayer(Artwork.tech().filledPolygonNode);
    private GerberLayer currentLayer;
    List<PolyBase.Point> polygonPoints = null;
    private static Technology pcbTech = Technology.findTechnology("pcb");

    Gerber(EditingPreferences ep, GerberPreferences ap) {
        super(ep);
        this.localPrefs = ap;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        String cellName = lib.getName();
        this.curCell = Cell.makeInstance(this.ep, lib, cellName + "{lay}");
        if (this.localPrefs.justThisFile) {
            try {
                this.readFile(this.lineReader);
            }
            catch (IOException e) {
                System.out.println("ERROR reading Gerber file: " + e.getMessage());
            }
        } else {
            ArrayList<String> gerberfiles = new ArrayList<String>();
            String topDirName = TextUtils.getFilePath(lib.getLibFile());
            File topDir = new File(topDirName);
            String[] fileList = topDir.list();
            for (int i = 0; i < fileList.length; ++i) {
                if (!fileList[i].endsWith(".gbr")) continue;
                String fileName = topDirName + fileList[i];
                gerberfiles.add(fileName);
            }
            Collections.sort(gerberfiles);
            try {
                for (String fileName : gerberfiles) {
                    System.out.println("Reading: " + fileName);
                    URL fileURL = TextUtils.makeURLToFile(fileName);
                    if (this.openTextInput(fileURL)) {
                        return null;
                    }
                    this.readFile(this.lineReader);
                    this.closeInput();
                }
            }
            catch (IOException e) {
                System.out.println("ERROR reading Gerber files: " + e.getMessage());
            }
        }
        return lib;
    }

    private void readFile(LineNumberReader lr) throws IOException {
        String line;
        this.currentPrepCode = 1;
        this.currentLayer = defaultGerberLayer;
        this.lastPart = null;
        while ((line = this.readSegment(lr)) != null) {
            if (line.startsWith("%FS")) {
                this.handleFormatStatement(line);
                continue;
            }
            if (line.startsWith("%MO")) {
                this.handleEmbeddedUnits(line);
                continue;
            }
            if (line.startsWith("%IP")) {
                this.handleImagePolarity(line);
                continue;
            }
            if (line.startsWith("%AD")) {
                this.handleStandardShape(line);
                continue;
            }
            if (line.startsWith("%AS") || line.startsWith("%SF") || line.startsWith("%IN")) continue;
            if (line.startsWith("%LN")) {
                int astPos = line.indexOf(42);
                if (astPos < 0) {
                    astPos = line.length();
                }
                String layerName = line.substring(3, astPos);
                this.currentLayer = GerberLayer.findLayer(layerName);
                continue;
            }
            if (line.startsWith("%LP")) {
                if (line.charAt(3) == 'D') {
                    this.currentLayer.setPolarity(true);
                    continue;
                }
                this.currentLayer.setPolarity(false);
                continue;
            }
            this.handleOldStyleLine(line, lr);
        }
    }

    private String readSegment(LineNumberReader lr) throws IOException {
        int astPos;
        String line;
        do {
            if (this.lastPart != null) {
                line = this.lastPart;
                this.lastPart = null;
                continue;
            }
            line = lr.readLine();
            if (line != null) continue;
            return null;
        } while (line.length() <= 0);
        if (line.charAt(0) != '%' && (astPos = line.indexOf(42)) >= 0 && astPos + 1 < line.length()) {
            this.lastPart = line.substring(astPos + 1);
            line = line.substring(0, astPos + 1);
        }
        return line;
    }

    private void handleOldStyleLine(String line, LineNumberReader lr) {
        Point2D.Double ctr;
        boolean foundCoord = false;
        List<StringPart> parts = this.parseString(line);
        for (StringPart sp2 : parts) {
            if (sp2.separator == 'G') {
                int prepCode = (int)sp2.value;
                switch (prepCode) {
                    case 4: 
                    case 57: {
                        return;
                    }
                    case 36: {
                        if (!this.localPrefs.fillPolygons) break;
                        this.polygonPoints = new ArrayList<PolyBase.Point>();
                        break;
                    }
                    case 37: {
                        if (this.polygonPoints == null) break;
                        double cX = 0.0;
                        double cY = 0.0;
                        if (this.polygonPoints.size() == 0) {
                            System.out.println("Warning: zero-size polygon on line " + lr.getLineNumber());
                        } else {
                            double minX = this.polygonPoints.get(0).getX();
                            double minY = this.polygonPoints.get(0).getY();
                            double maxX = minX;
                            double maxY = minY;
                            for (PolyBase.Point pt : this.polygonPoints) {
                                cX += ((Point2D)pt).getX();
                                cY += ((Point2D)pt).getY();
                                if (((Point2D)pt).getX() < minX) {
                                    minX = ((Point2D)pt).getX();
                                }
                                if (((Point2D)pt).getX() > maxX) {
                                    maxX = ((Point2D)pt).getX();
                                }
                                if (((Point2D)pt).getY() < minY) {
                                    minY = ((Point2D)pt).getY();
                                }
                                if (!(((Point2D)pt).getY() > maxY)) continue;
                                maxY = ((Point2D)pt).getY();
                            }
                            cX /= (double)this.polygonPoints.size();
                            cY /= (double)this.polygonPoints.size();
                            Point2D[] points = new PolyBase.Point[this.polygonPoints.size()];
                            for (int i = 0; i < this.polygonPoints.size(); ++i) {
                                points[i] = this.polygonPoints.get(i);
                            }
                            if (!this.currentLayer.polarityDark) {
                                boolean subtracted = false;
                                Poly subtractPoly = new Poly((PolyBase.Point[])points);
                                Rectangle2D.Double bounds = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
                                Iterator<Geometric> it = this.curCell.searchIterator(bounds);
                                while (it.hasNext()) {
                                    NodeInst ni;
                                    Geometric geom = it.next();
                                    if (geom instanceof ArcInst || (ni = (NodeInst)geom).getProto().getTechnology() != pcbTech) continue;
                                    EPoint[] pts = ni.getTrace();
                                    PolyBase.Point[] adjPts = new PolyBase.Point[pts.length];
                                    for (int i = 0; i < pts.length; ++i) {
                                        adjPts[i] = Poly.fromLambda(pts[i].getX() + ni.getAnchorCenterX(), pts[i].getY() + ni.getAnchorCenterY());
                                    }
                                    Poly existing = new Poly(adjPts);
                                    PolyMerge merge = new PolyMerge();
                                    merge.add(Artwork.tech().defaultLayer, existing);
                                    merge.subtract(Artwork.tech().defaultLayer, subtractPoly);
                                    List<PolyBase> polys = merge.getMergedPoints(Artwork.tech().defaultLayer, true);
                                    Iterator<PolyBase> i$ = polys.iterator();
                                    if (!i$.hasNext()) continue;
                                    PolyBase pb = i$.next();
                                    Point2D[] newPts = pb.getPoints();
                                    ni.setTrace(newPts);
                                    subtracted = true;
                                }
                                if (subtracted) break;
                            }
                            PrimitiveNode pNp = this.currentLayer.pNp;
                            this.currentLayer.usingIt();
                            Point2D.Double ctr2 = new Point2D.Double(cX, cY);
                            double width = maxX - minX;
                            double height = maxY - minY;
                            NodeInst ni = NodeInst.makeInstance(pNp, this.ep, ctr2, width, height, this.curCell);
                            ni.setTrace(points);
                        }
                        this.polygonPoints = null;
                        break;
                    }
                    case 70: {
                        this.scaleFactor = 2.54E7 / UNSCALE;
                        break;
                    }
                    case 71: {
                        this.scaleFactor = 1000000.0 / UNSCALE;
                        break;
                    }
                    case 75: {
                        this.fullCircle = true;
                        break;
                    }
                    case 90: {
                        this.absoluteCoordinates = true;
                        break;
                    }
                    case 91: {
                        this.absoluteCoordinates = false;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 60: {
                        this.currentPrepCode = prepCode;
                    }
                }
                continue;
            }
            if (sp2.separator == 'D') {
                int dCode = (int)sp2.value;
                if (dCode != 1 && dCode != 2) continue;
                this.currentDCode = dCode;
                continue;
            }
            if (sp2.separator == 'X') {
                this.curXValue = sp2.value;
                foundCoord = true;
                continue;
            }
            if (sp2.separator == 'Y') {
                this.curYValue = sp2.value;
                foundCoord = true;
                continue;
            }
            if (sp2.separator == 'I') {
                this.curIValue = sp2.value;
                foundCoord = true;
                continue;
            }
            if (sp2.separator != 'J') continue;
            this.curJValue = sp2.value;
            foundCoord = true;
        }
        if (!foundCoord) {
            return;
        }
        if (this.currentPrepCode == 12 || this.currentPrepCode == 11 || this.currentPrepCode == 1 || this.currentPrepCode == 10 || this.currentPrepCode == 60) {
            switch (this.currentPrepCode) {
                case 12: {
                    this.curXValue /= 100.0;
                    this.curYValue /= 100.0;
                    break;
                }
                case 11: {
                    this.curXValue /= 10.0;
                    this.curYValue /= 10.0;
                    break;
                }
                case 10: {
                    this.curXValue *= 10.0;
                    this.curYValue *= 10.0;
                    break;
                }
                case 60: {
                    this.curXValue *= 100.0;
                    this.curYValue *= 100.0;
                }
            }
            if (!this.absoluteCoordinates) {
                this.curXValue += this.lastXValue;
                this.curYValue += this.lastYValue;
            }
            if (this.currentDCode == 1) {
                ctr = new Point2D.Double((this.curXValue + this.lastXValue) / 2.0 * this.scaleFactor, (this.curYValue + this.lastYValue) / 2.0 * this.scaleFactor);
                double width = Math.abs(this.curXValue - this.lastXValue) * this.scaleFactor;
                double height = Math.abs(this.curYValue - this.lastYValue) * this.scaleFactor;
                PolyBase.Point pt1 = Poly.fromLambda(this.lastXValue * this.scaleFactor, this.lastYValue * this.scaleFactor);
                PolyBase.Point pt2 = Poly.fromLambda(this.curXValue * this.scaleFactor, this.curYValue * this.scaleFactor);
                Point2D[] points = new PolyBase.Point[]{pt1, pt2};
                if (this.polygonPoints != null) {
                    this.addPolygonPoints((PolyBase.Point[])points);
                } else {
                    PrimitiveNode pNp = this.currentLayer.pNp;
                    this.currentLayer.usingIt();
                    NodeInst ni = NodeInst.makeInstance(pNp, this.ep, ctr, width, height, this.curCell);
                    if (width != 0.0 && height != 0.0) {
                        ni.setTrace(points);
                    }
                }
            } else if (this.currentDCode == 3) {
                PrimitiveNode pNp = Artwork.tech().filledCircleNode;
                Point2D.Double ctr3 = new Point2D.Double(this.curXValue * this.scaleFactor, this.curYValue * this.scaleFactor);
                double width = 1.0;
                double height = 1.0;
                NodeInst.makeInstance(pNp, this.ep, ctr3, width, height, this.curCell);
            }
            this.lastXValue = this.curXValue;
            this.lastYValue = this.curYValue;
        }
        if (this.currentPrepCode == 2 || this.currentPrepCode == 3) {
            if (!this.absoluteCoordinates) {
                this.curXValue += this.lastXValue;
                this.curYValue += this.lastYValue;
            }
            if (this.currentDCode == 1) {
                ctr = new Point2D.Double((this.lastXValue + this.curIValue) * this.scaleFactor, (this.lastYValue + this.curJValue) * this.scaleFactor);
                Point2D.Double curveStart = new Point2D.Double(this.lastXValue * this.scaleFactor, this.lastYValue * this.scaleFactor);
                Point2D.Double curveEnd = new Point2D.Double(this.curXValue * this.scaleFactor, this.curYValue * this.scaleFactor);
                if (this.currentPrepCode == 3) {
                    Point2D.Double swap = curveStart;
                    curveStart = curveEnd;
                    curveEnd = swap;
                }
                double diameter = ctr.distance(curveStart) * 2.0;
                double rotation = (double)GenMath.figureAngle(ctr, curveEnd) * Math.PI / 1800.0;
                double angle = (double)GenMath.figureAngle(ctr, curveStart) * Math.PI / 1800.0 - rotation;
                if (angle < 0.0) {
                    angle += Math.PI * 2;
                }
                PolyBase.Point[] pointList = Artwork.fillEllipse(ctr, diameter, diameter, rotation, angle);
                if (this.polygonPoints != null) {
                    this.addPolygonPoints(pointList);
                } else {
                    PrimitiveNode pNp = this.currentLayer.pNp;
                    this.currentLayer.usingIt();
                    NodeInst ni = NodeInst.makeInstance(pNp, this.ep, ctr, diameter, diameter, this.curCell);
                    Point2D[] doubledPointList = new Point2D[pointList.length * 2 - 1];
                    for (int i = 0; i < pointList.length; ++i) {
                        doubledPointList[i] = pointList[i];
                        if (i >= pointList.length - 1) continue;
                        doubledPointList[i + pointList.length] = pointList[pointList.length - i - 2];
                    }
                    ni.setTrace(doubledPointList);
                }
            }
            this.lastXValue = this.curXValue;
            this.lastYValue = this.curYValue;
        }
    }

    private void addPolygonPoints(PolyBase.Point[] pts) {
        if (this.polygonPoints.size() != 0) {
            Point2D first = this.polygonPoints.get(0);
            Point2D last2 = this.polygonPoints.get(this.polygonPoints.size() - 1);
            PolyBase.Point firstNew = pts[0];
            PolyBase.Point lastNew = pts[pts.length - 1];
            double dist1 = first.distance(firstNew);
            double dist2 = first.distance(lastNew);
            double dist3 = last2.distance(firstNew);
            double dist4 = last2.distance(lastNew);
            double minDist = Math.min(Math.min(dist1, dist2), Math.min(dist3, dist4));
            if (dist1 == minDist) {
                for (int i = 1; i < pts.length; ++i) {
                    this.polygonPoints.add(0, pts[i]);
                }
                return;
            }
            if (dist2 == minDist) {
                for (int i = pts.length - 2; i >= 0; --i) {
                    this.polygonPoints.add(0, pts[i]);
                }
                return;
            }
            if (dist3 == minDist) {
                for (int i = 1; i < pts.length; ++i) {
                    this.polygonPoints.add(pts[i]);
                }
                return;
            }
            if (dist4 == minDist) {
                for (int i = pts.length - 2; i >= 0; --i) {
                    this.polygonPoints.add(pts[i]);
                }
                return;
            }
        }
        for (int i = 0; i < pts.length; ++i) {
            this.polygonPoints.add(pts[i]);
        }
    }

    private void handleFormatStatement(String line) {
        switch (line.charAt(3)) {
            case 'L': {
                this.currentNumberFormat = NumberFormat.OMIT_LEADING_ZEROS;
                break;
            }
            case 'T': {
                this.currentNumberFormat = NumberFormat.OMIT_TRAILING_ZEROS;
                break;
            }
            case 'D': {
                this.currentNumberFormat = NumberFormat.EXPLICIT_DECIMAL_POINT;
            }
        }
        switch (line.charAt(4)) {
            case 'A': {
                this.absoluteCoordinates = true;
                break;
            }
            case 'I': {
                this.absoluteCoordinates = false;
            }
        }
        int pos = 5;
        while (line.charAt(pos) != '*') {
            int value2 = TextUtils.atoi(line.substring(pos + 1));
            switch (line.charAt(pos)) {
                case 'N': {
                    break;
                }
                case 'G': {
                    break;
                }
                case 'X': {
                    this.xFormatLeft = value2 / 10;
                    this.xFormatRight = value2 % 10;
                    break;
                }
                case 'Y': {
                    this.yFormatLeft = value2 / 10;
                    this.yFormatRight = value2 % 10;
                    break;
                }
                case 'Z': {
                    break;
                }
                case 'D': {
                    break;
                }
            }
            ++pos;
            while (Character.isDigit(line.charAt(pos))) {
                ++pos;
            }
        }
    }

    private void handleEmbeddedUnits(String line) {
        if (line.equals("%MOIN*%")) {
            this.scaleFactor = 2.54E7 / UNSCALE;
        }
        if (line.equals("%MOMM*%")) {
            this.scaleFactor = 1000000.0 / UNSCALE;
        }
    }

    private void handleImagePolarity(String line) {
    }

    private void handleStandardShape(String line) {
        int codeNumber = TextUtils.atoi(line.substring(4));
        int pos = 4;
        while (Character.isDigit(line.charAt(pos))) {
            ++pos;
        }
        if (line.charAt(pos) == 'C') {
            List<StringPart> parts = this.parseString(line.substring(pos + 1));
            if (parts.size() < 1 || parts.size() > 3) {
                System.out.println("Illegal Standard Circle statement: " + line);
                return;
            }
            StandardCircle sc = new StandardCircle();
            sc.codeNumber = codeNumber;
            sc.diameter = parts.get((int)0).value;
            sc.holeSize1 = parts.size() > 1 ? parts.get((int)1).value : -1.0;
            sc.holeSize2 = parts.size() > 2 ? parts.get((int)2).value : -1.0;
            this.standardCircles.put(new Integer(codeNumber), sc);
        } else if (line.charAt(pos) == 'R') {
            List<StringPart> parts = this.parseString(line.substring(pos + 1));
            if (parts.size() != 2 || parts.size() != 4) {
                System.out.println("Illegal Standard Rectangle statement: " + line);
                return;
            }
            StandardRectangle sr = new StandardRectangle();
            sr.codeNumber = codeNumber;
            sr.width = parts.get((int)0).value;
            sr.height = parts.get((int)1).value;
            if (parts.size() > 2) {
                sr.holeWidth = parts.get((int)2).value;
                sr.holeHeight = parts.get((int)3).value;
            } else {
                sr.holeWidth = -1.0;
                sr.holeHeight = -1.0;
            }
            this.standardRectangles.put(new Integer(codeNumber), sr);
        }
    }

    private List<StringPart> parseString(String str) {
        ArrayList<StringPart> parts = new ArrayList<StringPart>();
        int pos = 0;
        StringBuffer sb = new StringBuffer();
        while (str.charAt(pos) != '*') {
            StringPart sp2 = new StringPart();
            sp2.separator = str.charAt(pos);
            sb.delete(0, sb.length());
            boolean foundDecimal = false;
            boolean neg = false;
            while (true) {
                int n = ++pos;
                ++pos;
                char nxt = str.charAt(n);
                if (nxt != '-' && nxt != '.' && !Character.isDigit(nxt)) break;
                if (nxt == '-') {
                    neg = true;
                    continue;
                }
                sb.append(nxt);
                if (nxt != '.') continue;
                foundDecimal = true;
            }
            --pos;
            if (foundDecimal || sp2.separator == 'G' || sp2.separator == 'D' || sp2.separator == 'M') {
                sp2.value = TextUtils.atof(sb.toString());
                if (sp2.value == 4.0) {
                    break;
                }
            } else {
                int left = this.xFormatLeft;
                int right = this.xFormatRight;
                if (sp2.separator == 'Y') {
                    left = this.yFormatLeft;
                    right = this.yFormatRight;
                }
                switch (this.currentNumberFormat) {
                    case OMIT_LEADING_ZEROS: {
                        sb.insert(sb.length() - right, '.');
                        break;
                    }
                    case OMIT_TRAILING_ZEROS: {
                        while (sb.length() < left) {
                            sb.append('0');
                        }
                        sb.insert(left, '.');
                        break;
                    }
                }
                sp2.value = TextUtils.atof(sb.toString());
            }
            if (neg) {
                sp2.value = -sp2.value;
            }
            parts.add(sp2);
        }
        return parts;
    }

    public static class GerberPreferences
    extends Input.InputPreferences {
        private boolean justThisFile;
        private boolean fillPolygons;

        public GerberPreferences(boolean factory) {
            super(factory);
            if (!factory) {
                this.justThisFile = !IOTool.isGerberReadsAllFiles();
                this.fillPolygons = IOTool.isGerberFillsPolygons();
            }
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, EditingPreferences ep, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            Gerber in = new Gerber(ep, this);
            if (this.justThisFile) {
                if (in.openTextInput(fileURL)) {
                    return null;
                }
                lib = in.importALibrary(lib, tech, currentCells);
                in.closeInput();
            } else {
                lib = in.importALibrary(lib, tech, currentCells);
            }
            return lib;
        }
    }

    static enum NumberFormat {
        OMIT_LEADING_ZEROS,
        OMIT_TRAILING_ZEROS,
        EXPLICIT_DECIMAL_POINT;

    }

    private static class GerberLayer {
        String layerName;
        boolean mentionedUse;
        boolean polarityDark;
        PrimitiveNode pNp;
        private static int ePrimitiveIndex = 0;
        private static PrimitiveNode[] ePrimitives = null;
        private static Map<String, GerberLayer> allLayers = new HashMap<String, GerberLayer>();

        public GerberLayer(PrimitiveNode pNp) {
            this.pNp = pNp;
            this.polarityDark = true;
            this.mentionedUse = false;
        }

        public void usingIt() {
            if (this.mentionedUse) {
                return;
            }
            this.mentionedUse = true;
            System.out.println("Importing layer name '" + this.layerName + "' (polarity " + (this.polarityDark ? "dark" : "light") + ") into layer " + this.pNp.getName());
        }

        public static GerberLayer findLayer(String name) {
            GerberLayer gl = allLayers.get(name);
            if (gl == null) {
                if (ePrimitives == null) {
                    ePrimitives = new PrimitiveNode[16];
                    int j = 0;
                    for (int i = 0; i < 8; ++i) {
                        GerberLayer.ePrimitives[j++] = pcbTech.findNodeProto("Signal-" + (i + 1) + "-Node");
                        GerberLayer.ePrimitives[j++] = pcbTech.findNodeProto("Power-" + (i + 1) + "-Node");
                    }
                }
                gl = new GerberLayer(ePrimitives[ePrimitiveIndex % ePrimitives.length]);
                ++ePrimitiveIndex;
                allLayers.put(name, gl);
                gl.layerName = name;
            }
            return gl;
        }

        public void setPolarity(boolean dark) {
            this.polarityDark = dark;
        }
    }

    private static class StandardRectangle {
        int codeNumber;
        double width;
        double height;
        double holeWidth;
        double holeHeight;

        private StandardRectangle() {
        }
    }

    private static class StandardCircle {
        int codeNumber;
        double diameter;
        double holeSize1;
        double holeSize2;

        private StandardCircle() {
        }
    }

    private static class StringPart {
        char separator;
        double value;

        private StringPart() {
        }
    }
}

