/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.generator.flag.Flag;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.routing.SeaOfGates;

public class FlagJob
extends Job {
    static final long serialVersionUID = 0L;
    private SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();

    private static void prln(String msg) {
        System.out.println(msg);
    }

    public FlagJob() {
        super("Generate layout for Infinity", NetworkTool.getNetworkTool(), Job.Type.CHANGE, null, null, Job.Priority.ANALYSIS);
        this.prefs.getOptionsFromPreferences();
        this.startJob();
    }

    @Override
    public boolean doIt() throws JobException {
        CellContext cc = NccUtils.getCurrentCellContext();
        if (cc == null) {
            return true;
        }
        Cell cell = cc.cell;
        if (!cell.isSchematic()) {
            FlagJob.prln("Current cell must be a schematic for which you wish to generate Infinity layout");
            return true;
        }
        new Flag(cell, this, this.prefs);
        return true;
    }
}

