/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.result.BenchmarkResults;
import com.sun.electric.tool.ncc.strategy.StratHashParts;
import com.sun.electric.tool.ncc.strategy.StratHashWires;
import com.sun.electric.tool.ncc.strategy.StratPortName;
import com.sun.electric.tool.ncc.strategy.StratRandomMatch;
import com.sun.electric.tool.ncc.strategy.StratSizes;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.LeafEquivRecords;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HashCodePartitioning {
    NccGlobals globals;

    private void hashAllParts(NccGlobals globals) {
        LeafList newBornList;
        EquivRecord er;
        HashCodePropagator hashProp = new HashCodePropagator(globals);
        if (globals.getParts() == null) {
            return;
        }
        globals.status2("----- hash all Parts");
        Iterator<EquivRecord> eIt = globals.getPartLeafEquivRecs().getNotMatched();
        while (eIt.hasNext()) {
            er = eIt.next();
            if (!er.isLeaf() || er.isMismatched()) continue;
            newBornList = StratHashParts.doYourJob(er, globals);
            hashProp.propagateFromNewBorns(newBornList);
        }
        eIt = globals.getPartLeafEquivRecs().getMatched();
        while (eIt.hasNext()) {
            er = eIt.next();
            if (!er.isLeaf() || er.isMismatched()) continue;
            newBornList = StratHashParts.doYourJob(er, globals);
            hashProp.propagateFromNewBorns(newBornList);
        }
        globals.initLeafLists();
    }

    private void hashFrontierParts(HashCodePropagator hashProp) {
        if (this.globals.getParts() == null) {
            return;
        }
        this.globals.status2("----- hash all Parts on frontier");
        Iterator<EquivRecord> eIt = this.globals.getPartLeafEquivRecs().getNotMatched();
        while (eIt.hasNext()) {
            EquivRecord er = eIt.next();
            if (!er.isLeaf() || er.isMismatched()) continue;
            LeafList newBornList = StratHashParts.doYourJob(er, this.globals);
            hashProp.propagateFromNewBorns(newBornList);
        }
    }

    private void hashFrontierWires(HashCodePropagator hashProp) {
        if (this.globals.getWires() == null) {
            return;
        }
        this.globals.status2("----- hash all Wires on frontier");
        Iterator<EquivRecord> eIt = this.globals.getWireLeafEquivRecs().getNotMatched();
        while (eIt.hasNext()) {
            EquivRecord er = eIt.next();
            if (!er.isLeaf() || er.isMismatched()) continue;
            LeafList newBornList = StratHashWires.doYourJob(er, this.globals);
            hashProp.propagateFromNewBorns(newBornList);
        }
    }

    private void hashFrontier(HashCodePropagator hashProp) {
        this.globals.status2("----- hash all NetObjects on frontier");
        this.hashFrontierParts(hashProp);
        this.hashFrontierWires(hashProp);
    }

    private boolean done() {
        return this.globals.getWireLeafEquivRecs().numNotMatched() == 0 && this.globals.getPartLeafEquivRecs().numNotMatched() == 0;
    }

    private void useExportNames(HashCodePropagator hashProp) {
        LeafList offspring;
        this.globals.status2("----- use Export Names");
        while ((offspring = StratPortName.doYourJob(this.globals)).size() != 0) {
            hashProp.propagateFromNewBorns(offspring);
        }
    }

    private void useTransistorSizes(HashCodePropagator hashProp) {
        LeafList offspring;
        this.globals.status2("----- use transistor sizes");
        while ((offspring = StratSizes.doYourJob(this.globals)).size() != 0) {
            hashProp.propagateFromNewBorns(offspring);
        }
    }

    private void randomMatch(HashCodePropagator hashProp) {
        LeafList offspring;
        this.globals.status2("----- random matching");
        while ((offspring = StratRandomMatch.doYourJob(this.globals)).size() != 0) {
            hashProp.propagateFromNewBorns(offspring);
        }
    }

    private void doWork() {
        long start = NccUtils.getTime();
        HashCodePropagator hashProp = new HashCodePropagator(this.globals);
        this.hashAllParts(this.globals);
        if (this.done()) {
            return;
        }
        Date d1 = new Date();
        hashProp = new HashCodePropagator(this.globals);
        this.hashFrontier(hashProp);
        start = NccUtils.registerTiming("  Hashing frontier took: ", start, BenchmarkResults.BenchIdx.HASH_CODE_PASS1_TIME, this.globals);
        if (this.done() || this.globals.userWantsToAbort()) {
            return;
        }
        this.useExportNames(hashProp);
        hashProp = new HashCodePropagator(this.globals);
        this.hashAllParts(this.globals);
        start = NccUtils.registerTiming("  Using export names took: ", start, BenchmarkResults.BenchIdx.EXPORT_MATCHING_TIME, this.globals);
        if (this.done() || this.globals.userWantsToAbort()) {
            return;
        }
        this.useTransistorSizes(hashProp);
        hashProp = new HashCodePropagator(this.globals);
        this.hashAllParts(this.globals);
        start = NccUtils.registerTiming("  Using transistor sizes took: ", start, BenchmarkResults.BenchIdx.SIZE_MATCHING_TIME, this.globals);
        if (this.done() || this.globals.userWantsToAbort()) {
            return;
        }
        boolean preGuessMismatch = this.hasMismatch();
        this.randomMatch(hashProp);
        hashProp = new HashCodePropagator(this.globals);
        this.hashAllParts(this.globals);
        start = NccUtils.registerTiming("  Random match took: ", start, BenchmarkResults.BenchIdx.RANDOM_MATCHING_TIME, this.globals);
        if (!preGuessMismatch && this.hasMismatch()) {
            NccUtils.incrementBenchmarkCount(BenchmarkResults.BenchIdx.MAYBE_RESULT, this.globals);
        }
    }

    private boolean hasMismatch() {
        LeafEquivRecords partLeafEquivRecs = this.globals.getPartLeafEquivRecs();
        LeafEquivRecords wireLeafEquivRecs = this.globals.getWireLeafEquivRecs();
        Iterator<EquivRecord> eIt = partLeafEquivRecs.getNotMatched();
        while (eIt.hasNext()) {
            if (!eIt.next().isMismatched()) continue;
            return true;
        }
        eIt = wireLeafEquivRecs.getNotMatched();
        while (eIt.hasNext()) {
            if (!eIt.next().isMatched()) continue;
            return true;
        }
        return false;
    }

    private boolean allPartsWiresMatch() {
        return this.globals.getPartLeafEquivRecs().numNotMatched() == 0 && this.globals.getWireLeafEquivRecs().numNotMatched() == 0;
    }

    private HashCodePartitioning(NccGlobals globals) {
        this.globals = globals;
        globals.status2("----- starting HashCodePartitioningNew");
        this.doWork();
        globals.status2("----- done HashCodePartitioningNew");
    }

    public static boolean doYourJob(NccGlobals globals) {
        HashCodePartitioning p = new HashCodePartitioning(globals);
        return p.allPartsWiresMatch();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashCodePropagator {
        NccGlobals globals;
        private final int MAX_REC_BIRTHDAYS = 5000;
        private int todaysDate = 1;
        private Map<EquivRecord, Integer> recToRehashDate = new HashMap<EquivRecord, Integer>();
        private LinkedList<ChildAndBirthday> matchedNewBorns = new LinkedList();
        private LinkedList<ChildAndBirthday> activeNewBorns = new LinkedList();
        private LinkedList<ChildAndBirthday> mismatchedNewBorns = new LinkedList();

        private ChildAndBirthday selectHighPriorityNewBorn2() {
            if (!this.matchedNewBorns.isEmpty()) {
                return this.matchedNewBorns.removeFirst();
            }
            if (!this.activeNewBorns.isEmpty()) {
                return this.activeNewBorns.removeFirst();
            }
            if (!this.mismatchedNewBorns.isEmpty()) {
                return this.mismatchedNewBorns.removeFirst();
            }
            return null;
        }

        private ChildAndBirthday selectHighPriorityNewBorn() {
            ChildAndBirthday cf;
            do {
                if ((cf = this.selectHighPriorityNewBorn2()) != null) continue;
                return null;
            } while (!cf.child.isLeaf());
            return cf;
        }

        private void addAll(LeafList newBorns) {
            ++this.todaysDate;
            if (this.recToRehashDate.size() > 5000) {
                this.globals.status1("  NCC: Reached MAX_REC_BIRTHDAYS: 5000");
                this.recToRehashDate.clear();
            }
            Iterator<EquivRecord> erIt = newBorns.iterator();
            while (erIt.hasNext()) {
                EquivRecord er = erIt.next();
                Job.error(er == null, "null not allowed");
                if (er.isMatched()) {
                    this.matchedNewBorns.add(new ChildAndBirthday(er, this.todaysDate));
                    continue;
                }
                if (er.isMismatched()) {
                    this.mismatchedNewBorns.add(new ChildAndBirthday(er, this.todaysDate));
                    continue;
                }
                this.activeNewBorns.add(new ChildAndBirthday(er, this.todaysDate));
            }
            ++this.todaysDate;
        }

        private List<EquivRecord> findStaleAdjacentTo(ChildAndBirthday cb) {
            int childsBirthday = cb.birthday;
            EquivRecord child = cb.child;
            ArrayList<EquivRecord> adjacent = new ArrayList<EquivRecord>();
            Iterator<Circuit> ci = child.getCircuits();
            while (ci.hasNext()) {
                Circuit jc = ci.next();
                Iterator<NetObject> ni = jc.getNetObjs();
                while (ni.hasNext()) {
                    NetObject netObj = ni.next();
                    Iterator<NetObject> it = netObj.getConnected();
                    while (it.hasNext()) {
                        EquivRecord neighbor = it.next().getParent().getParent();
                        if (neighbor.isActive()) {
                            Integer rehashDate = this.recToRehashDate.get(neighbor);
                            if (rehashDate != null && rehashDate >= childsBirthday) continue;
                            adjacent.add(neighbor);
                            this.recToRehashDate.put(neighbor, this.todaysDate);
                            continue;
                        }
                        this.recToRehashDate.remove(neighbor);
                    }
                }
            }
            return adjacent;
        }

        private List<EquivRecord> findStaleAdjacentToHighestPriorityNewBorn() {
            ChildAndBirthday cb;
            List<EquivRecord> adjacent;
            do {
                if ((cb = this.selectHighPriorityNewBorn()) != null) continue;
                return new ArrayList<EquivRecord>();
            } while ((adjacent = this.findStaleAdjacentTo(cb)).isEmpty());
            return adjacent;
        }

        public HashCodePropagator(NccGlobals glob) {
            this.globals = glob;
        }

        public void propagateFromNewBorns(LeafList newBornList) {
            List<EquivRecord> adjacent;
            this.addAll(newBornList);
            while (!(adjacent = this.findStaleAdjacentToHighestPriorityNewBorn()).isEmpty()) {
                for (EquivRecord er : adjacent) {
                    if (!er.isLeaf()) continue;
                    NccUtils.incrementBenchmarkCount(BenchmarkResults.BenchIdx.NEWBORNS_PROCESSED, this.globals);
                    if (er.getNetObjType() == NetObject.Type.PART) {
                        this.addAll(StratHashParts.doYourJob(er, this.globals));
                        continue;
                    }
                    this.addAll(StratHashWires.doYourJob(er, this.globals));
                }
            }
        }

        public static class ChildAndBirthday {
            EquivRecord child;
            int birthday;

            ChildAndBirthday(EquivRecord child, int birthday) {
                this.child = child;
                this.birthday = birthday;
            }
        }
    }
}

