/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibDirs;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;

public class OpenFile {
    public static String chooseInputFile(FileType type, String title) {
        return OpenFile.chooseInputFile(type, title, false, User.getWorkingDirectory(), true);
    }

    public static String chooseDirectory(String title) {
        return OpenFile.chooseInputFile(null, title, true, User.getWorkingDirectory(), true);
    }

    public static String chooseInputFile(FileType type, String title, boolean wantDirectory) {
        return OpenFile.chooseInputFile(type, title, wantDirectory, User.getWorkingDirectory(), true);
    }

    public static String chooseInputFile(FileType type, String title, boolean wantDirectory, String initialDir, boolean setSelectedDirAsWorkingDir) {
        String path;
        if (title == null) {
            title = wantDirectory ? "Choose Directory" : "Open file";
            if (type != null) {
                title = "Open " + type.getDescription();
            }
        }
        boolean useSwing = true;
        String string = path = type != null ? type.getGroupPath() : null;
        if (path != null) {
            initialDir = path;
        }
        if (useSwing) {
            OpenFileSwing dialog = new OpenFileSwing();
            dialog.saveDialog = false;
            dialog.setSelectedDirAsWorkingDir = setSelectedDirAsWorkingDir;
            dialog.fileType = type;
            dialog.setDialogTitle(title);
            File dir = new File(initialDir);
            if (!dir.exists() || !dir.isDirectory()) {
                dir = new File(User.getWorkingDirectory());
            }
            dialog.setCurrentDirectory(dir);
            if (type != null) {
                if (type == FileType.ELIB || type == FileType.JELIB || type == FileType.DELIB || type == FileType.LIBFILE || type == FileType.LIBRARYFORMATS) {
                    LibDirs.LibDirFileSystemView view = LibDirs.newLibDirFileSystemView(dialog.getFileSystemView());
                    dialog.setFileSystemView(view);
                    dialog.setFileView(new LibDirs.LibDirFileView(view));
                }
                dialog.setFileFilter(type.getFileFilterSwing());
            }
            if (wantDirectory) {
                dialog.setFileSelectionMode(1);
            }
            JFrame chooseFrame = new JFrame();
            chooseFrame.setIconImage(TopLevel.getFrameIcon().getImage());
            int returnVal = dialog.showOpenDialog(chooseFrame);
            if (returnVal == 0) {
                File file = dialog.getSelectedFile();
                return file.getPath();
            }
            return null;
        }
        FileDialog dialog = new FileDialog((Frame)TopLevel.getCurrentJFrame(), title, 0);
        dialog.setDirectory(User.getWorkingDirectory());
        if (type != null) {
            dialog.setFilenameFilter(type.getFileFilterAWT());
        }
        dialog.setVisible(true);
        String fileName = dialog.getFile();
        if (fileName == null) {
            return null;
        }
        User.setWorkingDirectory(dialog.getDirectory());
        return dialog.getDirectory() + fileName;
    }

    public static String chooseOutputFile(FileType type, String title, String defaultFile) {
        FileType[] types = type == null ? null : new FileType[]{type};
        return OpenFile.chooseOutputFile(types, title, defaultFile);
    }

    public static String chooseOutputFile(FileType[] types, String title, String defaultFile) {
        if (title == null) {
            title = types != null ? "Write " + types[0].getDescription() : "Write file";
        }
        if (types == null) {
            types = new FileType[]{FileType.ANY};
        }
        boolean useSwing = true;
        if (Client.isOSMac()) {
            useSwing = false;
        }
        String initialDir = User.getWorkingDirectory();
        String path = types[0].getGroupPath();
        if (path != null) {
            initialDir = path;
        }
        if (useSwing) {
            OpenFileSwing dialog = new OpenFileSwing();
            dialog.saveDialog = true;
            dialog.setDialogTitle(title);
            for (int i = 0; i < types.length; ++i) {
                dialog.addChoosableFileFilter(types[i].getFileFilterSwing());
            }
            dialog.setCurrentDirectory(new File(initialDir));
            if (defaultFile != null) {
                dialog.setFileFilter(FileMenu.getLibraryFormat(defaultFile, types[0]).getFileFilterSwing());
                dialog.setSelectedFile(new File(defaultFile));
            }
            JFrame chooseFrame = new JFrame();
            chooseFrame.setIconImage(TopLevel.getFrameIcon().getImage());
            int returnVal = dialog.showSaveDialog(chooseFrame);
            if (returnVal == 0) {
                File file = dialog.getSelectedFile();
                String fileName = file.getPath();
                FileType selectedType = FileType.getType(dialog.getFileFilter());
                if (selectedType != null) {
                    String dir = TextUtils.getFilePath(TextUtils.makeURLToFile(fileName));
                    selectedType.setGroupPath(dir);
                    String extension = selectedType.getExtensions()[0];
                    int dotPos = fileName.lastIndexOf(46);
                    if (dotPos < 0) {
                        fileName = fileName + "." + extension;
                    } else if (!fileName.substring(dotPos + 1).startsWith(extension)) {
                        fileName = fileName + "." + extension;
                    }
                }
                return fileName;
            }
            return null;
        }
        FileDialog awtDialog = new FileDialog((Frame)TopLevel.getCurrentJFrame(), title, 1);
        awtDialog.setDirectory(initialDir);
        awtDialog.setFile(defaultFile);
        awtDialog.setFilenameFilter(types[0].getFileFilterAWT());
        awtDialog.setVisible(true);
        String fileName = awtDialog.getFile();
        if (fileName == null) {
            return null;
        }
        types[0].setGroupPath(awtDialog.getDirectory());
        return awtDialog.getDirectory() + fileName;
    }

    public static FileType getOpenFileType(String libName, FileType def) {
        File libFile = new File(libName);
        if ((libName = libFile.getName()).endsWith(File.separator)) {
            libName = libName.substring(0, libName.length() - 1);
        }
        if (libName.endsWith(".elib")) {
            return FileType.ELIB;
        }
        if (libName.endsWith(".jelib")) {
            return FileType.JELIB;
        }
        if (libName.endsWith(".delib")) {
            return FileType.DELIB;
        }
        if (libName.endsWith(".txt")) {
            return FileType.READABLEDUMP;
        }
        return def;
    }

    private static class OpenFileSwing
    extends JFileChooser {
        private boolean saveDialog;
        private boolean setSelectedDirAsWorkingDir;
        File lastDELIBVisit = null;
        private FileType fileType;

        private OpenFileSwing() {
        }

        public void approveSelection() {
            File f = this.getSelectedFile();
            if (this.saveDialog) {
                int result;
                String filename = f.getName();
                if (f.exists() && (result = JOptionPane.showConfirmDialog(this, "The file " + filename + " already exists, would you like to overwrite it?", "Overwrite?", 0, 2)) != 0) {
                    return;
                }
            } else {
                FileSystemView view = this.getFileSystemView();
                if (view instanceof LibDirs.LibDirFileSystemView && !f.exists()) {
                    Iterator<String> it = LibDirs.getLibDirs();
                    while (it.hasNext()) {
                        File newFile;
                        String dirName = it.next();
                        File dir = new File(dirName);
                        if (!dir.exists() || !dir.isDirectory() || !(newFile = new File(dir, f.getName())).exists()) continue;
                        f = newFile;
                        break;
                    }
                }
            }
            this.setSelectedFile(f);
            if (this.setSelectedDirAsWorkingDir) {
                User.setWorkingDirectory(this.getCurrentDirectory().getPath());
            }
            if (this.fileType != null) {
                this.fileType.setGroupPath(this.getCurrentDirectory().getPath());
            }
            super.approveSelection();
        }

        public boolean isTraversable(File f) {
            this.lastDELIBVisit = null;
            if (f == null) {
                return false;
            }
            if (f.getName().toLowerCase().endsWith("." + FileType.DELIB.getExtensions()[0])) {
                this.lastDELIBVisit = f;
                return false;
            }
            return super.isTraversable(f);
        }

        public boolean isDirectorySelectionEnabled() {
            File file = this.getSelectedFile();
            if (file == null && this.lastDELIBVisit != null) {
                file = this.lastDELIBVisit;
            }
            if (file != null && super.getFileSelectionMode() != 1 && file.getName().toLowerCase().endsWith("." + FileType.DELIB.getExtensions()[0])) {
                return true;
            }
            return super.isDirectorySelectionEnabled();
        }
    }
}

