/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ColorPatternPanel;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtworkLook
extends EModelessDialog
implements HighlightListener {
    private ColorPatternPanel.Info li;
    private List<Geometric> artworkObjects;
    private ColorPatternPanel colorPatternPanel;
    private static ArtworkLook theDialog;
    private JButton apply;
    private JButton cancel;
    private JButton ok;

    public static void showArtworkLookDialog() {
        List<Geometric> artObjects = ArtworkLook.findSelectedArt();
        if (artObjects.size() == 0) {
            System.out.println("Selected object must be from the Artwork technology");
            return;
        }
        if (Client.getOperatingSystem() == Client.OS.UNIX) {
            if (theDialog != null) {
                theDialog.dispose();
            }
            theDialog = null;
        }
        if (theDialog == null) {
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new ArtworkLook((Frame)jf, artObjects);
        } else {
            theDialog.showArtworkObjects(artObjects);
        }
        if (!theDialog.isVisible()) {
            theDialog.pack();
            theDialog.ensureProperSize();
            theDialog.setVisible(true);
        }
        theDialog.toFront();
    }

    private static List<Geometric> findSelectedArt() {
        ArrayList<Geometric> artworkObjects = new ArrayList<Geometric>();
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return artworkObjects;
        }
        List<Geometric> objects = wnd.getHighlighter().getHighlightedEObjs(true, true);
        for (Geometric geom : objects) {
            ArcInst ai;
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                if (ni.isCellInstance() || ni.getProto().getTechnology() != Artwork.tech()) continue;
                artworkObjects.add(ni);
                continue;
            }
            if (!(geom instanceof ArcInst) || (ai = (ArcInst)geom).getProto().getTechnology() != Artwork.tech()) continue;
            artworkObjects.add(ai);
        }
        return artworkObjects;
    }

    public ArtworkLook(Frame parent, List<Geometric> artObjects) {
        super(parent, false);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.colorPatternPanel = new ColorPatternPanel(false, false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.colorPatternPanel, gbc);
        this.pack();
        Technology tech = Technology.getCurrent();
        Color[] map = new Color[tech.getNumTransparentLayers()];
        Color[] fullMap = tech.getColorMap();
        for (int i = 0; i < map.length; ++i) {
            map[i] = fullMap[1 << i];
        }
        this.colorPatternPanel.setColorMap(map);
        this.showArtworkObjects(artObjects);
        this.finishInitialization();
        Highlighter.addHighlightListener(this);
    }

    @Override
    protected void escapePressed() {
        this.cancel(null);
    }

    private void showArtworkObjects(List<Geometric> artObjects) {
        this.artworkObjects = artObjects;
        if (this.artworkObjects.size() == 0) {
            this.li = null;
        } else {
            EGraphics graphics = Artwork.makeGraphics(this.artworkObjects.get(0));
            if (graphics == null) {
                graphics = new EGraphics(false, false, null, 0, 0, 0, 0, 0.8, true, new int[]{65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535});
            }
            this.li = new ColorPatternPanel.Info(graphics);
        }
        this.colorPatternPanel.setColorPattern(this.li);
    }

    @Override
    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        List<Geometric> artObjects = ArtworkLook.findSelectedArt();
        this.showArtworkObjects(artObjects);
    }

    @Override
    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        List<Geometric> artObjects = ArtworkLook.findSelectedArt();
        this.showArtworkObjects(artObjects);
    }

    private void applyDialog() {
        if (this.li == null) {
            return;
        }
        if (this.li.updateGraphics(this.li.graphics)) {
            int transparent = this.li.graphics.getTransparentLayer();
            Color newColor = this.li.graphics.getColor();
            int index = -1;
            if (transparent != 0 || newColor != Color.BLACK) {
                index = transparent > 0 ? EGraphics.makeIndex(transparent) : EGraphics.makeIndex(newColor);
            }
            Integer[] pat = null;
            if (this.li.graphics.isPatternedOnDisplay()) {
                int[] pattern = this.li.graphics.getPattern();
                pat = new Integer[17];
                for (int i = 0; i < 16; ++i) {
                    pat[i] = new Integer(pattern[i]);
                }
                pat[16] = new Integer(this.li.graphics.getOutlined().getIndex());
            }
            new ApplyChanges(this.artworkObjects, index, pat);
        }
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.apply = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Artwork Color and Pattern");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ArtworkLook.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArtworkLook.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArtworkLook.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArtworkLook.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.pack();
    }

    private void applyActionPerformed(ActionEvent evt) {
        this.applyDialog();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        this.applyDialog();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        Highlighter.removeHighlightListener(this);
        this.dispose();
        theDialog = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ApplyChanges
    extends Job {
        private List<Geometric> artworkObjects;
        private int index;
        private Integer[] pat;

        protected ApplyChanges(List<Geometric> artworkObjects, int index, Integer[] pat) {
            super("Change Artwork Appearance", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.artworkObjects = artworkObjects;
            this.index = index;
            this.pat = pat;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            for (Geometric eObj : this.artworkObjects) {
                if (this.index == -1) {
                    if (eObj.getVarValue(Artwork.ART_COLOR, Integer.class) != null) {
                        eObj.delVar(Artwork.ART_COLOR);
                    }
                } else {
                    eObj.newVar(Artwork.ART_COLOR, (Object)new Integer(this.index));
                }
                if (this.pat != null) {
                    eObj.newVar(Artwork.ART_PATTERN, (Object)this.pat);
                    continue;
                }
                if (eObj.getVar(Artwork.ART_PATTERN) == null) continue;
                eObj.delVar(Artwork.ART_PATTERN);
            }
            return true;
        }
    }
}

