/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.CellId;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.user.ErrorHighArc;
import com.sun.electric.tool.user.ErrorHighExport;
import com.sun.electric.tool.user.ErrorHighLine;
import com.sun.electric.tool.user.ErrorHighNode;
import com.sun.electric.tool.user.Highlighter;
import java.awt.geom.Point2D;
import java.io.PrintStream;
import java.io.Serializable;

public abstract class ErrorHighlight
implements Serializable {
    public static final ErrorHighlight[] NULL_ARRAY = new ErrorHighlight[0];
    private final CellId cellId;
    private final VarContext context;

    ErrorHighlight(Cell c, VarContext con) {
        this.cellId = c != null ? c.getId() : null;
        this.context = con;
    }

    public Cell getCell(EDatabase database) {
        return this.cellId != null ? database.getCell(this.cellId) : null;
    }

    VarContext getVarContext() {
        return this.context;
    }

    boolean containsObject(Cell cell, Object obj) {
        return false;
    }

    Object getObject(EDatabase database) {
        return null;
    }

    void xmlDescription(PrintStream msg, EDatabase database) {
        System.out.println("Not implemented in xmlDescription");
    }

    boolean isValid(EDatabase database) {
        return this.cellId == null || this.getCell(database) != null;
    }

    public void addToHighlighter(Highlighter h, EDatabase database) {
    }

    public static ErrorHighlight newInstance(VarContext context, Geometric geom) {
        if (geom instanceof NodeInst) {
            return new ErrorHighNode(context, (NodeInst)geom);
        }
        return new ErrorHighArc(context, (ArcInst)geom);
    }

    public static ErrorHighlight newInstance(Cell cell, Point2D p1, Point2D p2) {
        return new ErrorHighLine(cell, EPoint.snap(p1), EPoint.snap(p2), false);
    }

    public static ErrorHighlight newInstance(Export e) {
        return new ErrorHighExport(null, e);
    }
}

