/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.VerticalRoute;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public abstract class InteractiveRouter
extends Router {
    private List<Highlight2> startRouteHighlights = new ArrayList<Highlight2>();
    private boolean started;
    private EditWindow wnd;
    private ElectricObject badStartObject;
    private ElectricObject badEndObject;

    public InteractiveRouter() {
        this.verbose = true;
        this.started = false;
        this.badEndObject = null;
        this.badStartObject = null;
        this.wnd = null;
        this.tool = Routing.getRoutingTool();
    }

    public String toString() {
        return "Interactive Router";
    }

    protected abstract boolean planRoute(Route var1, Cell var2, RouteElementPort var3, Point2D var4, Point2D var5, Point2D var6, PolyMerge var7, VerticalRoute var8, boolean var9, boolean var10, boolean var11);

    public void startInteractiveRoute(EditWindow wnd) {
        this.wnd = wnd;
        this.startRouteHighlights.clear();
        for (Highlight2 h : wnd.getHighlighter().getHighlights()) {
            this.startRouteHighlights.add(h);
        }
        wnd.clearHighlighting();
        this.started = true;
    }

    public void cancelInteractiveRoute() {
        Highlighter highlighter = this.wnd.getHighlighter();
        highlighter.clear();
        highlighter.setHighlightList(this.startRouteHighlights);
        highlighter.finished();
        this.wnd = null;
        this.started = false;
    }

    public void makeRoute(EditWindow wnd, Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        Route route = this.planRoute(cell, startObj, endObj, clicked, null, true, true);
        wnd.clearHighlighting();
        wnd.getHighlighter().setHighlightList(this.startRouteHighlights);
        this.createRoute(route, cell);
        this.started = false;
    }

    public boolean makeVerticalRoute(EditWindow wnd, PortInst startPort, ArcProto arc) {
        if (startPort.getPortProto().connectsTo(arc)) {
            return true;
        }
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        Point2D.Double startLoc = new Point2D.Double(startPort.getPoly().getCenterX(), startPort.getPoly().getCenterY());
        Poly poly = InteractiveRouter.getConnectingSite(startPort, startLoc, -1.0);
        RouteElementPort startRE = RouteElementPort.existingPortInst(startPort, poly);
        Route route = new Route();
        route.add(startRE);
        route.setStart(startRE);
        VerticalRoute vroute = VerticalRoute.newRoute(startPort.getPortProto(), arc);
        if (!vroute.isSpecificationSucceeded()) {
            this.cancelInteractiveRoute();
            return false;
        }
        vroute.buildRoute(route, startRE.getCell(), startRE, null, startLoc, startLoc, startLoc, null);
        wnd.finishedHighlighting();
        wnd.getHighlighter().setHighlightList(this.startRouteHighlights);
        new MakeVerticalRouteJob(this, route, startPort.getNodeInst().getParent(), true);
        this.started = false;
        return true;
    }

    public void highlightRoute(EditWindow wnd, Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        Route route = this.planRoute(cell, startObj, endObj, clicked, null, true, true);
        this.highlightRoute(wnd, route, cell);
    }

    public void highlightRoute(EditWindow wnd, Route route, Cell cell) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        wnd.clearHighlighting();
        for (RouteElement e : route) {
            e.addHighlightArea(wnd.getHighlighter());
        }
        wnd.finishedHighlighting();
    }

    public Route planRoute(Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked, PolyMerge stayInside, boolean extendArcHead, boolean extendArcTail) {
        double endArcWidth;
        PortProto endPort;
        Route route = new Route();
        if (cell == null) {
            return route;
        }
        RouteElementPort startRE = null;
        RouteElementPort endRE = null;
        startObj = InteractiveRouter.filterRouteObject(startObj, clicked);
        endObj = InteractiveRouter.filterRouteObject(endObj, clicked);
        PortProto startPort = InteractiveRouter.getRoutePort(startObj);
        if (startPort == null) {
            return route;
        }
        if (endObj == null) {
            ArcProto useArc = InteractiveRouter.getArcToUse(startPort, null);
            if (useArc == null) {
                return route;
            }
            PrimitiveNode pn = useArc.findOverridablePinProto();
            endPort = pn.getPort(0);
        } else {
            endPort = InteractiveRouter.getRoutePort(endObj);
        }
        VerticalRoute vroute = VerticalRoute.newRoute(startPort, endPort);
        if (!vroute.isSpecificationSucceeded()) {
            return new Route();
        }
        ArcProto startArc = vroute.getStartArc();
        ArcProto endArc = vroute.getEndArc();
        double startArcWidth = InteractiveRouter.getArcWidthToUse(startObj, startArc);
        double d = endArcWidth = endObj == null ? startArcWidth : InteractiveRouter.getArcWidthToUse(endObj, endArc);
        if (extendArcHead) {
            boolean bl = extendArcHead = startArc.isExtended() || endArc.isExtended();
        }
        if (extendArcTail) {
            extendArcTail = startArc.isExtended() || endArc.isExtended();
        }
        Poly startPoly = InteractiveRouter.getConnectingSite(startObj, clicked, startArcWidth);
        Poly endPoly = InteractiveRouter.getConnectingSite(endObj, clicked, endArcWidth);
        Point2D.Double startPoint = new Point2D.Double(0.0, 0.0);
        Point2D.Double endPoint = new Point2D.Double(0.0, 0.0);
        InteractiveRouter.getConnectingPoints(startObj, endObj, clicked, startPoint, endPoint, startPoly, endPoly, startArc, endArc);
        PortInst existingStartPort = null;
        PortInst existingEndPort = null;
        boolean contactsOnEndObject = true;
        if (startObj instanceof PortInst) {
            existingStartPort = (PortInst)startObj;
            startRE = RouteElementPort.existingPortInst(existingStartPort, startPoly);
        }
        if (startObj instanceof ArcInst) {
            startRE = this.findArcConnectingPoint(route, (ArcInst)startObj, startPoint, stayInside);
            contactsOnEndObject = false;
        }
        if (startRE == null) {
            if (startObj != this.badStartObject) {
                System.out.println("  Can't route from " + startObj + ", no ports");
            }
            this.badStartObject = startObj;
            return route;
        }
        if (endObj != null) {
            if (endObj instanceof PortInst) {
                existingEndPort = (PortInst)endObj;
                endRE = RouteElementPort.existingPortInst(existingEndPort, endPoly);
            }
            if (endObj instanceof ArcInst) {
                endRE = this.findArcConnectingPoint(route, (ArcInst)endObj, endPoint, stayInside);
                contactsOnEndObject = true;
            }
            if (endRE == null) {
                if (endObj != this.badEndObject) {
                    System.out.println("  Can't route to " + endObj + ", no ports");
                }
                this.badEndObject = endObj;
                endObj = null;
            }
        }
        if (endObj == null) {
            ArcProto useArc = null;
            if (startObj instanceof PortInst) {
                PortInst startPi = (PortInst)startObj;
                useArc = InteractiveRouter.getArcToUse(startPi.getPortProto(), null);
            }
            if (startObj instanceof ArcInst) {
                ArcInst startAi = (ArcInst)startObj;
                useArc = startAi.getProto();
            }
            PrimitiveNode pn = useArc.findOverridablePinProto();
            SizeOffset so = pn.getProtoSizeOffset();
            endRE = RouteElementPort.newNode(cell, pn, pn.getPort(0), endPoint, pn.getDefWidth() - so.getHighXOffset() - so.getLowXOffset(), pn.getDefHeight() - so.getHighYOffset() - so.getLowYOffset());
        }
        if (existingEndPort != null && existingEndPort == existingStartPort) {
            return new Route();
        }
        route.add(startRE);
        route.setStart(startRE);
        route.setEnd(startRE);
        if (this.planRoute(route, cell, endRE, startPoint, endPoint, clicked, stayInside, vroute, contactsOnEndObject, extendArcHead, extendArcTail)) {
            return route;
        }
        return new Route();
    }

    protected static ElectricObject filterRouteObject(ElectricObject routeObj, Point2D clicked) {
        if (routeObj instanceof NodeInst) {
            return ((NodeInst)routeObj).findClosestPortInst(clicked);
        }
        if (routeObj instanceof Export) {
            Export exp = (Export)routeObj;
            return exp.getOriginalPort();
        }
        return routeObj;
    }

    protected static PortProto getRoutePort(ElectricObject routeObj) {
        assert (!(routeObj instanceof NodeInst));
        if (routeObj instanceof ArcInst) {
            ArcInst ai = (ArcInst)routeObj;
            PrimitiveNode pn = ai.getProto().findOverridablePinProto();
            return pn.getPort(0);
        }
        if (routeObj instanceof PortInst) {
            PortInst pi = (PortInst)routeObj;
            return pi.getPortProto();
        }
        return null;
    }

    protected static double getArcWidthToUse(ElectricObject routeObj, ArcProto ap) {
        ArcInst ai;
        double width = -1.0;
        if (routeObj instanceof ArcInst && (ai = (ArcInst)routeObj).getProto() == ap) {
            return ai.getLambdaBaseWidth();
        }
        if (routeObj instanceof PortInst) {
            width = Router.getArcWidthToUse((PortInst)routeObj, ap);
        }
        return width;
    }

    protected static void getConnectingPoints(ElectricObject startObj, ElectricObject endObj, Point2D clicked, Point2D startPoint, Point2D endPoint, Poly startPoly, Poly endPoly, ArcProto startArc, ArcProto endArc) {
        double upperBoundX;
        double lowerBoundX;
        if (startPoly.getBox() == null && startPoly.getPoints().length != 2 || endPoly != null && endPoly.getBox() == null && endPoly.getPoints().length != 2) {
            startPoint.setLocation(startPoly.closestPoint(clicked));
            if (endPoly == null) {
                endPoint.setLocation(InteractiveRouter.getClosestOrthogonalPoint(startPoint, clicked));
            } else {
                endPoint.setLocation(endPoly.closestPoint(clicked));
            }
            return;
        }
        Rectangle2D startBounds = startPoly.getBounds2D();
        startPoint.setLocation(startBounds.getCenterX(), startBounds.getCenterY());
        if (startObj instanceof ArcInst) {
            double x = InteractiveRouter.getClosestValue(startBounds.getMinX(), startBounds.getMaxX(), clicked.getX());
            double y = InteractiveRouter.getClosestValue(startBounds.getMinY(), startBounds.getMaxY(), clicked.getY());
            startPoint.setLocation(x, y);
        }
        if (endPoly == null) {
            int angleIncrement = endArc.getAngleIncrement();
            endPoint.setLocation(InteractiveRouter.getClosestAngledPoint(startPoint, clicked, angleIncrement));
            if (startArc.getTechnology() == Artwork.tech) {
                endPoint.setLocation(clicked);
            }
            return;
        }
        Rectangle2D endBounds = endPoly.getBounds2D();
        endPoint.setLocation(endBounds.getCenterX(), endBounds.getCenterY());
        if (endObj instanceof ArcInst) {
            double x = InteractiveRouter.getClosestValue(endBounds.getMinX(), endBounds.getMaxX(), clicked.getX());
            double y = InteractiveRouter.getClosestValue(endBounds.getMinY(), endBounds.getMaxY(), clicked.getY());
            endPoint.setLocation(x, y);
        }
        if ((lowerBoundX = Math.max(startBounds.getMinX(), endBounds.getMinX())) <= (upperBoundX = Math.min(startBounds.getMaxX(), endBounds.getMaxX()))) {
            double x = InteractiveRouter.getClosestValue(lowerBoundX, upperBoundX, clicked.getX());
            startPoint.setLocation(x, startPoint.getY());
            endPoint.setLocation(x, endPoint.getY());
        } else if (startBounds.getMinX() > endBounds.getMaxX()) {
            startPoint.setLocation(startBounds.getMinX(), startPoint.getY());
            endPoint.setLocation(endBounds.getMaxX(), endPoint.getY());
        } else {
            startPoint.setLocation(startBounds.getMaxX(), startPoint.getY());
            endPoint.setLocation(endBounds.getMinX(), endPoint.getY());
        }
        double lowerBoundY = Math.max(startBounds.getMinY(), endBounds.getMinY());
        double upperBoundY = Math.min(startBounds.getMaxY(), endBounds.getMaxY());
        if (lowerBoundY <= upperBoundY) {
            double y = InteractiveRouter.getClosestValue(lowerBoundY, upperBoundY, clicked.getY());
            startPoint.setLocation(startPoint.getX(), y);
            endPoint.setLocation(endPoint.getX(), y);
        } else if (startBounds.getMinY() > endBounds.getMaxY()) {
            startPoint.setLocation(startPoint.getX(), startBounds.getMinY());
            endPoint.setLocation(endPoint.getX(), endBounds.getMaxY());
        } else {
            startPoint.setLocation(startPoint.getX(), startBounds.getMaxY());
            endPoint.setLocation(endPoint.getX(), endBounds.getMinY());
        }
    }

    protected static Poly getConnectingSite(ElectricObject obj, Point2D clicked, double arcWidth) {
        PortInst pi;
        assert (clicked != null);
        if (obj instanceof NodeInst) {
            pi = ((NodeInst)obj).findClosestPortInst(clicked);
            if (pi == null) {
                return null;
            }
            obj = pi;
        }
        if (obj instanceof PortInst) {
            pi = (PortInst)obj;
            NodeInst ni = pi.getNodeInst();
            PortProto pp = pi.getPortProto();
            boolean compressPort = false;
            if (!ni.isCellInstance()) {
                compressPort = true;
            }
            Poly poly = ni.getShapeOfPort(pp, clicked, compressPort, arcWidth);
            return poly;
        }
        if (obj instanceof ArcInst) {
            ArcInst arc = (ArcInst)obj;
            Point2D[] points = new Point2D[]{arc.getHeadLocation(), arc.getTailLocation()};
            Poly poly = new Poly(points);
            return poly;
        }
        return null;
    }

    protected RouteElementPort findArcConnectingPoint(Route route, ArcInst arc, Point2D point, PolyMerge stayInside) {
        double maxY;
        double minY;
        double maxX;
        double minX;
        EPoint head = arc.getHeadLocation();
        EPoint tail = arc.getTailLocation();
        RouteElementPort headRE = RouteElementPort.existingPortInst(arc.getHeadPortInst(), head);
        RouteElementPort tailRE = RouteElementPort.existingPortInst(arc.getTailPortInst(), tail);
        RouteElementPort startRE = null;
        EPoint minXpin = null;
        EPoint minYpin = null;
        if (head.getX() < tail.getX()) {
            minX = head.getX();
            maxX = tail.getX();
            minXpin = head;
        } else {
            minX = tail.getX();
            maxX = head.getX();
            minXpin = tail;
        }
        if (head.getY() < tail.getY()) {
            minY = head.getY();
            maxY = tail.getY();
            minYpin = head;
        } else {
            minY = tail.getY();
            maxY = head.getY();
            minYpin = tail;
        }
        if (head.getX() == tail.getX()) {
            if (point.getY() > minY && point.getY() < maxY) {
                Point2D.Double location = new Point2D.Double(head.getX(), point.getY());
                startRE = this.bisectArc(route, arc, location, stayInside);
            } else {
                startRE = point.getY() <= minY ? (minYpin == head ? headRE : tailRE) : (minYpin == head ? tailRE : headRE);
            }
        } else if (head.getY() == tail.getY()) {
            if (point.getX() > minX && point.getX() < maxX) {
                Point2D.Double location = new Point2D.Double(point.getX(), head.getY());
                startRE = this.bisectArc(route, arc, location, stayInside);
            } else {
                startRE = point.getX() <= minX ? (minXpin == head ? headRE : tailRE) : (minXpin == head ? tailRE : headRE);
            }
        } else {
            double tailDist;
            double headDist = point.distance(head);
            startRE = headDist < (tailDist = point.distance(tail)) ? headRE : tailRE;
        }
        return startRE;
    }

    protected RouteElementPort bisectArc(Route route, ArcInst arc, Point2D bisectPoint, PolyMerge stayInside) {
        Cell cell = arc.getParent();
        EPoint head = arc.getHeadLocation();
        EPoint tail = arc.getTailLocation();
        PrimitiveNode pn = arc.getProto().findOverridablePinProto();
        SizeOffset so = pn.getProtoSizeOffset();
        double width = pn.getDefWidth() - so.getHighXOffset() - so.getLowXOffset();
        double height = pn.getDefHeight() - so.getHighYOffset() - so.getLowYOffset();
        RouteElementPort newPinRE = RouteElementPort.newNode(cell, pn, pn.getPort(0), bisectPoint, width, height);
        newPinRE.setBisectArcPin(true);
        RouteElementPort headRE = RouteElementPort.existingPortInst(arc.getHeadPortInst(), head);
        RouteElementPort tailRE = RouteElementPort.existingPortInst(arc.getTailPortInst(), tail);
        headRE.setShowHighlight(false);
        tailRE.setShowHighlight(false);
        String name1 = null;
        String name2 = null;
        if (head.distance(bisectPoint) > tail.distance(bisectPoint)) {
            name1 = arc.getName();
        } else {
            name2 = arc.getName();
        }
        RouteElementArc newHeadArcRE = RouteElementArc.newArc(cell, arc.getProto(), arc.getLambdaBaseWidth(), headRE, newPinRE, head, bisectPoint, name1, arc.getTextDescriptor(ArcInst.ARC_NAME), arc, true, true, stayInside);
        RouteElementArc newTailArcRE = RouteElementArc.newArc(cell, arc.getProto(), arc.getLambdaBaseWidth(), newPinRE, tailRE, bisectPoint, tail, name2, arc.getTextDescriptor(ArcInst.ARC_NAME), arc, true, true, stayInside);
        newHeadArcRE.setShowHighlight(false);
        newTailArcRE.setShowHighlight(false);
        RouteElementArc deleteArcRE = RouteElementArc.deleteArc(arc);
        route.add(deleteArcRE);
        route.add(headRE);
        route.add(tailRE);
        route.add(newHeadArcRE);
        route.add(newTailArcRE);
        return newPinRE;
    }

    protected static double getClosestValue(double min, double max, double clicked) {
        if (clicked >= max) {
            return max;
        }
        if (clicked <= min) {
            return min;
        }
        return clicked;
    }

    protected static Point2D getClosestOrthogonalPoint(Point2D startPoint, Point2D clicked) {
        Point2D.Double newPoint = Math.abs(startPoint.getX() - clicked.getX()) < Math.abs(startPoint.getY() - clicked.getY()) ? new Point2D.Double(startPoint.getX(), clicked.getY()) : new Point2D.Double(clicked.getX(), startPoint.getY());
        return newPoint;
    }

    protected static Point2D getClosestAngledPoint(Point2D startPoint, Point2D clicked, int angleIncrement) {
        double yfinal;
        double xfinal;
        if ((angleIncrement = Math.abs(angleIncrement)) == 0) {
            return clicked;
        }
        if (angleIncrement == 90) {
            return InteractiveRouter.getClosestOrthogonalPoint(startPoint, clicked);
        }
        double angleInc = (double)angleIncrement * Math.PI / 180.0;
        double x = clicked.getX() - startPoint.getX();
        double y = clicked.getY() - startPoint.getY();
        double angle = Math.atan2(y, x);
        double nearest1 = (double)((int)(angle / angleInc)) * angleInc;
        double nearest2 = angle < 0.0 ? nearest1 - angleInc : nearest1 + angleInc;
        double tan1 = Math.tan(nearest1);
        if (tan1 == 0.0) {
            tan1 = 1.0E-6;
        }
        Point2D.Double n1_1 = new Point2D.Double(x, x * tan1);
        Point2D.Double n1_2 = new Point2D.Double(y / tan1, y);
        Point2D.Double n1 = n1_1.distance(x, y) < n1_2.distance(x, y) ? n1_1 : n1_2;
        double tan2 = Math.tan(nearest2);
        if (tan2 == 0.0) {
            tan2 = 1.0E-6;
        }
        Point2D.Double n2_1 = new Point2D.Double(x, x * tan2);
        Point2D.Double n2_2 = new Point2D.Double(y / tan2, y);
        Point2D.Double n2 = n2_1.distance(x, y) < n2_2.distance(x, y) ? n2_1 : n2_2;
        if (n2.distance(x, y) < n1.distance(x, y)) {
            xfinal = DBMath.round(((Point2D)n2).getX() + startPoint.getX());
            yfinal = DBMath.round(((Point2D)n2).getY() + startPoint.getY());
        } else {
            xfinal = DBMath.round(((Point2D)n1).getX() + startPoint.getX());
            yfinal = DBMath.round(((Point2D)n1).getY() + startPoint.getY());
        }
        return new Point2D.Double(xfinal, yfinal);
    }

    protected boolean withinBounds(double point, double bound1, double bound2) {
        double max;
        double min;
        if (bound1 < bound2) {
            min = bound1;
            max = bound2;
        } else {
            min = bound2;
            max = bound1;
        }
        return point >= min && point <= max;
    }

    protected boolean onSegment(Point2D point, Line2D line) {
        double maxY;
        double minY;
        double maxX;
        double minX;
        Point2D head = line.getP1();
        Point2D tail = line.getP2();
        if (head.getX() < tail.getX()) {
            minX = head.getX();
            maxX = tail.getX();
        } else {
            minX = tail.getX();
            maxX = head.getX();
        }
        if (head.getY() < tail.getY()) {
            minY = head.getY();
            maxY = tail.getY();
        } else {
            minY = tail.getY();
            maxY = head.getY();
        }
        return point.getX() >= minX && point.getX() <= maxX && point.getY() >= minY && point.getY() <= maxY;
    }

    private static class MakeVerticalRouteJob
    extends Router.CreateRouteJob {
        protected MakeVerticalRouteJob(Router router, Route route, Cell cell, boolean verbose) {
            super(router.toString(), route, cell, verbose, Routing.getRoutingTool());
        }

        @Override
        public boolean doIt() throws JobException {
            PortInst pi;
            NodeInst ni;
            if (!super.doIt()) {
                return false;
            }
            RouteElementPort startRE = this.route.getStart();
            if (startRE.getAction() == RouteElement.RouteElementAction.existingPortInst && (ni = (pi = startRE.getPortInst()).getNodeInst()).getProto().getFunction() == PrimitiveNode.Function.PIN) {
                CircuitChangeJobs.Reconnect re = CircuitChangeJobs.Reconnect.erasePassThru(ni, false, true);
                if (re != null) {
                    re.reconnectArcs();
                }
                if (!ni.hasExports()) {
                    ni.kill();
                }
            }
            return true;
        }
    }
}

