/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.VectorCache;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.sound.sampled.AudioSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends Listener {
    private static User tool = new User();
    public static final Variable.Key FRAME_SIZE = Variable.newKey("FACET_schematic_page_size");
    public static final Variable.Key FRAME_COMPANY_NAME = Variable.newKey("USER_drawing_company_name");
    public static final Variable.Key FRAME_DESIGNER_NAME = Variable.newKey("USER_drawing_designer_name");
    public static final Variable.Key FRAME_LAST_CHANGED_BY = Variable.newKey("USER_drawing_last_changed_by");
    public static final Variable.Key FRAME_PROJECT_NAME = Variable.newKey("USER_drawing_project_name");
    private ArcProto currentArcProto = null;
    private NodeProto currentNodeProto = null;
    private boolean undoRedo;
    private static HashMap<EditWindow, Rectangle2D> changedWindowRects = new HashMap();
    private static AudioClip clickSound = null;
    private static boolean hasSound = true;
    private static Pref cacheIconGenDrawLeads = Pref.makeBooleanPref("IconGenDrawLeads", User.tool.prefs, true);
    private static Pref cacheIconGenDrawBody = Pref.makeBooleanPref("IconGenDrawBody", User.tool.prefs, true);
    private static Pref cacheIconGenReverseExportOrder = Pref.makeBooleanPref("IconGenReverseExportOrder", User.tool.prefs, false);
    private static Pref cacheIconGenInputSide = Pref.makeIntPref("IconGenInputSide", User.tool.prefs, 0);
    private static Pref cacheIconGenOutputSide = Pref.makeIntPref("IconGenOutputSide", User.tool.prefs, 1);
    private static Pref cacheIconGenBidirSide = Pref.makeIntPref("IconGenBidirSide", User.tool.prefs, 2);
    private static Pref cacheIconGenPowerSide = Pref.makeIntPref("IconGenPowerSide", User.tool.prefs, 3);
    private static Pref cacheIconGenGroundSide = Pref.makeIntPref("IconGenGroundSide", User.tool.prefs, 3);
    private static Pref cacheIconGenClockSide = Pref.makeIntPref("IconGenClockSide", User.tool.prefs, 0);
    private static Pref cacheIconGenExportLocation = Pref.makeIntPref("IconGenExportLocation", User.tool.prefs, 1);
    private static Pref cacheIconGenExportStyle = Pref.makeIntPref("IconGenExportStyle", User.tool.prefs, 0);
    private static Pref cacheIconGenExportTech = Pref.makeIntPref("IconGenExportTech", User.tool.prefs, 0);
    private static Pref cacheIconGenInstanceLocation = Pref.makeIntPref("IconGenInstanceLocation", User.tool.prefs, 0);
    private static Pref cacheIconGenLeadLength = Pref.makeDoublePref("IconGenLeadLength", User.tool.prefs, 2.0);
    private static Pref cacheIconGenLeadSpacing = Pref.makeDoublePref("IconGenLeadSpacing", User.tool.prefs, 2.0);
    private static Pref cachePortDisplayLevel = Pref.makeIntPref("PortDisplayLevel", User.tool.prefs, 0);
    private static Pref cacheExportDisplayLevel = Pref.makeIntPref("ExportDisplayLevel", User.tool.prefs, 0);
    private static Pref cacheMoveNodeWithExport = Pref.makeBooleanPref("MoveNodeWithExport", User.tool.prefs, false);
    private static Pref cacheEasySelectionOfCellInstances = Pref.makeBooleanPref("EasySelectionOfCellInstances", User.tool.prefs, true);
    private static Pref cacheDraggingMustEncloseObjects = Pref.makeBooleanPref("DraggingMustEncloseObjects", User.tool.prefs, false);
    private static Pref cacheMouseOverHighlighting = Pref.makeBooleanPref("UseMouseOverHighlighting", User.tool.prefs, true);
    private static Pref cacheDefGridXSpacing = Pref.makeDoublePref("DefGridXSpacing", User.tool.prefs, 1.0);
    private static Pref cacheDefGridYSpacing = Pref.makeDoublePref("DefGridYSpacing", User.tool.prefs, 1.0);
    private static Pref cacheDefGridXBoldFrequency = Pref.makeIntPref("DefGridXBoldFrequency", User.tool.prefs, 10);
    private static Pref cacheDefGridYBoldFrequency = Pref.makeIntPref("DefGridYBoldFrequency", User.tool.prefs, 10);
    private static Pref cacheAlignmentToGridVector = Pref.makeStringPref("AlignmentToGridVector", User.tool.prefs, "(-1 0.5 0.25)");
    private static Pref cacheShowGridAxes = Pref.makeBooleanPref("ShowGridAxes", User.tool.prefs, false);
    private static Pref cacheTextVisibilityNode = Pref.makeBooleanPref("TextVisibilityNode", User.tool.prefs, true);
    private static Pref cacheTextVisibilityArc = Pref.makeBooleanPref("TextVisibilityArc", User.tool.prefs, true);
    private static Pref cacheTextVisibilityPort = Pref.makeBooleanPref("TextVisibilityPort", User.tool.prefs, true);
    private static Pref cacheTextVisibilityExport = Pref.makeBooleanPref("TextVisibilityExport", User.tool.prefs, true);
    private static Pref cacheTextVisibilityAnnotation = Pref.makeBooleanPref("TextVisibilityAnnotation", User.tool.prefs, true);
    private static Pref cacheTextVisibilityInstance = Pref.makeBooleanPref("TextVisibilityInstance", User.tool.prefs, true);
    private static Pref cacheTextVisibilityCell = Pref.makeBooleanPref("TextVisibilityCell", User.tool.prefs, true);
    private static Pref cacheSmartVerticalPlacementExport = Pref.makeIntPref("SmartVerticalPlacementExport", User.tool.prefs, 0);
    private static Pref cacheSmartHorizontalPlacementExport = Pref.makeIntPref("SmartHorizontalPlacementExport", User.tool.prefs, 0);
    private static Pref cacheSmartVerticalPlacementArc = Pref.makeIntPref("SmartVerticalPlacementArc", User.tool.prefs, 0);
    private static Pref cacheSmartHorizontalPlacementArc = Pref.makeIntPref("SmartHorizontalPlacementArc", User.tool.prefs, 0);
    private static Pref cacheDefaultFont = Pref.makeStringPref("DefaultFont", User.tool.prefs, "SansSerif");
    private static Pref cacheDefaultTextCellFont = Pref.makeStringPref("DefaultTextCellFont", User.tool.prefs, "SansSerif");
    private static Pref cacheDefaultTextCellSize = Pref.makeIntPref("DefaultTextCellSize", User.tool.prefs, 12);
    private static Pref cacheGlobalTextScale = Pref.makeDoublePref("TextGlobalScale", User.tool.prefs, 1.0);
    private static Pref cacheFrameCompanyName = Pref.makeStringPref("FrameCompanyName", User.tool.prefs, "");
    private static Pref cacheFrameDesignerName = Pref.makeStringPref("FrameDesignerName", User.tool.prefs, "");
    private static Pref cacheFrameProjectName = Pref.makeStringPref("FrameProjectName", User.tool.prefs, "");
    private static Pref cacheColorBackground = Pref.makeIntPref("ColorBackground", User.tool.prefs, Color.LIGHT_GRAY.getRGB());
    private static Pref cacheColorGrid = Pref.makeIntPref("ColorGrid", User.tool.prefs, Color.BLACK.getRGB());
    private static Pref cacheColorHighlight = Pref.makeIntPref("ColorHighlight", User.tool.prefs, Color.WHITE.getRGB());
    private static Pref cacheColorMouseOverHighlight = Pref.makeIntPref("ColorMouseOverHighlight", User.tool.prefs, new Color(51, 255, 255).getRGB());
    private static Pref cacheColorPortHighlight = Pref.makeIntPref("ColorPortHighlight", User.tool.prefs, Color.YELLOW.getRGB());
    private static Pref cacheColorText = Pref.makeIntPref("ColorText", User.tool.prefs, Color.BLACK.getRGB());
    private static Pref cacheColorInstanceOutline = Pref.makeIntPref("ColorInstanceOutline", User.tool.prefs, Color.BLACK.getRGB());
    private static Pref cacheColorWaveformBackground = Pref.makeIntPref("ColorWaveformBackground", User.tool.prefs, Color.BLACK.getRGB());
    private static Pref cacheColorWaveformForeground = Pref.makeIntPref("ColorWaveformForeground", User.tool.prefs, Color.WHITE.getRGB());
    private static Pref cacheColorWaveformStimuli = Pref.makeIntPref("ColorWaveformStimuli", User.tool.prefs, Color.RED.getRGB());
    private static Pref cacheColorWaveformStrengthOff = Pref.makeIntPref("ColorWaveformStrengthOff", User.tool.prefs, Color.BLUE.getRGB());
    private static Pref cacheColorWaveformStrengthNode = Pref.makeIntPref("ColorWaveformStrengthNode", User.tool.prefs, Color.GREEN.getRGB());
    private static Pref cacheColorWaveformStrengthGate = Pref.makeIntPref("ColorWaveformStrengthGate", User.tool.prefs, Color.MAGENTA.getRGB());
    private static Pref cacheColorWaveformStrengthPower = Pref.makeIntPref("ColorWaveformStrengthPower", User.tool.prefs, Color.LIGHT_GRAY.getRGB());
    private static Pref cacheColorWaveformCrossProbeLow = Pref.makeIntPref("ColorWaveformCrossProbeLow", User.tool.prefs, Color.BLUE.getRGB());
    private static Pref cacheColorWaveformCrossProbeHigh = Pref.makeIntPref("ColorWaveformCrossProbeHigh", User.tool.prefs, Color.GREEN.getRGB());
    private static Pref cacheColorWaveformCrossProbeX = Pref.makeIntPref("ColorWaveformCrossProbeX", User.tool.prefs, Color.BLACK.getRGB());
    private static Pref cacheColorWaveformCrossProbeZ = Pref.makeIntPref("ColorWaveformCrossProbeZ", User.tool.prefs, Color.LIGHT_GRAY.getRGB());
    private static Pref cacheDistanceUnits = Pref.makeIntPref("DistanceUnits", User.tool.prefs, TextUtils.UnitScale.NANO.getIndex());
    private static Pref cacheResistanceUnits = Pref.makeIntPref("ResistanceUnits", User.tool.prefs, TextUtils.UnitScale.NONE.getIndex());
    private static Pref cacheCapacitanceUnits = Pref.makeIntPref("CapacitanceUnits", User.tool.prefs, TextUtils.UnitScale.PICO.getIndex());
    private static Pref cacheInductanceUnits = Pref.makeIntPref("InductanceUnits", User.tool.prefs, TextUtils.UnitScale.NANO.getIndex());
    private static Pref cacheAmperageUnits = Pref.makeIntPref("AmperageUnits", User.tool.prefs, TextUtils.UnitScale.MILLI.getIndex());
    private static Pref cacheVoltageUnits = Pref.makeIntPref("VoltageUnits", User.tool.prefs, TextUtils.UnitScale.NONE.getIndex());
    private static Pref cacheTimeUnits = Pref.makeIntPref("TimeUnits", User.tool.prefs, TextUtils.UnitScale.NONE.getIndex());
    private static Pref cacheDefaultTechnology = Pref.makeStringSetting("DefaultTechnology", User.tool.prefs, tool, tool.getProjectSettings(), null, "Technology tab", "Default Technology for editing", "mocmos");
    private static Pref cacheSchematicTechnology = Pref.makeStringSetting("SchematicTechnology", User.tool.prefs, tool, tool.getProjectSettings(), null, "Technology tab", "Schematics use scale values from this technology", "mocmos");
    private static Pref cacheWorkingDirectory = Pref.makeStringPref("WorkingDirectory", User.tool.prefs, System.getProperty("user.dir"));
    private static Pref cachePromptForIndexWhenDescending = Pref.makeBooleanPref("PromptForIndexWhenDescending", User.tool.prefs, false);
    private static Pref cacheBeepAfterLongJobs = Pref.makeBooleanPref("BeepAfterLongJobs", User.tool.prefs, false);
    private static Pref cacheJobVerboseMode = Pref.makeBooleanPref("JobVerboseMode", User.tool.prefs, false);
    private static Pref cacheRotateLayoutTransistors = Pref.makeBooleanPref("RotateLayoutTransistors", User.tool.prefs, false);
    private static Pref cacheSideBarOnRight = Pref.makeBooleanPref("SideBarOnRight", User.tool.prefs, false);
    private static Pref cacheDefaultWindowTab = Pref.makeIntPref("DefaultWindowTab", User.tool.prefs, 0);
    private static Pref cacheDefaultWindowXPos = Pref.makeIntPref("DefaultWindowXPos", User.tool.prefs, 0);
    private static Pref cacheDefaultWindowYPos = Pref.makeIntPref("DefaultWindowYPos", User.tool.prefs, 0);
    private static Pref cacheDefaultWindowXSize = Pref.makeIntPref("DefaultWindowXSize", User.tool.prefs, 0);
    private static Pref cacheDefaultWindowYSize = Pref.makeIntPref("DefaultWindowYSize", User.tool.prefs, 0);
    private static Pref cacheDefaultMessagesXPos = Pref.makeIntPref("DefaultMessagesXPos", User.tool.prefs, -1);
    private static Pref cacheDefaultMessagesYPos = Pref.makeIntPref("DefaultMessagesYPos", User.tool.prefs, -1);
    private static Pref cacheDefaultMessagesXSize = Pref.makeIntPref("DefaultMessagesXSize", User.tool.prefs, 0);
    private static Pref cacheDefaultMessagesYSize = Pref.makeIntPref("DefaultMessagesYSize", User.tool.prefs, 0);
    private static Pref cachePlayClickSoundsWhenCreatingArcs = Pref.makeBooleanPref("PlayClickSoundsWhenCreatingArcs", User.tool.prefs, true);
    private static Pref cacheIncludeDateAndVersionInOutput = Pref.makeBooleanSetting("IncludeDateAndVersionInOutput", User.tool.prefs, tool, tool.getProjectSettings(), null, "Netlists tab", "Include date and version in output", true);
    private static Pref cacheShowHierarchicalCursorCoordinates = Pref.makeBooleanPref("ShowHierarchicalCursorCoordinates", User.tool.prefs, true);
    private static Pref cacheWhichDisplayAlgorithm = Pref.makeIntPref("WhichDisplayAlgorithm", User.tool.prefs, 1);
    private static Pref cacheUseCellGreekingImages = Pref.makeBooleanPref("UseCellGreekingImages", User.tool.prefs, false);
    private static Pref cacheGreekSizeLimit = Pref.makeDoublePref("GreekSizeLimit", User.tool.prefs, 3.0);
    private static Pref cacheGreekCellSizeLimit = Pref.makeDoublePref("GreekCellSizeLimit", User.tool.prefs, 0.1);
    private static Pref cachePatternedScaleLimit = Pref.makeDoublePref("PatternedScaleLimit", User.tool.prefs, 0.1);
    private static Pref cacheAlphaBlendingLimit = Pref.makeDoublePref("AlphaBlendingLimit", User.tool.prefs, 0.6);
    private static Pref cacheShowFileSelectionForNetlists = Pref.makeBooleanPref("ShowFileSelectionForNetlists", User.tool.prefs, true);
    private static Pref cachePanningDistance = Pref.makeIntPref("PanningDistance", User.tool.prefs, 1);
    private static Pref cacheErrorLimit = Pref.makeIntPref("ErrorLimit", User.tool.prefs, 0);
    private static Pref cacheMaxUndoHistory = Pref.makeIntPref("MaxUndoHistory", User.tool.prefs, 40);
    private static Pref cacheMemorySize = Pref.makeIntPref("MemorySize", User.tool.prefs, 1000);
    private static Pref cachePermSize = Pref.makeIntPref("PermSize", User.tool.prefs, 0);
    private static Pref cacheUseTwoJVMs = Pref.makeBooleanPref("UseTwoJVMs", User.tool.prefs, false);
    private static Pref cacheUseClientServer = Pref.makeBooleanPref("UseClientServer", User.tool.prefs, false);
    private static Pref cacheSnapshotLogging = Pref.makeBooleanPref("SnapshotLogging", User.tool.prefs, false);
    private static Pref cacheAutoTechnologySwitch = Pref.makeBooleanPref("AutoTechnologySwitch", User.tool.prefs, true);
    private static Pref cachePlaceCellCenter = Pref.makeBooleanPref("PlaceCellCenter", User.tool.prefs, true);
    private static Pref cacheReconstructArcsToDeletedCells = Pref.makeBooleanPref("ReconstructArcsToDeletedCells", User.tool.prefs, true);
    private static Pref cacheCheckCellDates = Pref.makeBooleanPref("CheckCellDates", User.tool.prefs, false);
    private static Pref cacheDisallowModificationLockedPrims = Pref.makeBooleanPref("DisallowModificationLockedPrims", User.tool.prefs, false);
    private static Pref cacheDisallowModificationComplexNodes = Pref.makeBooleanPref("DisallowModificationComplexNodes", User.tool.prefs, false);
    private static Pref cacheMoveAfterDuplicate = Pref.makeBooleanPref("MoveAfterDuplicate", User.tool.prefs, true);
    private static Pref cacheDupCopiesExports = Pref.makeBooleanPref("DupCopiesExports", User.tool.prefs, false);
    private static Pref cacheExtractCopiesExports = Pref.makeBooleanPref("ExtractCopiesExports", User.tool.prefs, true);
    private static Pref cacheArcsAutoIncremented = Pref.makeBooleanPref("ArcsAutoIncremented", User.tool.prefs, true);
    private static Pref cacheNewNodeRotation = Pref.makeIntPref("NewNodeRotation", User.tool.prefs, 0);
    private static Pref cacheNewNodeMirrorX = Pref.makeBooleanPref("NewNodeMirrorX", User.tool.prefs, false);

    private User() {
        super("user");
    }

    @Override
    public void init() {
        this.setOn();
        this.setIncremental();
        if (Job.getRunMode() != Job.Mode.CLIENT) {
            Clipboard.clear();
        }
    }

    public static User getUserTool() {
        return tool;
    }

    @Override
    public void endBatch(Snapshot oldSnapshot, Snapshot newSnapshot, boolean undoRedo) {
        HashSet<Cell> marked = new HashSet<Cell>();
        for (CellId cellId : newSnapshot.getChangedCells(oldSnapshot)) {
            CellBackup newBackup = newSnapshot.getCell(cellId);
            CellBackup oldBackup = oldSnapshot.getCell(cellId);
            ERectangle newBounds = newSnapshot.getCellBounds(cellId);
            ERectangle oldBounds = oldSnapshot.getCellBounds(cellId);
            if (newBackup == oldBackup && newBounds == oldBounds || newBackup == null) continue;
            Cell cell = Cell.inCurrentThread(cellId);
            User.markCellForRedrawRecursively(cell, marked);
            EditWindow.forceRedraw(cell);
        }
        Iterator<WindowFrame> wit = WindowFrame.getWindows();
        while (wit.hasNext()) {
            Cell winCell;
            WindowFrame wf = wit.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || (winCell = content.getCell()) == null) continue;
            EditWindow wnd = (EditWindow)content;
            if (!winCell.isLinked()) {
                wnd.setCell(null, null, null);
                continue;
            }
            if (!marked.contains(winCell)) continue;
            wnd.repaintContents(null, false);
        }
    }

    public static void fixStaleCellReferences(IdMapper idMapper) {
        if (idMapper == null) {
            return;
        }
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            EditWindow wnd;
            Cell cell;
            WindowFrame frame = it.next();
            if (!(frame.getContent() instanceof EditWindow) || (cell = (wnd = (EditWindow)frame.getContent()).getCell()) == null || cell.isLinked()) continue;
            CellId cellId = idMapper.get(cell.getId());
            Cell newCell = EDatabase.clientDatabase().getCell(cellId);
            if (newCell == null) continue;
            wnd.setCell(newCell, VarContext.globalContext, null);
        }
    }

    public static Rectangle2D getChangedInWindow(EditWindow wnd) {
        Rectangle2D changedArea = changedWindowRects.get(wnd);
        return changedArea;
    }

    public static void clearChangedInWindow(EditWindow wnd) {
        changedWindowRects.remove(wnd);
    }

    private static void setChangedInWindow(EditWindow wnd, Rectangle2D changedArea) {
    }

    public static void markCellForRedraw(Cell cell, boolean cellChanged) {
        HashSet<Cell> marked = new HashSet<Cell>();
        User.markCellForRedrawRecursively(cell, marked);
        if (cellChanged) {
            EditWindow.forceRedraw(cell);
            Iterator<NodeInst> it = cell.getInstancesOf();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                User.markCellForRedrawRecursively(ni.getParent(), marked);
            }
        }
        Iterator<WindowFrame> wit = WindowFrame.getWindows();
        while (wit.hasNext()) {
            Cell winCell;
            WindowFrame wf = wit.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || !marked.contains(winCell = content.getCell())) continue;
            EditWindow wnd = (EditWindow)content;
            wnd.repaintContents(null, false);
        }
    }

    private static void markCellForRedrawRecursively(Cell cell, HashSet<Cell> marked) {
        if (marked.contains(cell)) {
            return;
        }
        marked.add(cell);
        Iterator<NodeInst> it = cell.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isExpanded()) continue;
            User.markCellForRedrawRecursively(ni.getParent(), marked);
        }
    }

    public static void technologyChanged() {
        VectorCache.theCache.clearCache();
        EditWindow.clearSubCellCache();
    }

    public static void layerVisibilityChanged(boolean onlyText) {
        if (!onlyText) {
            VectorCache.theCache.clearFadeImages();
        }
        EditWindow.clearSubCellCache();
        EditWindow.repaintAllContents();
    }

    public NodeProto getCurrentNodeProto() {
        return this.currentNodeProto;
    }

    public void setCurrentNodeProto(NodeProto np) {
        this.currentNodeProto = np;
    }

    public ArcProto getCurrentArcProto() {
        return this.currentArcProto;
    }

    public void setCurrentArcProto(ArcProto ap) {
        this.currentArcProto = ap;
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        if (wf != null) {
            wf.getPaletteTab().arcProtoChanged();
        }
    }

    public static void playSound() {
        if (!hasSound) {
            return;
        }
        if (!User.isPlayClickSoundsWhenCreatingArcs()) {
            return;
        }
        if (clickSound == null) {
            try {
                boolean bl = hasSound = AudioSystem.getMixerInfo().length > 0;
                if (!hasSound) {
                    return;
                }
            }
            catch (Throwable t) {
                hasSound = false;
                return;
            }
            URL url = Resources.getURLResource(TopLevel.class, "Click.wav");
            if (url == null) {
                hasSound = false;
                return;
            }
            clickSound = Applet.newAudioClip(url);
        }
        clickSound.play();
    }

    public static boolean isIconGenDrawLeads() {
        return cacheIconGenDrawLeads.getBoolean();
    }

    public static void setIconGenDrawLeads(boolean on) {
        cacheIconGenDrawLeads.setBoolean(on);
    }

    public static boolean isIconGenDrawBody() {
        return cacheIconGenDrawBody.getBoolean();
    }

    public static void setIconGenDrawBody(boolean on) {
        cacheIconGenDrawBody.setBoolean(on);
    }

    public static boolean isIconGenReverseExportOrder() {
        return cacheIconGenReverseExportOrder.getBoolean();
    }

    public static void setIconGenReverseExportOrder(boolean on) {
        cacheIconGenReverseExportOrder.setBoolean(on);
    }

    public static int getIconGenInputSide() {
        return cacheIconGenInputSide.getInt();
    }

    public static void setIconGenInputSide(int side) {
        cacheIconGenInputSide.setInt(side);
    }

    public static int getIconGenOutputSide() {
        return cacheIconGenOutputSide.getInt();
    }

    public static void setIconGenOutputSide(int side) {
        cacheIconGenOutputSide.setInt(side);
    }

    public static int getIconGenBidirSide() {
        return cacheIconGenBidirSide.getInt();
    }

    public static void setIconGenBidirSide(int side) {
        cacheIconGenBidirSide.setInt(side);
    }

    public static int getIconGenPowerSide() {
        return cacheIconGenPowerSide.getInt();
    }

    public static void setIconGenPowerSide(int side) {
        cacheIconGenPowerSide.setInt(side);
    }

    public static int getIconGenGroundSide() {
        return cacheIconGenGroundSide.getInt();
    }

    public static void setIconGenGroundSide(int side) {
        cacheIconGenGroundSide.setInt(side);
    }

    public static int getIconGenClockSide() {
        return cacheIconGenClockSide.getInt();
    }

    public static void setIconGenClockSide(int side) {
        cacheIconGenClockSide.setInt(side);
    }

    public static int getIconGenExportLocation() {
        return cacheIconGenExportLocation.getInt();
    }

    public static void setIconGenExportLocation(int loc) {
        cacheIconGenExportLocation.setInt(loc);
    }

    public static int getIconGenExportStyle() {
        return cacheIconGenExportStyle.getInt();
    }

    public static void setIconGenExportStyle(int style) {
        cacheIconGenExportStyle.setInt(style);
    }

    public static int getIconGenExportTech() {
        return cacheIconGenExportTech.getInt();
    }

    public static void setIconGenExportTech(int t) {
        cacheIconGenExportTech.setInt(t);
    }

    public static int getIconGenInstanceLocation() {
        return cacheIconGenInstanceLocation.getInt();
    }

    public static void setIconGenInstanceLocation(int loc) {
        cacheIconGenInstanceLocation.setInt(loc);
    }

    public static double getIconGenLeadLength() {
        return cacheIconGenLeadLength.getDouble();
    }

    public static void setIconGenLeadLength(double len) {
        cacheIconGenLeadLength.setDouble(len);
    }

    public static double getIconGenLeadSpacing() {
        return cacheIconGenLeadSpacing.getDouble();
    }

    public static void setIconGenLeadSpacing(double dist) {
        cacheIconGenLeadSpacing.setDouble(dist);
    }

    public static int getPortDisplayLevel() {
        return cachePortDisplayLevel.getInt();
    }

    public static void setPortDisplayLevels(int level) {
        cachePortDisplayLevel.setInt(level);
    }

    public static int getExportDisplayLevel() {
        return cacheExportDisplayLevel.getInt();
    }

    public static void setExportDisplayLevels(int level) {
        cacheExportDisplayLevel.setInt(level);
    }

    public static boolean isMoveNodeWithExport() {
        return cacheMoveNodeWithExport.getBoolean();
    }

    public static void setMoveNodeWithExport(boolean on) {
        cacheMoveNodeWithExport.setBoolean(on);
    }

    public static boolean isEasySelectionOfCellInstances() {
        return cacheEasySelectionOfCellInstances.getBoolean();
    }

    public static void setEasySelectionOfCellInstances(boolean on) {
        cacheEasySelectionOfCellInstances.setBoolean(on);
    }

    public static boolean isDraggingMustEncloseObjects() {
        return cacheDraggingMustEncloseObjects.getBoolean();
    }

    public static void setDraggingMustEncloseObjects(boolean on) {
        cacheDraggingMustEncloseObjects.setBoolean(on);
    }

    public static boolean isMouseOverHighlightingEnabled() {
        return cacheMouseOverHighlighting.getBoolean();
    }

    public static void setMouseOverHighlightingEnabled(boolean on) {
        cacheMouseOverHighlighting.setBoolean(on);
    }

    public static double getDefGridXSpacing() {
        return cacheDefGridXSpacing.getDouble();
    }

    public static void setDefGridXSpacing(double dist) {
        cacheDefGridXSpacing.setDouble(dist);
    }

    public static double getDefGridYSpacing() {
        return cacheDefGridYSpacing.getDouble();
    }

    public static void setDefGridYSpacing(double dist) {
        cacheDefGridYSpacing.setDouble(dist);
    }

    public static int getDefGridXBoldFrequency() {
        return cacheDefGridXBoldFrequency.getInt();
    }

    public static void setDefGridXBoldFrequency(int dist) {
        cacheDefGridXBoldFrequency.setInt(dist);
    }

    public static int getDefGridYBoldFrequency() {
        return cacheDefGridYBoldFrequency.getInt();
    }

    public static void setDefGridYBoldFrequency(int dist) {
        cacheDefGridYBoldFrequency.setInt(dist);
    }

    public static double getAlignmentToGrid() {
        double[] vals = User.getAlignmentToGridVector();
        for (int i = 0; i < vals.length; ++i) {
            if (!(vals[i] < 0.0)) continue;
            return Math.abs(vals[i]);
        }
        assert (false);
        return -1.0;
    }

    public static double[] getAlignmentToGridVector() {
        return GenMath.transformVectorIntoValues(cacheAlignmentToGridVector.getString());
    }

    public static void setAlignmentToGridVector(double[] dist) {
        cacheAlignmentToGridVector.setString(GenMath.transformStringsIntoVector(dist[0], dist[1], dist[2]));
    }

    public static boolean isGridAxesShown() {
        return cacheShowGridAxes.getBoolean();
    }

    public static void setGridAxesShown(boolean s) {
        cacheShowGridAxes.setBoolean(s);
    }

    public static boolean isTextVisibilityOnNode() {
        return cacheTextVisibilityNode.getBoolean();
    }

    public static void setTextVisibilityOnNode(boolean on) {
        cacheTextVisibilityNode.setBoolean(on);
    }

    public static boolean isTextVisibilityOnArc() {
        return cacheTextVisibilityArc.getBoolean();
    }

    public static void setTextVisibilityOnArc(boolean on) {
        cacheTextVisibilityArc.setBoolean(on);
    }

    public static boolean isTextVisibilityOnPort() {
        return cacheTextVisibilityPort.getBoolean();
    }

    public static void setTextVisibilityOnPort(boolean on) {
        cacheTextVisibilityPort.setBoolean(on);
    }

    public static boolean isTextVisibilityOnExport() {
        return cacheTextVisibilityExport.getBoolean();
    }

    public static void setTextVisibilityOnExport(boolean on) {
        cacheTextVisibilityExport.setBoolean(on);
    }

    public static boolean isTextVisibilityOnAnnotation() {
        return cacheTextVisibilityAnnotation.getBoolean();
    }

    public static void setTextVisibilityOnAnnotation(boolean on) {
        cacheTextVisibilityAnnotation.setBoolean(on);
    }

    public static boolean isTextVisibilityOnInstance() {
        return cacheTextVisibilityInstance.getBoolean();
    }

    public static void setTextVisibilityOnInstance(boolean on) {
        cacheTextVisibilityInstance.setBoolean(on);
    }

    public static boolean isTextVisibilityOnCell() {
        return cacheTextVisibilityCell.getBoolean();
    }

    public static void setTextVisibilityOnCell(boolean on) {
        cacheTextVisibilityCell.setBoolean(on);
    }

    public static int getSmartVerticalPlacementExport() {
        return cacheSmartVerticalPlacementExport.getInt();
    }

    public static void setSmartVerticalPlacementExport(int s) {
        cacheSmartVerticalPlacementExport.setInt(s);
    }

    public static int getSmartHorizontalPlacementExport() {
        return cacheSmartHorizontalPlacementExport.getInt();
    }

    public static void setSmartHorizontalPlacementExport(int s) {
        cacheSmartHorizontalPlacementExport.setInt(s);
    }

    public static int getSmartVerticalPlacementArc() {
        return cacheSmartVerticalPlacementArc.getInt();
    }

    public static void setSmartVerticalPlacementArc(int s) {
        cacheSmartVerticalPlacementArc.setInt(s);
    }

    public static int getSmartHorizontalPlacementArc() {
        return cacheSmartHorizontalPlacementArc.getInt();
    }

    public static void setSmartHorizontalPlacementArc(int s) {
        cacheSmartHorizontalPlacementArc.setInt(s);
    }

    public static String getDefaultFont() {
        return cacheDefaultFont.getString();
    }

    public static void setDefaultFont(String f) {
        cacheDefaultFont.setString(f);
    }

    public static String getDefaultTextCellFont() {
        return cacheDefaultTextCellFont.getString();
    }

    public static void setDefaultTextCellFont(String f) {
        cacheDefaultTextCellFont.setString(f);
    }

    public static int getDefaultTextCellSize() {
        return cacheDefaultTextCellSize.getInt();
    }

    public static void setDefaultTextCellSize(int s) {
        cacheDefaultTextCellSize.setInt(s);
    }

    public static double getGlobalTextScale() {
        return cacheGlobalTextScale.getDouble();
    }

    public static void setGlobalTextScale(double s) {
        cacheGlobalTextScale.setDouble(s);
    }

    public static String getFrameCompanyName() {
        return cacheFrameCompanyName.getString();
    }

    public static void setFrameCompanyName(String c) {
        cacheFrameCompanyName.setString(c);
    }

    public static String getFrameDesignerName() {
        return cacheFrameDesignerName.getString();
    }

    public static void setFrameDesignerName(String c) {
        cacheFrameDesignerName.setString(c);
    }

    public static String getFrameProjectName() {
        return cacheFrameProjectName.getString();
    }

    public static void setFrameProjectName(String c) {
        cacheFrameProjectName.setString(c);
    }

    public static int getColorBackground() {
        return cacheColorBackground.getInt();
    }

    public static void setColorBackground(int c) {
        cacheColorBackground.setInt(c);
        try {
            Class j3DUtilsClass = Resources.get3DClass("utils.J3DUtils");
            Method setMethod = j3DUtilsClass.getDeclaredMethod("setBackgroundColor", Object.class);
            setMethod.invoke((Object)j3DUtilsClass, new Object[]{null});
        }
        catch (Exception e) {
            System.out.println("Cannot call 3D plugin method setBackgroundColor: " + e.getMessage());
        }
    }

    public static int getColorGrid() {
        return cacheColorGrid.getInt();
    }

    public static void setColorGrid(int c) {
        cacheColorGrid.setInt(c);
    }

    public static int getColorHighlight() {
        return cacheColorHighlight.getInt();
    }

    public static void setColorHighlight(int c) {
        cacheColorHighlight.setInt(c);
    }

    public static int getColorMouseOverHighlight() {
        return cacheColorMouseOverHighlight.getInt();
    }

    public static void setColorMouseOverHighlight(int c) {
        cacheColorMouseOverHighlight.setInt(c);
    }

    public static int getColorPortHighlight() {
        return cacheColorPortHighlight.getInt();
    }

    public static void setColorPortHighlight(int c) {
        cacheColorPortHighlight.setInt(c);
    }

    public static int getColorText() {
        return cacheColorText.getInt();
    }

    public static void setColorText(int c) {
        cacheColorText.setInt(c);
    }

    public static int getColorInstanceOutline() {
        return cacheColorInstanceOutline.getInt();
    }

    public static void setColorInstanceOutline(int c) {
        cacheColorInstanceOutline.setInt(c);
    }

    public static int getColorWaveformBackground() {
        return cacheColorWaveformBackground.getInt();
    }

    public static void setColorWaveformBackground(int c) {
        cacheColorWaveformBackground.setInt(c);
    }

    public static int getColorWaveformForeground() {
        return cacheColorWaveformForeground.getInt();
    }

    public static void setColorWaveformForeground(int c) {
        cacheColorWaveformForeground.setInt(c);
    }

    public static int getColorWaveformStimuli() {
        return cacheColorWaveformStimuli.getInt();
    }

    public static void setColorWaveformStimuli(int c) {
        cacheColorWaveformStimuli.setInt(c);
    }

    public static int getColorWaveformStrengthOff() {
        return cacheColorWaveformStrengthOff.getInt();
    }

    public static void setColorWaveformStrengthOff(int c) {
        cacheColorWaveformStrengthOff.setInt(c);
    }

    public static int getColorWaveformStrengthNode() {
        return cacheColorWaveformStrengthNode.getInt();
    }

    public static void setColorWaveformStrengthNode(int c) {
        cacheColorWaveformStrengthNode.setInt(c);
    }

    public static int getColorWaveformStrengthGate() {
        return cacheColorWaveformStrengthGate.getInt();
    }

    public static void setColorWaveformStrengthGate(int c) {
        cacheColorWaveformStrengthGate.setInt(c);
    }

    public static int getColorWaveformStrengthPower() {
        return cacheColorWaveformStrengthPower.getInt();
    }

    public static void setColorWaveformStrengthPower(int c) {
        cacheColorWaveformStrengthPower.setInt(c);
    }

    public static int getColorWaveformCrossProbeLow() {
        return cacheColorWaveformCrossProbeLow.getInt();
    }

    public static void setColorWaveformCrossProbeLow(int c) {
        cacheColorWaveformCrossProbeLow.setInt(c);
    }

    public static int getColorWaveformCrossProbeHigh() {
        return cacheColorWaveformCrossProbeHigh.getInt();
    }

    public static void setColorWaveformCrossProbeHigh(int c) {
        cacheColorWaveformCrossProbeHigh.setInt(c);
    }

    public static int getColorWaveformCrossProbeX() {
        return cacheColorWaveformCrossProbeX.getInt();
    }

    public static void setColorWaveformCrossProbeX(int c) {
        cacheColorWaveformCrossProbeX.setInt(c);
    }

    public static int getColorWaveformCrossProbeZ() {
        return cacheColorWaveformCrossProbeZ.getInt();
    }

    public static void setColorWaveformCrossProbeZ(int c) {
        cacheColorWaveformCrossProbeZ.setInt(c);
    }

    public static TextUtils.UnitScale getDistanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheDistanceUnits.getInt());
    }

    public static void setDistanceUnits(TextUtils.UnitScale us) {
        cacheDistanceUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getResistanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheResistanceUnits.getInt());
    }

    public static void setResistanceUnits(TextUtils.UnitScale us) {
        cacheResistanceUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getCapacitanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheCapacitanceUnits.getInt());
    }

    public static void setCapacitanceUnits(TextUtils.UnitScale us) {
        cacheCapacitanceUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getInductanceUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheInductanceUnits.getInt());
    }

    public static void setInductanceUnits(TextUtils.UnitScale us) {
        cacheInductanceUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getAmperageUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheAmperageUnits.getInt());
    }

    public static void setAmperageUnits(TextUtils.UnitScale us) {
        cacheAmperageUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getVoltageUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheVoltageUnits.getInt());
    }

    public static void setVoltageUnits(TextUtils.UnitScale us) {
        cacheVoltageUnits.setInt(us.getIndex());
    }

    public static TextUtils.UnitScale getTimeUnits() {
        return TextUtils.UnitScale.findFromIndex(cacheTimeUnits.getInt());
    }

    public static void setTimeUnits(TextUtils.UnitScale us) {
        cacheTimeUnits.setInt(us.getIndex());
    }

    public static String getDefaultTechnology() {
        return cacheDefaultTechnology.getString();
    }

    public static void setDefaultTechnology(String t) {
        cacheDefaultTechnology.setString(t);
    }

    public static Technology getSchematicTechnology() {
        String t = cacheSchematicTechnology.getString();
        Technology tech = Technology.findTechnology(t);
        if (tech == null) {
            return MoCMOS.tech;
        }
        return tech;
    }

    public static void setSchematicTechnology(Technology t) {
        if (t == null) {
            return;
        }
        cacheSchematicTechnology.setString(t.getTechName());
    }

    public static String getWorkingDirectory() {
        return cacheWorkingDirectory.getString();
    }

    public static void setWorkingDirectory(String dir) {
        cacheWorkingDirectory.setString(dir);
    }

    public static boolean isPromptForIndexWhenDescending() {
        return cachePromptForIndexWhenDescending.getBoolean();
    }

    public static void setPromptForIndexWhenDescending(boolean on) {
        cachePromptForIndexWhenDescending.setBoolean(on);
    }

    public static boolean isBeepAfterLongJobs() {
        return cacheBeepAfterLongJobs.getBoolean();
    }

    public static void setBeepAfterLongJobs(boolean on) {
        cacheBeepAfterLongJobs.setBoolean(on);
    }

    public static boolean isJobVerboseMode() {
        return cacheJobVerboseMode.getBoolean();
    }

    public static void setJobVerboseMode(boolean on) {
        cacheJobVerboseMode.setBoolean(on);
    }

    public static boolean isRotateLayoutTransistors() {
        return cacheRotateLayoutTransistors.getBoolean();
    }

    public static void setRotateLayoutTransistors(boolean on) {
        cacheRotateLayoutTransistors.setBoolean(on);
    }

    public static boolean isSideBarOnRight() {
        return cacheSideBarOnRight.getBoolean();
    }

    public static void setSideBarOnRight(boolean on) {
        cacheSideBarOnRight.setBoolean(on);
    }

    public static int getDefaultWindowTab() {
        return cacheDefaultWindowTab.getInt();
    }

    public static void setDefaultWindowTab(int t) {
        cacheDefaultWindowTab.setInt(t);
    }

    public static Point getDefaultWindowPos() {
        return new Point(cacheDefaultWindowXPos.getInt(), cacheDefaultWindowYPos.getInt());
    }

    public static void setDefaultWindowPos(Point pt) {
        cacheDefaultWindowXPos.setInt(pt.x);
        cacheDefaultWindowYPos.setInt(pt.y);
    }

    public static Dimension getDefaultWindowSize() {
        if (cacheDefaultWindowXSize.getInt() == 0 || cacheDefaultWindowYSize.getInt() == 0) {
            return null;
        }
        return new Dimension(cacheDefaultWindowXSize.getInt(), cacheDefaultWindowYSize.getInt());
    }

    public static void setDefaultWindowSize(Dimension sz) {
        cacheDefaultWindowXSize.setInt(sz.width);
        cacheDefaultWindowYSize.setInt(sz.height);
    }

    public static Point getDefaultMessagesPos() {
        if (cacheDefaultMessagesXPos.getInt() < 0 && cacheDefaultMessagesYPos.getInt() < 0) {
            return null;
        }
        return new Point(cacheDefaultMessagesXPos.getInt(), cacheDefaultMessagesYPos.getInt());
    }

    public static void setDefaultMessagesPos(Point pt) {
        cacheDefaultMessagesXPos.setInt(pt.x);
        cacheDefaultMessagesYPos.setInt(pt.y);
    }

    public static Dimension getDefaultMessagesSize() {
        if (cacheDefaultMessagesXSize.getInt() == 0 || cacheDefaultMessagesYSize.getInt() == 0) {
            return null;
        }
        return new Dimension(cacheDefaultMessagesXSize.getInt(), cacheDefaultMessagesYSize.getInt());
    }

    public static void setDefaultMessagesSize(Dimension sz) {
        cacheDefaultMessagesXSize.setInt(sz.width);
        cacheDefaultMessagesYSize.setInt(sz.height);
    }

    public static boolean isPlayClickSoundsWhenCreatingArcs() {
        return cachePlayClickSoundsWhenCreatingArcs.getBoolean();
    }

    public static void setPlayClickSoundsWhenCreatingArcs(boolean on) {
        cachePlayClickSoundsWhenCreatingArcs.setBoolean(on);
    }

    public static boolean isIncludeDateAndVersionInOutput() {
        return cacheIncludeDateAndVersionInOutput.getBoolean();
    }

    public static void setIncludeDateAndVersionInOutput(boolean on) {
        cacheIncludeDateAndVersionInOutput.setBoolean(on);
    }

    public static boolean isShowHierarchicalCursorCoordinates() {
        return cacheShowHierarchicalCursorCoordinates.getBoolean();
    }

    public static void setShowHierarchicalCursorCoordinates(boolean on) {
        cacheShowHierarchicalCursorCoordinates.setBoolean(on);
    }

    public static int getDisplayAlgorithm() {
        return cacheWhichDisplayAlgorithm.getInt();
    }

    public static void setDisplayAlgorithm(int w) {
        cacheWhichDisplayAlgorithm.setInt(w);
    }

    public static boolean isUseCellGreekingImages() {
        return cacheUseCellGreekingImages.getBoolean();
    }

    public static void setUseCellGreekingImages(boolean on) {
        cacheUseCellGreekingImages.setBoolean(on);
    }

    public static double getGreekSizeLimit() {
        return cacheGreekSizeLimit.getDouble();
    }

    public static void setGreekSizeLimit(double l) {
        cacheGreekSizeLimit.setDouble(l);
    }

    public static double getGreekCellSizeLimit() {
        return cacheGreekCellSizeLimit.getDouble();
    }

    public static void setGreekCellSizeLimit(double l) {
        cacheGreekCellSizeLimit.setDouble(l);
    }

    public static double getPatternedScaleLimit() {
        return cachePatternedScaleLimit.getDouble();
    }

    public static void setPatternedScaleLimit(double l) {
        cachePatternedScaleLimit.setDouble(l);
    }

    public static double getAlphaBlendingOvercolorLimit() {
        return cacheAlphaBlendingLimit.getDouble();
    }

    public static void setAlphaBlendingOvercolorLimit(double l) {
        cacheAlphaBlendingLimit.setDouble(l);
    }

    public static boolean isShowFileSelectionForNetlists() {
        return cacheShowFileSelectionForNetlists.getBoolean();
    }

    public static void setShowFileSelectionForNetlists(boolean on) {
        cacheShowFileSelectionForNetlists.setBoolean(on);
    }

    public static int getPanningDistance() {
        return cachePanningDistance.getInt();
    }

    public static void setPanningDistance(int d) {
        cachePanningDistance.setInt(d);
    }

    public static int getErrorLimit() {
        return cacheErrorLimit.getInt();
    }

    public static void setErrorLimit(int limit) {
        cacheErrorLimit.setInt(limit);
    }

    public static int getMaxUndoHistory() {
        return cacheMaxUndoHistory.getInt();
    }

    public static void setMaxUndoHistory(int n) {
        cacheMaxUndoHistory.setInt(n);
    }

    public static int getMemorySize() {
        return cacheMemorySize.getInt();
    }

    public static void setMemorySize(int limit) {
        cacheMemorySize.setInt(limit);
    }

    public static int getPermSpace() {
        return cachePermSize.getInt();
    }

    public static void setPermSpace(int limit) {
        cachePermSize.setInt(limit);
    }

    public static boolean isUseTwoJVMs() {
        return cacheUseTwoJVMs.getBoolean();
    }

    public static void setUseTwoJVMs(boolean on) {
        cacheUseTwoJVMs.setBoolean(on);
    }

    public static boolean isUseClientServer() {
        return cacheUseClientServer.getBoolean();
    }

    public static void setUseClientServer(boolean on) {
        cacheUseClientServer.setBoolean(on);
    }

    public static boolean isSbapshotLogging() {
        return cacheSnapshotLogging.getBoolean();
    }

    public static void setSnapshotLogging(boolean on) {
        cacheSnapshotLogging.setBoolean(on);
    }

    public static boolean isAutoTechnologySwitch() {
        return cacheAutoTechnologySwitch.getBoolean();
    }

    public static void setAutoTechnologySwitch(boolean on) {
        cacheAutoTechnologySwitch.setBoolean(on);
    }

    public static boolean isPlaceCellCenter() {
        return cachePlaceCellCenter.getBoolean();
    }

    public static void setPlaceCellCenter(boolean on) {
        cachePlaceCellCenter.setBoolean(on);
    }

    public static boolean isReconstructArcsToDeletedCells() {
        return cacheReconstructArcsToDeletedCells.getBoolean();
    }

    public static void setReconstructArcsToDeletedCells(boolean on) {
        cacheReconstructArcsToDeletedCells.setBoolean(on);
    }

    public static boolean isCheckCellDates() {
        return cacheCheckCellDates.getBoolean();
    }

    public static void setCheckCellDates(boolean on) {
        cacheCheckCellDates.setBoolean(on);
    }

    public static boolean isDisallowModificationLockedPrims() {
        return cacheDisallowModificationLockedPrims.getBoolean();
    }

    public static void setDisallowModificationLockedPrims(boolean on) {
        cacheDisallowModificationLockedPrims.setBoolean(on);
    }

    public static boolean isDisallowModificationComplexNodes() {
        return cacheDisallowModificationComplexNodes.getBoolean();
    }

    public static void setDisallowModificationComplexNodes(boolean on) {
        cacheDisallowModificationComplexNodes.setBoolean(on);
    }

    public static boolean isMoveAfterDuplicate() {
        return cacheMoveAfterDuplicate.getBoolean();
    }

    public static void setMoveAfterDuplicate(boolean on) {
        cacheMoveAfterDuplicate.setBoolean(on);
    }

    public static boolean isDupCopiesExports() {
        return cacheDupCopiesExports.getBoolean();
    }

    public static void setDupCopiesExports(boolean on) {
        cacheDupCopiesExports.setBoolean(on);
    }

    public static boolean isExtractCopiesExports() {
        return cacheExtractCopiesExports.getBoolean();
    }

    public static void setExtractCopiesExports(boolean on) {
        cacheExtractCopiesExports.setBoolean(on);
    }

    public static boolean isArcsAutoIncremented() {
        return cacheArcsAutoIncremented.getBoolean();
    }

    public static void setArcsAutoIncremented(boolean on) {
        cacheArcsAutoIncremented.setBoolean(on);
    }

    public static int getNewNodeRotation() {
        return cacheNewNodeRotation.getInt();
    }

    public static void setNewNodeRotation(int rot) {
        cacheNewNodeRotation.setInt(rot);
    }

    public static boolean isNewNodeMirrorX() {
        return cacheNewNodeMirrorX.getBoolean();
    }

    public static void setNewNodeMirrorX(boolean on) {
        cacheNewNodeMirrorX.setBoolean(on);
    }
}

